/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.EntityCatalog;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileEntityResolver
extends EntityCatalog
implements Environment.Provider {
    private static final String ENTITY_PREFIX = "/xml/entities";
    private static final String LOOKUP_PREFIX = "/xml/lookups";
    private static Method method;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject;
    static /* synthetic */ Class class$org$openide$loaders$XMLDataObject$Info;

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        if (string == null) {
            return null;
        }
        String string3 = FileEntityResolver.convertPublicId(string);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(ENTITY_PREFIX);
        stringBuffer.append(string3);
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(stringBuffer.toString());
        if (fileObject != null) {
            InputSource inputSource = new InputSource(fileObject.getInputStream());
            try {
                Object object = fileObject.getAttribute("hint.originalPublicID");
                if (object instanceof String) {
                    inputSource.setPublicId((String)object);
                }
                URL uRL = fileObject.getURL();
                inputSource.setSystemId(uRL.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return inputSource;
        }
        return null;
    }

    public Lookup getEnvironment(DataObject dataObject) {
        if (dataObject instanceof XMLDataObject) {
            XMLDataObject xMLDataObject = (XMLDataObject)dataObject;
            String string = null;
            try {
                DocumentType documentType = xMLDataObject.getDocument().getDoctype();
                if (documentType != null) {
                    string = documentType.getPublicId();
                }
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                return null;
            }
            catch (SAXException sAXException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)sAXException);
                return null;
            }
            if (string == null) {
                return null;
            }
            string = FileEntityResolver.convertPublicId(string);
            return new Lkp(string, xMLDataObject);
        }
        return null;
    }

    private static Lookup findLookup(XMLDataObject xMLDataObject, DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        try {
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = FileEntityResolver.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (instanceCookie != null) {
                Object object = instanceCookie.instanceCreate();
                if (object instanceof Environment.Provider) {
                    return ((Environment.Provider)object).getEnvironment((DataObject)xMLDataObject);
                }
                if (object instanceof XMLDataObject.Processor) {
                    XMLDataObject.Info info = new XMLDataObject.Info();
                    info.addProcessorClass(object.getClass());
                    object = info;
                }
                if (object instanceof XMLDataObject.Info) {
                    return FileEntityResolver.createInfoLookup(xMLDataObject, (XMLDataObject.Info)object);
                }
            }
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)classNotFoundException);
        }
        return null;
    }

    private static Lookup createInfoLookup(XMLDataObject xMLDataObject, XMLDataObject.Info info) {
        if (method == null) {
            try {
                method = (class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = FileEntityResolver.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject).getDeclaredMethod("createInfoLookup", class$org$openide$loaders$XMLDataObject == null ? (class$org$openide$loaders$XMLDataObject = FileEntityResolver.class$("org.openide.loaders.XMLDataObject")) : class$org$openide$loaders$XMLDataObject, class$org$openide$loaders$XMLDataObject$Info == null ? (class$org$openide$loaders$XMLDataObject$Info = FileEntityResolver.class$("org.openide.loaders.XMLDataObject$Info")) : class$org$openide$loaders$XMLDataObject$Info);
                ((AccessibleObject)method).setAccessible(true);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify((Throwable)exception);
                return null;
            }
        }
        try {
            return (Lookup)method.invoke(null, xMLDataObject, info);
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify((Throwable)exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String convertPublicId(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            block9: {
                int n5 = cArray[n4];
                switch (n2) {
                    case 0: {
                        if (n5 == 43 || n5 == 45 || n5 == 73 || n5 == 83 || n5 == 79) break block9;
                        n2 = 1;
                    }
                    case 1: {
                        if (n5 != 47) break;
                        n2 = 2;
                        if (++n == 3) {
                            return new String(cArray, 0, n3);
                        }
                        cArray[n3++] = 47;
                    }
                    {
                        break block9;
                    }
                    case 2: {
                        if (n5 == 47) break block9;
                        n2 = 1;
                    }
                }
                cArray[n3++] = n5 >= 65 && n5 <= 90 || n5 >= 97 && n5 <= 122 || n5 >= 48 && n5 <= 57 ? n5 : 95;
            }
            ++n4;
        }
        return new String(cArray, 0, n3);
    }

    private static FileObject findObject(String string, FileObject[] fileObjectArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(LOOKUP_PREFIX);
        stringBuffer.append(string);
        int n = stringBuffer.length();
        stringBuffer.append(".instance");
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
        String string2 = stringBuffer.toString();
        int n2 = FileEntityResolver.searchFolder(fileObject, string2, fileObjectArray);
        if (n2 == -1) {
            return null;
        }
        FileObject fileObject2 = fileObjectArray[0].getFileObject(string2.substring(n2));
        if (fileObject2 == null) {
            stringBuffer.setLength(n);
            stringBuffer.append(".xml");
            fileObject2 = fileObjectArray[0].getFileObject(stringBuffer.toString().substring(n2));
        }
        return fileObject2;
    }

    private static int searchFolder(FileObject fileObject, String string, FileObject[] fileObjectArray) {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(47, n)) == -1) {
                fileObjectArray[0] = fileObject;
                return n;
            }
            if (n2 == n) {
                ++n;
                continue;
            }
            FileObject fileObject2 = fileObject.getFileObject(string.substring(n, n2));
            if (fileObject2 == null) {
                fileObjectArray[0] = fileObject;
                return -1;
            }
            n = n2 + 1;
            fileObject = fileObject2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Lkp
    extends ProxyLookup
    implements PropertyChangeListener,
    FileChangeListener {
        private String id;
        private XMLDataObject xml;
        private FileObject folder;
        private DataObject obj;

        public Lkp(String string, XMLDataObject xMLDataObject) {
            super(new Lookup[0]);
            this.id = string;
            this.xml = xMLDataObject;
        }

        protected void beforeLookup(Lookup.Template template) {
            if (this.folder == null && this.obj == null) {
                this.update();
            }
        }

        private void update() {
            FileObject[] fileObjectArray = new FileObject[1];
            FileObject fileObject = FileEntityResolver.findObject(this.id, fileObjectArray);
            DataObject dataObject = null;
            if (fileObject != null) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)dataObjectNotFoundException);
                }
            }
            if (dataObject == this.obj) {
                Lookup lookup = FileEntityResolver.findLookup(this.xml, dataObject);
                if (dataObject != null && lookup != null) {
                    this.setLookups(new Lookup[]{lookup});
                    return;
                }
            } else {
                this.obj = dataObject;
                Lookup lookup = FileEntityResolver.findLookup(this.xml, dataObject);
                if (dataObject != null && lookup != null) {
                    dataObject.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)dataObject));
                    this.setLookups(new Lookup[]{lookup});
                    return;
                }
            }
            this.setLookups(new Lookup[0]);
            if (this.folder != fileObjectArray[0]) {
                this.folder = fileObjectArray[0];
                fileObjectArray[0].addFileChangeListener(WeakListener.fileChange((FileChangeListener)this, (Object)fileObjectArray[0]));
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.update();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.update();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.update();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("cookie" == string || "name" == string || "valid" == string || "primaryFile" == string) {
                this.update();
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.update();
        }

        public void fileChanged(FileEvent fileEvent) {
        }
    }
}

