/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;

public class VersionSerializator {
    HashMap versionMap;
    String lastReadVersion;
    String lastRegisteredVersion;
    static /* synthetic */ Class class$org$netbeans$core$windows$util$VersionSerializator;

    public VersionSerializator() {
        this(10);
    }

    public VersionSerializator(int n) {
        this.versionMap = new HashMap(n);
    }

    public void putVersion(Versionable versionable) {
        String string = versionable.getName();
        this.versionMap.put(string, versionable);
        this.lastRegisteredVersion = string;
    }

    public void removeVersion(String string) {
        this.versionMap.remove(string);
        if (string.equals(this.lastRegisteredVersion)) {
            this.lastRegisteredVersion = null;
        }
    }

    public Versionable getVersion(String string) {
        return (Versionable)this.versionMap.get(string);
    }

    public String lastReadVersion() {
        return this.lastReadVersion;
    }

    public Versionable readVersion(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        Versionable versionable = (Versionable)this.versionMap.get(string);
        if (versionable == null) {
            throw new IOException(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$util$VersionSerializator == null ? (class$org$netbeans$core$windows$util$VersionSerializator = VersionSerializator.class$("org.netbeans.core.windows.util.VersionSerializator")) : class$org$netbeans$core$windows$util$VersionSerializator)).getString("EXC_UnknownVersion") + string);
        }
        try {
            versionable.readData(objectInput);
        }
        catch (Exception exception) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                exception.printStackTrace();
            }
            throw new SafeException(exception);
        }
        this.lastReadVersion = string;
        return versionable;
    }

    public void writeVersion(ObjectOutput objectOutput, String string) throws IOException {
        Versionable versionable = (Versionable)this.versionMap.get(string);
        if (versionable == null) {
            throw new IOException(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$util$VersionSerializator == null ? (class$org$netbeans$core$windows$util$VersionSerializator = VersionSerializator.class$("org.netbeans.core.windows.util.VersionSerializator")) : class$org$netbeans$core$windows$util$VersionSerializator)).getString("EXC_UnknownVersion"));
        }
        objectOutput.writeObject(string);
        try {
            versionable.writeData(objectOutput);
        }
        catch (Exception exception) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                exception.printStackTrace();
            }
            throw new SafeException(exception);
        }
    }

    public void writeLastVersion(ObjectOutput objectOutput) throws IOException {
        this.writeVersion(objectOutput, this.lastRegisteredVersion);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Versionable {
        public String getName();

        public void readData(ObjectInput var1) throws IOException, ClassNotFoundException;

        public void writeData(ObjectOutput var1) throws IOException;
    }
}

