/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.ModeData;
import org.netbeans.core.windows.layers.TCRef;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.TopManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInfo;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class TCRefImpl
extends DefaultHandler
implements TCRef,
FileChangeListener,
FileSystem.AtomicAction,
DeferredPerformer.DeferredCommand,
PropertyChangeListener {
    public static final String INSTANCE_DTD_ID = "-//NetBeans//DTD Top Component in Mode Properties 1.0//EN";
    public static final String INSTANCE_DTD_WWW = "http://www.netbeans.org/dtds/tc-ref1_0.dtd";
    public static final String INSTANCE_DTD_LOCAL = "/org/netbeans/core/resources/tc-ref1_0.dtd";
    private static final String ATT_ID = "id";
    private static final String ATT_CONSTRAINT = "constraint";
    private static final String ATT_STATE = "state";
    private static final String ATT_SELECTED = "selected";
    private static final String ATT_TYPE = "type";
    private String tc_id;
    private int orderWeight = Integer.MAX_VALUE;
    private boolean selected = false;
    private boolean opened = false;
    private String constraint;
    private boolean tc_idChanged = false;
    private boolean orderWeightChanged = false;
    private boolean selectedChanged = false;
    private boolean constraintChanged = false;
    private boolean openedChanged = false;
    private boolean dataValid;
    private boolean noSectionLoaded;
    private ModeImpl mi;
    private TopComponent tcRef;
    private DataObject producer;
    private ModeData modeData;
    private StringBuffer buffer;
    private boolean shouldParse;
    private boolean propsLoaded;
    private String moduleCodeNameBase;
    private String moduleCodeNameRelease;
    private String moduleSpecificationVersion;
    private PropertyChangeListener weakPropertyChangeL;
    private final Object RW_LOCK = new Object();
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ModeData;

    public TCRefImpl(DataObject dataObject, ModeImpl modeImpl) {
        this.producer = dataObject;
        this.mi = modeImpl;
        this.shouldParse = true;
        dataObject.getPrimaryFile().addFileChangeListener((FileChangeListener)this);
    }

    public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
        try {
            TopComponent topComponent = this.getTopComponent();
            topComponent.open(this.mi.getWorkspace());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean updateMode() throws IOException {
        TopComponent topComponent;
        this.dataValid = true;
        this.parse();
        if (!this.dataValid || this.noSectionLoaded) {
            return false;
        }
        if (this.moduleCodeNameBase != null) {
            topComponent = WindowUtils.findModule(this.moduleCodeNameBase, this.moduleCodeNameRelease, this.moduleSpecificationVersion);
            if (topComponent != null && topComponent.isEnabled()) {
                if (this.weakPropertyChangeL == null) {
                    this.weakPropertyChangeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)topComponent);
                    topComponent.addPropertyChangeListener(this.weakPropertyChangeL);
                }
            } else {
                this.deleteFiles();
                return false;
            }
        }
        topComponent = this.getTopComponent();
        if (!this.opened && topComponent.isOpened(this.mi.getWorkspace())) {
            topComponent.close(this.mi.getWorkspace());
        }
        this.mi.dockIntoNoSelect(topComponent, this.constraint, this.getOrderWeight());
        if (this.opened) {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
            WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(null, true));
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteFiles() {
        FileObject fileObject = this.producer.getPrimaryFile();
        FileLock fileLock = null;
        if (!fileObject.isValid()) return;
        try {
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var5_4 = null;
                if (fileLock == null) return;
                fileLock.releaseLock();
                return;
            }
            Object var5_3 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            ModuleInfo moduleInfo = (ModuleInfo)propertyChangeEvent.getSource();
            if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.deleteFiles();
            }
        }
    }

    private void fillBuffer() throws IOException {
        this.buffer = new StringBuffer(800);
        this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        this.buffer.append("<tc-ref version=\"1.0\" id=\"");
        this.buffer.append(XMLUtil.toAttributeValue((String)this.producer.getPrimaryFile().getName()));
        this.buffer.append("\" >\n");
        if (this.moduleCodeNameBase != null) {
            this.buffer.append("    <module");
            this.buffer.append(" name=\"");
            if (this.moduleCodeNameRelease != null) {
                this.buffer.append(this.moduleCodeNameBase + "/" + this.moduleCodeNameRelease);
            } else {
                this.buffer.append(this.moduleCodeNameBase);
            }
            if (this.moduleSpecificationVersion != null) {
                this.buffer.append("\" spec=\"");
                this.buffer.append(this.moduleSpecificationVersion);
            }
            this.buffer.append("\" />\n");
        }
        this.buffer.append("    <ui-type type=\"any\" state=\"");
        try {
            TopComponent topComponent = this.getTopComponent();
            boolean bl = topComponent.isOpened(this.mi.getWorkspace());
            this.buffer.append(bl ? "opened" : "closed");
            String string = (String)this.getModeImpl().getConstraint(topComponent);
            if (string != null) {
                this.buffer.append("\" constraint=\"");
                this.buffer.append(WindowUtils.convertConstraint2Xml(string));
            }
            if (bl) {
                TopComponentContainer topComponentContainer = this.mi.getContainerInstance();
                this.buffer.append("\" selected=\"");
                if (topComponentContainer != null) {
                    this.buffer.append(topComponent.equals(topComponentContainer.getArea(string).getSelectedTopComponent()) ? "true" : "false");
                } else {
                    this.buffer.append("false");
                }
            }
        }
        catch (IOException iOException) {
            this.buffer.append("closed");
            this.buffer.append("\" selected=\"false");
        }
        this.buffer.append("\" />\n");
        this.buffer.append("</tc-ref>\n");
    }

    public void save() throws IOException {
        this.fillBuffer();
        Object object = this.RW_LOCK;
        synchronized (object) {
            this.producer.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws IOException {
        FileLock fileLock;
        block3: {
            this.noSectionLoaded = false;
            FileObject fileObject = this.producer.getPrimaryFile();
            fileLock = fileObject.lock();
            OutputStreamWriter outputStreamWriter = null;
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                outputStreamWriter.write(this.buffer.toString());
                Object var6_5 = null;
                this.buffer = null;
                if (outputStreamWriter == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.buffer = null;
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                fileLock.releaseLock();
                throw throwable;
            }
            outputStreamWriter.close();
        }
        fileLock.releaseLock();
    }

    public boolean isSynchronized() {
        return false;
    }

    public ModeImpl getModeImpl() {
        return this.mi;
    }

    public TopComponent getTopComponent() throws IOException {
        if (!this.producer.isValid() || !this.producer.getPrimaryFile().isValid()) {
            throw new FileNotFoundException();
        }
        if (this.tcRef == null) {
            if (this.tc_id == null) {
                this.tc_id = this.producer.getPrimaryFile().getName();
            }
            this.tcRef = WindowManagerImpl.getDefault().lookupTCInstance(this.tc_id);
        }
        return this.tcRef;
    }

    public boolean isOpened() throws IOException {
        if (this.shouldParse) {
            this.parse();
        }
        return this.opened;
    }

    public String toString() {
        return this.producer.getPrimaryFile().toString();
    }

    int getOrderWeight() {
        return this.orderWeight;
    }

    Object getConstraint() {
        return this.constraint;
    }

    int setOrderWeight(int n) {
        this.orderWeight = n;
        return this.orderWeight;
    }

    public int compareTo(Object object) {
        return this.getOrderWeight() - ((TCRefImpl)object).getOrderWeight();
    }

    public DataObject getDataObject() {
        return this.producer;
    }

    void setSynchronized(boolean bl) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("tc-ref".equals(string3)) {
            this.handle_tc_ref(attributes);
        } else if ("ui-type".equals(string3)) {
            this.handle_ui_type(attributes);
        } else if ("module".equals(string3)) {
            this.handleModule(attributes);
        }
    }

    private void handle_tc_ref(Attributes attributes) throws SAXException {
        String string = attributes.getValue(ATT_ID);
        if (string != null) {
            if (!string.equals(this.tc_id)) {
                this.tc_id = string;
                this.tc_idChanged = true;
            }
        } else {
            this.dataValid = false;
            this.log("Error in configuration file. File: " + this.producer.getPrimaryFile().getName() + "  Error: Attribute \"id\" is required.");
            return;
        }
    }

    private void handleModule(Attributes attributes) {
        String string = attributes.getValue("name");
        if (string != null) {
            int n = string.indexOf(47);
            if (n != -1) {
                this.moduleCodeNameBase = string.substring(0, n);
                this.moduleCodeNameRelease = string.substring(n + 1);
            } else {
                this.moduleCodeNameBase = string;
                this.moduleCodeNameRelease = null;
            }
        } else {
            this.moduleCodeNameBase = null;
            this.moduleCodeNameRelease = null;
        }
        this.moduleSpecificationVersion = attributes.getValue("spec");
    }

    private void handle_ui_type(Attributes attributes) throws SAXException {
        if (this.propsLoaded) {
            return;
        }
        String string = attributes.getValue(ATT_TYPE);
        if (WindowManagerImpl.getDefault().uiModeManager().getUIMode() == WindowUtils.parseUIType(string)) {
            this.propsLoaded = true;
        } else if (!"any".equals(string)) {
            return;
        }
        this.noSectionLoaded = false;
        string = attributes.getValue(ATT_STATE);
        if (string != null) {
            boolean bl = this.opened;
            if (string.equals("opened")) {
                this.opened = true;
            } else if (string.equals("closed")) {
                this.opened = false;
            } else {
                this.log("Value of attribute state in invalid in file " + this.producer.getPrimaryFile().getName() + ", ignoring.");
            }
            boolean bl2 = this.openedChanged = this.opened != bl;
        }
        if ((string = attributes.getValue(ATT_CONSTRAINT)) != null) {
            if (!string.equals(this.constraint)) {
                this.constraint = WindowUtils.convertConstraint2Perim(string);
                if (this.constraint == null) {
                    this.constraint = "CENTER";
                }
                this.constraintChanged = true;
            }
        } else if (!"center".equals(this.constraint)) {
            this.constraint = "CENTER";
            this.constraintChanged = true;
        }
        if ((string = attributes.getValue(ATT_SELECTED)) != null) {
            if (!string.equals("true") && !string.equals("false")) {
                this.log("Warning in configuration file. File: " + this.producer.getPrimaryFile().getName() + "  Warning: Value \"" + string + "\" for attribute \"selected\" is invalid.");
                this.log("Valid values are: \"true\",\"false\".");
                this.log("Default value \"false\" is set.");
            }
            if (string.equals("true") && !this.selected) {
                this.selected = true;
                this.selectedChanged = true;
            }
            if (string.equals("false") && this.selected) {
                this.selected = false;
                this.selectedChanged = true;
            }
        } else if (this.selected) {
            this.selected = false;
            this.selectedChanged = true;
        }
    }

    private void log(String string) {
        TopManager.getDefault().getErrorManager().log(5, string);
        System.err.println(string);
    }

    private void parse() throws IOException {
        try {
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.setEntityResolver(this);
                xMLReader.setErrorHandler(this.getDefaultErrorHandler());
                Object object = this.RW_LOCK;
                synchronized (object) {
                    InputStream inputStream = this.producer.getPrimaryFile().getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    this.propsLoaded = false;
                    this.noSectionLoaded = true;
                    xMLReader.parse(inputSource);
                }
                Object var7_9 = null;
                this.shouldParse = false;
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                String string = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$layers$ModeData == null ? (class$org$netbeans$core$windows$layers$ModeData = TCRefImpl.class$("org.netbeans.core.windows.layers.ModeData")) : class$org$netbeans$core$windows$layers$ModeData)).getString("EXC_TCRefParse"), this.producer.getPrimaryFile().getName());
                IOException iOException = new IOException(string);
                TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.shouldParse = false;
            throw throwable;
        }
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }
        };
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (INSTANCE_DTD_ID.equals(string)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            if (byteArrayInputStream == null) {
                throw new IllegalStateException("Entity cannot be resolved.");
            }
            return new InputSource(byteArrayInputStream);
        }
        return null;
    }

    private void fileStd() {
        try {
            if (ICFolderImpl.isListening()) {
                this.updateMode();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.producer.getPrimaryFile().removeFileChangeListener((FileChangeListener)this);
        final TopComponent topComponent = this.tcRef;
        if (topComponent != null) {
            ModeImpl modeImpl = (ModeImpl)this.mi.getWorkspace().findMode(topComponent);
            if (topComponent.isOpened(this.mi.getWorkspace()) && this.mi.equals(modeImpl)) {
                topComponent.close(this.mi.getWorkspace());
            }
            this.tcRef = null;
            if (EventQueue.isDispatchThread()) {
                this.mi.release(topComponent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TCRefImpl.this.mi.release(topComponent);
                    }
                });
            }
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        this.fileStd();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

