/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.EmptyTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.netbeans.core.windows.frames.SplittedContainerImpl$SerializationReplacer;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.awt.MouseUtils;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class SplitContainerImpl
extends DefaultContainerImpl
implements ChangeListener,
ComponentListener {
    private TopComponent wasSelected;
    private static final ArrayList positionNames = new ArrayList(5);
    private static TabbedPaneUI emptyTabbedUI;
    private HashMap constraints = new HashMap(15);
    private JTabbedPane[] tabbedContainer = new JTabbedPane[positionNames.size()];
    private BasicTabbedPaneUI[] basicTabbedPaneUI = new BasicTabbedPaneUI[positionNames.size()];
    private Dimension[] prefTabbedSize = new Dimension[positionNames.size()];
    private int[] selectedTabs = new int[positionNames.size()];
    private HashMap tabbedContainer2Constraint = new HashMap(10);
    private HashMap constrs2Areas = new HashMap(10);
    private ArrayList areas = new ArrayList(5);
    private int counter = 0;
    private PerimeterPane contentPane = new PerimeterPane();
    private PopupMouseImpl popup = new PopupMouseImpl();
    private FocusListener tabbedFocusListener = new TabbedContainerFocusL();
    private ArrayList serConstraints;
    private ArrayList serSelectedTabs;
    private TopComponent requestedTC = null;
    public static final String DEFAULT_CONTAINER = "defaultContainer";
    public static final String CONSTRAINTS_LIST = "constraintsArray";
    public static final String TABBED_CONTAINERS_SIZE = "tabbedSizesArray";
    public static final String INDEX_OF_SELECTED_TAB = "selectedTabIndexes";
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$SplitContainerImpl;

    public SplitContainerImpl() {
        int n = 0;
        while (n < positionNames.size()) {
            this.selectedTabs[n] = -1;
            ++n;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        NbFocusManager.install();
    }

    protected void actionPerformed(SystemAction systemAction, boolean bl) {
        if (bl) {
            return;
        }
        if (systemAction instanceof NextTabAction || systemAction instanceof PreviousTabAction) {
            TopComponent topComponent = this.getSelectedTopComponent();
            JTabbedPane jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n <= 1 || n2 == -1) {
                return;
            }
            int n3 = systemAction instanceof NextTabAction ? 1 : -1;
            int n4 = (n2 + n3 + n) % n;
            jTabbedPane.setSelectedIndex(n4);
        }
    }

    void updateNextAndPreviousState() {
        TopComponent topComponent = this.getSelectedTopComponent();
        if (topComponent == null) {
            return;
        }
        JTabbedPane jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
        if (jTabbedPane != null && jTabbedPane.getComponentCount() > 1) {
            DefaultContainerImpl.nextTab.setActionPerformer((ActionPerformer)this);
            DefaultContainerImpl.prevTab.setActionPerformer((ActionPerformer)this);
        } else {
            DefaultContainerImpl.nextTab.setActionPerformer(null);
            DefaultContainerImpl.prevTab.setActionPerformer(null);
        }
    }

    public void requestVisible(TopComponent topComponent) {
        if (this.isActivated()) {
            TopComponent topComponent2;
            JTabbedPane jTabbedPane;
            JTabbedPane jTabbedPane2 = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            if (jTabbedPane2 == (jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent2 = this.getSelectedTopComponent()))])) {
                topComponent.requestFocus();
            } else if (jTabbedPane2 != null && jTabbedPane2.indexOfComponent((Component)topComponent) >= 0) {
                jTabbedPane2.removeChangeListener(this);
                jTabbedPane2.setSelectedComponent((Component)topComponent);
                jTabbedPane2.addChangeListener(this);
            }
        } else {
            JTabbedPane jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            TopComponent topComponent3 = this.getSelectedTopComponent();
            JTabbedPane jTabbedPane3 = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent3))];
            if (jTabbedPane != null && jTabbedPane.indexOfComponent((Component)topComponent) >= 0) {
                jTabbedPane.removeChangeListener(this);
                this.setSelectedTopComponent(topComponent);
                jTabbedPane.addChangeListener(this);
                if (jTabbedPane == jTabbedPane3) {
                    this.requestedTC = topComponent;
                } else if (jTabbedPane3 != null && jTabbedPane3.indexOfComponent((Component)topComponent3) >= 0) {
                    jTabbedPane3.removeChangeListener(this);
                    this.setSelectedTopComponent(topComponent3);
                    jTabbedPane3.addChangeListener(this);
                }
            }
        }
    }

    public boolean canAdd(TopComponent[] topComponentArray) {
        return true;
    }

    public Object getConstraints(TopComponent topComponent) {
        return this.constraints.get(topComponent);
    }

    public TopComponentContainer.Area getArea(Object object) {
        return (TopComponentContainer.Area)this.constrs2Areas.get(object);
    }

    public List getAreas() {
        return this.areas;
    }

    public List getConstraintsOrder() {
        return ((PerimeterLayout)this.contentPane.getLayout()).getDominance();
    }

    public void setConstraintsOrder(List list) {
        PerimeterLayout perimeterLayout = (PerimeterLayout)this.contentPane.getLayout();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (!"CENTER".equals(e)) {
                perimeterLayout.setDominant((String)list.get(n));
            }
            --n;
        }
    }

    protected void attachComponents() {
        if (this.constraints.size() == 1) {
            TopComponent topComponent = this.getSelectedTopComponent();
            this.contentPane.add((Component)topComponent, this.constraints.get(topComponent));
            if (!topComponent.isVisible()) {
                topComponent.setVisible(true);
            }
            this.invalidate();
            this.validate();
            return;
        }
        TopComponent[] topComponentArray = this.getTopComponents();
        Image image = null;
        int n = 0;
        while (n < topComponentArray.length) {
            image = topComponentArray[n].getIcon();
            int n2 = positionNames.indexOf(this.constraints.get(topComponentArray[n]));
            if (this.tabbedContainer[n2] == null) {
                this.openTabbedContainer(n2, topComponentArray[n], this.constraints.get(topComponentArray[n]));
            }
            this.tabbedContainer[n2].removeChangeListener(this);
            this.tabbedContainer[n2].addTab(topComponentArray[n].getName(), image == null ? null : new ImageIcon(image), (Component)topComponentArray[n], topComponentArray[n].getToolTipText());
            this.tabbedContainer[n2].addChangeListener(this);
            ++n;
        }
        int n3 = 0;
        while (n3 < positionNames.size()) {
            if (this.tabbedContainer[n3] != null) {
                this.switchEmptyUI(this.tabbedContainer[n3], n3, null);
                if (this.selectedTabs[n3] > -1 && this.selectedTabs[n3] < this.tabbedContainer[n3].getComponentCount()) {
                    this.tabbedContainer[n3].setSelectedIndex(this.selectedTabs[n3]);
                    TopComponent topComponent = (TopComponent)this.tabbedContainer[n3].getComponentAt(this.selectedTabs[n3]);
                    this.refreshAfterAdding(topComponent);
                }
            }
            ++n3;
        }
        if (this.wasSelected != null && this.containsTopComponent(this.wasSelected)) {
            if (!this.wasSelected.isVisible()) {
                this.wasSelected.setVisible(true);
            }
            this.setSelectedTopComponent(this.wasSelected);
        } else if (topComponentArray.length > 0) {
            if (!topComponentArray[0].isVisible()) {
                topComponentArray[0].setVisible(true);
            }
            this.setSelectedTopComponent(topComponentArray[0]);
        }
    }

    protected void detachComponents() {
        if (this.constraints.size() == 1) {
            this.contentPane.remove((Component)this.getSelectedTopComponent());
            return;
        }
        this.wasSelected = this.getSelectedTopComponent();
        int n = 0;
        while (n < positionNames.size()) {
            if (this.tabbedContainer[n] != null) {
                this.selectedTabs[n] = this.tabbedContainer[n].getSelectedIndex();
                this.tabbedContainer[n].removeAll();
            } else {
                this.selectedTabs[n] = -1;
            }
            ++n;
        }
    }

    protected void componentAdded(TopComponent topComponent) {
        this.componentAdded(topComponent, "CENTER", Integer.MAX_VALUE, null);
    }

    protected void componentAdded(TopComponent topComponent, Object object, int n, TopComponentContainer.Area area) {
        if (positionNames.indexOf(object) == -1) {
            throw new IllegalArgumentException("invalid constraint: " + object);
        }
        SplitContainerImpl splitContainerImpl = this;
        synchronized (splitContainerImpl) {
            Object object2;
            this.constraints.put(topComponent, object);
            int n2 = positionNames.indexOf(object);
            TopComponentContainer.Area area2 = (TopComponentContainer.Area)this.constrs2Areas.get(object);
            if (area != null && area2 == null) {
                this.constrs2Areas.put(object, area);
                this.areas.add(area);
                area2 = area;
            }
            if (area2 == null) {
                area2 = new TCCTabbedAreaImpl(object);
                this.constrs2Areas.put(object, area2);
                this.areas.add(area2);
            }
            int n3 = this.findPosition(n, object);
            area2.getComponentsList().add(n3, topComponent);
            if (this.constraints.size() == 1) {
                this.setSelectedTopComponent(topComponent);
                if (this.isAttached()) {
                    this.contentPane.add((Component)topComponent, this.constraints.get(topComponent));
                }
                return;
            }
            if (this.constraints.size() == 2) {
                object2 = this.getTopComponents();
                TopComponent topComponent2 = object2[0];
                if (topComponent2.equals(topComponent)) {
                    topComponent2 = object2[1];
                }
                int n4 = positionNames.indexOf(this.constraints.get(topComponent2));
                this.contentPane.remove((Component)topComponent2);
                this.openTabbedContainer(n4, topComponent2, this.getConstraints(topComponent2));
                if (this.isAttached()) {
                    this.switchEmptyUI(this.tabbedContainer[n4], n4, topComponent2);
                    Image image = topComponent2.getIcon();
                    this.tabbedContainer[n4].addTab(topComponent2.getName(), image == null ? null : new ImageIcon(image), (Component)topComponent2, topComponent2.getToolTipText());
                    this.refreshAfterAdding(topComponent2);
                }
            }
            if (this.tabbedContainer[n2] == null) {
                this.openTabbedContainer(n2, topComponent, object);
            }
            if (this.isAttached()) {
                this.switchEmptyUI(this.tabbedContainer[n2], n2, topComponent);
                object2 = topComponent.getIcon();
                this.tabbedContainer[n2].insertTab(topComponent.getName(), object2 == null ? null : new ImageIcon((Image)object2), (Component)topComponent, topComponent.getToolTipText(), n3);
                this.refreshAfterAdding(topComponent);
            }
        }
    }

    protected void componentRemoved(TopComponent topComponent) {
        SplitContainerImpl splitContainerImpl = this;
        synchronized (splitContainerImpl) {
            int n = positionNames.indexOf(this.constraints.get(topComponent));
            if (this.constraints.size() == 1) {
                this.removeFromArea(topComponent);
                this.constraints.remove(topComponent);
                this.doActivateComponent(null);
                this.contentPane.remove((Component)topComponent);
                return;
            }
            JTabbedPane jTabbedPane = this.tabbedContainer[n];
            if (jTabbedPane != null && jTabbedPane.indexOfComponent((Component)topComponent) != -1) {
                jTabbedPane.removeChangeListener(this);
                jTabbedPane.remove((Component)topComponent);
                this.switchEmptyUI(jTabbedPane, n, null);
                jTabbedPane.addChangeListener(this);
            }
            this.removeFromArea(topComponent);
            this.constraints.remove(topComponent);
            if (jTabbedPane != null && jTabbedPane.getTabCount() == 0) {
                this.closeTabbedContainer(n);
            }
            this.contentPane.remove((Component)topComponent);
            if (this.constraints.size() == 1) {
                TopComponent topComponent2 = (TopComponent)this.topComponents().get(0);
                n = positionNames.indexOf(this.constraints.get(topComponent2));
                jTabbedPane = this.tabbedContainer[n];
                if (jTabbedPane != null) {
                    jTabbedPane.removeChangeListener(this);
                    jTabbedPane.remove((Component)topComponent2);
                    jTabbedPane.addChangeListener(this);
                    this.closeTabbedContainer(n);
                }
                if (this.isAttached()) {
                    topComponent2.setVisible(true);
                    this.contentPane.add((Component)topComponent2, this.constraints.get(topComponent2));
                    this.mode.updateTitle();
                }
                this.setSelectedTopComponent(topComponent2);
                this.reactivateSelectedComponent();
            } else if (jTabbedPane != null && jTabbedPane.getSelectedComponent() != null) {
                this.setSelectedTopComponent((TopComponent)jTabbedPane.getSelectedComponent());
                this.reactivateSelectedComponent();
                jTabbedPane.invalidate();
                jTabbedPane.validate();
                jTabbedPane.repaint();
            }
        }
    }

    private boolean switchEmptyUI(JTabbedPane jTabbedPane, int n, TopComponent topComponent) {
        boolean bl = jTabbedPane.getUI() instanceof EmptyTabbedPaneUI;
        boolean bl2 = this.canEnableEmptyUI(jTabbedPane, topComponent);
        if (!bl && bl2) {
            jTabbedPane.setUI(new EmptyTabbedPaneUI());
            return true;
        }
        if (bl && !bl2) {
            this.changeUI(n);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canEnableEmptyUI(JTabbedPane jTabbedPane, TopComponent topComponent) {
        Object object;
        if (topComponent == null) {
            if (jTabbedPane.getTabCount() != 1) {
                return false;
            }
            object = jTabbedPane.getComponent(0);
            if (!(object instanceof TopComponent)) return false;
            topComponent = (TopComponent)object;
        } else if (jTabbedPane.getTabCount() != 0) {
            return false;
        }
        object = (String)topComponent.getClientProperty("TabPolicy");
        return "HideWhenAlone".equals(object);
    }

    private void removeFromArea(TopComponent topComponent) {
        Object v = this.constraints.get(topComponent);
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(v);
        List list = area.getComponentsList();
        list.remove(topComponent);
        if (list.size() <= 0) {
            this.constrs2Areas.remove(v);
            ((AbstractCollection)this.areas).remove(area);
            if (this.isAttached()) {
                HashMap<Object, TopComponentContainer.Area> hashMap = this.mode.getAreas();
                hashMap = hashMap == null ? new HashMap() : new HashMap(hashMap);
                hashMap.put(v, area);
                this.mode.setAreas(hashMap);
            }
        }
    }

    protected void componentIconChanged(TopComponent topComponent, Image image) {
        if (!this.containsTopComponent(topComponent)) {
            return;
        }
        if (this.constraints.size() > 1) {
            JTabbedPane jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            int n = jTabbedPane.indexOfComponent((Component)topComponent);
            if (n < 0) {
                return;
            }
            jTabbedPane.setIconAt(n, new ImageIcon(image));
            if (this.isAttached()) {
                jTabbedPane.revalidate();
                jTabbedPane.repaint();
            }
        }
    }

    protected void componentNameChanged(TopComponent topComponent) {
        if (!this.containsTopComponent(topComponent)) {
            return;
        }
        String string = topComponent.getName();
        if (this.constraints.size() > 1) {
            JTabbedPane jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
            int n = jTabbedPane.indexOfComponent((Component)topComponent);
            if (n < 0) {
                return;
            }
            jTabbedPane.setTitleAt(n, string);
            jTabbedPane.setToolTipTextAt(n, topComponent.getToolTipText());
        }
        this.firePropertyChange("name", null, string);
    }

    protected void componentSelected(TopComponent topComponent) {
        JTabbedPane jTabbedPane;
        if (topComponent == null) {
            return;
        }
        if (this.constraints.size() > 1 && (jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))]).indexOfComponent((Component)topComponent) >= 0) {
            jTabbedPane.setSelectedComponent((Component)topComponent);
        }
        ((TopComponentContainer.Area)this.constrs2Areas.get(this.constraints.get(topComponent))).setSelectedTopComponent(topComponent);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (!this.isVisible() || !this.isShowing() || jTabbedPane.getTabCount() <= 0) {
            return;
        }
        int n = jTabbedPane.getSelectedIndex();
        TopComponent topComponent = n < 0 ? null : (TopComponent)jTabbedPane.getComponentAt(n);
        this.setSelectedTopComponent(topComponent);
        this.reactivateSelectedComponent();
    }

    protected void refreshAfterAdding(TopComponent topComponent) {
        JTabbedPane jTabbedPane = this.tabbedContainer[positionNames.indexOf(this.constraints.get(topComponent))];
        this.componentSelected(topComponent);
        if (!topComponent.isVisible()) {
            topComponent.setVisible(true);
        }
        jTabbedPane.invalidate();
        jTabbedPane.validate();
        jTabbedPane.repaint();
    }

    public void validateData() {
        Iterator iterator;
        super.validateData();
        TopComponent topComponent = this.getSelectedTopComponent();
        if (this.serConstraints != null) {
            iterator = ((AbstractList)this.serConstraints).iterator();
            Iterator iterator2 = ((AbstractList)this.topComponents()).iterator();
            while (iterator2.hasNext() && iterator.hasNext()) {
                this.componentAdded((TopComponent)iterator2.next(), iterator.next(), Integer.MAX_VALUE, null);
            }
            this.serConstraints = null;
        }
        if (this.serSelectedTabs != null) {
            iterator = ((AbstractList)this.serSelectedTabs).iterator();
            int n = 0;
            while (n < positionNames.size() && iterator.hasNext()) {
                this.selectedTabs[n] = (Integer)iterator.next();
                ++n;
            }
            this.serConstraints = null;
        } else {
            int n = 0;
            while (n < positionNames.size()) {
                this.selectedTabs[n] = -1;
                ++n;
            }
        }
        this.setSelectedTopComponent(topComponent);
        this.wasSelected = this.getSelectedTopComponent();
    }

    public void changeUI() {
        int n = this.tabbedContainer.length;
        int n2 = 0;
        while (n2 < n) {
            this.changeUI(n2);
            ++n2;
        }
    }

    public void changeUI(int n) {
        if (this.tabbedContainer[n] != null) {
            boolean bl = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
            switch (WindowManagerImpl.getDefault().tabbedContainerUIManager().getTabbedContainerUI()) {
                case 1: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(0, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof BasicTabbedPaneUI) break;
                    this.tabbedContainer[n].setUI(this.basicTabbedPaneUI[n]);
                    break;
                }
                case 2: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof ArrowsTabbedPaneUI) break;
                    this.tabbedContainer[n].setUI(new ArrowsTabbedPaneUI());
                    break;
                }
                case 3: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof PopupTabbedPaneUI) break;
                    this.tabbedContainer[n].setUI(new PopupTabbedPaneUI());
                    break;
                }
                case 4: {
                    if (bl) {
                        MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabbedContainer[n]);
                        break;
                    }
                    if (this.tabbedContainer[n].getUI() instanceof ArrowsTabbedPaneUI) break;
                    this.tabbedContainer[n].setUI(new ArrowsTabbedPaneUI());
                }
            }
        }
    }

    private void openTabbedContainer(int n, TopComponent topComponent, Object object) {
        this.tabbedContainer[n] = new JTabbedPane();
        this.basicTabbedPaneUI[n] = this.tabbedContainer[n].getUI() instanceof BasicTabbedPaneUI ? (BasicTabbedPaneUI)this.tabbedContainer[n].getUI() : null;
        this.changeUI(n);
        this.tabbedContainer[n].setTabPlacement(3);
        if (this.prefTabbedSize[n] == null) {
            Cloneable cloneable;
            Dimension dimension = null;
            TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(object);
            if (area != null && (cloneable = area.getBounds()) != null) {
                dimension = new Dimension();
                dimension.width = cloneable.width;
                dimension.height = cloneable.height;
            }
            if (dimension == null) {
                dimension = topComponent.getSize();
            }
            cloneable = this.tabbedContainer[n].getInsets();
            dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            this.prefTabbedSize[n] = dimension;
        }
        this.tabbedContainer[n].setPreferredSize(this.prefTabbedSize[n]);
        this.tabbedContainer[n].addChangeListener(this);
        this.tabbedContainer[n].addMouseListener((MouseListener)((Object)this.popup));
        this.tabbedContainer[n].addFocusListener(this.tabbedFocusListener);
        this.tabbedContainer[n].addComponentListener(this);
        this.tabbedContainer[n].getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl)).getString("ACSN_TabbedContainer"));
        this.tabbedContainer[n].getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$frames$SplitContainerImpl == null ? (class$org$netbeans$core$windows$frames$SplitContainerImpl = SplitContainerImpl.class$("org.netbeans.core.windows.frames.SplitContainerImpl")) : class$org$netbeans$core$windows$frames$SplitContainerImpl)).getString("ACSD_TabbedContainer"));
        this.tabbedContainer2Constraint.put(this.tabbedContainer[n], positionNames.get(n));
        if (this.counter == 1) {
            int n2 = 0;
            while (n2 < positionNames.size()) {
                if (this.tabbedContainer[n2] != null) {
                    this.tabbedContainer[n2].setBorder(BorderFactory.createEtchedBorder(Color.white, Color.darkGray));
                }
                ++n2;
            }
        } else if (this.counter > 1) {
            this.tabbedContainer[n].setBorder(BorderFactory.createEtchedBorder(Color.white, Color.darkGray));
        }
        ++this.counter;
        this.contentPane.add((Component)this.tabbedContainer[n], positionNames.get(n));
    }

    private void closeTabbedContainer(int n) {
        this.tabbedContainer[n].removeChangeListener(this);
        this.tabbedContainer[n].removeMouseListener((MouseListener)((Object)this.popup));
        this.tabbedContainer[n].removeFocusListener(this.tabbedFocusListener);
        this.tabbedContainer[n].removeComponentListener(this);
        this.tabbedContainer2Constraint.remove(this.tabbedContainer[n]);
        this.prefTabbedSize[n] = this.tabbedContainer[n].getSize();
        this.contentPane.remove(this.tabbedContainer[n]);
        this.tabbedContainer[n] = null;
        --this.counter;
        int n2 = 0;
        while (n2 < positionNames.size()) {
            if (this.tabbedContainer[n2] != null) {
                this.tabbedContainer[n2].setPreferredSize(this.tabbedContainer[n2].getSize());
                this.setSelectedTopComponent((TopComponent)this.tabbedContainer[n2].getSelectedComponent());
                if (this.counter == 1) {
                    this.tabbedContainer[n2].setBorder(null);
                }
            }
            ++n2;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Object v = this.tabbedContainer2Constraint.get(componentEvent.getComponent());
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(v);
        area.setBounds(componentEvent.getComponent().getBounds());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Object v = this.tabbedContainer2Constraint.get(componentEvent.getComponent());
        TopComponentContainer.Area area = (TopComponentContainer.Area)this.constrs2Areas.get(v);
        area.setBounds(componentEvent.getComponent().getBounds());
    }

    protected void componentFocusGained(TopComponent topComponent, FocusEvent focusEvent) {
        if (this.requestedTC != null) {
            if (!this.containsTopComponent(this.requestedTC)) {
                this.requestedTC = topComponent;
            }
            super.componentFocusGained(this.requestedTC, focusEvent);
            if (this.requestedTC != this.getSelectedTopComponent()) {
                int n = positionNames.indexOf(this.constraints.get(this.requestedTC));
                JTabbedPane jTabbedPane = this.tabbedContainer[n];
                if (jTabbedPane != null) {
                    jTabbedPane.removeChangeListener(this);
                }
                this.setSelectedTopComponent(this.requestedTC);
                this.reactivateWithDelay();
                if (jTabbedPane != null) {
                    jTabbedPane.addChangeListener(this);
                }
            }
            if (this.requestedTC.equals(topComponent)) {
                this.requestedTC = null;
            }
        } else {
            super.componentFocusGained(topComponent, focusEvent);
            if (topComponent != this.getSelectedTopComponent()) {
                int n = positionNames.indexOf(this.constraints.get(topComponent));
                JTabbedPane jTabbedPane = this.tabbedContainer[n];
                if (jTabbedPane != null) {
                    jTabbedPane.removeChangeListener(this);
                }
                this.setSelectedTopComponent(topComponent);
                this.reactivateWithDelay();
                if (jTabbedPane != null) {
                    jTabbedPane.addChangeListener(this);
                }
            }
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SplittedContainerImpl$SerializationReplacer(this);
    }

    void writeData(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put(DEFAULT_CONTAINER, new DefaultContainerImpl.SerializedData(this));
        ArrayList arrayList = this.topComponents();
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            arrayList2.add(this.constraints.get(iterator.next()));
        }
        putField.put(CONSTRAINTS_LIST, arrayList2);
        ArrayList<Dimension> arrayList3 = new ArrayList<Dimension>(this.prefTabbedSize.length);
        int n = 0;
        while (n < this.prefTabbedSize.length) {
            arrayList3.add(this.tabbedContainer[n] == null ? this.prefTabbedSize[n] : this.tabbedContainer[n].getSize());
            ++n;
        }
        putField.put(TABBED_CONTAINERS_SIZE, arrayList3);
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(positionNames.size());
        int n2 = 0;
        while (n2 < positionNames.size()) {
            arrayList4.add(this.tabbedContainer[n2] == null ? new Integer(-1) : new Integer(this.tabbedContainer[n2].getSelectedIndex()));
            ++n2;
        }
        putField.put(INDEX_OF_SELECTED_TAB, arrayList4);
        objectOutputStream.writeFields();
    }

    void readData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ArrayList arrayList;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.attachData((DefaultContainerImpl.SerializedData)getField.get(DEFAULT_CONTAINER, null));
        this.serConstraints = (ArrayList)getField.get(CONSTRAINTS_LIST, null);
        if (WindowUtils.hasObjectStreamField(getField, TABBED_CONTAINERS_SIZE) && (arrayList = (ArrayList)getField.get(TABBED_CONTAINERS_SIZE, null)) != null) {
            this.prefTabbedSize = arrayList.toArray(new Dimension[5]);
        }
        if (WindowUtils.hasObjectStreamField(getField, INDEX_OF_SELECTED_TAB)) {
            this.serSelectedTabs = (ArrayList)getField.get(INDEX_OF_SELECTED_TAB, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        positionNames.add("NORTH");
        positionNames.add("SOUTH");
        positionNames.add("EAST");
        positionNames.add("WEST");
        positionNames.add("CENTER");
    }

    private final class PopupMouseImpl
    extends MouseUtils.PopupMouseAdapter {
        private PopupMouseImpl() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
            int n = tabbedPaneUI.tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            TopComponent topComponent = (TopComponent)jTabbedPane.getSelectedComponent();
            SplitContainerImpl.this.setSelectedTopComponent(topComponent);
            SplitContainerImpl.this.reactivateSelectedComponent();
            if (topComponent == null || !topComponent.equals(TopComponent.getRegistry().getActivated())) {
                return;
            }
            if (n != -1) {
                DefaultContainerImpl.showPopupMenu(DefaultContainerImpl.createPopupMenu(topComponent), mouseEvent.getPoint(), jTabbedPane);
            }
        }
    }

    private class TabbedContainerFocusL
    extends FocusAdapter {
        private TabbedContainerFocusL() {
        }

        public void focusGained(FocusEvent focusEvent) {
            TopComponent topComponent = (TopComponent)((JTabbedPane)focusEvent.getComponent()).getSelectedComponent();
            if (topComponent != null && topComponent != SplitContainerImpl.this.getSelectedTopComponent()) {
                SplitContainerImpl.this.setSelectedTopComponent(topComponent);
                SplitContainerImpl.this.reactivateWithDelay();
            }
        }
    }
}

