/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.openide.TopManager;
import org.openide.util.Utilities;

class ShortcutAndMenuKeyEventProcessor
implements KeyEventPostProcessor,
KeyEventDispatcher {
    private boolean wasPopupDisplayed;
    private KeyEvent lastKeyPressed;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$javax$swing$JComponent;

    ShortcutAndMenuKeyEventProcessor() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(this);
        keyboardFocusManager.addKeyEventPostProcessor(this);
    }

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        Window window = SwingUtilities.windowForComponent(keyEvent.getComponent());
        if (!ShortcutAndMenuKeyEventProcessor.isTransmodalAction(keyStroke) && window instanceof Dialog && ((Dialog)window).isModal()) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(keyEvent.getSource(), 1001, Utilities.keyToString((KeyStroke)keyStroke));
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        Action action = keymap.getAction(keyStroke);
        if (action != null && action.isEnabled()) {
            TopManager.getDefault().getActionManager().invokeAction(action, actionEvent);
            keyEvent.consume();
            return true;
        }
        if (window instanceof Dialog) {
            return false;
        }
        MainWindow mainWindow = WindowManagerImpl.mainWindow();
        if (mainWindow == window) {
            return false;
        }
        JMenuBar jMenuBar = mainWindow.getJMenuBar();
        if (jMenuBar == null) {
            return false;
        }
        boolean bl = keyEvent.getID() == 401;
        boolean bl2 = ShortcutAndMenuKeyEventProcessor.invokeProcessKeyBindingsForAllComponents(keyEvent, mainWindow, bl);
        if (bl2) {
            keyEvent.consume();
        }
        return bl2;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        MenuElement[] menuElementArray;
        int n;
        if (Utilities.getOperatingSystem() == 16 && (n = keyEvent.getModifiers()) == 4) {
            n = n & 0xFFFFFFFB | 8;
            keyEvent.setModifiers(n);
        }
        DefaultContainerImpl.runPendingNodeActivator();
        if (keyEvent.getID() == 401) {
            this.lastKeyPressed = keyEvent;
        }
        if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) == null || menuElementArray.length == 0) {
            this.wasPopupDisplayed = false;
            return false;
        }
        if (!this.wasPopupDisplayed && this.lastKeyPressed != null && keyEvent.getID() == 400 && this.lastKeyPressed.getModifiers() == 8 && keyEvent.getModifiers() == 8 && this.lastKeyPressed.getKeyChar() == keyEvent.getKeyChar()) {
            this.wasPopupDisplayed = true;
            keyEvent.consume();
            return true;
        }
        this.wasPopupDisplayed = true;
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && menuElementArray[0] instanceof JMenuBar) {
            keyEvent.setSource(WindowManagerImpl.mainWindow());
        }
        return keyEvent.isConsumed();
    }

    private static boolean invokeProcessKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl) {
        try {
            Method method = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = ShortcutAndMenuKeyEventProcessor.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getDeclaredMethod("processKeyBindingsForAllComponents", class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = ShortcutAndMenuKeyEventProcessor.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent, class$java$awt$Container == null ? (class$java$awt$Container = ShortcutAndMenuKeyEventProcessor.class$("java.awt.Container")) : class$java$awt$Container, Boolean.TYPE);
            if (method == null) {
                return false;
            }
            method.setAccessible(true);
            Boolean bl2 = (Boolean)method.invoke(null, keyEvent, container, new Boolean(bl));
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTransmodalAction(KeyStroke keyStroke) {
        Keymap keymap = TopManager.getDefault().getGlobalKeymap();
        Action action = keymap.getAction(keyStroke);
        if (action == null) {
            return false;
        }
        Object object = action.getValue("OpenIDE-Transmodal-Action");
        return object != null && object.equals(Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

