/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.netbeans.core.windows.frames.LayoutResourceManager;
import org.netbeans.core.windows.frames.PerimeterLayout;

public class PerimeterPane
extends JComponent
implements Accessible,
LayoutResourceManager {
    private PerimeterLayout layout = new PerimeterLayout();
    private HashMap components = new HashMap(5);
    private PerimeterGapListener pgl = new PerimeterGapListener();

    public PerimeterPane() {
        this.setLayout(this.layout);
        this.setBorder(BorderFactory.createEmptyBorder());
        PerimeterGapListener perimeterGapListener = new PerimeterGapListener();
        this.addMouseMotionListener(perimeterGapListener);
        this.addMouseListener(perimeterGapListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            static /* synthetic */ Class class$javax$swing$JPanel;

            public void eventDispatched(AWTEvent aWTEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (PerimeterPane.this.contains(mouseEvent.getPoint()) && (class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = 1.class$("javax.swing.JPanel")) : class$javax$swing$JPanel).equals(mouseEvent.getComponent().getClass())) {
                    PerimeterPane.this.dispatchEvent(new MouseEvent(PerimeterPane.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, 32L);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.components.put(object, component);
    }

    public void remove(Component component) {
        super.remove(component);
        if (this.components != null && component != null) {
            Iterator iterator = this.components.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!component.equals(entry.getValue())) continue;
                iterator.remove();
            }
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (!(layoutManager instanceof PerimeterLayout)) {
            throw new AWTError("PerimeterPanel can only use PerimeterLayout");
        }
        super.setLayout(layoutManager);
    }

    public Component getComponentAt(String string) {
        return (Component)this.components.get(string);
    }

    public void moveToFront(Component component) {
        this.layout.setDominant(component);
        component.requestFocus();
    }

    public void moveToFront(String string) {
        Component component = (Component)this.components.get(string);
        if (component != null) {
            component.requestFocus();
        }
        this.layout.setDominant(string);
    }

    public void setDominant(Component component) {
        this.layout.setDominant(component);
        this.revalidate();
    }

    public void setDominant(String string) {
        this.layout.setDominant(string);
        this.revalidate();
    }

    public void relayout(int n, int n2) {
        this.layout.relayout(n, n2);
    }

    private class PerimeterGapListener
    extends MouseAdapter
    implements MouseMotionListener {
        private static final int CHANGE = 3;
        private static final int NORTHSIDE = 0;
        private static final int SOUTHSIDE = 1;
        private static final int EASTSIDE = 2;
        private static final int WESTSIDE = 3;
        private static final int MIDDLE = 4;
        private int[] outcodes = new int[5];
        private PerimeterPane pPane = PerimeterPane.this;
        private boolean resizing = false;
        private boolean dragging = false;
        private Point mouseLocation;
        int oldCursorType = this.pPane.getCursor().getType();
        boolean sizingCursorSet = false;

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                this.mouseLocation = mouseEvent.getPoint();
                this.resizing = this.pPane.getComponentAt(this.mouseLocation) == this.pPane;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.resizing = false;
            this.dragging = false;
            this.pPane.setCursor(Cursor.getPredefinedCursor(this.oldCursorType));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.resizing) {
                this.dragging = true;
                Point point = mouseEvent.getPoint();
                if (this.oldCursorType == this.pPane.getCursor().getType() && this.sizingCursorSet) {
                    int n = this.getCursorType(this.outcodes[4]);
                    this.pPane.setCursor(Cursor.getPredefinedCursor(n));
                }
                if (point.distance(this.mouseLocation) > 3.0) {
                    Component component = null;
                    Rectangle rectangle = null;
                    HashMap hashMap = this.pPane.components;
                    Rectangle rectangle2 = this.pPane.getBounds();
                    if (this.outcodes[0] == 8) {
                        component = (Component)hashMap.get("NORTH");
                        rectangle = component.getBounds();
                        rectangle.height = point.y;
                        component.setBounds(rectangle);
                    }
                    if (this.outcodes[1] == 2) {
                        component = (Component)hashMap.get("SOUTH");
                        rectangle = component.getBounds();
                        rectangle.height = rectangle2.height - point.y - PerimeterPane.this.layout.getGap();
                        component.setBounds(rectangle);
                    }
                    if (this.outcodes[2] == 1) {
                        component = (Component)hashMap.get("EAST");
                        rectangle = component.getBounds();
                        rectangle.width = rectangle2.width - point.x - PerimeterPane.this.layout.getGap();
                        rectangle.x = point.x;
                        component.setBounds(rectangle);
                    }
                    if (this.outcodes[3] == 4) {
                        component = (Component)hashMap.get("WEST");
                        rectangle = component.getBounds();
                        rectangle.width = point.x;
                        component.setBounds(rectangle);
                    }
                    this.mouseLocation = point;
                    this.pPane.revalidate();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Component component = this.pPane.getComponentAt(mouseEvent.getPoint());
            this.updateOutcodes(mouseEvent.getPoint());
            int n = this.getCursorType(this.outcodes[4]);
            if (component == this.pPane) {
                if (!this.sizingCursorSet) {
                    this.oldCursorType = this.pPane.getCursor().getType();
                    this.sizingCursorSet = true;
                }
                this.pPane.setCursor(Cursor.getPredefinedCursor(n));
            } else if (this.sizingCursorSet) {
                this.pPane.setCursor(Cursor.getPredefinedCursor(this.oldCursorType));
                this.sizingCursorSet = false;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.dragging) {
                this.pPane.setCursor(Cursor.getPredefinedCursor(this.oldCursorType));
            }
        }

        private void updateOutcodes(Point point) {
            Component component = (Component)this.pPane.components.get("NORTH");
            this.outcodes[0] = component != null ? this.getOutcode(component, point) & 8 : 0;
            component = (Component)this.pPane.components.get("SOUTH");
            this.outcodes[1] = component != null ? this.getOutcode(component, point) & 2 : 0;
            component = (Component)this.pPane.components.get("EAST");
            this.outcodes[2] = component != null ? this.getOutcode(component, point) & 1 : 0;
            component = (Component)this.pPane.components.get("WEST");
            this.outcodes[3] = component != null ? this.getOutcode(component, point) & 4 : 0;
            this.outcodes[4] = this.outcodes[0] | this.outcodes[1] | this.outcodes[2] | this.outcodes[3];
        }

        private int getOutcode(Component component, Point point) {
            Rectangle rectangle = component.getBounds();
            int n = PerimeterPane.this.layout.getGap();
            rectangle.setLocation(rectangle.x - n, rectangle.y - n);
            rectangle.grow(n * 2, n * 2);
            return rectangle.contains(point) ? component.getBounds().outcode(point) : 0;
        }

        private int getCursorType(int n) {
            switch (n) {
                case 2: {
                    return 9;
                }
                case 8: {
                    return 8;
                }
                case 1: {
                    return 11;
                }
                case 4: {
                    return 10;
                }
                case 3: {
                    return 5;
                }
                case 12: {
                    return 6;
                }
                case 6: {
                    return 4;
                }
                case 9: {
                    return 7;
                }
                case 7: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    return 13;
                }
            }
            return this.pPane.getCursor().getType();
        }
    }
}

