/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeAdapter;
import org.netbeans.core.windows.frames.FrameTypeEvent;
import org.netbeans.core.windows.frames.FrameTypeSupport;
import org.netbeans.core.windows.frames.InternalFrameTypeImpl;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.frames.PerimeterPane;
import org.openide.util.Utilities;

public class DesktopPane
extends PerimeterPane
implements SwingConstants {
    private JDesktopPane desktopPane = new JDesktopPane();
    private DesktopScrollbarListener desktopScrollbarListener = new DesktopScrollbarListener();
    private MinMaxListener minMaxListener = new MinMaxListener();
    private DeactivationListener deactivationListener = new DeactivationListener();
    private JScrollPane desktopScrollPane = new JScrollPane(this.desktopPane);
    private boolean maxMode;
    private WeakHashMap frames2States;
    private Window topLevelWindow;
    private static int HORIZONTAL_STEP = 10;
    private static int VERTICAL_STEP = 14;

    public DesktopPane() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.desktopPane.putClientProperty("JDesktopPane.dragMode", "outline");
        this.desktopPane.addContainerListener(this.desktopScrollbarListener);
        this.desktopScrollPane.getVerticalScrollBar().addAdjustmentListener(this.desktopScrollbarListener);
        this.desktopScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.desktopScrollbarListener);
        super.addImpl(this.desktopScrollPane, "CENTER", 0);
        this.desktopPane.registerKeyboardAction(new CloseViewActionRunner(), KeyStroke.getKeyStroke(115, 2), 1);
    }

    public void addNotify() {
        super.addNotify();
        Window window = SwingUtilities.windowForComponent(this);
        if (window != this.topLevelWindow) {
            window.addWindowListener(this.deactivationListener);
            if (this.topLevelWindow != null) {
                this.topLevelWindow.removeWindowListener(this.deactivationListener);
            }
            this.topLevelWindow = window;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.topLevelWindow != null) {
            this.topLevelWindow.removeWindowListener(this.deactivationListener);
            this.topLevelWindow = null;
        }
    }

    public Dimension getInnerDesktopSize() {
        return this.desktopPane.getSize();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (object == "CENTER") {
            throw new IllegalArgumentException("Cannot replace desktop.");
        }
        super.addImpl(component, object, n + 1);
    }

    public void addFrameType(FrameType frameType) {
        Container container = frameType.getRootPaneContainer();
        container.addComponentListener(this.desktopScrollbarListener);
        frameType.addFrameTypeListener(this.minMaxListener);
        if (frameType.getIcon() != null) {
            frameType.getIcon().addComponentListener(this.desktopScrollbarListener);
        }
        frameType.addFrameTypeListener(this.deactivationListener);
        this.desktopPane.add(FrameTypeSupport.obtainFrameComponent(frameType));
    }

    public void addFrameType(FrameType frameType, Object object) {
        if (object == "CENTER") {
            this.addFrameType(frameType);
        } else {
            frameType.addFrameTypeListener(this.deactivationListener);
            this.add((Component)frameType.getRootPaneContainer(), object);
        }
    }

    public void removeFrameType(FrameType frameType) {
        Component component = FrameTypeSupport.obtainFrameComponent(frameType);
        if (this.desktopPane.isAncestorOf(component)) {
            ((Container)this.desktopPane).remove(component);
            if (component.isVisible()) {
                this.desktopPane.repaint();
            }
        } else {
            this.remove(component);
        }
        if (frameType.getIcon() != null) {
            frameType.getIcon().removeComponentListener(this.desktopScrollbarListener);
        }
        frameType.getRootPaneContainer().removeComponentListener(this.desktopScrollbarListener);
        frameType.removeFrameTypeListener(this.minMaxListener);
        frameType.removeFrameTypeListener(this.deactivationListener);
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component != this.desktopScrollPane) {
            super.remove(n);
            this.revalidate();
        }
    }

    public void remove(Component component) {
        if (component != this.desktopScrollPane) {
            super.remove(component);
        }
    }

    public void removeAll() {
        ((Container)this.desktopPane).removeAll();
        super.removeAll();
    }

    public void moveToFront(FrameType frameType) {
        Component component = FrameTypeSupport.obtainFrameComponent(frameType);
        if (this.desktopPane.isAncestorOf(component)) {
            this.desktopPane.moveToFront(component);
            if (component instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)component).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
        } else {
            super.moveToFront(component);
        }
    }

    public void setAutoFocusEnabled(boolean bl) {
        this.deactivationListener.setAutoFocusEnabled(bl);
    }

    public boolean isAutoFocusEnabled() {
        return this.deactivationListener.isAutoFocusEnabled();
    }

    public void setMaxMode(boolean bl) {
        if (this.maxMode == bl) {
            return;
        }
        this.maxMode = bl;
        this.desktopScrollbarListener.passivate();
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (bl) {
            this.frames2States = new WeakHashMap(Math.max(5, jInternalFrameArray.length * 2));
        }
        int n = 0;
        while (n < jInternalFrameArray.length) {
            this.setMaxModeForFrame(jInternalFrameArray[n], bl);
            ++n;
        }
        if (!bl) {
            this.frames2States = null;
        }
        this.desktopScrollbarListener.activate();
    }

    public boolean isMaxMode() {
        return this.maxMode;
    }

    private void setMaxModeForFrame(JInternalFrame jInternalFrame, boolean bl) {
        if (bl) {
            Rectangle rectangle = this.desktopScrollPane.getViewport().getViewRect();
            try {
                if (jInternalFrame.isIcon()) {
                    this.frames2States.put(jInternalFrame, Boolean.TRUE);
                }
                jInternalFrame.setMaximum(true);
                jInternalFrame.setBounds(rectangle);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        } else {
            try {
                jInternalFrame.setMaximum(false);
                if (this.frames2States.get(jInternalFrame) != null) {
                    jInternalFrame.setIcon(true);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
    }

    public Rectangle getFrameBounds(FrameType frameType) {
        Component component = FrameTypeSupport.obtainFrameComponent(frameType);
        if (component instanceof JInternalFrame) {
            return ((JInternalFrame)component).getNormalBounds();
        }
        return component.getBounds();
    }

    public int getFrameState(FrameType frameType) {
        if (this.isMaxMode()) {
            return this.frames2States.get(frameType.getRootPaneContainer()) != null ? 1 : 0;
        }
        return frameType.getState();
    }

    public void relayout(int n, int n2) {
        PerimeterLayout.relayoutImpl(n, n2, this.desktopPane.getComponents());
    }

    private class MinMaxListener
    extends FrameTypeAdapter {
        private boolean maximized = false;

        private MinMaxListener() {
        }

        public void frameClosed(FrameTypeEvent frameTypeEvent) {
            if (DesktopPane.this.desktopPane.getAllFrames().length == 0) {
                DesktopPane.this.setMaxMode(false);
            }
        }

        public void frameIconified(FrameTypeEvent frameTypeEvent) {
            InternalFrameTypeImpl internalFrameTypeImpl = (InternalFrameTypeImpl)frameTypeEvent.getSource();
            if (!internalFrameTypeImpl.isVisible()) {
                return;
            }
            DesktopPane.this.setMaxMode(false);
            Rectangle rectangle = DesktopPane.this.desktopScrollPane.getViewport().getViewRect();
            JInternalFrame.JDesktopIcon jDesktopIcon = internalFrameTypeImpl.getDesktopIcon();
            Rectangle rectangle2 = jDesktopIcon.getBounds();
            rectangle2.setLocation(rectangle.x, rectangle.y + rectangle.height - rectangle2.height);
            Component component = null;
            do {
                Component component2 = component = (component = DesktopPane.this.desktopPane.getComponentAt(rectangle2.getLocation())) instanceof RootPaneContainer || component == jDesktopIcon || component == DesktopPane.this.desktopPane ? null : component;
                if (component == null) continue;
                rectangle2.setLocation(rectangle2.x + component.getBounds().width, rectangle2.y);
            } while (component != null);
        }

        public void frameMaximized(FrameTypeEvent frameTypeEvent) {
            if (!((InternalFrameTypeImpl)frameTypeEvent.getSource()).isVisible()) {
                return;
            }
            if (!DesktopPane.this.isMaxMode()) {
                DesktopPane.this.setMaxMode(true);
                this.selectFrame((FrameType)frameTypeEvent.getSource());
            }
        }

        public void frameNormalized(FrameTypeEvent frameTypeEvent) {
            if (!((InternalFrameTypeImpl)frameTypeEvent.getSource()).isVisible()) {
                return;
            }
            if (DesktopPane.this.isMaxMode()) {
                DesktopPane.this.frames2States.remove(frameTypeEvent.getSource());
                DesktopPane.this.setMaxMode(false);
                this.selectFrame((FrameType)frameTypeEvent.getSource());
            }
        }

        private void selectFrame(FrameType frameType) {
            DesktopPane.this.moveToFront(frameType);
        }
    }

    private class DesktopScrollbarListener
    implements ComponentListener,
    ContainerListener,
    AdjustmentListener {
        private boolean nowUpdating = false;

        private DesktopScrollbarListener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.checkDesktopSize();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.checkDesktopSize();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.checkDesktopSize();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.checkDesktopSize();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.checkDesktopSize();
        }

        public void componentAdded(ContainerEvent containerEvent) {
            if (DesktopPane.this.isMaxMode() && containerEvent.getChild() instanceof FrameType) {
                try {
                    ((FrameType)((Object)containerEvent.getChild())).setState(2);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
            this.checkDesktopSize();
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this.checkDesktopSize();
        }

        private void checkDesktopSize() {
            if (this.nowUpdating) {
                return;
            }
            this.nowUpdating = true;
            JDesktopPane jDesktopPane = DesktopPane.this.desktopPane;
            JScrollPane jScrollPane = DesktopPane.this.desktopScrollPane;
            Rectangle rectangle = jScrollPane.getViewport().getViewRect();
            Point point = jScrollPane.getViewport().getViewPosition();
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            if (!DesktopPane.this.isMaxMode()) {
                int n = 0;
                while (n < jInternalFrameArray.length) {
                    Rectangle rectangle2;
                    Rectangle rectangle3 = rectangle2 = jInternalFrameArray[n].isIcon() ? jInternalFrameArray[n].getDesktopIcon().getBounds() : jInternalFrameArray[n].getBounds();
                    if (jInternalFrameArray[n].isIcon()) {
                        rectangle2.y = 0;
                    }
                    rectangle.add(rectangle2);
                    ++n;
                }
                boolean bl = !rectangle.getSize().equals(jDesktopPane.getSize());
                boolean bl2 = (rectangle.x != 0 || rectangle.y != 0) && point.x != -rectangle.x && point.y != -rectangle.y;
                this.resizeDesktop(rectangle, point);
            } else {
                int n = 0;
                while (n < jInternalFrameArray.length) {
                    jInternalFrameArray[n].setBounds(jScrollPane.getViewport().getViewRect());
                    ++n;
                }
                this.resizeDesktop(rectangle, point);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    nowUpdating = false;
                }
            });
        }

        private void resizeDesktop(Rectangle rectangle, Point point) {
            JDesktopPane jDesktopPane = DesktopPane.this.desktopPane;
            JScrollPane jScrollPane = DesktopPane.this.desktopScrollPane;
            boolean bl = jDesktopPane.getSize().getHeight() == 0.0 && jDesktopPane.getSize().getWidth() == 0.0;
            this.passivate();
            JViewport jViewport = jScrollPane.getViewport();
            jScrollPane.setVisible(false);
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            JInternalFrame jInternalFrame = null;
            JComponent jComponent = null;
            boolean bl2 = false;
            int n = 0;
            while (n < jInternalFrameArray.length) {
                jInternalFrame = jInternalFrameArray[n];
                bl2 = jInternalFrame.isIcon();
                jComponent = bl2 ? jInternalFrame.getDesktopIcon() : jInternalFrame;
                Point point2 = jComponent.getLocation();
                point2.x -= rectangle.x;
                point2.y -= rectangle.y;
                if (bl2) {
                    point2.y -= rectangle.height - jDesktopPane.getSize().height;
                    point2.y = Math.min(point2.y, jDesktopPane.getHeight() - ((Component)jComponent).getHeight());
                }
                jComponent.setLocation(point2);
                ++n;
            }
            jDesktopPane.setPreferredSize(rectangle.getSize());
            jDesktopPane.setSize(rectangle.getSize());
            jDesktopPane.revalidate();
            if (rectangle.x != 0 || rectangle.y != 0) {
                point.translate(-rectangle.x, -rectangle.y);
                jViewport.setViewPosition(point);
            }
            if (!bl) {
                this.determineScrollBarPolicy(rectangle);
            }
            jScrollPane.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(this, jScrollPane){
                private final /* synthetic */ JScrollPane val$scrollPane;
                private final /* synthetic */ DesktopScrollbarListener this$1;
                {
                    this.this$1 = desktopScrollbarListener;
                    this.val$scrollPane = jScrollPane;
                }

                public void run() {
                    this.val$scrollPane.invalidate();
                    this.val$scrollPane.validate();
                }
            });
            this.activate();
        }

        private void determineScrollBarPolicy(Rectangle rectangle) {
            JScrollPane jScrollPane = DesktopPane.this.desktopScrollPane;
            Dimension dimension = jScrollPane.getSize();
            int n = rectangle.height > dimension.height ? 22 : 21;
            boolean bl = n == 22;
            int n2 = rectangle.width > dimension.width ? 32 : 31;
            boolean bl2 = n2 == 32;
            jScrollPane.setVerticalScrollBarPolicy(n);
            jScrollPane.setHorizontalScrollBarPolicy(n2);
            jScrollPane.getVerticalScrollBar().setEnabled(bl);
            jScrollPane.getHorizontalScrollBar().setEnabled(bl2);
            if (bl) {
                jScrollPane.getVerticalScrollBar().setUnitIncrement(VERTICAL_STEP);
            }
            if (bl2) {
                jScrollPane.getHorizontalScrollBar().setUnitIncrement(HORIZONTAL_STEP);
            }
        }

        private void passivate() {
            JDesktopPane jDesktopPane = DesktopPane.this.desktopPane;
            JScrollPane jScrollPane = DesktopPane.this.desktopScrollPane;
            jDesktopPane.removeContainerListener(this);
            jScrollPane.getVerticalScrollBar().removeAdjustmentListener(this);
            jScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this);
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            int n = 0;
            while (n < jInternalFrameArray.length) {
                jInternalFrameArray[n].getDesktopIcon().removeComponentListener(this);
                jInternalFrameArray[n].removeComponentListener(this);
                ++n;
            }
        }

        private void activate() {
            JDesktopPane jDesktopPane = DesktopPane.this.desktopPane;
            JScrollPane jScrollPane = DesktopPane.this.desktopScrollPane;
            jDesktopPane.addContainerListener(this);
            jScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
            jScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            int n = 0;
            while (n < jInternalFrameArray.length) {
                jInternalFrameArray[n].getDesktopIcon().addComponentListener(this);
                jInternalFrameArray[n].addComponentListener(this);
                ++n;
            }
        }
    }

    private static class DeactivationListener
    extends FrameTypeAdapter
    implements WindowListener {
        private FrameType activated;
        private boolean autoFocusEnabled = true;

        private DeactivationListener() {
        }

        public void setAutoFocusEnabled(boolean bl) {
            if (this.autoFocusEnabled == bl) {
                return;
            }
            this.autoFocusEnabled = bl;
        }

        public boolean isAutoFocusEnabled() {
            return this.autoFocusEnabled;
        }

        public void frameActivated(FrameTypeEvent frameTypeEvent) {
            FrameType frameType = (FrameType)frameTypeEvent.getSource();
            if (this.activated != null && frameType != this.activated) {
                try {
                    this.activated.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
            this.activated = frameType;
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            if (this.autoFocusEnabled && this.activated != null) {
                try {
                    this.activated.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.autoFocusEnabled && this.activated != null) {
                try {
                    this.activated.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }
    }

    private static final class CloseViewActionRunner
    implements ActionListener {
        private CloseViewActionRunner() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(115, 2);
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), 1001, Utilities.keyToString((KeyStroke)keyStroke));
            NbFocusManager.processKeyStroke(keyStroke, actionEvent2);
        }
    }
}

