/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.projects.SessionManager;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.TabbedContainerUIManager;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.WeakHash;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.layers.ResetCookie;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.TopManager;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WindowManagerImpl
extends WindowManager {
    public static final String TC_PREFIX = "wstopcomp";
    public static final int PROPERTIES = 1;
    public static final int WORKSPACES = 2;
    static MainWindow mainWindow;
    static WindowManagerImpl defaultInstance;
    static StateManager stateManager;
    static DeferredPerformer deferredPerformer;
    private UIModeManager uiModeManager;
    private TabbedContainerUIManager tabbedContainerUIManager;
    private Workspace[] workspaces;
    private Workspace current;
    int savedUIMode = 0;
    private PropertyChangeSupport changeSupport;
    private HashSet tcListeners;
    private static Hashtable lastActivatedComponents;
    private boolean isCreated;
    private WeakHash workspace2Nodes;
    private boolean serializationInProgress = false;
    private boolean mainPositioned = false;
    private TopComponentManager validatedManager;
    private Exception mainEx;
    private Map failedCompsMap;
    private Dimension oldScreenSize;
    private Rectangle oldMainWindowBounds;
    private LazyUpdater updater;
    private PersistenceManager persistenceManager;
    static final long serialVersionUID = 680725949680433701L;
    private static final String DEFAULT_NAME = "untitled_mode";
    private static final int MAX_MODE_NAME_LENGTH = 20;
    private static boolean isProjectOpen;
    private static Object LOCK;
    static /* synthetic */ Class class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
    static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;

    private WindowManagerImpl() {
        this.initialize();
    }

    private void initialize() {
        this.initToolbars();
        this.changeSupport = new PropertyChangeSupport((Object)this);
        this.workspace2Nodes = new WeakHash();
        this.workspaces = new Workspace[0];
    }

    private void initToolbars() {
        Class clazz = class$org$netbeans$core$windows$toolbars$ToolbarProcessor == null ? (class$org$netbeans$core$windows$toolbars$ToolbarProcessor = WindowManagerImpl.class$("org.netbeans.core.windows.toolbars.ToolbarProcessor")) : class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
        XMLDataObject.Info info = new XMLDataObject.Info();
        info.addProcessorClass(clazz);
        info.setIconBase("/org/netbeans/core/windows/toolbars/xmlToolbars");
        XMLDataObject.registerInfo((String)"-//Forte for Java//DTD toolbar//EN", (XMLDataObject.Info)info);
    }

    public static synchronized WindowManagerImpl getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new WindowManagerImpl();
            if (NbTopManager.get().isInteractive(4)) {
                SessionManager.getDefault().addPropertyChangeListener(new ProjectSwitchListener());
            }
        }
        return defaultInstance;
    }

    public static StateManager stateManager() {
        if (stateManager == null) {
            stateManager = new StateManager();
        }
        return stateManager;
    }

    public static DeferredPerformer deferredPerformer() {
        if (deferredPerformer == null) {
            deferredPerformer = new DeferredPerformer();
        }
        return deferredPerformer;
    }

    public static void cleanWindowManager() {
        if (defaultInstance == null) {
            WindowManagerImpl.getDefault();
        } else {
            Workspace[] workspaceArray = WindowManagerImpl.getDefault().getWorkspaces();
            int n = 0;
            while (n < workspaceArray.length) {
                workspaceArray[n].remove();
                ++n;
            }
        }
    }

    public static void createFromScratch() {
        if ("full".equals(System.getProperty("netbeans.full.hack"))) {
            return;
        }
        if (defaultInstance == null) {
            WindowManagerImpl.getDefault();
        }
    }

    public Frame getMainWindow() {
        return WindowManagerImpl.mainWindow();
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(mainWindow);
        mainWindow.pack();
        Workspace[] workspaceArray = this.getWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            Iterator iterator = workspaceArray[n].getModes().iterator();
            while (iterator.hasNext()) {
                ((ModeImpl)iterator.next()).updateUI();
            }
            ++n;
        }
    }

    protected TopComponent.Registry componentRegistry() {
        RegistryImpl registryImpl = new RegistryImpl();
        this.addTopComponentListener(registryImpl);
        return registryImpl;
    }

    public Workspace createWorkspace(String string, String string2) {
        return new WorkspaceImpl(string, string2);
    }

    public Workspace findWorkspace(String string) {
        return this.doFindWorkspace(string, true);
    }

    public Workspace findLoadedWorkspace(String string) {
        return this.doFindWorkspace(string, false);
    }

    private Workspace doFindWorkspace(String string, boolean bl) {
        if (bl) {
            this.ensureSectionLoaded(3);
        }
        int n = 0;
        while (n < this.workspaces.length) {
            if (string.equals(this.workspaces[n].getName())) {
                return this.workspaces[n];
            }
            ++n;
        }
        return null;
    }

    public Workspace[] getWorkspaces() {
        this.ensureSectionLoaded(3);
        return this.workspaces;
    }

    public Workspace[] getWorkspacesNoLoad() {
        return this.workspaces;
    }

    public void setWorkspaces(Workspace[] workspaceArray) {
        if (Arrays.equals(this.workspaces, workspaceArray)) {
            return;
        }
        int n = 0;
        while (n < workspaceArray.length) {
            if (workspaceArray[n] == null) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
        Workspace[] workspaceArray2 = this.workspaces;
        this.workspaces = workspaceArray;
        this.changeSupport.firePropertyChange("workspaces", workspaceArray2, this.workspaces);
    }

    public Workspace getCurrentWorkspace() {
        this.ensureSectionLoaded(3);
        if (this.current == null) {
            this.current = new WorkspaceImpl();
        }
        return this.current;
    }

    public Workspace getCurrentWorkspaceNoLoad() {
        return this.current;
    }

    public void setCurrentWorkspace(Workspace workspace) {
        this.ensureSectionLoaded(3);
        if (SwingUtilities.isEventDispatchThread()) {
            this.getWorkspaceSetter(workspace).run();
        } else {
            SwingUtilities.invokeLater(this.getWorkspaceSetter(workspace));
        }
    }

    private Runnable getWorkspaceSetter(final Workspace workspace) {
        return new Runnable(){

            public void run() {
                if (WindowManagerImpl.this.current != null && WindowManagerImpl.this.current.equals(workspace)) {
                    return;
                }
                boolean bl = false;
                int n = 0;
                while (n < WindowManagerImpl.this.workspaces.length) {
                    if (WindowManagerImpl.this.workspaces[n].equals(workspace)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    return;
                }
                StateManager stateManager = WindowManagerImpl.stateManager();
                if ((stateManager.getState() & 0x20) != 0) {
                    stateManager.setMainState(256);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
                Workspace workspace2 = WindowManagerImpl.this.current;
                WindowManagerImpl.this.current = workspace;
                if (workspace2 != null) {
                    WindowManagerImpl.this.workspace2Nodes.put(workspace2, WindowManagerImpl.getSelectedNodes());
                    ((WorkspaceImpl)workspace2).setVisible(false);
                }
                ((WorkspaceImpl)WindowManagerImpl.this.current).setVisible(true);
                WindowManagerImpl.this.changeSupport.firePropertyChange("currentWorkspace", workspace2, WindowManagerImpl.this.current);
                WindowManagerImpl.this.setSelectedNodes(WindowManagerImpl.this.workspace2Nodes.get(WindowManagerImpl.this.current));
                if ((stateManager.getState() & 0x100) != 0) {
                    stateManager.setMainState(32);
                }
            }
        };
    }

    public int getSavedUIMode() {
        this.ensureSectionLoaded(1);
        return this.savedUIMode;
    }

    public void setSavedUIMode(int n) {
        this.savedUIMode = n;
    }

    public void attachUpdater(LazyUpdater lazyUpdater) {
        this.updater = lazyUpdater;
    }

    private boolean ensureSectionLoaded(int n) {
        try {
            if (this.updater == null) {
                this.persistenceManager().readXML();
                if (this.updater == null) {
                    return false;
                }
            }
            if ((n & this.updater.getLoadedSections()) != n) {
                this.updater.loadDataSection(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized void nextWorkspace() {
        int n;
        Workspace workspace = this.getCurrentWorkspace();
        int n2 = n = this.workspaces.length - 1;
        while (n2 >= 0) {
            if (this.workspaces[n2] == workspace) {
                n2 = n2 == n ? 0 : ++n2;
                workspace = this.workspaces[n2];
                workspace.activate();
                return;
            }
            --n2;
        }
    }

    public synchronized void previousWorkspace() {
        int n;
        Workspace workspace = this.getCurrentWorkspace();
        int n2 = n = this.workspaces.length - 1;
        while (n2 >= 0) {
            if (this.workspaces[n2] == workspace) {
                n2 = n2 == 0 ? n : --n2;
                workspace = this.workspaces[n2];
                workspace.activate();
                return;
            }
            --n2;
        }
    }

    public void attachExplorer(Runnable runnable, ExplorerManager explorerManager) {
        ((RegistryImpl)this.getRegistry()).attachExplorer(runnable, explorerManager);
    }

    static WeakHash.Value getSelectedNodes() {
        Node[] nodeArray = WindowManagerImpl.getDefault().getRegistry().getCurrentNodes();
        Node[] nodeArray2 = WindowManagerImpl.getDefault().getRegistry().getActivatedNodes();
        TopComponent topComponent = WindowManagerImpl.getDefault().getRegistry().getActivated();
        return new WeakHash.Value(nodeArray, nodeArray2, topComponent);
    }

    void setSelectedNodes(WeakHash.Value value) {
        Node[] nodeArray = value == null ? new Node[]{} : value.getActivatedNodes();
        Node[] nodeArray2 = value == null ? new Node[]{} : value.getCurrentNodes();
        Node[][] nodeArrayArray = new Node[][]{nodeArray2, nodeArray};
        RegistryImpl registryImpl = (RegistryImpl)this.getRegistry();
        SelectedNodesChangedEvent selectedNodesChangedEvent = new SelectedNodesChangedEvent(nodeArrayArray, null, nodeArray);
        registryImpl.selectedNodesChanged(selectedNodesChangedEvent);
        selectedNodesChangedEvent = new SelectedNodesChangedEvent(nodeArrayArray, null, nodeArray2);
        registryImpl.selectedNodesChanged(selectedNodesChangedEvent);
        if (value != null) {
            // empty if block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addTopComponentListener(TopComponentListener topComponentListener) {
        if (this.tcListeners == null) {
            this.tcListeners = new HashSet(5);
        }
        this.tcListeners.add(topComponentListener);
    }

    public synchronized void removeTopComponentListener(TopComponentListener topComponentListener) {
        if (this.tcListeners == null) {
            return;
        }
        this.tcListeners.remove(topComponentListener);
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    void setCreated(boolean bl) {
        this.isCreated = bl;
    }

    public boolean isMainPositioned() {
        return this.mainPositioned;
    }

    public void setMainPositioned(boolean bl) {
        this.mainPositioned = bl;
    }

    Set getTcListenersForFiring() {
        if (this.tcListeners == null) {
            return null;
        }
        Set set = null;
        WindowManagerImpl windowManagerImpl = this;
        synchronized (windowManagerImpl) {
            set = (Set)this.tcListeners.clone();
        }
        return set;
    }

    public static TopComponentContainer findContainer(String string) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
        TopComponentContainer topComponentContainer = null;
        Workspace workspace = windowManagerImpl.getCurrentWorkspace();
        topComponentContainer = WindowManagerImpl.findContainer(string, workspace);
        if (null != topComponentContainer) {
            return topComponentContainer;
        }
        Workspace[] workspaceArray = windowManagerImpl.getWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            if (workspaceArray[n] != workspace && null != (topComponentContainer = WindowManagerImpl.findContainer(string, workspaceArray[n]))) break;
            ++n;
        }
        return topComponentContainer;
    }

    public static TopComponentContainer findContainer(String string, Workspace workspace) {
        TopComponentContainer topComponentContainer = null;
        ModeImpl modeImpl = (ModeImpl)workspace.findMode(string);
        if (null != modeImpl && null != (topComponentContainer = modeImpl.getContainerInstance()) && 0 == topComponentContainer.getTopComponents().length) {
            topComponentContainer = null;
        }
        return topComponentContainer;
    }

    public static String findUnusedModeName(String string, Workspace workspace) {
        return WindowManagerImpl.findUnusedModeName(string, workspace, false);
    }

    public static String findUnusedModeName(String string, Workspace workspace, boolean bl) {
        if (string == null) {
            string = DEFAULT_NAME;
        }
        if (string.length() > 20) {
            string = string.substring(0, 20);
        }
        if (!bl && workspace.findMode(string) == null) {
            return string;
        }
        String string2 = null;
        int n = 1;
        while (workspace.findMode(string2 = string + "_" + n) != null) {
            ++n;
        }
        return string2;
    }

    public void activateComponent(TopComponent topComponent) {
        Set set;
        if (topComponent != null) {
            ((WorkspaceImpl)this.getCurrentWorkspace()).componentActivated(topComponent);
        }
        if ((set = this.getTcListenersForFiring()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ((TopComponentListener)iterator.next()).topComponentActivated(new TopComponentChangedEvent((Object)this, topComponent, this.getCurrentWorkspace(), TopComponentChangedEvent.ACTIVATED));
            }
        }
        super.activateComponent(topComponent);
    }

    public void annotatePersistenceError(Exception exception, String string) {
        if (this.mainEx == null) {
            this.mainEx = new Exception();
        }
        TopManager.getDefault().getErrorManager().annotate((Throwable)this.mainEx, (Throwable)exception);
        if (this.failedCompsMap == null) {
            this.failedCompsMap = new HashMap();
        }
        this.failedCompsMap.put(string, string);
    }

    public void checkPersistenceErrors(boolean bl) {
        if (this.mainEx == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.failedCompsMap.values().iterator();
        stringBuffer.append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(", " + (String)iterator.next());
        }
        String string = null;
        string = bl ? MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = WindowManagerImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl)).getString("FMT_TCReadError"), stringBuffer.toString()) : MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = WindowManagerImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl)).getString("FMT_TCWriteError"), stringBuffer.toString());
        TopManager.getDefault().getErrorManager().annotate((Throwable)this.mainEx, string);
        TopManager.getDefault().getErrorManager().notify(4096, (Throwable)this.mainEx);
        this.mainEx = null;
        this.failedCompsMap = null;
    }

    protected synchronized WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        TopComponentManager topComponentManager = this.validatedManager == null ? new TopComponentManager(topComponent) : this.validatedManager;
        this.validatedManager = null;
        return topComponentManager;
    }

    private void setValidatedManager(TopComponentManager topComponentManager) {
        this.validatedManager = topComponentManager;
    }

    private TopComponentManager getValidatedManager() {
        return this.validatedManager;
    }

    public static TopComponentManager findManager(TopComponent topComponent) {
        return (TopComponentManager)WindowManager.findComponentManager((TopComponent)topComponent);
    }

    public static final MainWindow mainWindow() {
        if (mainWindow == null) {
            Class clazz = class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = WindowManagerImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl;
            synchronized (clazz) {
                if (mainWindow == null) {
                    mainWindow = MainWindow.getDefault();
                    mainWindow.addWindowListener(new IconifyManager());
                }
            }
        }
        return mainWindow;
    }

    public String findFrameType(ModeImpl modeImpl) {
        return this.uiModeManager().findFrameType(modeImpl);
    }

    public final UIModeManager uiModeManager() {
        if (this.uiModeManager == null) {
            this.uiModeManager = new UIModeManager();
        }
        return this.uiModeManager;
    }

    public void setTabbedContainerUI(int n) {
        this.tabbedContainerUIManager().setTabbedContainerUI(n);
    }

    public int getTabbedContainerUI() {
        return this.tabbedContainerUIManager().getTabbedContainerUI();
    }

    public final TabbedContainerUIManager tabbedContainerUIManager() {
        if (this.tabbedContainerUIManager == null) {
            this.tabbedContainerUIManager = new TabbedContainerUIManager();
        }
        return this.tabbedContainerUIManager;
    }

    public Dimension getOldScreenSize() {
        return this.oldScreenSize;
    }

    public Rectangle getOldMainWindowBounds() {
        return this.oldMainWindowBounds;
    }

    public TopComponent lookupTCInstance(String string) throws IOException {
        return this.persistenceManager().lookupTCInstance(string);
    }

    public String lookupTCStringId(TopComponent topComponent) throws IOException {
        return this.persistenceManager().lookupTCStringId(topComponent);
    }

    public PersistenceManager persistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = new PersistenceManager();
        }
        return this.persistenceManager;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer();
    }

    public static boolean isProjectOpen() {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = isProjectOpen;
            return bl;
        }
    }

    private static void setProjectOpen(boolean bl) {
        Object object = LOCK;
        synchronized (object) {
            isProjectOpen = bl;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        isProjectOpen = false;
        LOCK = new Object();
    }

    public static final class TopComponentManager
    extends ComponentAdapter
    implements WindowManager.Component,
    DeferredPerformer.DeferredCommand,
    Runnable {
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";
        public static final String PROP_NAME = "name";
        public static final String PROP_ICON = "icon";
        public static final String TAB_POLICY = "TabPolicy";
        public static final String HIDE_WHEN_ALONE = "HideWhenAlone";
        HashSet whereOpened;
        TopComponent component;
        private NbMarshalledObject marshalledComponent;
        String componentName;
        Image icon;
        Node[] nodes;
        Node[] tempNodes;
        WindowManagerImpl wm;
        PropertyChangeSupport changeSupport;
        DeferredPerformer deferredPerformer;
        private int innerState = 1;
        private RequestProcessor.Task deferNameChange;
        private static final int READY = 1;
        private static final int INVALID = 2;
        private static final int FAILED = 4;
        private static VersionSerializator serializationManager;
        static final long serialVersionUID = 5669852754182098300L;

        TopComponentManager(TopComponent topComponent) {
            this.component = topComponent;
            this.whereOpened = new HashSet(5);
            this.initialize();
        }

        private void initialize() {
            this.wm = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
            this.changeSupport = new PropertyChangeSupport(this);
            this.deferredPerformer = WindowManagerImpl.deferredPerformer();
        }

        public void open() {
            this.open(null);
        }

        public void open(Workspace workspace) {
            if (this.deferredPerformer.canImmediatelly()) {
                Workspace workspace2;
                Workspace workspace3 = workspace2 = workspace == null ? this.wm.getCurrentWorkspace() : workspace;
                if (EventQueue.isDispatchThread()) {
                    this.doOpen(workspace2);
                } else {
                    SwingUtilities.invokeLater(new Runnable(this, workspace2){
                        private final /* synthetic */ Workspace val$realWorkspace;
                        private final /* synthetic */ TopComponentManager this$0;
                        {
                            this.this$0 = topComponentManager;
                            this.val$realWorkspace = workspace;
                        }

                        public void run() {
                            TopComponentManager.access$1100(this.this$0, this.val$realWorkspace);
                        }
                    });
                }
            } else {
                this.deferredPerformer.putRequest((DeferredPerformer.DeferredCommand)this, workspace);
            }
        }

        public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
            this.component.open((Workspace)deferredContext.getData());
        }

        private void doOpen(Workspace workspace) {
            Object object;
            Mode mode = workspace.findMode(this.component);
            if (!this.whereOpened.add(workspace)) {
                if (mode != null && ((ModeImpl)mode).getFrameState() == 1) {
                    ((ModeImpl)mode).setFrameState(0);
                }
                return;
            }
            if (mode == null) {
                object = WindowManagerImpl.findUnusedModeName(this.component.getName(), workspace);
                mode = ((WorkspaceImpl)workspace).createMode((String)object, (String)object, null, true);
            }
            mode.dockInto(this.component);
            if (this.whereOpened.size() == 1) {
                WindowManagerImpl.super.componentOpenNotify(this.component);
            }
            if ((object = this.wm.getTcListenersForFiring()) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ((TopComponentListener)iterator.next()).topComponentOpened(new TopComponentChangedEvent(this, this.component, workspace, TopComponentChangedEvent.OPENED));
                }
            }
        }

        public boolean isOpened() {
            return this.whereOpened.size() > 0;
        }

        public boolean isOpened(Workspace workspace) {
            return this.whereOpened.contains(workspace);
        }

        public void close(Workspace workspace) {
            switch (this.component.getCloseOperation()) {
                case 1: {
                    if (!this.isOpened(workspace)) break;
                    this.doClose(workspace);
                    break;
                }
                case 0: {
                    Workspace[] workspaceArray = this.wm.getWorkspaces();
                    int n = 0;
                    while (n < workspaceArray.length) {
                        if (this.isOpened(workspaceArray[n])) {
                            this.doClose(workspaceArray[n]);
                        }
                        ++n;
                    }
                    break;
                }
            }
        }

        public void requestFocus() {
            DoRequest doRequest = new DoRequest(0);
            if (EventQueue.isDispatchThread()) {
                doRequest.run();
            } else {
                SwingUtilities.invokeLater(doRequest);
            }
        }

        public void requestVisible() {
            DoRequest doRequest = new DoRequest(1);
            if (EventQueue.isDispatchThread()) {
                doRequest.run();
            } else {
                SwingUtilities.invokeLater(doRequest);
            }
        }

        Mode getMode() {
            return this.wm.getCurrentWorkspace().findMode(this.component);
        }

        void doClose(Workspace workspace) {
            Set set;
            ModeImpl modeImpl = (ModeImpl)workspace.findMode(this.component);
            this.whereOpened.remove(workspace);
            if (modeImpl != null) {
                modeImpl.close(this.component);
            }
            if (!this.isOpened()) {
                WindowManagerImpl.super.componentCloseNotify(this.component);
            }
            if ((set = this.wm.getTcListenersForFiring()) != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ((TopComponentListener)iterator.next()).topComponentClosed(new TopComponentChangedEvent(this, this.component, workspace, TopComponentChangedEvent.CLOSED));
                }
            }
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public void setActivatedNodes(Node[] nodeArray) {
            if (this.component == null) {
                this.tempNodes = nodeArray;
                return;
            }
            if (Arrays.equals(this.nodes, nodeArray)) {
                return;
            }
            Node[] nodeArray2 = this.nodes;
            this.nodes = nodeArray;
            this.changeSupport.firePropertyChange(PROP_ACTIVATED_NODES, nodeArray2, nodeArray);
            Set set = this.wm.getTcListenersForFiring();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ((TopComponentListener)iterator.next()).selectedNodesChanged(new SelectedNodesChangedEvent(this, this.component, nodeArray));
                }
            }
        }

        public void nameChanged() {
            if (this.component != null) {
                RequestProcessor.Task task = this.deferNameChange;
                if (task == null) {
                    this.deferNameChange = RequestProcessor.postRequest((Runnable)this, (int)200, (int)1);
                } else {
                    task.schedule(200);
                }
            }
        }

        public void run() {
            this.changeSupport.firePropertyChange(PROP_NAME, null, this.component.getName());
            this.deferNameChange = null;
        }

        public void setIcon(Image image) {
            if (this.icon != null && this.icon.equals(image) || this.icon == null && image == null) {
                return;
            }
            Image image2 = this.icon;
            this.icon = image;
            this.changeSupport.firePropertyChange(PROP_ICON, image2, this.icon);
        }

        public Image getIcon() {
            return this.icon;
        }

        public TopComponent getComponent() {
            return this.component;
        }

        public Set whereOpened() {
            return this.whereOpened;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.component.removeComponentListener(this);
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ TopComponentManager this$0;
                {
                    this.this$0 = topComponentManager;
                }

                public void run() {
                    this.this$0.component.requestFocus();
                }
            });
        }

        private Object writeReplace() throws ObjectStreamException {
            NbMarshalledObject nbMarshalledObject = null;
            try {
                nbMarshalledObject = new NbMarshalledObject((Object)this.component);
            }
            catch (Exception exception) {
                this.wm.annotatePersistenceError(exception, this.component.getName());
                return null;
            }
            return new SerializationReplacer(this.componentName, nbMarshalledObject);
        }

        public boolean validateData() {
            if (this.innerState != 2) {
                return this.innerState == 1;
            }
            if (this.marshalledComponent == null) {
                this.innerState = 4;
                return false;
            }
            try {
                block6: {
                    try {
                        this.wm.setValidatedManager(this);
                        this.component = (TopComponent)this.marshalledComponent.get();
                        int n = this.innerState = this.component == null ? 4 : 1;
                        if (this.component == null || this.tempNodes == null) break block6;
                        this.setActivatedNodes(this.tempNodes);
                        this.tempNodes = null;
                    }
                    catch (Exception exception) {
                        this.innerState = 4;
                        this.wm.annotatePersistenceError(exception, this.componentName);
                        boolean bl = false;
                        Object var4_2 = null;
                        this.wm.setValidatedManager(null);
                        return bl;
                    }
                }
                Object var4_1 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.wm.setValidatedManager(null);
                throw throwable;
            }
            this.wm.setValidatedManager(null);
            return this.innerState == 1;
        }

        private static TopComponentManager createTCM(String string, NbMarshalledObject nbMarshalledObject) {
            TopComponentManager topComponentManager = new TopComponentManager(null);
            topComponentManager.componentName = string;
            topComponentManager.marshalledComponent = nbMarshalledObject;
            topComponentManager.innerState = 2;
            return topComponentManager;
        }

        private VersionSerializator serializationManager() {
            if (serializationManager == null) {
                serializationManager = TopComponentManager.createSerializationManager();
            }
            return serializationManager;
        }

        private static VersionSerializator createSerializationManager() {
            VersionSerializator versionSerializator = new VersionSerializator();
            versionSerializator.putVersion(new Version1());
            return versionSerializator;
        }

        static /* synthetic */ void access$1100(TopComponentManager topComponentManager, Workspace workspace) {
            topComponentManager.doOpen(workspace);
        }

        private static final class VSAccess
        implements DefaultReplacer.Access {
            private static final long serialVersionUID = -6484558550904999459L;
            transient VersionSerializator vs;

            public VSAccess(VersionSerializator versionSerializator) {
                this.vs = versionSerializator;
            }

            public VersionSerializator getVersionSerializator() {
                return this.vs == null ? TopComponentManager.createSerializationManager() : this.vs;
            }
        }

        private static final class Version1
        implements DefaultReplacer.ResVersionable {
            public static final String NAME = "Version_1.0";
            String componentName;
            NbMarshalledObject marshalledComponent;
            TopComponentManager tcm;
            transient HashSet whereOpened;

            private Version1() {
            }

            public String getName() {
                return NAME;
            }

            public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
                this.componentName = (String)objectInput.readObject();
                this.marshalledComponent = (NbMarshalledObject)objectInput.readObject();
            }

            public void writeData(ObjectOutput objectOutput) throws IOException {
                throw new InternalError();
            }

            public Object resolveData() throws ObjectStreamException {
                return TopComponentManager.createTCM(this.componentName, this.marshalledComponent);
            }
        }

        private static final class SerializationReplacer
        implements Serializable {
            static final long serialVersionUID = -9009124438910567345L;
            private static final String NAME = "name";
            private static final String MARSHALLED_COMPONENT = "marshalledComponent";
            private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("marshalledComponent", class$org$openide$util$io$NbMarshalledObject == null ? (class$org$openide$util$io$NbMarshalledObject = SerializationReplacer.class$("org.openide.util.io.NbMarshalledObject")) : class$org$openide$util$io$NbMarshalledObject)};
            private String componentName;
            private NbMarshalledObject marshalledComponent;
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$org$openide$util$io$NbMarshalledObject;

            SerializationReplacer(String string, NbMarshalledObject nbMarshalledObject) {
                this.componentName = string;
                this.marshalledComponent = nbMarshalledObject;
            }

            private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
                ObjectOutputStream.PutField putField = objectOutputStream.putFields();
                putField.put("name", this.componentName);
                putField.put(MARSHALLED_COMPONENT, this.marshalledComponent);
                objectOutputStream.writeFields();
            }

            private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
                ObjectInputStream.GetField getField = objectInputStream.readFields();
                this.componentName = (String)getField.get("name", null);
                this.marshalledComponent = (NbMarshalledObject)getField.get(MARSHALLED_COMPONENT, null);
            }

            private synchronized Object readResolve() throws ObjectStreamException {
                return TopComponentManager.createTCM(this.componentName, this.marshalledComponent);
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }

        private class DoRequest
        implements Runnable {
            private static final int REQUEST_FOCUS = 0;
            private static final int REQUEST_VISIBLE = 1;
            private int action;

            DoRequest(int n) {
                this.action = n;
            }

            private void requestFocus() {
                if (TopComponentManager.this.component.isDisplayable()) {
                    ModeImpl modeImpl = (ModeImpl)TopComponentManager.this.getMode();
                    if (modeImpl != null && TopComponentManager.this.component != null && NbPresenter.currentModalDialog == null) {
                        modeImpl.requestFocus(TopComponentManager.this.component);
                    }
                } else {
                    TopComponentManager.this.component.addComponentListener(TopComponentManager.this);
                }
            }

            private void requestVisible() {
                ModeImpl modeImpl;
                if (TopComponentManager.this.component.isDisplayable() && (modeImpl = (ModeImpl)TopComponentManager.this.getMode()) != null && TopComponentManager.this.component != null && NbPresenter.currentModalDialog == null) {
                    modeImpl.requestVisible(TopComponentManager.this.component);
                }
            }

            public void run() {
                if (!TopComponentManager.this.isOpened()) {
                    return;
                }
                if (this.action == 0) {
                    this.requestFocus();
                } else if (this.action == 1) {
                    this.requestVisible();
                }
            }
        }
    }

    private static final class ProjectSwitchListener
    implements PropertyChangeListener {
        private ProjectSwitchListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            try {
                if ("session_close".equals(string)) {
                    WindowManagerImpl.setProjectOpen(false);
                    AWT aWT = new AWT(false);
                    if (EventQueue.isDispatchThread()) {
                        aWT.run();
                    } else {
                        while (true) {
                            if (!WindowManagerImpl.deferredPerformer().isProcessing()) {
                                EventQueue.invokeAndWait(aWT);
                                break;
                            }
                            Thread.currentThread();
                            Thread.sleep(200L);
                        }
                    }
                }
                if (!"session_open".equals(string)) return;
                RequestProcessor.postRequest((Runnable)new Runnable(this){
                    private final /* synthetic */ ProjectSwitchListener this$0;
                    {
                        this.this$0 = projectSwitchListener;
                    }

                    public void run() {
                        AWT aWT = new AWT(true);
                        EventQueue.invokeLater(aWT);
                    }
                });
                return;
            }
            catch (InterruptedException interruptedException) {
                WindowManagerImpl.getDefault().annotatePersistenceError(interruptedException, null);
                WindowManagerImpl.getDefault().checkPersistenceErrors(false);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                WindowManagerImpl.getDefault().annotatePersistenceError(invocationTargetException, null);
                WindowManagerImpl.getDefault().checkPersistenceErrors(false);
            }
        }

        private static class AWT
        implements Runnable {
            private final boolean open;
            private static WorkspaceImpl lastActiveWsp = null;
            static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;

            public AWT(boolean bl) {
                this.open = bl;
            }

            public void run() {
                if (this.open) {
                    this.run_open();
                } else {
                    this.run_close();
                }
            }

            private void run_close() {
                WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
                PersistenceManager persistenceManager = windowManagerImpl.persistenceManager();
                persistenceManager.resetTCPairs();
                WorkspaceImpl workspaceImpl = (WorkspaceImpl)windowManagerImpl.getCurrentWorkspaceNoLoad();
                if (workspaceImpl != null) {
                    workspaceImpl.setVisible(false);
                }
                lastActiveWsp = workspaceImpl;
                Workspace[] workspaceArray = windowManagerImpl.getWorkspacesNoLoad();
                if (workspaceArray != null) {
                    int n = 0;
                    while (n < workspaceArray.length) {
                        ((WorkspaceImpl)workspaceArray[n]).closeModes();
                        ++n;
                    }
                }
            }

            private void run_open() {
                WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
                PersistenceManager persistenceManager = windowManagerImpl.persistenceManager();
                FileObject fileObject = persistenceManager.getWindowManagerFolder(1);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                this.invalidate(dataFolder);
                DataObject[] dataObjectArray = dataFolder.getChildren();
                WindowManagerImpl.setProjectOpen(true);
                try {
                    dataFolder.setOrder(dataObjectArray);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                }
                WorkspaceImpl workspaceImpl = (WorkspaceImpl)windowManagerImpl.getCurrentWorkspaceNoLoad();
                if (workspaceImpl != null && lastActiveWsp == workspaceImpl) {
                    workspaceImpl.setVisible(true);
                }
            }

            private void invalidate(DataFolder dataFolder) {
                DataObject[] dataObjectArray = dataFolder.getChildren();
                int n = 0;
                while (n < dataObjectArray.length) {
                    ResetCookie resetCookie;
                    if (dataObjectArray[n] instanceof DataFolder) {
                        this.invalidate((DataFolder)dataObjectArray[n]);
                    }
                    if ((resetCookie = (ResetCookie)dataObjectArray[n].getCookie(class$org$netbeans$core$windows$layers$ResetCookie == null ? AWT.class$("org.netbeans.core.windows.layers.ResetCookie") : class$org$netbeans$core$windows$layers$ResetCookie)) != null) {
                        resetCookie.reset();
                    }
                    ++n;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    static final class IconifyManager
    extends WindowAdapter
    implements Runnable {
        private WorkspaceImpl workspace;

        IconifyManager() {
        }

        public void windowIconified(WindowEvent windowEvent) {
            if (!WindowUtils.isMdi()) {
                RequestProcessor.postRequest((Runnable)this, (int)200);
            }
        }

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.iconify();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            if (this.workspace != null) {
                this.workspace.setVisible(true);
                this.workspace = null;
            }
        }

        private void iconify() {
            this.workspace = (WorkspaceImpl)TopManager.getDefault().getWindowManager().getCurrentWorkspace();
            Iterator iterator = this.workspace.getModes().iterator();
            while (iterator.hasNext()) {
                FrameType frameType = ((ModeImpl)iterator.next()).getFrameInstance();
                if (frameType == null || frameType.getState() != 0) continue;
                this.workspace.setVisible(false);
                return;
            }
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = -8212722893309295268L;
        private static final String WORKSPACES = "workspaces";
        private static final String CURRENT_WORKSPACE = "currentWorkspace";
        private static final String MAIN_WINDOW_BOUNDS = "mainWindowBounds";
        private static final String UI_MODE = "uiMode";
        private static final String SCREEN_SIZE = "screenSize";
        private static final String TABBED_CONTAINER_UI = "tabbedContainerUI";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("workspaces", class$java$util$List == null ? (class$java$util$List = SerializationReplacer.class$("java.util.List")) : class$java$util$List), new ObjectStreamField("currentWorkspace", class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = SerializationReplacer.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl), new ObjectStreamField("mainWindowBounds", class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = SerializationReplacer.class$("java.awt.Rectangle")) : class$java$awt$Rectangle), new ObjectStreamField("uiMode", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("screenSize", class$java$awt$Dimension == null ? (class$java$awt$Dimension = SerializationReplacer.class$("java.awt.Dimension")) : class$java$awt$Dimension), new ObjectStreamField("tabbedContainerUI", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer)};
        private Workspace[] workspaces;
        private Workspace current;
        private Dimension oldScreenSize;
        private int uiMode;
        private int tabbedContainerUI;
        private Rectangle mainWindowBounds;
        private boolean isStartup = true;
        static /* synthetic */ Class class$java$util$List;
        static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceImpl;
        static /* synthetic */ Class class$java$awt$Rectangle;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$awt$Dimension;

        private SerializationReplacer() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
            windowManagerImpl.persistenceManager().cleanXML();
            StateManager stateManager = WindowManagerImpl.stateManager();
            stateManager.setMainState(128);
            try {
                ObjectInputStream.GetField getField = objectInputStream.readFields();
                if (WindowUtils.hasObjectStreamField(getField, MAIN_WINDOW_BOUNDS)) {
                    List list = (List)getField.get(WORKSPACES, null);
                    Workspace[] workspaceArray = list.toArray(new Workspace[list.size()]);
                    ArrayList<Workspace> arrayList = new ArrayList<Workspace>();
                    Workspace workspace = null;
                    int n = 0;
                    while (n < workspaceArray.length) {
                        if ("Browsing".equals(workspaceArray[n].getName())) {
                            workspace = workspaceArray[n];
                        } else {
                            arrayList.add(workspaceArray[n]);
                        }
                        ++n;
                    }
                    this.workspaces = arrayList.toArray(new Workspace[arrayList.size()]);
                    this.current = (Workspace)getField.get(CURRENT_WORKSPACE, null);
                    if (this.current == workspace) {
                        this.current = arrayList.size() > 0 ? this.workspaces[0] : null;
                    }
                    this.oldScreenSize = (Dimension)getField.get(SCREEN_SIZE, null);
                    this.uiMode = (Integer)getField.get(UI_MODE, null);
                    this.mainWindowBounds = (Rectangle)getField.get(MAIN_WINDOW_BOUNDS, null);
                } else {
                    int n = objectInputStream.readInt();
                    this.workspaces = new Workspace[n];
                    Workspace workspace = null;
                    int n2 = 0;
                    while (n2 < n) {
                        this.workspaces[n2] = (Workspace)objectInputStream.readObject();
                        if ("CTL_Workspace_Browsing".equals(this.workspaces[n2].getDisplayName())) {
                            workspace = this.workspaces[n2];
                            Workspace[] workspaceArray = new Workspace[n - 1];
                            System.arraycopy(this.workspaces, 0, workspaceArray, 0, n2);
                            if (n2 + 1 < n) {
                                System.arraycopy(this.workspaces, n2 + 1, workspaceArray, n2, n - n2 - 1);
                            }
                            --n;
                            --n2;
                            this.workspaces = workspaceArray;
                        }
                        ++n2;
                    }
                    this.current = (Workspace)objectInputStream.readObject();
                    if (this.current == workspace) {
                        this.current = n > 0 ? this.workspaces[0] : null;
                    }
                    this.mainWindowBounds = (Rectangle)objectInputStream.readObject();
                    this.uiMode = 1;
                }
                this.tabbedContainerUI = getField.getObjectStreamClass().getField(TABBED_CONTAINER_UI) != null ? (Integer)getField.get(TABBED_CONTAINER_UI, null) : 1;
                Object var11_14 = null;
                this.isStartup = false;
                stateManager.setMainState(32);
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.isStartup = false;
                stateManager.setMainState(32);
                throw throwable;
            }
        }

        private synchronized Object readResolve() throws ObjectStreamException {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
            StateManager stateManager = WindowManagerImpl.stateManager();
            stateManager.setMainState(128);
            try {
                this.initGlobalProperties();
                int n = 0;
                while (n < this.workspaces.length) {
                    ((WorkspaceImpl)this.workspaces[n]).validateSelf();
                    ++n;
                }
                windowManagerImpl.setWorkspaces(this.workspaces);
                if (windowManagerImpl.uiModeManager().getUIMode() != this.uiMode) {
                    windowManagerImpl.uiModeManager.changeModeFrameTypes();
                }
                int n2 = 0;
                while (n2 < this.workspaces.length) {
                    ((WorkspaceImpl)this.workspaces[n2]).validateData();
                    ++n2;
                }
                windowManagerImpl.setCurrentWorkspace(this.current);
                Object var6_5 = null;
                stateManager.setMainState(32);
                windowManagerImpl.checkPersistenceErrors(true);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                stateManager.setMainState(32);
                windowManagerImpl.checkPersistenceErrors(true);
                throw throwable;
            }
            WindowManagerImpl.deferredPerformer().putRequest(new DeferredPerformer.DeferredCommand(this){
                private final /* synthetic */ SerializationReplacer this$0;
                {
                    this.this$0 = serializationReplacer;
                }

                public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
                    try {
                        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
                        windowManagerImpl.persistenceManager().writeXML();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }, new DeferredPerformer.DeferredContext(null, true));
            return windowManagerImpl;
        }

        private void initGlobalProperties() {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
            windowManagerImpl.mainPositioned = true;
            windowManagerImpl.oldScreenSize = this.oldScreenSize;
            windowManagerImpl.oldMainWindowBounds = new Rectangle(this.mainWindowBounds);
            windowManagerImpl.setTabbedContainerUI(this.tabbedContainerUI);
            if (windowManagerImpl.uiModeManager().getUIMode() == this.uiMode) {
                if (this.oldScreenSize != null) {
                    WindowUtils.convertRectangle(this.mainWindowBounds, this.oldScreenSize, Toolkit.getDefaultToolkit().getScreenSize());
                }
                ((Component)WindowManagerImpl.mainWindow()).setBounds(this.mainWindowBounds);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getDefault();
            StateManager stateManager = WindowManagerImpl.stateManager();
            stateManager.setMainState(64);
            try {
                ObjectOutputStream.PutField putField = objectOutputStream.putFields();
                putField.put(WORKSPACES, Arrays.asList(windowManagerImpl.workspaces));
                putField.put(CURRENT_WORKSPACE, windowManagerImpl.current);
                putField.put(MAIN_WINDOW_BOUNDS, WindowManagerImpl.mainWindow().getBounds());
                putField.put(SCREEN_SIZE, Toolkit.getDefaultToolkit().getScreenSize());
                putField.put(UI_MODE, new Integer(windowManagerImpl.uiModeManager().getUIMode()));
                putField.put(TABBED_CONTAINER_UI, new Integer(windowManagerImpl.getTabbedContainerUI()));
                objectOutputStream.writeFields();
                Object var6_5 = null;
                stateManager.setMainState(32);
                windowManagerImpl.checkPersistenceErrors(false);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                stateManager.setMainState(32);
                windowManagerImpl.checkPersistenceErrors(false);
                throw throwable;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

