/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.windows.BoundsConvertor;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeEvent;
import org.netbeans.core.windows.frames.FrameTypeListener;
import org.netbeans.core.windows.frames.FrameTypeSupport;
import org.netbeans.core.windows.frames.LayoutResource;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public final class ModeImpl
implements Comparable,
Mode,
FrameTypeListener,
ComponentListener,
DeferredPerformer.DeferredCommand,
StateManager.StateListener {
    static final long serialVersionUID = 2721445375634234372L;
    public static final int SINGLE = 1;
    public static final int MULTI_TAB = 2;
    public static final int SIDE_BY_SIDE = 4;
    public static final int INTERNAL_FRAME = 8;
    public static final String PROP_TOP_COMPONENTS = "topComponents";
    public static final String PROP_FRAME_INSTANCE = "frameInstance";
    public static final String PROP_CONTAINER_INSTANCE = "containerInstance";
    public static final String PROP_CONSTRAINTS = "containerInstance";
    public static final int PROPERTIES = 1;
    public static final int COMPONENTS = 2;
    public static final String NAMING_TYPE = "NamingType";
    public static final String BOTH_ONLY_COMP_NAME = "BothOnlyCompName";
    public static final String SDI_ONLY_COMP_NAME = "SDIOnlyCompName";
    public static final String MDI_ONLY_COMP_NAME = "MDIOnlyCompName";
    private static String untitledComponent;
    private static MessageFormat windowTitle;
    private static MessageFormat descriptionFormat;
    private URL icon;
    private Image iconImage;
    private String name;
    private String displayName;
    private String description;
    private Rectangle bounds;
    private boolean userDefined;
    private Workspace workspace;
    private String workspaceName;
    private TopComponentContainer tcc;
    private FrameType frame;
    private boolean active = false;
    private String containerType;
    private String frameType;
    private int frameTypeState = -1;
    private Object constraints;
    private Object currnetConstraints;
    private List ignoredTcList;
    private WeakHashMap closedComponents;
    private WindowManagerImpl wm;
    private PropertyChangeSupport changeSupport;
    private boolean showing;
    private boolean deferredFocusRequest;
    private TopComponent compToReceiveFocus;
    private NameListener nameListener;
    private StateManager stateManager;
    private Rectangle relativeBounds;
    private HashMap areas;
    private static VersionSerializator serializationManager;
    private LazyUpdater updater;
    private boolean hidden = true;
    private WeakSet removedComps;
    private String nameBundle;
    private String descriptionBundle;
    private boolean fromBundle;
    private boolean closeOnlyInMemory;
    static /* synthetic */ Class class$org$netbeans$core$windows$ModeImpl;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public ModeImpl(String string, String string2, URL uRL, int n, boolean bl, Workspace workspace) {
        this(string, string2, uRL, bl, workspace);
    }

    public ModeImpl(String string, String string2, URL uRL, boolean bl, Workspace workspace) {
        this.name = string;
        this.displayName = string2;
        this.icon = uRL;
        this.workspace = workspace;
        this.userDefined = bl;
        this.initialize();
    }

    public ModeImpl(Workspace workspace, ModeImpl modeImpl) {
        this(modeImpl.getName(), modeImpl.getDisplayNameXML(), modeImpl.getIconURL(), modeImpl.isUserDefined(), workspace);
        if (workspace.findMode(this.name) != null) {
            int n = 1;
            while (workspace.findMode(this.name = modeImpl.name + "_" + n++) != null) {
            }
        }
        this.fromBundle = modeImpl.isFromBundle();
        this.nameBundle = modeImpl.getNameBundle();
        this.setBounds(modeImpl.bounds == null ? null : new Rectangle(modeImpl.bounds));
        this.setContainerType(modeImpl.getContainerType());
        this.setFrameType(modeImpl.getFrameType());
        WindowUtils.changeModeConstraints(this, modeImpl.constraints, true);
        ((WorkspaceImpl)workspace).addMode(this);
        TopComponent[] topComponentArray = modeImpl.getTopComponents();
        int n = 0;
        while (n < topComponentArray.length) {
            Object object = modeImpl.tcc.getConstraints(topComponentArray[n]);
            if (this.canDock(topComponentArray[n]) && this.dockInto(topComponentArray[n], object)) {
                topComponentArray[n].open(workspace);
            }
            ++n;
        }
    }

    private void initialize() {
        this.wm = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
        this.changeSupport = new PropertyChangeSupport(this);
        this.stateManager = WindowManagerImpl.stateManager();
        if ((this.stateManager.getState() & 1) == 0) {
            this.stateManager.addStateListener(this);
        }
    }

    private void updateBounds() {
        if (this.relativeBounds != null) {
            this.setRelativeBounds(this.relativeBounds);
        }
        Rectangle rectangle = this.getBounds();
        if (this.areas != null && rectangle != null) {
            Iterator iterator = this.areas.keySet().iterator();
            while (iterator.hasNext()) {
                TopComponentContainer.Area area = (TopComponentContainer.Area)this.areas.get(iterator.next());
                Rectangle rectangle2 = area.getRelativeBounds();
                if (rectangle2 == null) continue;
                Rectangle rectangle3 = new Rectangle();
                rectangle3.x = rectangle2.x * rectangle.width / 100;
                rectangle3.y = rectangle2.y * rectangle.height / 100;
                rectangle3.width = rectangle2.width * rectangle.width / 100;
                rectangle3.height = rectangle2.height * rectangle.height / 100;
                area.setBounds(rectangle3);
                area.setRelativeBounds(null);
            }
        }
    }

    public void stateChanged(int n) {
        if ((n & 1) != 0) {
            this.stateManager.removeStateListener(this);
            this.updateBounds();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean canDock(TopComponent topComponent) {
        return this.tcc == null ? true : this.tcc.canAdd(new TopComponent[]{topComponent});
    }

    public boolean dockInto(TopComponent topComponent) {
        return this.dockInto(topComponent, null);
    }

    public boolean dockInto(TopComponent topComponent, Object object) {
        return this.dockInto(topComponent, object, Integer.MAX_VALUE);
    }

    public boolean dockInto(final TopComponent topComponent, final Object object, final int n) {
        if (!this.canDock(topComponent)) {
            return false;
        }
        this.ensureSectionLoaded(3);
        WindowManagerImpl.deferredPerformer().putRequest(new DeferredPerformer.DeferredCommand(){

            public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
                ModeImpl modeImpl = (ModeImpl)ModeImpl.this.workspace.findMode(topComponent);
                ModeImpl.this.wm;
                boolean bl = WindowManagerImpl.findManager(topComponent).isOpened(ModeImpl.this.workspace);
                if (modeImpl != null && !ModeImpl.this.equals(modeImpl)) {
                    modeImpl.release(topComponent);
                }
                if (bl) {
                    ModeImpl.this.updateBounds();
                    if (ModeImpl.this.bounds == null) {
                        ((WorkspaceImpl)ModeImpl.this.workspace).placeMode(ModeImpl.this, topComponent);
                    }
                    ClosedTCContext closedTCContext = ModeImpl.this.removeClosedComponent(topComponent);
                    ModeImpl.this.addToContainer(topComponent, true, object == null && closedTCContext != null ? closedTCContext.constraints : object, n == Integer.MAX_VALUE && closedTCContext != null ? closedTCContext.orderWeight : n);
                    if (ModeImpl.this.workspace.equals(ModeImpl.this.wm.getCurrentWorkspace())) {
                        ModeImpl.this.setVisible(true);
                    }
                } else {
                    ModeImpl.this.addClosedComponent(topComponent, object, n);
                }
                ModeImpl.this.removeFromRemovedComps(topComponent);
                ModeImpl.this.changeSupport.firePropertyChange(ModeImpl.PROP_TOP_COMPONENTS, null, null);
            }
        }, new DeferredPerformer.DeferredContext(null, true));
        return true;
    }

    public boolean dockIntoNoSelect(TopComponent topComponent) {
        return this.dockIntoNoSelect(topComponent, null);
    }

    public boolean dockIntoNoSelect(TopComponent topComponent, Object object) {
        return this.dockIntoNoSelect(topComponent, object, Integer.MAX_VALUE);
    }

    public boolean dockIntoNoSelect(final TopComponent topComponent, final Object object, final int n) {
        if (!this.canDock(topComponent)) {
            return false;
        }
        this.ensureSectionLoaded(3);
        WindowManagerImpl.deferredPerformer().putRequest(new DeferredPerformer.DeferredCommand(){

            public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
                ModeImpl modeImpl = (ModeImpl)ModeImpl.this.workspace.findMode(topComponent);
                ModeImpl.this.wm;
                boolean bl = WindowManagerImpl.findManager(topComponent).isOpened(ModeImpl.this.workspace);
                if (modeImpl != null && !ModeImpl.this.equals(modeImpl)) {
                    modeImpl.release(topComponent);
                }
                if (bl) {
                    ModeImpl.this.updateBounds();
                    if (ModeImpl.this.bounds == null) {
                        ((WorkspaceImpl)ModeImpl.this.workspace).placeMode(ModeImpl.this, topComponent);
                    }
                    ClosedTCContext closedTCContext = ModeImpl.this.removeClosedComponent(topComponent);
                    ModeImpl.this.addToContainer(topComponent, false, object == null && closedTCContext != null ? closedTCContext.constraints : object, n == Integer.MAX_VALUE && closedTCContext != null ? closedTCContext.orderWeight : n);
                    if (ModeImpl.this.workspace.equals(ModeImpl.this.wm.getCurrentWorkspace())) {
                        ModeImpl.this.setVisible(true);
                    }
                } else {
                    ModeImpl.this.addClosedComponent(topComponent, object, n);
                }
                ModeImpl.this.removeFromRemovedComps(topComponent);
                ModeImpl.this.changeSupport.firePropertyChange(ModeImpl.PROP_TOP_COMPONENTS, null, null);
            }
        }, new DeferredPerformer.DeferredContext(null, true));
        return true;
    }

    public void release(TopComponent topComponent) {
        if (WindowManagerImpl.findManager(topComponent).isOpened(this.workspace)) {
            int n = this.tcc.removeTopComponent(topComponent);
            if (n <= 0) {
                this.destroyFrame();
            } else {
                this.updateNameListener();
            }
        } else {
            this.removeClosedComponent(topComponent);
        }
        this.addToRemovedComps(topComponent);
        this.changeSupport.firePropertyChange(PROP_TOP_COMPONENTS, null, null);
    }

    public void close(final TopComponent topComponent) {
        WindowManagerImpl.deferredPerformer().putRequest(new DeferredPerformer.DeferredCommand(){

            public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
                if (ModeImpl.this.tcc == null) {
                    return;
                }
                if (ModeImpl.this.tcc.containsTopComponent(topComponent)) {
                    Object object = ModeImpl.this.tcc.getConstraints(topComponent);
                    int n = ModeImpl.this.tcc.getOrderWeight(topComponent);
                    int n2 = ModeImpl.this.tcc.removeTopComponent(topComponent);
                    if (n2 <= 0) {
                        ModeImpl.this.destroyFrame();
                    } else {
                        ModeImpl.this.updateNameListener();
                    }
                    ModeImpl.this.addClosedComponent(topComponent, object, n);
                }
                ModeImpl.this.changeSupport.firePropertyChange(ModeImpl.PROP_TOP_COMPONENTS, null, null);
            }
        }, new DeferredPerformer.DeferredContext(null, true));
    }

    public boolean close() {
        if (this.closedComponents != null) {
            this.closedComponents.clear();
        }
        if (this.tcc == null) {
            return true;
        }
        TopComponent[] topComponentArray = this.tcc.getTopComponents();
        TopComponent topComponent = this.tcc.getSelectedTopComponent();
        boolean bl = true;
        int n = 0;
        while (n < topComponentArray.length) {
            if (!topComponentArray[n].equals(topComponent) && !topComponentArray[n].close(this.workspace)) {
                bl = false;
            }
            ++n;
        }
        if (topComponent != null && !topComponent.close(this.workspace)) {
            bl = false;
        }
        return bl;
    }

    public void resetComponents() {
        if (this.updater != null) {
            this.updater.resetComponents();
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (this.bounds != null && this.bounds.equals(rectangle)) {
            return;
        }
        final Rectangle rectangle2 = this.bounds;
        this.bounds = rectangle;
        if (this.frame != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                Component component = FrameTypeSupport.obtainFrameComponent(this.frame);
                if (component != null) {
                    component.setBounds(this.bounds);
                    if (component instanceof JInternalFrame) {
                        ((JInternalFrame)component).revalidate();
                    }
                }
                this.changeSupport.firePropertyChange("bounds", rectangle2, this.bounds);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Component component = FrameTypeSupport.obtainFrameComponent(ModeImpl.this.frame);
                        if (component != null) {
                            component.setBounds(ModeImpl.this.bounds);
                            if (component instanceof JInternalFrame) {
                                ((JInternalFrame)component).revalidate();
                            }
                        }
                        ModeImpl.this.changeSupport.firePropertyChange("bounds", rectangle2, ModeImpl.this.bounds);
                    }
                });
            }
        } else {
            this.changeSupport.firePropertyChange("bounds", rectangle2, this.bounds);
        }
    }

    public void setRelativeBounds(Rectangle rectangle) {
        int n = WindowManagerImpl.stateManager().getState();
        if ((n & 1) == 0) {
            this.relativeBounds = rectangle;
            return;
        }
        this.relativeBounds = rectangle;
        if (this.relativeBounds != null) {
            Component component;
            Cloneable cloneable;
            Rectangle rectangle2 = null;
            if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl" == this.getFrameType()) {
                cloneable = ((WorkspaceImpl)this.getWorkspace()).desktopPane().getInnerDesktopSize();
                if (cloneable.width == 0 && cloneable.height == 0) {
                    return;
                }
                rectangle2 = new Rectangle(0, 0, cloneable.width, cloneable.height);
            } else {
                rectangle2 = ((WorkspaceImpl)this.workspace).getWorkingSpaceBounds();
            }
            cloneable = new Rectangle();
            ((Rectangle)cloneable).x = rectangle2.width * this.relativeBounds.x / 100 + rectangle2.x;
            ((Rectangle)cloneable).y = rectangle2.height * this.relativeBounds.y / 100 + rectangle2.y;
            ((Rectangle)cloneable).width = rectangle2.width * this.relativeBounds.width / 100;
            ((Rectangle)cloneable).height = rectangle2.height * this.relativeBounds.height / 100;
            if (this.frame != null && ModeImpl.handleLayoutResource(component = FrameTypeSupport.obtainFrameComponent(this.frame), this.relativeBounds, this.workspace)) {
                this.relativeBounds = null;
            }
            this.setBounds((Rectangle)cloneable);
        }
    }

    private static boolean handleLayoutResource(Component component, Rectangle rectangle, Workspace workspace) {
        if (component instanceof LayoutResource) {
            LayoutResource layoutResource = (LayoutResource)((Object)component);
            layoutResource.setRelativeBounds(rectangle);
            layoutResource.setWorkspace(workspace);
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        this.ensureSectionLoaded(1);
        return this.bounds;
    }

    public Rectangle getRelativeBounds() {
        int n = WindowManagerImpl.stateManager().getState();
        if ((n & 1) == 0) {
            return null;
        }
        this.ensureSectionLoaded(1);
        if (this.bounds == null) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle(this.bounds);
        Rectangle rectangle3 = ((WorkspaceImpl)this.workspace).getWorkingSpaceBounds();
        rectangle.x = 100 * (rectangle2.x - rectangle3.x) / rectangle3.width;
        rectangle.y = 100 * (rectangle2.y - rectangle3.y) / rectangle3.height;
        rectangle.width = 100 * rectangle2.width / rectangle3.width;
        rectangle.height = 100 * rectangle2.height / rectangle3.height;
        return rectangle;
    }

    public Rectangle getNormalBounds() {
        DesktopPane desktopPane;
        this.ensureSectionLoaded(1);
        Rectangle rectangle = null;
        if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && (desktopPane = ((WorkspaceImpl)this.workspace).desktopPane()).isMaxMode() && this.frame != null) {
            rectangle = desktopPane.getFrameBounds(this.frame);
        }
        return rectangle != null ? rectangle : this.getBounds();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public TopComponent[] getTopComponents() {
        return this.doGetTopComponents(true);
    }

    public TopComponent[] getLoadedTopComponents() {
        return this.doGetTopComponents(false);
    }

    private TopComponent[] doGetTopComponents(boolean bl) {
        TopComponent[] topComponentArray;
        if (bl) {
            this.ensureSectionLoaded(2);
        }
        TopComponent[] topComponentArray2 = topComponentArray = this.tcc == null ? new TopComponent[]{} : this.tcc.getTopComponents();
        if (this.closedComponents == null) {
            return topComponentArray;
        }
        TopComponent[] topComponentArray3 = null;
        WeakHashMap weakHashMap = this.closedComponents;
        synchronized (weakHashMap) {
            Set set = ((AbstractMap)this.closedComponents).keySet();
            topComponentArray3 = new TopComponent[topComponentArray.length + set.size()];
            System.arraycopy(topComponentArray, 0, topComponentArray3, 0, topComponentArray.length);
            System.arraycopy(set.toArray(new TopComponent[set.size()]), 0, topComponentArray3, topComponentArray.length, set.size());
        }
        return topComponentArray3;
    }

    public Set getRemovedComps() {
        Set set = null;
        ModeImpl modeImpl = this;
        synchronized (modeImpl) {
            set = this.removedComps == null ? null : (Set)this.removedComps.clone();
        }
        return set;
    }

    public synchronized void clearRemovedComps() {
        if (this.removedComps != null) {
            this.removedComps.clear();
        }
    }

    private synchronized void addToRemovedComps(TopComponent topComponent) {
        if (this.removedComps == null) {
            this.removedComps = new WeakSet(10);
        }
        this.removedComps.add((Object)topComponent);
    }

    private synchronized boolean removeFromRemovedComps(TopComponent topComponent) {
        if (this.removedComps == null) {
            return false;
        }
        return this.removedComps.remove((Object)topComponent);
    }

    public TopComponent[] getOpenedTopComponents() {
        this.ensureSectionLoaded(2);
        return this.getLoadedOpenedTopComponents();
    }

    public TopComponent[] getLoadedOpenedTopComponents() {
        return this.tcc == null ? new TopComponent[]{} : this.tcc.getTopComponents();
    }

    public void requestFocus(final TopComponent topComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestFocus(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doRequestFocus(topComponent);
                }
            });
        }
    }

    public void requestFocus() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doRequestFocus();
                }
            });
        }
    }

    private void doRequestFocus(TopComponent topComponent) {
        if (!this.showing) {
            if ((this.stateManager.getState() & 0x100) == 0 || (this.stateManager.getState() & 2) != 0) {
                this.deferredFocusRequest = true;
                this.compToReceiveFocus = topComponent;
            }
        } else if (this.tcc != null && this.tcc.containsTopComponent(topComponent)) {
            this.requestFocus();
            this.tcc.requestFocus(topComponent);
        }
    }

    private void doRequestFocus() {
        if (!this.showing) {
            if ((this.stateManager.getState() & 0x100) == 0 || (this.stateManager.getState() & 2) != 0) {
                this.deferredFocusRequest = true;
            }
        } else if (this.frame != null) {
            try {
                this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void requestVisible(final TopComponent topComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestVisible(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doRequestVisible(topComponent);
                }
            });
        }
    }

    private void doRequestVisible(TopComponent topComponent) {
        if (this.showing && this.tcc != null && this.tcc.containsTopComponent(topComponent)) {
            this.tcc.requestVisible(topComponent);
        }
    }

    public TopComponentContainer getContainerInstance() {
        return this.tcc;
    }

    public FrameType getFrameInstance() {
        return this.frame;
    }

    public String getDisplayNameXML() {
        this.ensureSectionLoaded(1);
        return this.displayName;
    }

    public String getDisplayName() {
        this.ensureSectionLoaded(1);
        if (this.fromBundle && this.nameBundle != null) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = NbBundle.getBundle((String)this.nameBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                try {
                    return resourceBundle.getString(this.displayName);
                }
                catch (MissingResourceException missingResourceException) {
                    missingResourceException.printStackTrace();
                }
            }
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        String string2 = this.getDisplayName();
        if (string2 != null) {
            string2 = Actions.cutAmpersand((String)string2);
        }
        String string3 = Actions.cutAmpersand((String)string);
        if (string2 != null && string2.equals(string3) || string2 == null && string3 == null) {
            return;
        }
        this.fromBundle = false;
        String string4 = this.displayName;
        this.displayName = string;
        this.changeSupport.firePropertyChange("displayName", string4, this.displayName);
    }

    public String getNameBundle() {
        this.ensureSectionLoaded(1);
        return this.nameBundle;
    }

    public void setNameBundle(String string) {
        this.nameBundle = string;
    }

    public String getDescriptionXML() {
        this.ensureSectionLoaded(1);
        return this.description;
    }

    public void setDescriptionXML(String string) {
        this.description = string;
    }

    public String getDescription() {
        this.ensureSectionLoaded(1);
        if (this.descriptionBundle != null && this.description != null) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = NbBundle.getBundle((String)this.descriptionBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                try {
                    return resourceBundle.getString(this.description);
                }
                catch (MissingResourceException missingResourceException) {
                    missingResourceException.printStackTrace();
                }
            }
        }
        return this.description;
    }

    public String getDescriptionBundle() {
        this.ensureSectionLoaded(1);
        return this.descriptionBundle;
    }

    public void setDescriptionBundle(String string) {
        this.descriptionBundle = string;
    }

    public Image getIcon() {
        this.ensureSectionLoaded(1);
        if (this.iconImage == null && this.icon != null) {
            try {
                this.iconImage = Toolkit.getDefaultToolkit().getImage(this.icon);
            }
            catch (Exception exception) {
                String string = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl)).getString("FMT_NoIconWarning");
                TopManager.getDefault().getErrorManager().annotate((Throwable)exception, MessageFormat.format(string, this.icon));
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)exception);
            }
        }
        return this.iconImage;
    }

    public URL getIconURL() {
        this.ensureSectionLoaded(1);
        return this.icon;
    }

    public void setIconURL(URL uRL) {
        this.icon = uRL;
    }

    public void updateUI() {
        if (this.frame != null) {
            this.frame.updateUI();
        }
    }

    public void setFrameState(final int n) {
        block5: {
            if (this.frame != null) {
                try {
                    if (EventQueue.isDispatchThread()) {
                        this.frame.setState(n);
                        break block5;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                FrameType frameType = ModeImpl.this.frame;
                                if (frameType != null) {
                                    frameType.setState(n);
                                }
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                String string = NbBundle.getBundle(this.getClass()).getString("EXC_SetState");
                                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                                errorManager.annotate((Throwable)propertyVetoException, MessageFormat.format(string, ModeImpl.this.getDisplayName()));
                                errorManager.notify(16, (Throwable)propertyVetoException);
                            }
                        }
                    });
                }
                catch (PropertyVetoException propertyVetoException) {
                    String string = NbBundle.getBundle(this.getClass()).getString("EXC_SetState");
                    ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                    errorManager.annotate((Throwable)propertyVetoException, MessageFormat.format(string, this.getDisplayName()));
                    errorManager.notify(16, (Throwable)propertyVetoException);
                }
            } else {
                this.frameTypeState = n;
            }
        }
    }

    public int getFrameState() {
        this.ensureSectionLoaded(1);
        if (this.frame != null) {
            DesktopPane desktopPane;
            if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && (desktopPane = ((WorkspaceImpl)this.workspace).desktopPane()).isMaxMode()) {
                return desktopPane.getFrameState(this.frame);
            }
            return this.frame.getState();
        }
        if (-1 != this.frameTypeState) {
            return this.frameTypeState;
        }
        return 0;
    }

    public void setVisible(boolean bl) {
        if (this.isHidden() && this.frame == null) {
            if (this.isUserDefined()) {
                this.destroyMode();
            }
            return;
        }
        this.ensureSectionLoaded(2);
        if (this.isOrphan() || this.frame == null) {
            this.setHidden(true);
            return;
        }
        BoundsConvertor.getInstance().updateBounds(this);
        Component component = FrameTypeSupport.obtainFrameComponent(this.frame);
        if (bl != component.isVisible() && (!bl || this.shouldShow())) {
            if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType) || "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType)) {
                WorkspaceImpl workspaceImpl = (WorkspaceImpl)this.workspace;
                if (bl) {
                    if (workspaceImpl.desktopPane().getParent() == null) {
                        WindowManagerImpl.mainWindow().getContentPane().add(workspaceImpl.desktopPane());
                    }
                    if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType)) {
                        workspaceImpl.desktopPane().addFrameType(this.frame, this.constraints);
                    } else {
                        workspaceImpl.desktopPane().addFrameType(this.frame);
                    }
                } else {
                    workspaceImpl.desktopPane().removeFrameType(this.frame);
                }
            }
            if (bl) {
                this.restoreState();
            }
            component.setVisible(bl);
            if (bl && Utilities.isUnix() && component instanceof JFrame) {
                ((JFrame)component).requestFocus();
            }
            this.tcc.setAttached(bl);
        }
    }

    public boolean isVisible() {
        return this.frame == null ? false : FrameTypeSupport.obtainFrameComponent(this.frame).isVisible();
    }

    public boolean isActive() {
        return this.active;
    }

    private void restoreState() {
        if (-1 == this.frameTypeState) {
            return;
        }
        if (!"org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType)) {
            this.setFrameState(this.frameTypeState);
        }
        this.frameTypeState = -1;
    }

    private boolean shouldShow() {
        TopComponent[] topComponentArray = this.tcc.getTopComponents();
        int n = 0;
        while (n < topComponentArray.length) {
            if (WindowManagerImpl.findManager(topComponentArray[n]).isOpened(this.getWorkspace())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isOrphan() {
        this.ensureSectionLoaded(3);
        return this.frame == null || this.tcc == null || this.tcc.getTopComponents().length <= 0;
    }

    public boolean isSingle() {
        this.ensureSectionLoaded(3);
        return this.frame != null && this.tcc != null && this.tcc.getTopComponents().length == 1;
    }

    public boolean isSingleType() {
        if (!this.isSingle()) {
            return false;
        }
        String string = (String)this.tcc.getTopComponents()[0].getClientProperty(NAMING_TYPE);
        if (string == null) {
            return false;
        }
        if (BOTH_ONLY_COMP_NAME.equals(string)) {
            return true;
        }
        if (WindowUtils.isMdi()) {
            return MDI_ONLY_COMP_NAME.equals(string);
        }
        return SDI_ONLY_COMP_NAME.equals(string);
    }

    public boolean isUserDefined() {
        this.ensureSectionLoaded(1);
        return this.userDefined;
    }

    public boolean isFromBundle() {
        this.ensureSectionLoaded(1);
        return this.fromBundle;
    }

    public void setUserDefined(boolean bl) {
        this.userDefined = bl;
    }

    public boolean isNameFromBundle() {
        this.ensureSectionLoaded(1);
        return this.fromBundle;
    }

    public void setNameFromBundle(boolean bl) {
        this.fromBundle = bl;
    }

    private Map getClosedComponents() {
        this.ensureSectionLoaded(2);
        return this.closedComponents;
    }

    void fillTopComponents(ModeImpl modeImpl) {
        Object[] objectArray;
        Map map = modeImpl.getClosedComponents();
        if (map != null) {
            objectArray = null;
            Map map2 = map;
            synchronized (map2) {
                objectArray = map.entrySet().toArray(new Map.Entry[map.size()]);
            }
            Object var5_7 = null;
            int n = 0;
            while (n < objectArray.length) {
                ClosedTCContext closedTCContext = (ClosedTCContext)objectArray[n].getValue();
                this.dockInto((TopComponent)objectArray[n].getKey(), closedTCContext.constraints, closedTCContext.orderWeight);
                ++n;
            }
        }
        objectArray = modeImpl.getOpenedTopComponents();
        int n = 0;
        while (n < objectArray.length) {
            this.dockInto(objectArray[n], modeImpl.tcc.getConstraints(objectArray[n]));
            objectArray[n].open(this.workspace);
            ++n;
        }
    }

    public void frameDeactivated(FrameTypeEvent frameTypeEvent) {
        this.active = false;
        ((WorkspaceImpl)this.workspace).setActiveMode(null);
    }

    public void frameClosed(FrameTypeEvent frameTypeEvent) {
    }

    public void frameDeiconified(FrameTypeEvent frameTypeEvent) {
    }

    public void frameNormalized(FrameTypeEvent frameTypeEvent) {
    }

    public void frameOpened(FrameTypeEvent frameTypeEvent) {
    }

    public void frameIconified(FrameTypeEvent frameTypeEvent) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && this.equals(this.getWorkspace().findMode(topComponent))) {
            this.wm.activateComponent(null);
        }
    }

    public void frameClosing(FrameTypeEvent frameTypeEvent) {
        if (!this.isInClosableState()) {
            return;
        }
        TopComponent[] topComponentArray = this.tcc.getTopComponents();
        TopComponent topComponent = this.tcc.getSelectedTopComponent();
        boolean bl = true;
        int n = 0;
        while (n < topComponentArray.length) {
            if (!topComponentArray[n].equals(topComponent) && !topComponentArray[n].close()) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl && topComponent != null && !topComponent.close()) {
            bl = false;
        }
    }

    public void frameActivated(FrameTypeEvent frameTypeEvent) {
        this.active = true;
        ((WorkspaceImpl)this.workspace).setActiveMode(this);
    }

    public void frameMaximized(FrameTypeEvent frameTypeEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setBounds(componentEvent.getComponent().getBounds());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.setBounds(componentEvent.getComponent().getBounds());
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.showing = true;
        if (this.deferredFocusRequest) {
            this.deferredFocusRequest = false;
            if (this.compToReceiveFocus != null) {
                this.requestFocus(this.compToReceiveFocus);
                this.compToReceiveFocus = null;
            } else {
                this.requestFocus();
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.showing = false;
    }

    public void setContainerType(String string) {
        if (string.equals(this.containerType)) {
            return;
        }
        this.containerType = string;
        if (this.tcc != null) {
            TopComponentContainer topComponentContainer = this.tcc;
            this.tcc = this.createContainer(this.containerType);
            this.changeContainer(topComponentContainer, this.tcc);
        }
    }

    public String getContainerType() {
        this.ensureSectionLoaded(1);
        if (this.containerType == null) {
            this.containerType = WindowTypesManager.getDefaultContainer();
        }
        return this.containerType;
    }

    public void setFrameType(String string) {
        if (string.equals(this.frameType)) {
            return;
        }
        String string2 = this.frameType;
        this.frameType = string;
        WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(string2, true));
    }

    private void doSetFrameType(String string) {
        BoundsConvertor.getInstance().updateBounds(this, string, this.frameType);
        if (this.frame != null) {
            boolean bl = FrameTypeSupport.obtainFrameComponent(this.frame).isVisible();
            if (bl) {
                this.setVisible(false);
            }
            FrameType frameType = this.frame;
            this.frame = this.createFrame(this.frameType);
            this.changeFrame(frameType, this.frame);
            frameType.dispose();
            if (bl) {
                this.setVisible(true);
            }
            this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, frameType, this.frame);
        }
    }

    public String getFrameType() {
        this.ensureSectionLoaded(1);
        if (this.frameType == null) {
            this.frameType = WindowTypesManager.getDefaultFrame();
        }
        return this.frameType;
    }

    public void setConstraints(Object object) {
        Object object2;
        if (this.constraints == null ? this.constraints == object : this.constraints.equals(object)) {
            return;
        }
        if (object != null && !"CENTER".equals(object) && (object2 = WindowUtils.findConstrainedMode(this.workspace, object)) != null) {
            throw new IllegalArgumentException("Cannot attach " + this.getDisplayName() + "@" + System.identityHashCode(this) + " to " + object + " side. " + ((ModeImpl)object2).getDisplayName() + "@" + System.identityHashCode(object2) + " is already attached there.");
        }
        object2 = this.constraints;
        if (this.frame != null && FrameTypeSupport.obtainFrameComponent(this.frame).isVisible()) {
            this.setVisible(false);
            this.constraints = object;
            this.setVisible(true);
        } else {
            this.constraints = object;
        }
        this.changeSupport.firePropertyChange("containerInstance", object2, this.constraints);
    }

    public Object getConstraints() {
        this.ensureSectionLoaded(1);
        return this.getLoadedConstraints();
    }

    public void setCurrentConstraints(Object object) {
        this.currnetConstraints = object;
    }

    public Object getCurrentConstraints() {
        return this.currnetConstraints;
    }

    public Object getLoadedConstraints() {
        return this.constraints;
    }

    public Object getConstraint(TopComponent topComponent) {
        Object object;
        if (this.tcc != null && (object = this.tcc.getConstraints(topComponent)) != null) {
            return object;
        }
        ClosedTCContext closedTCContext = (ClosedTCContext)this.closedComponents.get(topComponent);
        return closedTCContext == null ? null : closedTCContext.constraints;
    }

    public boolean isHidden() {
        this.ensureSectionLoaded(1);
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean addIgnoredNameClass(Class clazz) {
        if (this.ignoredTcList == null) {
            this.ignoredTcList = new ArrayList(5);
        }
        if (!(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = ModeImpl.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("tcClass parameter is not a subclass of TopComponent class");
        }
        return this.ignoredTcList.add(clazz);
    }

    public boolean removeIgnoredNameClass(Class clazz) {
        if (this.ignoredTcList == null) {
            return false;
        }
        return this.ignoredTcList.remove(clazz);
    }

    void addClosedComponent(TopComponent topComponent, Object object, int n) {
        if (this.closedComponents == null) {
            this.closedComponents = new WeakHashMap(10);
        }
        WeakHashMap weakHashMap = this.closedComponents;
        synchronized (weakHashMap) {
            ClosedTCContext closedTCContext = (ClosedTCContext)this.closedComponents.get(topComponent);
            if (closedTCContext != null) {
                if (object != null) {
                    closedTCContext.constraints = object;
                }
                if (n != Integer.MAX_VALUE) {
                    closedTCContext.orderWeight = n;
                }
            } else {
                this.closedComponents.put(topComponent, new ClosedTCContext(object, n));
            }
        }
    }

    ClosedTCContext removeClosedComponent(TopComponent topComponent) {
        if (this.closedComponents == null) {
            return null;
        }
        WeakHashMap weakHashMap = this.closedComponents;
        synchronized (weakHashMap) {
            ClosedTCContext closedTCContext = (ClosedTCContext)this.closedComponents.get(topComponent);
            this.closedComponents.remove(topComponent);
            ClosedTCContext closedTCContext2 = closedTCContext;
            return closedTCContext2;
        }
    }

    public void removeAllClosedComponents() {
        if (this.closedComponents != null) {
            this.closedComponents.clear();
        }
    }

    private void addToContainer(TopComponent topComponent, boolean bl, Object object, int n) {
        Object object2;
        if (this.frame == null) {
            this.frame = this.createFrame(this.getFrameType());
            this.changeFrame(null, this.frame);
            object2 = this.obtainFrameIcon(topComponent);
            if (object2 != null) {
                this.frame.setIconImage((Image)object2);
            }
            this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, null, this.frame);
        }
        if (this.tcc == null) {
            this.tcc = this.createContainer(this.getContainerType());
            this.changeContainer(null, this.tcc);
        }
        if (object == null) {
            object = "CENTER";
        }
        object2 = null;
        if (this.areas != null) {
            object2 = (TopComponentContainer.Area)this.areas.remove(object);
        }
        if (object == null ? this.tcc.addTopComponent(topComponent, bl) : this.tcc.addTopComponent(topComponent, bl, object, n, (TopComponentContainer.Area)object2)) {
            this.updateNameListener();
        }
        this.setHidden(false);
    }

    private Image obtainFrameIcon(TopComponent topComponent) {
        Image image = this.getIcon();
        if (image != null) {
            return image;
        }
        Image image2 = topComponent.getIcon();
        if (image2 != null) {
            return image2;
        }
        return ModeImpl.defaultIcon();
    }

    private static Image defaultIcon() {
        return Utilities.loadImage((String)"/org/netbeans/core/resources/frames/default.gif");
    }

    public void setAreas(Map map) {
        this.areas = new HashMap(map);
    }

    public Map getAreas() {
        return this.areas;
    }

    private TopComponentContainer createContainer(String string) {
        return WindowTypesManager.createContainer(string);
    }

    private FrameType createFrame(String string) {
        FrameType frameType = WindowTypesManager.createFrame(string);
        frameType.setDefaultCloseOperation(0);
        Component component = FrameTypeSupport.obtainFrameComponent(frameType);
        component.setVisible(false);
        if (this.bounds != null) {
            component.setBounds(this.bounds);
        }
        if (this.relativeBounds != null) {
            ModeImpl.handleLayoutResource(component, this.relativeBounds, this.workspace);
            this.relativeBounds = null;
        }
        return frameType;
    }

    void setCloseOnlyInMemory(boolean bl) {
        this.closeOnlyInMemory = bl;
    }

    private void destroyMode() {
        ((WorkspaceImpl)this.workspace).removeMode(this);
        if (!this.closeOnlyInMemory && this.updater != null) {
            try {
                this.updater.destroy();
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
            }
        }
    }

    private void destroyFrame() {
        FrameType frameType;
        if (this.isUserDefined()) {
            this.destroyMode();
        }
        if (this.frame == null) {
            return;
        }
        this.updateNameListener();
        this.changeFrame(this.frame, null);
        this.frameTypeState = this.frame.getState();
        if (1 == this.frameTypeState) {
            this.frameTypeState = 0;
        }
        this.bounds = this.getNormalBounds();
        this.setHidden(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doDisposeFrame(this.frame);
        } else {
            frameType = this.frame;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doDisposeFrame(frameType);
                }
            });
        }
        frameType = this.frame;
        this.frame = null;
        this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, frameType, null);
    }

    private void doDisposeFrame(FrameType frameType) {
        if (this.isVisible() && ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType) || "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType))) {
            ((WorkspaceImpl)this.workspace).desktopPane().removeFrameType(frameType);
        }
        frameType.dispose();
    }

    private void destroyContainer() {
        if (this.tcc == null) {
            return;
        }
        this.changeContainer(this.tcc, null);
        TopComponentContainer topComponentContainer = this.tcc;
        this.tcc = null;
        this.changeSupport.firePropertyChange("containerInstance", topComponentContainer, null);
    }

    String frameTitle() {
        String string;
        Object object;
        if (windowTitle == null) {
            object = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl));
            windowTitle = new MessageFormat(((ResourceBundle)object).getString("CTL_MultiTabTitle"));
            if (untitledComponent == null) {
                untitledComponent = ((ResourceBundle)object).getString("CTL_UntitledComponent");
            }
        }
        String string2 = string = (object = this.getContainerInstance().getSelectedTopComponent()) == null ? "?" : ((Component)object).getName();
        if (string == null) {
            string = untitledComponent;
        }
        if (this.isSingleType()) {
            return string;
        }
        if (object != null && this.shouldIgnoreName((TopComponent)object)) {
            return this.getDisplayName();
        }
        return windowTitle.format(new Object[]{this.getDisplayName(), string});
    }

    private String frameDescription() {
        TopComponent topComponent;
        String string;
        if (descriptionFormat == null) {
            descriptionFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl)).getString("ACSD_FrameDescriptionFormat"));
        }
        String string2 = string = (topComponent = this.getContainerInstance().getSelectedTopComponent()) == null ? "?" : topComponent.getAccessibleContext().getAccessibleDescription();
        if (string == null) {
            return null;
        }
        String string3 = this.getDescription();
        if (string3 == null) {
            string3 = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl)).getString("ACSD_DefaultModeDescription");
        }
        return descriptionFormat.format(new Object[]{string3, string});
    }

    public void updateTitle() {
        if (this.frame != null) {
            this.frame.setTitle(this.frameTitle());
            this.frame.getRootPaneContainer().getAccessibleContext().setAccessibleDescription(this.frameDescription());
        }
    }

    public void attachUpdater(LazyUpdater lazyUpdater) {
        this.updater = lazyUpdater;
    }

    private void changeFrame(FrameType frameType, FrameType frameType2) {
        Image image = null;
        if (frameType != null) {
            frameType.removeFrameTypeListener(this);
            FrameTypeSupport.obtainFrameComponent(frameType).removeComponentListener(this);
            image = frameType.getIconImage();
        }
        if (frameType2 != null) {
            frameType2.addFrameTypeListener(this);
            FrameTypeSupport.obtainFrameComponent(frameType2).addComponentListener(this);
            TopComponentContainer topComponentContainer = this.getContainerInstance();
            if (topComponentContainer != null) {
                frameType2.setContentPane(topComponentContainer.getContentPane());
                frameType2.setTitle(this.frameTitle());
                frameType2.getRootPaneContainer().getAccessibleContext().setAccessibleDescription(this.frameDescription());
            }
            if (image != null) {
                frameType2.setIconImage(image);
            }
            if (frameType != null) {
                this.frameTypeState = frameType.getState();
            }
        }
    }

    private void changeContainer(TopComponentContainer topComponentContainer, TopComponentContainer topComponentContainer2) {
        if (topComponentContainer != null) {
            topComponentContainer.attachToMode(null);
        }
        if (topComponentContainer2 != null) {
            topComponentContainer2.attachToMode(this);
            FrameType frameType = this.getFrameInstance();
            if (frameType != null) {
                frameType.setContentPane(topComponentContainer2.getContentPane());
                frameType.setTitle(this.frameTitle());
                frameType.getRootPaneContainer().getAccessibleContext().setAccessibleDescription(this.frameDescription());
            }
        }
    }

    public boolean shouldIgnoreName(TopComponent topComponent) {
        if (!this.isSingle()) {
            return false;
        }
        return this.getDisplayName().equalsIgnoreCase(topComponent.getName()) || this.ignoredTcList != null && this.ignoredTcList.contains(topComponent.getClass());
    }

    private void updateNameListener() {
        if (this.isSingle()) {
            if (this.nameListener == null) {
                this.nameListener = new NameListener();
            }
            this.nameListener.activate();
        } else if (this.nameListener != null) {
            this.nameListener.passivate();
        }
        this.changeSupport.firePropertyChange("displayName", null, this.getDisplayName());
    }

    public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
        Object object = deferredContext.getData();
        if (object instanceof DeferredOpenContext) {
            DeferredOpenContext deferredOpenContext = (DeferredOpenContext)object;
            deferredOpenContext.tc.open(deferredOpenContext.workspace);
        } else if (object instanceof String) {
            this.doSetFrameType((String)object);
        }
    }

    private boolean isInClosableState() {
        return NbPresenter.currentModalDialog == null;
    }

    private boolean ensureSectionLoaded(int n) {
        if (this.updater == null) {
            return false;
        }
        try {
            if ((n & this.updater.getLoadedSections()) != n) {
                this.updater.loadDataSection(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + ", workspace " + this.getWorkspace().getName() + "]";
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this);
    }

    void validateSelf(Workspace workspace) {
        this.workspace = workspace;
    }

    void validateData() {
        if (this.tcc != null) {
            TopComponent[] topComponentArray;
            Object object;
            this.tcc.validateData();
            if (this.tcc instanceof MultiTabbedContainerImpl && null != this.containerType && this.containerType.equals("org.netbeans.core.windows.frames.SplitContainerImpl")) {
                object = this.createContainer(this.containerType);
                topComponentArray = this.tcc.getTopComponents();
                object.attachToMode(this);
                int n = 0;
                while (n < topComponentArray.length) {
                    object.addTopComponent(topComponentArray[n], true, "CENTER");
                    ++n;
                }
                this.tcc = object;
            }
            if (this.tcc.getTopComponents().length > 0) {
                object = this.tcc.getSelectedTopComponent();
                topComponentArray = this.tcc.getTopComponents();
                DeferredOpenContext deferredOpenContext = null;
                int n = 0;
                while (n < topComponentArray.length) {
                    deferredOpenContext = new DeferredOpenContext();
                    deferredOpenContext.tc = topComponentArray[n];
                    deferredOpenContext.workspace = this.workspace;
                    WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(deferredOpenContext, true));
                    ++n;
                }
                if (object != null) {
                    WindowManagerImpl.deferredPerformer().putRequest(new DeferredPerformer.DeferredCommand((TopComponent)object){
                        private final /* synthetic */ TopComponent val$tc;
                        {
                            this.val$tc = topComponent;
                        }

                        public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
                            ModeImpl modeImpl = ModeImpl.this;
                            synchronized (modeImpl) {
                                if (ModeImpl.this.tcc == null) {
                                    return;
                                }
                                ModeImpl.this.requestFocus(this.val$tc);
                            }
                        }
                    }, new DeferredPerformer.DeferredContext(null, true));
                }
            } else {
                this.tcc = null;
            }
        }
        if (this.frame != null) {
            this.frame.addFrameTypeListener(this);
            FrameTypeSupport.obtainFrameComponent(this.frame).addComponentListener(this);
        }
        this.changeSupport.firePropertyChange("containerInstance", null, this.tcc);
        this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, null, this.frame);
        this.changeSupport.firePropertyChange(PROP_TOP_COMPONENTS, null, null);
    }

    private VersionSerializator serializationManager() {
        if (serializationManager == null) {
            serializationManager = ModeImpl.createSerializationManager();
        }
        return serializationManager;
    }

    private static VersionSerializator createSerializationManager() {
        VersionSerializator versionSerializator = new VersionSerializator();
        versionSerializator.putVersion(new Version1());
        versionSerializator.putVersion(new Version2());
        return versionSerializator;
    }

    public int compareTo(Object object) {
        String string = this.getDisplayName();
        String string2 = object instanceof Mode ? ((Mode)object).getDisplayName() : null;
        if (string2 == null) {
            if (string == null) {
                return 0;
            }
            return 1;
        }
        if (string == null) {
            return -1;
        }
        return string.compareTo(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class VSAccess
    implements DefaultReplacer.Access {
        transient VersionSerializator vs;
        private static final long serialVersionUID = -7577235918945664917L;

        public VSAccess(VersionSerializator versionSerializator) {
            this.vs = versionSerializator;
        }

        public VersionSerializator getVersionSerializator() {
            return this.vs == null ? ModeImpl.createSerializationManager() : this.vs;
        }
    }

    private static class Version2
    extends Version1 {
        public static final String NAME = "Version_2.0";
        List ignoredTcList;

        private Version2() {
        }

        public String getName() {
            return NAME;
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readData(objectInput);
            ArrayList arrayList = (ArrayList)objectInput.readObject();
            if (arrayList == null || arrayList.size() <= 0 || arrayList.get(0) instanceof Class) {
                this.ignoredTcList = arrayList;
            } else {
                this.ignoredTcList = new ArrayList(arrayList.size());
                String string = null;
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    this.ignoredTcList.add(Class.forName(string, false, TopManager.getDefault().systemClassLoader()));
                }
            }
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            super.writeData(objectOutput);
            ArrayList<String> arrayList = null;
            if (this.mode.ignoredTcList != null) {
                arrayList = new ArrayList<String>(this.mode.ignoredTcList.size());
                String string = null;
                Iterator iterator = this.mode.ignoredTcList.iterator();
                while (iterator.hasNext()) {
                    string = ((Class)iterator.next()).getName();
                    arrayList.add(string);
                }
            }
            objectOutput.writeObject(arrayList);
        }

        public Object resolveData() throws ObjectStreamException {
            ModeImpl modeImpl = (ModeImpl)super.resolveData();
            if (modeImpl.ignoredTcList == null) {
                modeImpl.ignoredTcList = this.ignoredTcList;
            } else if (this.ignoredTcList != null) {
                modeImpl.ignoredTcList.addAll(this.ignoredTcList);
            }
            return modeImpl;
        }
    }

    private static class Version1
    implements DefaultReplacer.ResVersionable {
        public static final String NAME = "Version_1.0";
        String name;
        String displayName;
        Rectangle bounds;
        URL icon;
        int containerType;
        boolean userDefined;
        String workspaceName;
        TopComponentContainer tcc;
        ModeImpl mode;

        private Version1() {
        }

        public String getName() {
            return NAME;
        }

        public void assignData(ModeImpl modeImpl) {
            this.mode = modeImpl;
        }

        public void readData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.name = (String)objectInput.readObject();
            this.displayName = (String)objectInput.readObject();
            this.bounds = (Rectangle)objectInput.readObject();
            this.icon = (URL)objectInput.readObject();
            this.containerType = (Integer)objectInput.readObject();
            this.userDefined = (Boolean)objectInput.readObject();
            this.workspaceName = (String)objectInput.readObject();
            this.tcc = (TopComponentContainer)objectInput.readObject();
        }

        public void writeData(ObjectOutput objectOutput) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            ModeImpl modeImpl;
            Workspace workspace = TopManager.getDefault().getWindowManager().findWorkspace(this.workspaceName);
            ModeImpl modeImpl2 = modeImpl = workspace == null ? null : (ModeImpl)workspace.findMode(this.name);
            if (modeImpl == null) {
                modeImpl = new ModeImpl(this.name, this.displayName, this.icon, this.userDefined, workspace);
                if (workspace == null) {
                    modeImpl.workspaceName = this.workspaceName;
                }
            }
            if (null != modeImpl) {
                modeImpl.bounds = this.bounds;
                modeImpl.tcc = this.tcc;
            }
            return modeImpl;
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = 1230255666898346575L;
        private static final String NAME = "name";
        private static final String DISPLAY_NAME = "displayName";
        private static final String BOUNDS = "bounds";
        private static final String ICON_URL = "iconURL";
        private static final String USER_DEFINED = "userDefined";
        private static final String WORKSPACE_NAME = "workspaceName";
        private static final String TC_CONTAINER = "tcContainer";
        private static final String FRAME_TYPE = "frameType";
        private static final String FRAME_TYPE_STATE = "frameTypeState";
        private static final String CONTAINER_TYPE = "containerType";
        private static final String CONSTRAINTS = "constraints";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("displayName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("bounds", class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = SerializationReplacer.class$("java.awt.Rectangle")) : class$java$awt$Rectangle), new ObjectStreamField("iconURL", class$java$net$URL == null ? (class$java$net$URL = SerializationReplacer.class$("java.net.URL")) : class$java$net$URL), new ObjectStreamField("userDefined", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializationReplacer.class$("java.lang.Boolean")) : class$java$lang$Boolean), new ObjectStreamField("workspaceName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("tcContainer", class$org$netbeans$core$windows$frames$TopComponentContainer == null ? (class$org$netbeans$core$windows$frames$TopComponentContainer = SerializationReplacer.class$("org.netbeans.core.windows.frames.TopComponentContainer")) : class$org$netbeans$core$windows$frames$TopComponentContainer), new ObjectStreamField("frameType", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("frameTypeState", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("containerType", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("constraints", class$java$lang$Object == null ? (class$java$lang$Object = SerializationReplacer.class$("java.lang.Object")) : class$java$lang$Object)};
        private static final String OLD_SPLIT_CONTAINER = "org.netbeans.core.windows.frames.SplittedContainerImpl";
        transient ModeImpl source;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$awt$Rectangle;
        static /* synthetic */ Class class$java$net$URL;
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$org$netbeans$core$windows$frames$TopComponentContainer;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$Object;

        SerializationReplacer(ModeImpl modeImpl) {
            this.source = modeImpl;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put(NAME, this.source.getName());
            putField.put(DISPLAY_NAME, this.source.getDisplayName());
            putField.put(BOUNDS, this.source.getNormalBounds());
            putField.put(ICON_URL, this.source.getIconURL());
            putField.put(USER_DEFINED, new Boolean(this.source.isUserDefined()));
            putField.put(WORKSPACE_NAME, this.source.workspace.getName());
            putField.put(TC_CONTAINER, this.source.tcc);
            putField.put(FRAME_TYPE, this.source.getFrameType());
            putField.put(FRAME_TYPE_STATE, new Integer(this.source.getFrameState()));
            putField.put(CONTAINER_TYPE, this.source.getContainerType());
            putField.put(CONSTRAINTS, this.source.getConstraints());
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            String string = (String)getField.get(NAME, null);
            String string2 = (String)getField.get(WORKSPACE_NAME, null);
            Workspace workspace = TopManager.getDefault().getWindowManager().findWorkspace(string2);
            ModeImpl modeImpl = this.source = workspace == null ? null : (ModeImpl)workspace.findMode(string);
            if (this.source == null) {
                this.source = new ModeImpl(string, (String)getField.get(DISPLAY_NAME, null), (URL)getField.get(ICON_URL, null), (Boolean)getField.get(USER_DEFINED, null), workspace);
            } else {
                this.source.close();
                this.source.destroyFrame();
                this.source.destroyContainer();
                this.source.setDisplayName((String)getField.get(DISPLAY_NAME, null));
            }
            this.source.setBounds((Rectangle)getField.get(BOUNDS, null));
            this.source.frameType = (String)getField.get(FRAME_TYPE, null);
            this.source.containerType = (String)getField.get(CONTAINER_TYPE, null);
            if (OLD_SPLIT_CONTAINER.equals(this.source.containerType)) {
                this.source.containerType = "org.netbeans.core.windows.frames.SplitContainerImpl";
            }
            this.source.constraints = getField.get(CONSTRAINTS, null);
            this.source.tcc = (TopComponentContainer)getField.get(TC_CONTAINER, null);
            if (workspace == null) {
                this.source.workspaceName = string2;
            }
            if (null != this.source.frameType && WindowUtils.hasObjectStreamField(getField, FRAME_TYPE_STATE)) {
                this.source.frameTypeState = (Integer)getField.get(FRAME_TYPE_STATE, new Integer(0));
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.source;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static final class ClosedTCContext {
        Object constraints;
        int orderWeight;

        ClosedTCContext(Object object, int n) {
            this.constraints = object;
            this.orderWeight = n;
        }
    }

    public static final class ModeDefinition {
        String name;
        String displayName;
        URL iconURL;
        String containerType;
        Object constraints;
    }

    private final class NameListener
    implements PropertyChangeListener {
        WindowManagerImpl.TopComponentManager tcm;

        private NameListener() {
        }

        void activate() {
            if (this.tcm == null) {
                ModeImpl.this.wm;
                this.tcm = WindowManagerImpl.findManager(ModeImpl.this.tcc.getTopComponents()[0]);
                this.tcm.addPropertyChangeListener(this);
            }
        }

        void passivate() {
            if (this.tcm != null) {
                this.tcm.removePropertyChangeListener(this);
                this.tcm = null;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("name".equals(string)) {
                if (ModeImpl.this.frame != null) {
                    ModeImpl.this.frame.setTitle(ModeImpl.this.frameTitle());
                }
                ModeImpl.this.changeSupport.firePropertyChange("displayName", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    private static final class DeferredOpenContext {
        TopComponent tc;
        Workspace workspace;

        private DeferredOpenContext() {
        }
    }
}

