/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.core.Splash;
import org.netbeans.core.upgrade.CopyUtil;
import org.netbeans.core.upgrade.PreUpgradePanel;
import org.netbeans.core.upgrade.TransferSettingsPanel;
import org.netbeans.core.upgrade.UpgradePanel;
import org.netbeans.core.upgrade.UpgradeWizardSettings;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.NbBundle;

public final class UpgradeWizard
implements PropertyChangeListener {
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    static final String PROP_CONTENT_PANEL_SELECTED = "WizardPanel_selected";
    private FinalNoBackIterator it = null;
    private WizardDescriptor wd = null;
    private boolean cancelOnClose = true;
    private UpgradeWizardSettings uwSettings = null;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$UpgradeWizard;

    private UpgradeWizard() {
    }

    private boolean show(Splash.SplashOutput splashOutput) {
        boolean bl;
        this.uwSettings = UpgradeWizardSettings.getInstance();
        if (null == this.uwSettings.getIDEVersion() || null == this.uwSettings.getIDELocation()) {
            if (splashOutput != null) {
                Splash.hideSplash(splashOutput);
            }
            bl = this.showInteractive();
        } else {
            bl = CopyUtil.canUpgradeFrom(this.uwSettings.getIDEVersion()) ? this.showAutomatic() : false;
        }
        return bl;
    }

    private boolean showInteractive() {
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new PreUpgradePanel(), new UpgradePanel(), new TransferSettingsPanel()};
        Object[] objectArray = new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION};
        return this.show_internal(objectArray, panelArray);
    }

    private boolean showAutomatic() {
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new TransferSettingsPanel()};
        Object[] objectArray = new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION};
        return this.show_internal(objectArray, panelArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean show_internal(Object[] objectArray, WizardDescriptor.Panel[] panelArray) {
        TransferSettingsPanel transferSettingsPanel = (TransferSettingsPanel)panelArray[panelArray.length - 1];
        boolean bl = 1 == panelArray.length;
        this.it = new FinalNoBackIterator(panelArray);
        this.wd = new WizardDescriptor((WizardDescriptor.Iterator)this.it, (Object)this.uwSettings);
        this.it.addPropertyChangeListener(this);
        this.it.addPropertyChangeListener(transferSettingsPanel);
        this.wd.putProperty(PROP_AUTO_WIZARD_STYLE, (Object)new Boolean(true));
        this.wd.putProperty(PROP_CONTENT_DISPLAYED, (Object)new Boolean(true));
        this.wd.putProperty(PROP_CONTENT_NUMBERED, (Object)new Boolean(true));
        this.wd.setTitleFormat(new MessageFormat("{0}"));
        this.wd.setTitle(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"LBL_UpgradeWizard_Title"));
        this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.it.getContentData());
        this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, (Object)new Integer(this.it.getContentSelectedIndex()));
        this.wd.setOptions(objectArray);
        this.wd.setClosingOptions(new Object[]{WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION});
        Dialog dialog = TopManager.getDefault().createDialog((DialogDescriptor)this.wd);
        if (bl) {
            TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"MSG_SplashScreen_status"));
            this.it.hasNext();
            try {
                while (0 == transferSettingsPanel.getStatus() || 1 == transferSettingsPanel.getStatus()) {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                bl = 2 == transferSettingsPanel.getStatus();
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
        }
        if (!bl) {
            dialog.show();
        }
        dialog.dispose();
        this.it.removePropertyChangeListener(this);
        this.it.removePropertyChangeListener(transferSettingsPanel);
        if (this.wd.getValue() == NotifyDescriptor.CANCEL_OPTION) return true;
        if (!this.cancelOnClose) return false;
        if (this.wd.getValue() != NotifyDescriptor.CLOSED_OPTION) return false;
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (PROP_CONTENT_SELECTED_INDEX.equals(propertyChangeEvent.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, (Object)new Integer(this.it.getContentSelectedIndex()));
        } else if (PROP_CONTENT_DATA.equals(propertyChangeEvent.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.it.getContentData());
        } else if (PROP_CONTENT_PANEL_SELECTED.equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() instanceof TransferSettingsPanel) {
                this.cancelOnClose = false;
                this.wd.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION});
            } else {
                this.cancelOnClose = true;
                this.wd.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION});
            }
        }
    }

    public static boolean showWizard(Splash.SplashOutput splashOutput) {
        boolean bl = false;
        LocalFileSystem localFileSystem = new LocalFileSystem();
        try {
            localFileSystem.setRootDirectory(new File(System.getProperty("netbeans.user", "")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        FileObject fileObject = localFileSystem.findResource("system/project.last");
        if (null == fileObject) {
            UpgradeWizard upgradeWizard = new UpgradeWizard();
            bl = upgradeWizard.show(splashOutput);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        UpgradeWizard upgradeWizard = new UpgradeWizard();
        upgradeWizard.show(null);
        System.out.println("exit");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ExtendedPanel {
        public boolean hasNext();

        public boolean hasPrevious();
    }

    private class FinalNoBackIterator
    extends WizardDescriptor.ArrayIterator {
        protected WizardDescriptor.Panel[] panels;
        protected LinkedList listeners = new LinkedList();
        private boolean first = true;

        public FinalNoBackIterator(WizardDescriptor.Panel[] panelArray) {
            super(panelArray);
            this.panels = panelArray;
        }

        public boolean hasPrevious() {
            this.checkFirst();
            int n = this.getContentSelectedIndex();
            boolean bl = super.hasPrevious();
            if (bl) {
                boolean bl2 = bl = n < this.panels.length - 1;
            }
            if (bl && this.panels[n] instanceof ExtendedPanel) {
                bl = ((ExtendedPanel)this.panels[n]).hasPrevious();
            }
            return bl;
        }

        public boolean hasNext() {
            this.checkFirst();
            int n = this.getContentSelectedIndex();
            boolean bl = super.hasNext();
            if (bl && this.panels[n] instanceof ExtendedPanel) {
                bl = ((ExtendedPanel)this.panels[n]).hasNext();
            }
            return bl;
        }

        public void previousPanel() {
            super.previousPanel();
            this.firePanelChangedEvent();
        }

        public void nextPanel() {
            super.nextPanel();
            this.firePanelChangedEvent();
        }

        public String[] getContentData() {
            String[] stringArray = new String[this.panels.length];
            int n = 0;
            while (n < this.panels.length) {
                stringArray[n] = this.panels[n].getComponent().getName();
                ++n;
            }
            return stringArray;
        }

        public int getContentSelectedIndex() {
            int n = 0;
            while (n < this.panels.length) {
                if (this.current() == this.panels[n]) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (!this.listeners.contains(propertyChangeListener)) {
                this.listeners.add(propertyChangeListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.listeners.remove(propertyChangeListener);
        }

        private void checkFirst() {
            if (this.first) {
                this.first = false;
                this.firePanelChangedEvent();
            }
        }

        private void firePanelChangedEvent() {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
                propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, UpgradeWizard.PROP_CONTENT_SELECTED_INDEX, null, new Integer(this.getContentSelectedIndex())));
                propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, UpgradeWizard.PROP_CONTENT_PANEL_SELECTED, null, this.current()));
            }
        }
    }
}

