/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.upgrade.CopyUtil;
import org.netbeans.core.upgrade.FSChooser;
import org.netbeans.core.upgrade.UpgradeWizardSettings;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class UpgradePanel
extends JPanel
implements WizardDescriptor.Panel {
    private JTextField txtVersion;
    private JPanel pnlUpgrade;
    private JTextArea txtLabelTop;
    private JButton cmdSelectDir;
    private JLabel lblLocation;
    private JLabel lblVersion;
    private JPanel jPanel1;
    private JTextField txtLocation;
    private File lastLocation = null;
    private static final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.core.upgrade.Bundle");
    private boolean upgradeStatus = false;
    private ArrayList changeListeners = new ArrayList(1);
    private UpgradeWizardSettings settings = new UpgradeWizardSettings();

    public static void main(String[] stringArray) {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new UpgradePanel(), bundle.getString("LBL_UpgradePanel_Name"));
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        dialog.dispose();
    }

    public UpgradePanel() {
        this.initComponents();
        this.initAccessibility();
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return null != this.settings.getIDELocation();
    }

    public void storeSettings(Object object) {
        ((UpgradeWizardSettings)object).read(this.settings);
    }

    public void readSettings(Object object) {
        this.settings.read((UpgradeWizardSettings)object);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        ((AbstractCollection)this.changeListeners).remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    private void initAccessibility() {
        this.txtVersion.selectAll();
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Upgrade_Description_Top"));
        this.lblLocation.setDisplayedMnemonic(bundle.getString("LBL_lblLocation_Mnem").charAt(0));
        this.txtLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_txtLocation"));
        this.txtVersion.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_txtVersion"));
        this.cmdSelectDir.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_cmdSelectDir"));
        this.cmdSelectDir.setMnemonic(bundle.getString("LBL_cmdSelectDir_Mnem").charAt(0));
    }

    private void initComponents() {
        this.pnlUpgrade = new JPanel();
        this.lblLocation = new JLabel();
        this.txtLocation = new JTextField();
        this.cmdSelectDir = new JButton();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.txtLabelTop = new JTextArea();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(550, 350));
        this.setName(bundle.getString("LBL_UpgradePanel_Name"));
        this.setMinimumSize(new Dimension(500, 279));
        this.setMaximumSize(new Dimension(123456, 123456));
        this.pnlUpgrade.setLayout(new GridBagLayout());
        this.lblLocation.setText(bundle.getString("LBL_lblLocation"));
        this.lblLocation.setLabelFor(this.txtLocation);
        this.lblLocation.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlUpgrade.add((Component)this.lblLocation, gridBagConstraints);
        this.txtLocation.setDisabledTextColor(Color.black);
        this.txtLocation.setBorder(new EtchedBorder());
        this.txtLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpgradePanel.this.txtLocationActionPerformed(actionEvent);
            }
        });
        this.txtLocation.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                UpgradePanel.this.txtLocationKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.pnlUpgrade.add((Component)this.txtLocation, gridBagConstraints);
        this.cmdSelectDir.setText(bundle.getString("LBL_cmdSelectDir"));
        this.cmdSelectDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpgradePanel.this.cmdSelectDirActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.pnlUpgrade.add((Component)this.cmdSelectDir, gridBagConstraints);
        this.lblVersion.setText(bundle.getString("LBL_lblVersion"));
        this.lblVersion.setLabelFor(this.txtVersion);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.pnlUpgrade.add((Component)this.lblVersion, gridBagConstraints);
        this.txtVersion.setEditable(false);
        this.txtVersion.setDisabledTextColor(Color.black);
        this.txtVersion.setBorder(new EtchedBorder());
        this.txtVersion.setEnabled(false);
        this.txtVersion.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                UpgradePanel.this.txtVersionFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.pnlUpgrade.add((Component)this.txtVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pnlUpgrade, gridBagConstraints);
        this.txtLabelTop.setWrapStyleWord(true);
        this.txtLabelTop.setLineWrap(true);
        this.txtLabelTop.setEditable(false);
        this.txtLabelTop.setFont(this.lblLocation.getFont());
        this.txtLabelTop.setText(bundle.getString("LBL_Upgrade_Description_Top"));
        this.txtLabelTop.setDisabledTextColor(this.lblLocation.getForeground());
        this.txtLabelTop.setDoubleBuffered(true);
        this.txtLabelTop.setEnabled(false);
        this.txtLabelTop.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.txtLabelTop, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void txtVersionFocusGained(FocusEvent focusEvent) {
        this.txtVersion.selectAll();
    }

    private void txtLocationKeyTyped(KeyEvent keyEvent) {
        final UpgradePanel upgradePanel = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpgradePanel.this.lastLocation = new File(UpgradePanel.this.txtLocation.getText());
                upgradePanel.checkLocation(UpgradePanel.this.lastLocation);
            }
        });
    }

    private void txtLocationActionPerformed(ActionEvent actionEvent) {
        this.lastLocation = new File(this.txtLocation.getText());
        this.checkLocation(this.lastLocation);
    }

    private void cmdSelectDirActionPerformed(ActionEvent actionEvent) {
        FSChooser fSChooser = new FSChooser();
        fSChooser.setFileSelectionMode(1);
        fSChooser.setDialogTitle(bundle.getString("LBL_SelectDir_Dialog_Title"));
        if (this.lastLocation != null) {
            fSChooser.setCurrentDirectory(this.lastLocation);
        }
        if (Utilities.showJFileChooser((JFileChooser)fSChooser, (Component)this, (String)bundle.getString("LBL_Open_Button")) == 0) {
            this.lastLocation = fSChooser.getSelectedFile();
            this.txtLocation.setText(this.lastLocation.getAbsolutePath());
            if (!this.checkLocation(this.lastLocation)) {
                this.notify(bundle.getString("MSG_Old_IDE_Location_Invalid"), 0);
            }
        }
    }

    private boolean checkLocation(File file) {
        String string = CopyUtil.getIdeVersion(file);
        if (null != string) {
            this.settings.setIDELocation(file);
            this.settings.setIDEVersion(string);
            this.txtVersion.setText(string);
        } else {
            this.settings.setIDELocation(null);
            this.settings.setIDEVersion(null);
            this.txtVersion.setText("");
        }
        this.fireStateChanged();
        return null != string;
    }

    private void fireStateChanged() {
        int n = 0;
        while (n < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.get(n)).stateChanged(new ChangeEvent(this));
            ++n;
        }
    }

    private void notify(String string, int n) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, n);
        TopManager.getDefault().notify((NotifyDescriptor)message);
    }
}

