/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.enum.EmptyEnumeration;

abstract class CopyUtil {
    private static final int timeDev = 100000;
    private int items;
    private int maxItems;
    private static final String DIRTYPE_INST = "Installation Directory";
    private static final String DIRTYPE_USER = "User Directory";
    private static String[] versions;
    private static String ffj20IE;
    private static String ffj30EE;
    private static String[] nonCpFiles;
    private static String userdirNonCpFiles;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$FileCopy;
    static /* synthetic */ Class class$org$netbeans$core$NbTopManager;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$CopyUtil;

    CopyUtil() {
    }

    protected abstract void message(String var1);

    protected abstract void progress(int var1, int var2);

    protected final void upgradeIde(String string, File file, File file2) throws Exception {
        Object object;
        int n = CopyUtil.getIdeVersion(string);
        if (n < 0 || n >= versions.length) {
            this.message(CopyUtil.getString("MSG_BAD_IDE"));
            int n2 = 0;
            while (n2 < versions.length) {
                this.message(versions[n2]);
                ++n2;
            }
            throw new Exception("Invalid IDE version");
        }
        this.message(CopyUtil.getString("MSG_UPDATE_FROM", versions[n]));
        FileSystem fileSystem = null;
        FileSystem fileSystem2 = null;
        FileSystem fileSystem3 = null;
        String[] stringArray = null;
        if (-1 != string.indexOf(DIRTYPE_INST)) {
            object = new File(file, "system");
            File file3 = new File(file2, "system");
            fileSystem = this.createFileSystem((File)object);
            fileSystem2 = this.createFileSystem(file3);
            if (fileSystem == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", object.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + object.getAbsolutePath());
            }
            if (fileSystem2 == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", file3.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + file3.getAbsolutePath());
            }
            File file4 = new File(file2, "system_backup");
            if (!file4.exists()) {
                file4.mkdirs();
            }
            fileSystem3 = this.createFileSystem(file4);
            stringArray = this.originalFiles(nonCpFiles[n]);
        } else {
            fileSystem = this.createFileSystem(file);
            fileSystem2 = this.createFileSystem(file2);
            if (fileSystem == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", file.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + file.getAbsolutePath());
            }
            if (fileSystem2 == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", file2.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + file2.getAbsolutePath());
            }
            object = new File(file2.getParentFile(), "userdir_backup");
            if (!object.exists()) {
                object.mkdirs();
            }
            fileSystem3 = this.createFileSystem((File)object);
            stringArray = this.originalFiles(userdirNonCpFiles);
        }
        if (fileSystem3 != null) {
            object = fileSystem3.getRoot().getChildren();
            int n3 = 0;
            while (n3 < ((FileObject[])object).length) {
                this.deleteAll(object[n3]);
                ++n3;
            }
            CopyUtil.copyAttributes(fileSystem2.getRoot(), fileSystem3.getRoot());
            this.recursiveCopy(fileSystem2.getRoot(), fileSystem3.getRoot());
        }
        try {
            this.update(fileSystem, fileSystem2, this.getLastModified(file), stringArray);
        }
        catch (Exception exception) {
            if (fileSystem3 != null) {
                this.message(CopyUtil.getString("MSG_recovery_started"));
                this.deleteAll(fileSystem2.getRoot());
                CopyUtil.copyAttributes(fileSystem3.getRoot(), fileSystem2.getRoot());
                this.recursiveCopy(fileSystem3.getRoot(), fileSystem2.getRoot());
                this.message(CopyUtil.getString("MSG_recovery_finished"));
            }
            throw exception;
        }
    }

    private FileSystem createFileSystem(File file) {
        LocalFileSystem localFileSystem = null;
        if (file.exists() && file.isDirectory()) {
            try {
                localFileSystem = new LocalFileSystem();
                localFileSystem.setRootDirectory(file);
            }
            catch (Exception exception) {
                localFileSystem = null;
            }
        }
        return localFileSystem == null ? null : new AttrslessLocalFileSystem(localFileSystem);
    }

    private void update(FileSystem fileSystem, FileSystem fileSystem2, long l, String[] stringArray) throws IOException {
        this.items = 0;
        this.maxItems = 0;
        CopyUtil.copyAttributes(fileSystem.getRoot(), fileSystem2.getRoot());
        this.recursiveCopyWithFilter(fileSystem.getRoot(), fileSystem2.getRoot(), stringArray, l);
    }

    private void recursiveCopy(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject3 = fileObjectArray[n];
            FileObject fileObject4 = null;
            if (fileObject3.isFolder()) {
                fileObject4 = fileObject2.getFileObject(fileObject3.getName());
                if (fileObject4 == null) {
                    fileObject4 = fileObject2.createFolder(fileObject3.getName());
                }
                CopyUtil.copyAttributes(fileObject3, fileObject4);
                this.recursiveCopy(fileObject3, fileObject4);
            } else {
                fileObject4 = fileObject2.getFileObject(fileObject3.getNameExt());
                if (fileObject4 == null) {
                    fileObject4 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName(), (String)fileObject3.getExt());
                }
                CopyUtil.copyAttributes(fileObject3, fileObject4);
            }
            ++n;
        }
    }

    private void recursiveCopyWithFilter(FileObject fileObject, FileObject fileObject2, String[] stringArray, long l) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (!fileObject.isFolder()) {
            this.message(CopyUtil.getString("MSG_IS_NOT_FOLDER", fileObject.getName()));
        }
        this.maxItems += fileObjectArray.length;
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject3 = fileObjectArray[n];
            ++this.items;
            this.progress(this.items, this.maxItems);
            if (this.canCopy(fileObject3, stringArray, l)) {
                FileObject fileObject4 = null;
                if (fileObject3.isFolder()) {
                    fileObject4 = fileObject2.getFileObject(fileObject3.getName());
                    if (fileObject4 == null) {
                        fileObject4 = fileObject2.createFolder(fileObject3.getName());
                    }
                    CopyUtil.copyAttributes(fileObject3, fileObject4);
                    this.recursiveCopyWithFilter(fileObject3, fileObject4, stringArray, l);
                } else {
                    fileObject4 = fileObject2.getFileObject(fileObject3.getName(), fileObject3.getExt());
                    if (fileObject4 != null) {
                        FileLock fileLock = fileObject4.lock();
                        fileObject4.delete(fileLock);
                        fileLock.releaseLock();
                    }
                    fileObject4 = FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName());
                    CopyUtil.copyAttributes(fileObject3, fileObject4);
                }
            }
            ++n;
        }
    }

    private static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = fileObject.getAttribute(string);
            if (object == null) continue;
            fileObject2.setAttribute(string, object);
        }
    }

    private boolean canCopy(FileObject fileObject, String[] stringArray, long l) throws IOException {
        if (fileObject.isFolder()) {
            String string = fileObject.getPackageNameExt('/', '.') + "/*";
            return Arrays.binarySearch(stringArray, string) < 0;
        }
        String string = fileObject.getPackageNameExt('/', '.');
        long l2 = fileObject.lastModified().getTime();
        return Arrays.binarySearch(stringArray, string) < 0 && l + 100000L <= l2;
    }

    private long getLastModified(File file) {
        long l = file.lastModified();
        long l2 = 0L;
        File file2 = new File(file, CopyUtil.getString("CTL_README"));
        if (file2.exists()) {
            l2 = file2.lastModified();
            if (l2 < l) {
                l = l2;
            }
        } else {
            this.message(CopyUtil.getString("MSG_NOT_FOUNDED", file2.getPath()));
        }
        if ((file2 = new File(new File(file, "beans"), "TimerBean.jar")).exists()) {
            l2 = file2.lastModified();
            if (l2 < l) {
                l = l2;
            }
        } else {
            this.message(CopyUtil.getString("MSG_NOT_FOUNDED", file2.getPath()));
        }
        return l2;
    }

    private String[] originalFiles(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((class$org$netbeans$core$upgrade$FileCopy == null ? (class$org$netbeans$core$upgrade$FileCopy = CopyUtil.class$("org.netbeans.core.upgrade.FileCopy")) : class$org$netbeans$core$upgrade$FileCopy).getResourceAsStream(string)));
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
            }
            vector.add(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAll(FileObject fileObject) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (true) {
            block10: {
                if (n >= fileObjectArray.length) {
                    return;
                }
                FileObject fileObject2 = fileObjectArray[n];
                FileLock fileLock = null;
                if (!fileObject2.getNameExt().equals("ide.log")) {
                    Object var8_7;
                    if (fileObject2.isFolder()) {
                        this.deleteAll(fileObject2);
                    }
                    try {
                        try {
                            fileLock = fileObject2.lock();
                            fileObject2.delete(fileLock);
                        }
                        catch (IOException iOException) {
                            System.out.println("FileObject " + fileObject2.getPackageNameExt('/', '.') + " couldn't be deleted.");
                            var8_7 = null;
                            if (null != fileLock) {
                                fileLock.releaseLock();
                            }
                            break block10;
                        }
                        var8_7 = null;
                        if (null == fileLock) break block10;
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        if (null != fileLock) {
                            fileLock.releaseLock();
                        }
                        throw throwable;
                    }
                    fileLock.releaseLock();
                }
            }
            ++n;
        }
    }

    public static String getIdeVersion(File file) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        File file2 = new File(file, "lib");
        Object object2 = new File(file2, "core.jar");
        if (!((File)object2).exists()) {
            object2 = new File(file2, "developer.jar");
        } else {
            string3 = CopyUtil.getBranding((File)object2);
            if (null != string3) {
                object = new File(file2, "locale/core_" + string3 + ".jar");
                object2 = ((File)object).exists() ? object : object2;
            }
        }
        try {
            if (((File)object2).exists()) {
                string2 = DIRTYPE_INST;
                object = string3 == null ? "org/netbeans/core/Bundle.properties" : "org/netbeans/core/Bundle_" + string3 + ".properties";
                JarFile jarFile = new JarFile((File)object2);
                JarEntry jarEntry = jarFile.getJarEntry((String)object);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));
                string = CopyUtil.readIdeVersion(bufferedReader, "currentVersion", false);
                bufferedReader.close();
            } else {
                object = new File(file, "system/ide.log");
                if (((File)object).exists()) {
                    string2 = DIRTYPE_USER;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object)));
                    string = CopyUtil.readIdeVersion(bufferedReader, "Product Version", true);
                    bufferedReader.close();
                }
            }
        }
        catch (IOException iOException) {
            string = null;
        }
        if (string != null) {
            int n = CopyUtil.getIdeVersion(string);
            string = n == -1 ? null : versions[n] + " - " + string2;
        }
        return string;
    }

    public static boolean canUpgradeFrom(String string) {
        return !ffj20IE.equals(string) || CopyUtil.isForte();
    }

    private static String readIdeVersion(BufferedReader bufferedReader, String string, boolean bl) throws IOException {
        String string2 = null;
        String string3 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string4;
            int n = string2.indexOf(61);
            if (n == -1 || !(string4 = string2.substring(0, n).trim()).equals(string)) continue;
            string3 = string2.substring(n + 1).trim();
            if (!bl) break;
        }
        return string3;
    }

    private static String getBranding(File file) {
        File file2 = new File(file.getParentFile(), "branding");
        String string = null;
        if (file2.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    private static int getIdeVersion(String string) {
        int n = 0;
        while (n < versions.length) {
            if (string.startsWith(versions[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean isForte() {
        String string = NbBundle.getMessage((Class)(class$org$netbeans$core$NbTopManager == null ? (class$org$netbeans$core$NbTopManager = CopyUtil.class$("org.netbeans.core.NbTopManager")) : class$org$netbeans$core$NbTopManager), (String)"currentVersion");
        if (null == string) {
            return true;
        }
        return string.startsWith("Forte");
    }

    protected static String getString(String string) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$CopyUtil == null ? (class$org$netbeans$core$upgrade$CopyUtil = CopyUtil.class$("org.netbeans.core.upgrade.CopyUtil")) : class$org$netbeans$core$upgrade$CopyUtil), (String)string);
    }

    protected static String getString(String string, String string2) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$CopyUtil == null ? (class$org$netbeans$core$upgrade$CopyUtil = CopyUtil.class$("org.netbeans.core.upgrade.CopyUtil")) : class$org$netbeans$core$upgrade$CopyUtil), (String)string, (Object)string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ffj20IE = "Forte(tm) for Java(tm), release 2.0, Internet Edition";
        ffj30EE = "Forte for Java, EE v. 3.0";
        userdirNonCpFiles = "userdir.cfg";
        if (CopyUtil.isForte()) {
            versions = new String[]{"NetBeans IDE v3.0", "Forte(tm) for Java(tm), release 2.0, Community Edition", "Forte for Java, CE v. 3.0", ffj20IE, ffj30EE, "NetBeans IDE 3.1", "NetBeans IDE 3.2", "NetBeans IDE, Release 3.3", "NetBeans IDE Version 3.3", "NetBeans IDE 3.3", "NetBeans IDE, Development Version"};
            nonCpFiles = new String[]{"netbeans30.cfg", "forte4j20CE.cfg", "nbdev.cfg", "forte4j20IE.cfg", "nbdev.cfg", "netbeans31.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg"};
        } else {
            versions = new String[]{"NetBeans IDE v3.0", "Forte(tm) for Java(tm), release 2.0, Community Edition", "Forte for Java, CE v. 3.0", "NetBeans IDE 3.1", "NetBeans IDE 3.2", "NetBeans IDE, Release 3.3", "NetBeans IDE Version 3.3", "NetBeans IDE 3.3", "NetBeans IDE, Development Version"};
            nonCpFiles = new String[]{"netbeans30.cfg", "forte4j20CE.cfg", "nbdev.cfg", "netbeans31.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg"};
        }
    }

    private static class AttrslessLocalFileSystem
    extends AbstractFileSystem
    implements AbstractFileSystem.Attr {
        public AttrslessLocalFileSystem(LocalFileSystem localFileSystem) {
            this.change = new LocalFileSystem.Impl(localFileSystem);
            this.info = (AbstractFileSystem.Info)this.change;
            this.list = (AbstractFileSystem.List)this.change;
            this.attr = this;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getDisplayName() {
            return ((Object)((Object)this)).getClass().toString();
        }

        public void deleteAttributes(String string) {
        }

        public Enumeration attributes(String string) {
            return EmptyEnumeration.EMPTY;
        }

        public void renameAttributes(String string, String string2) {
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
        }

        public Object readAttribute(String string, String string2) {
            return null;
        }
    }
}

