/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleManager;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public final class ModuleBean
implements Runnable,
PropertyChangeListener {
    private static final ErrorManager err = TopManager.getDefault().getErrorManager().getInstance("org.netbeans.core.ui.ModuleBean");
    private final Module module;
    private String codeName;
    private String codeNameBase;
    private String specVers;
    private String implVers;
    private File jar;
    private boolean enabled;
    private boolean reloadable;
    private boolean autoscan;
    private boolean autoload;
    private boolean problematic;
    private String displayName;
    private String shortDescription;
    private String longDescription;
    private String category;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    private ModuleBean(Module module) {
        this.module = module;
        this.loadProps();
        this.module.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)((Object)this.module)));
    }

    public Module getModule() {
        return this.module;
    }

    private void loadProps() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("loadProps: module=" + (Object)((Object)this.module));
        if (!this.module.isValid()) {
            err.log("invalid, forget it...");
            return;
        }
        this.codeName = this.module.getCodeName();
        this.codeNameBase = this.module.getCodeNameBase();
        SpecificationVersion specificationVersion = this.module.getSpecificationVersion();
        this.specVers = specificationVersion == null ? null : specificationVersion.toString();
        this.implVers = (String)this.module.getAttribute("OpenIDE-Module-Implementation-Version");
        this.jar = this.module.getJarFile();
        this.enabled = this.module.isEnabled();
        this.reloadable = this.module.isReloadable();
        this.autoload = this.module.isAutoload();
        Object object = this.module.getHistory();
        this.autoscan = object instanceof ModuleHistory ? ((ModuleHistory)object).isAutoscan() : false;
        this.problematic = !this.module.getProblems().isEmpty();
        this.displayName = this.module.getDisplayName();
        this.shortDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Short-Description");
        this.longDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Long-Description");
        this.category = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getSpecificationVersion() {
        return this.specVers;
    }

    public String getImplementationVersion() {
        return this.implVers;
    }

    public File getJar() {
        return this.jar;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (this.jar == null || this.autoload || this.problematic) {
            throw new IllegalStateException();
        }
        err.log("setEnabled: module=" + (Object)((Object)this.module) + " enabled=" + bl);
        this.enabled = bl;
        this.supp.firePropertyChange("enabled", null, null);
        Update update = new Update(bl ? "enable" : "disable", (Object)this.module);
        AllModulesBean.getDefault().update(update);
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        if (this.reloadable == bl) {
            return;
        }
        err.log("setReloadable: module=" + (Object)((Object)this.module) + " reloadable=" + bl);
        this.reloadable = bl;
        this.supp.firePropertyChange("reloadable", null, null);
        Update update = new Update(bl ? "makeReloadable" : "makeUnreloadable", (Object)this.module);
        AllModulesBean.getDefault().update(update);
    }

    public void delete() {
        if (this.jar == null || this.autoscan) {
            throw new IllegalStateException();
        }
        err.log("delete: module=" + (Object)((Object)this.module));
        Update update = new Update("delete", (Object)this.module);
        AllModulesBean.getDefault().update(update);
    }

    public boolean isAutoscan() {
        return this.autoscan;
    }

    public boolean isProblematic() {
        return this.problematic;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getCategory() {
        return this.category;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("got changes: module=" + (Object)((Object)this.module) + " evt=" + propertyChangeEvent);
        if (propertyChangeEvent != null && "classLoader".equals(propertyChangeEvent.getPropertyName())) {
            err.log("ignoring PROP_CLASS_LOADER");
            return;
        }
        this.loadProps();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("firing changes: module=" + (Object)((Object)this.module));
        this.supp.firePropertyChange(null, null, null);
    }

    private static final class Update {
        public final String command;
        public final Object arg;

        public Update(String string, Object object) {
            this.command = string;
            this.arg = object;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Update)) {
                return false;
            }
            Update update = (Update)object;
            return this.command.equals(update.command) && this.arg.equals(update.arg);
        }

        public int hashCode() {
            return this.command.hashCode() ^ this.arg.hashCode();
        }

        public String toString() {
            return "Update[" + this.command + "," + this.arg + "]";
        }
    }

    public static final class AllModulesBean
    implements Runnable,
    PropertyChangeListener {
        private static AllModulesBean deflt = null;
        private final ModuleManager mgr = NbTopManager.get().getModuleSystem().getManager();
        private final Events ev = NbTopManager.get().getModuleSystem().getEvents();
        private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
        private ModuleBean[] modules = null;
        private final List updates = new LinkedList();
        private boolean paused = false;
        private Runnable updater = new Updater();
        static /* synthetic */ Class class$org$netbeans$core$ui$ModuleBean;

        public static synchronized AllModulesBean getDefault() {
            if (deflt == null) {
                deflt = new AllModulesBean();
            }
            return deflt;
        }

        private AllModulesBean() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }

        public synchronized ModuleBean[] getModules() {
            err.log("getModules: modules count=" + (this.modules == null ? "null" : String.valueOf(this.modules.length)));
            if (this.modules == null) {
                RequestProcessor.postRequest((Runnable)new Reader());
                this.modules = new ModuleBean[0];
                return this.modules;
            }
            return this.modules;
        }

        public void create(File file, boolean bl) {
            err.log("create: jar=" + file);
            Update update = new Update(bl ? "createReloadable" : "create", file);
            this.update(update);
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("in event thread, will fire changes");
            this.supp.firePropertyChange(null, null, null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("got changes: evt=" + propertyChangeEvent);
            if ("modules".equals(propertyChangeEvent.getPropertyName())) {
                Object object;
                HashMap<Module, ModuleBean> hashMap = new HashMap<Module, ModuleBean>(this.modules.length * 4 / 3 + 1);
                int n = 0;
                while (n < this.modules.length) {
                    hashMap.put(this.modules[n].getModule(), this.modules[n]);
                    ++n;
                }
                Set set = this.mgr.getModules();
                ModuleBean[] moduleBeanArray = new ModuleBean[set.size()];
                Iterator iterator = set.iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    object = (Module)((Object)iterator.next());
                    ModuleBean moduleBean = (ModuleBean)hashMap.get(object);
                    if (moduleBean == null) {
                        moduleBean = new ModuleBean((Module)((Object)object));
                    }
                    moduleBeanArray[n2++] = moduleBean;
                }
                object = this;
                synchronized (object) {
                    this.modules = moduleBeanArray;
                }
                SwingUtilities.invokeLater(this);
            }
        }

        public void pause() {
            err.log("pause");
            this.paused = true;
        }

        public void resume() {
            err.log("resume");
            this.paused = false;
            RequestProcessor.postRequest((Runnable)this.updater);
        }

        public void cancel() {
            err.log("cancel");
            List list = this.updates;
            synchronized (list) {
                this.updates.clear();
            }
            this.paused = false;
            this.supp.firePropertyChange("pending", null, null);
        }

        public boolean isPending() {
            List list = this.updates;
            synchronized (list) {
                boolean bl = !this.updates.isEmpty();
                return bl;
            }
        }

        void update(Update update) {
            List list = this.updates;
            synchronized (list) {
                boolean bl = this.updates.isEmpty();
                this.updates.add(update);
                err.log("pending updates: " + this.updates);
                if (bl) {
                    RequestProcessor.postRequest((Runnable)this.updater);
                }
            }
            this.supp.firePropertyChange("pending", null, null);
        }

        private void doDelete(Set set) {
            if (set.isEmpty()) {
                return;
            }
            err.log("doDelete: " + set);
            this.doDisable(set);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)((Object)iterator.next());
                if (module.isFixed()) continue;
                this.mgr.delete(module);
            }
        }

        private void doDisable(Set set) {
            Object object;
            Object object2;
            if (set.isEmpty()) {
                return;
            }
            err.log("doDisable: " + set);
            HashSet hashSet = new HashSet(set);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object2 = (Module)((Object)iterator.next());
                if (object2.isEnabled() && !object2.isAutoload() && !object2.isFixed()) continue;
                iterator.remove();
            }
            object2 = this.mgr.simulateDisable(hashSet);
            iterator = object2.iterator();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            while (iterator.hasNext()) {
                object = (Module)((Object)iterator.next());
                if (object.isAutoload() || hashSet.contains(object)) continue;
                hashSet2.add(object);
            }
            if (!hashSet2.isEmpty()) {
                ModuleBean[] moduleBeanArray;
                object = new StringBuffer(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"MB_MSG_in_order_to_disable"));
                ((StringBuffer)object).append('\n');
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    moduleBeanArray = (ModuleBean[])iterator.next();
                    ((StringBuffer)object).append(moduleBeanArray.getDisplayName());
                    ((StringBuffer)object).append('\n');
                }
                ((StringBuffer)object).append(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"MB_MSG_must_also_disable"));
                iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    moduleBeanArray = (Module)((Object)iterator.next());
                    ((StringBuffer)object).append('\n');
                    ((StringBuffer)object).append(moduleBeanArray.getDisplayName());
                }
                if (TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)((StringBuffer)object).toString(), NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"MB_TITLE_disabling"), 2)) != NotifyDescriptor.OK_OPTION) {
                    moduleBeanArray = this.modules;
                    if (moduleBeanArray != null) {
                        int n = 0;
                        while (n < moduleBeanArray.length) {
                            if (hashSet.contains((Object)moduleBeanArray[n].module)) {
                                moduleBeanArray[n].propertyChange(null);
                            }
                            ++n;
                        }
                    }
                    return;
                }
                hashSet.addAll(hashSet2);
            }
            this.mgr.disable(hashSet);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private void doEnable(Set var1_1) {
            block21: {
                block22: {
                    if (var1_1.isEmpty()) {
                        return;
                    }
                    ModuleBean.access$000().log("doEnable: " + var1_1);
                    var2_2 = new HashSet<E>(var1_1);
                    var3_3 = var2_2.iterator();
                    while (var3_3.hasNext()) {
                        var4_4 /* !! */  = (Module)var3_3.next();
                        if (!var4_4 /* !! */ .isEnabled() && !var4_4 /* !! */ .isAutoload() && !var4_4 /* !! */ .isFixed() && var4_4 /* !! */ .getProblems().isEmpty()) continue;
                        var3_3.remove();
                    }
                    var4_4 /* !! */  = this.mgr.simulateEnable(var2_2);
                    var3_3 = var4_4 /* !! */ .iterator();
                    var5_5 = new HashSet<Object>();
                    while (var3_3.hasNext()) {
                        var6_6 /* !! */  = (Module)var3_3.next();
                        if (var6_6 /* !! */ .isAutoload() || var2_2.contains((Object)var6_6 /* !! */ )) continue;
                        var5_5.add((Object)var6_6 /* !! */ );
                    }
                    if (!var5_5.isEmpty()) {
                        var6_6 /* !! */  = new StringBuffer(NbBundle.getMessage((Class)(AllModulesBean.class$org$netbeans$core$ui$ModuleBean == null ? (AllModulesBean.class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : AllModulesBean.class$org$netbeans$core$ui$ModuleBean), (String)"MB_MSG_in_order_to_enable"));
                        var6_6 /* !! */ .append('\n');
                        var3_3 = var2_2.iterator();
                        while (var3_3.hasNext()) {
                            var7_8 = (Module)var3_3.next();
                            var6_6 /* !! */ .append(var7_8.getDisplayName());
                            var6_6 /* !! */ .append('\n');
                        }
                        var6_6 /* !! */ .append(NbBundle.getMessage((Class)(AllModulesBean.class$org$netbeans$core$ui$ModuleBean == null ? (AllModulesBean.class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : AllModulesBean.class$org$netbeans$core$ui$ModuleBean), (String)"MB_MSG_must_also_enable"));
                        var3_3 = var5_5.iterator();
                        while (var3_3.hasNext()) {
                            var7_8 = (Module)var3_3.next();
                            var6_6 /* !! */ .append('\n');
                            var6_6 /* !! */ .append(var7_8.getDisplayName());
                        }
                        if (TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)var6_6 /* !! */ .toString(), NbBundle.getMessage((Class)(AllModulesBean.class$org$netbeans$core$ui$ModuleBean == null ? (AllModulesBean.class$org$netbeans$core$ui$ModuleBean = AllModulesBean.class$("org.netbeans.core.ui.ModuleBean")) : AllModulesBean.class$org$netbeans$core$ui$ModuleBean), (String)"MB_TITLE_enabling"), 2)) != NotifyDescriptor.OK_OPTION) {
                            var7_8 = this.modules;
                            if (var7_8 != null) {
                                var8_10 = 0;
                                while (var8_10 < var7_8.length) {
                                    if (var2_2.contains((Object)ModuleBean.access$1200(var7_8[var8_10]))) {
                                        var7_8[var8_10].propertyChange(null);
                                    }
                                    ++var8_10;
                                }
                            }
                            return;
                        }
                        var2_2.addAll(var5_5);
                    }
                    var3_3 = var4_4 /* !! */ .iterator();
                    while (var3_3.hasNext()) {
                        block20: {
                            var6_6 /* !! */  = (Module)var3_3.next();
                            if (!var6_6 /* !! */ .isReloadable()) continue;
                            try {
                                this.mgr.reload(var6_6 /* !! */ );
                                continue;
                            }
                            catch (IOException var7_9) {
                                TopManager.getDefault().notifyException((Throwable)var7_9);
                                var8_11 = this.modules;
                                if (var8_11 == null) break block20;
                                var9_13 = 0;
                                ** while (var9_13 < var8_11.length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (var2_2.contains((Object)ModuleBean.access$1200(var8_11[var9_13]))) {
                                    var8_11[var9_13].propertyChange(null);
                                }
                                ++var9_13;
                                continue;
                            }
                        }
                        return;
                    }
                    try {
                        this.mgr.enable(var2_2);
                        break block21;
                    }
                    catch (InvalidException var6_7) {
                        ModuleBean.access$000().notify(1, (Throwable)var6_7);
                        var7_8 = var6_7.getModule();
                        if (var7_8 == null) {
                            throw new IllegalStateException();
                        }
                        this.ev.log("failedInstallNewUnexpected", var7_8, var6_7);
                        var8_12 = this.modules;
                        if (var8_12 == null) break block22;
                        var9_14 = 0;
                        ** while (var9_14 < var8_12.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (ModuleBean.access$1200(var8_12[var9_14]) == var7_8) {
                            var8_12[var9_14].propertyChange(null);
                        }
                        ++var9_14;
                        continue;
                    }
                }
                var2_2.remove((Object)var6_7.getModule());
                this.doEnable(var2_2);
            }
        }

        private void doCreate(Set set, boolean bl) {
            if (set.isEmpty()) {
                return;
            }
            err.log("doCreate: " + set + " reloadable=" + bl);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Module module;
                File file = (File)iterator.next();
                try {
                    module = this.mgr.create(file, new ModuleHistory(), bl, false);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                    continue;
                }
                catch (DuplicateException duplicateException) {
                    Module module2 = duplicateException.getOldModule();
                    if (module2.isFixed()) continue;
                    if (module2.isEnabled()) {
                        if (module2.isAutoload()) continue;
                        this.doDisable(Collections.singleton(module2));
                        if (module2.isEnabled()) continue;
                    }
                    this.mgr.delete(module2);
                    try {
                        module = this.mgr.create(file, new ModuleHistory(), bl, false);
                    }
                    catch (IOException iOException) {
                        TopManager.getDefault().notifyException((Throwable)iOException);
                        continue;
                    }
                    catch (DuplicateException duplicateException2) {
                        TopManager.getDefault().notifyException((Throwable)duplicateException2);
                        continue;
                    }
                }
                if (module.getProblems().isEmpty()) {
                    this.doEnable(Collections.singleton(module));
                    continue;
                }
                this.ev.log("failedInstallNew", Collections.singleton(module));
            }
        }

        static /* synthetic */ ModuleBean[] access$402(AllModulesBean allModulesBean, ModuleBean[] moduleBeanArray) {
            allModulesBean.modules = moduleBeanArray;
            return moduleBeanArray;
        }

        static /* synthetic */ boolean access$600(AllModulesBean allModulesBean) {
            return allModulesBean.paused;
        }

        static /* synthetic */ List access$700(AllModulesBean allModulesBean) {
            return allModulesBean.updates;
        }

        static /* synthetic */ void access$800(AllModulesBean allModulesBean, Set set) {
            allModulesBean.doDelete(set);
        }

        static /* synthetic */ void access$900(AllModulesBean allModulesBean, Set set) {
            allModulesBean.doDisable(set);
        }

        static /* synthetic */ void access$1000(AllModulesBean allModulesBean, Set set) {
            allModulesBean.doEnable(set);
        }

        static /* synthetic */ void access$1100(AllModulesBean allModulesBean, Set set, boolean bl) {
            allModulesBean.doCreate(set, bl);
        }

        static /* synthetic */ ModuleBean[] access$400(AllModulesBean allModulesBean) {
            return allModulesBean.modules;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private class Updater
        implements Runnable {
            private boolean theother = false;

            private Updater() {
            }

            /*
             * Unable to fully structure code
             */
            public void run() {
                block24: {
                    if (SwingUtilities.isEventDispatchThread()) {
                        throw new IllegalStateException();
                    }
                    if (!this.theother) {
                        ModuleBean.access$000().log("will run updates in write mutex...");
                        var1_1 = new Updater();
                        var1_1.theother = true;
                        AllModulesBean.access$200(AllModulesBean.this).mutex().writeAccess((Runnable)var1_1);
                        return;
                    }
                    try {
                        if (AllModulesBean.access$600(AllModulesBean.this)) {
                            ModuleBean.access$000().log("run updates, but paused");
                            return;
                        }
                        var1_2 = new HashSet<Object>();
                        var2_4 = new HashSet<Object>();
                        var3_6 = new HashSet<Object>();
                        var4_8 = new HashSet<Object>();
                        var5_9 = new HashSet<Object>();
                        var6_10 = new HashSet<Object>();
                        var7_11 = new HashSet<Object>();
                        var9_12 = AllModulesBean.access$700(AllModulesBean.this);
                        synchronized (var9_12) {
                            if (AllModulesBean.access$700(AllModulesBean.this).isEmpty()) {
                                ModuleBean.access$000().log("run updates, but empty");
                                return;
                            }
                            ModuleBean.access$000().log("run updates: " + AllModulesBean.access$700(AllModulesBean.this));
                            var8_13 = new LinkedList<E>(AllModulesBean.access$700(AllModulesBean.this)).iterator();
                            AllModulesBean.access$700(AllModulesBean.this).clear();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl30 : MonitorExitStatement: MONITOREXIT : var9_12
                            if (true) ** GOTO lbl92
                        }
                        do {
                            var10_15 = (Update)var8_13.next();
                            if (var10_15.command.equals("enable")) {
                                if (var5_9.contains(var10_15.arg)) {
                                    throw new IllegalStateException();
                                }
                                var2_4.remove(var10_15.arg);
                                var1_2.add(var10_15.arg);
                                continue;
                            }
                            if (var10_15.command.equals("disable")) {
                                if (var5_9.contains(var10_15.arg)) {
                                    throw new IllegalStateException();
                                }
                                var1_2.remove(var10_15.arg);
                                var2_4.add(var10_15.arg);
                                continue;
                            }
                            if (var10_15.command.equals("makeReloadable")) {
                                if (var5_9.contains(var10_15.arg)) {
                                    throw new IllegalStateException();
                                }
                                var4_8.remove(var10_15.arg);
                                var3_6.add(var10_15.arg);
                                continue;
                            }
                            if (var10_15.command.equals("makeUnreloadable")) {
                                if (var5_9.contains(var10_15.arg)) {
                                    throw new IllegalStateException();
                                }
                                var3_6.remove(var10_15.arg);
                                var4_8.add(var10_15.arg);
                                continue;
                            }
                            if (var10_15.command.equals("delete")) {
                                var1_2.remove(var10_15.arg);
                                var2_4.remove(var10_15.arg);
                                var3_6.remove(var10_15.arg);
                                var4_8.remove(var10_15.arg);
                                var5_9.add(var10_15.arg);
                                continue;
                            }
                            if (var10_15.command.equals("create")) {
                                var7_11.remove(var10_15.arg);
                                var6_10.add(var10_15.arg);
                                continue;
                            }
                            if (var10_15.command.equals("createReloadable")) {
                                var6_10.remove(var10_15.arg);
                                var7_11.add(var10_15.arg);
                                continue;
                            }
                            throw new IllegalStateException();
lbl92:
                            // 8 sources

                        } while (var8_13.hasNext());
                        AllModulesBean.access$800(AllModulesBean.this, var5_9);
                        AllModulesBean.access$900(AllModulesBean.this, var2_4);
                        var8_13 = var3_6.iterator();
                        while (var8_13.hasNext()) {
                            var10_15 = (Module)var8_13.next();
                            var10_15.setReloadable(true);
                        }
                        var8_13 = var4_8.iterator();
                        while (var8_13.hasNext()) {
                            var10_15 = (Module)var8_13.next();
                            var10_15.setReloadable(false);
                        }
                        AllModulesBean.access$1000(AllModulesBean.this, var1_2);
                        AllModulesBean.access$1100(AllModulesBean.this, var6_10, false);
                        AllModulesBean.access$1100(AllModulesBean.this, var7_11, true);
                        break block24;
                    }
                    catch (RuntimeException var1_3) {
                        ModuleBean.access$000().notify((Throwable)var1_3);
                        var2_5 = AllModulesBean.access$400(AllModulesBean.this);
                        if (var2_5 == null) break block24;
                        var3_7 = 0;
                        ** while (var3_7 < var2_5.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var2_5[var3_7].propertyChange(null);
                        ++var3_7;
                        continue;
                    }
                }
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }

        private class Reader
        implements Runnable {
            private boolean theother = false;

            private Reader() {
            }

            public void run() {
                Object object;
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new IllegalStateException();
                }
                if (!this.theother) {
                    err.log("will load modules in read mutex...");
                    Reader reader = new Reader();
                    reader.theother = true;
                    AllModulesBean.this.mgr.mutex().readAccess((Runnable)reader);
                    return;
                }
                err.log("first time, finding module list");
                Set set = AllModulesBean.this.mgr.getModules();
                ModuleBean[] moduleBeanArray = new ModuleBean[set.size()];
                Iterator iterator = set.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    object = (Module)((Object)iterator.next());
                    moduleBeanArray[n++] = new ModuleBean((Module)((Object)object));
                }
                object = AllModulesBean.this;
                synchronized (object) {
                    AllModulesBean.access$402(AllModulesBean.this, moduleBeanArray);
                }
                AllModulesBean.this.mgr.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)AllModulesBean.this, (Object)AllModulesBean.this.mgr));
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }
    }
}

