/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.core.AutomountSupport;
import org.netbeans.core.projects.FilterFileSystem;
import org.netbeans.core.projects.LocalFileSystemEx;
import org.netbeans.core.projects.SystemFileSystem;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class SessionManager {
    public static final String PROP_OPEN = "session_open";
    public static final String PROP_CLOSE = "session_close";
    public static final String LAYER_SESSION = "session";
    public static final String LAYER_INSTALL = "install";
    public static final String LAYER_PROJECT = "project";
    private static SessionManager sm = null;
    private SystemFileSystem systemFS;
    private HashMap layers = new HashMap();
    private boolean isOpen = false;
    private transient ArrayList propertyChangeListeners;

    private SessionManager() {
    }

    public static SessionManager getDefault() {
        if (sm == null) {
            sm = new SessionManager();
        }
        return sm;
    }

    public FileSystem create(File file, File file2) throws PropertyVetoException, IOException {
        this.systemFS = SystemFileSystem.create(file, file2);
        this.layers.put(LAYER_INSTALL, this.systemFS.getInstallationLayer());
        this.layers.put(LAYER_SESSION, this.systemFS.getUserLayer());
        return this.systemFS;
    }

    public void setProjectLayer(FileObject fileObject) throws IOException {
        int n;
        FileSystem[] fileSystemArray;
        FileObject fileObject2;
        FilterFileSystem filterFileSystem = (FilterFileSystem)((Object)this.layers.get(LAYER_PROJECT));
        FileSystem fileSystem = null;
        FileObject fileObject3 = fileObject2 = filterFileSystem == null ? null : filterFileSystem.getRootFileObject();
        if (fileObject == null && fileObject2 == null) {
            return;
        }
        if (fileObject != null) {
            fileSystem = this.createProjectLayer(fileObject);
        }
        if (this.isOpen) {
            this.firePropertyChange(PROP_CLOSE);
        }
        this.waitForLocks();
        FileSystem[] fileSystemArray2 = this.systemFS.getLayers();
        if (this.layers.get(LAYER_PROJECT) == null) {
            fileSystemArray = new FileSystem[fileSystemArray2.length + 1];
            n = 0;
            while (n < fileSystemArray2.length) {
                fileSystemArray[n + 1] = fileSystemArray2[n];
                ++n;
            }
            fileSystemArray2 = fileSystemArray;
        }
        if (fileObject == null) {
            fileSystemArray = new FileSystem[fileSystemArray2.length - 1];
            n = 0;
            while (n < fileSystemArray.length) {
                fileSystemArray[n] = fileSystemArray2[n + 1];
                ++n;
            }
            fileSystemArray2 = fileSystemArray;
        } else {
            fileSystemArray2[0] = fileSystem;
        }
        fileSystemArray = fileSystemArray2;
        final FileSystem fileSystem2 = fileSystem;
        try {
            this.systemFS.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    SessionManager.this.systemFS.setLayers(fileSystemArray);
                    SessionManager.this.layers.put(SessionManager.LAYER_PROJECT, fileSystem2);
                }
            });
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            TopManager.getDefault().notifyException(throwable);
        }
        AutomountSupport.initialize().waitFinished();
        this.isOpen = true;
        this.firePropertyChange(PROP_OPEN);
    }

    private FileSystem createProjectLayer(FileObject fileObject) throws IOException {
        FileObject fileObject2 = null;
        if (fileObject.getFileSystem() != this.systemFS) {
            fileObject2 = fileObject;
        } else {
            String string = fileObject.getPackageNameExt('/', '.');
            fileObject2 = FileUtil.createFolder((FileObject)this.systemFS.getUserLayer().getLayers()[0].getRoot(), (String)string);
        }
        if (fileObject2 == null) {
            throw new IOException("FileObject " + fileObject + " can't be used as a root of project layer.");
        }
        return new FilterFileSystem(fileObject2);
    }

    public void close() {
        this.firePropertyChange(PROP_CLOSE);
        this.waitForLocks();
    }

    public FileSystem getLayer(String string) {
        return (FileSystem)this.layers.get(string);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList();
        }
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners != null) {
            ((AbstractCollection)this.propertyChangeListeners).remove(propertyChangeListener);
        }
    }

    private void firePropertyChange(String string) {
        ArrayList arrayList;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this.propertyChangeListeners == null || this.propertyChangeListeners.size() == 0) {
                return;
            }
            arrayList = (ArrayList)this.propertyChangeListeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, null, null);
        int n = 0;
        while (n < arrayList.size()) {
            try {
                ((PropertyChangeListener)arrayList.get(n)).propertyChange(propertyChangeEvent);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                TopManager.getDefault().notifyException(throwable);
            }
            ++n;
        }
    }

    private void waitForLocks() {
        int n = 50;
        try {
            while (LocalFileSystemEx.hasLocks() && 0 < n) {
                Thread.currentThread();
                Thread.sleep(100L);
                --n;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LocalFileSystemEx.hasLocks()) {
            String[] stringArray = LocalFileSystemEx.getLocks();
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("Settings saving ");
            stringBuffer.append(n == 0 ? "timeout!" : "interrupted!");
            stringBuffer.append("\nList of pending locks:\n");
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2]);
                stringBuffer.append("\n");
                ++n2;
            }
            System.err.println(stringBuffer.toString());
        }
    }
}

