/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.core.projects.SystemFileSystem;
import org.openide.TopManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;

public class ModuleLayeredFileSystem
extends MultiFileSystem {
    private static final long serialVersionUID = 782910986724201983L;

    ModuleLayeredFileSystem(FileSystem fileSystem) {
        super(new FileSystem[]{fileSystem, new XMLFileSystem()});
        this.setPropagateMasks(true);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.getDelegates()[0];
    }

    final XMLFileSystem getXMLLayer() {
        return (XMLFileSystem)this.getDelegates()[1];
    }

    public static FileSystem create(File file, File file2) throws PropertyVetoException, IOException {
        return SystemFileSystem.create(file, file2);
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem systemFileSystem = (SystemFileSystem)TopManager.getDefault().getRepository().getDefaultFileSystem();
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem = (SystemFileSystem)TopManager.getDefault().getRepository().getDefaultFileSystem();
        return systemFileSystem.getUserLayer();
    }

    public void setURLs(final List list) throws Exception {
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        this.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                ModuleLayeredFileSystem moduleLayeredFileSystem = ModuleLayeredFileSystem.this;
                synchronized (moduleLayeredFileSystem) {
                    try {
                        ModuleLayeredFileSystem.this.getXMLLayer().setXmlUrls(list.toArray(new URL[list.size()]));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        IOException iOException = new IOException(propertyVetoException.toString());
                        TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, (Throwable)propertyVetoException);
                        throw iOException;
                    }
                }
            }
        });
        this.firePropertyChange("layers", null, null);
    }

    public void addURLs(Collection collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        FileSystem[] fileSystemArray = this.getDelegates();
        XMLFileSystem xMLFileSystem = fileSystemArray.length < 2 ? null : (XMLFileSystem)fileSystemArray[1];
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (xMLFileSystem != null) {
            arrayList.addAll(Arrays.asList(xMLFileSystem.getXmlUrls()));
        }
        arrayList.addAll(collection);
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection collection) throws Exception {
        XMLFileSystem xMLFileSystem;
        FileSystem[] fileSystemArray = this.getDelegates();
        XMLFileSystem xMLFileSystem2 = xMLFileSystem = fileSystemArray.length < 2 ? null : (XMLFileSystem)fileSystemArray[1];
        if (xMLFileSystem == null) {
            return;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(Arrays.asList(xMLFileSystem.getXmlUrls()));
        ((AbstractCollection)arrayList).removeAll(collection);
        this.setURLs(arrayList);
    }
}

