/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.netbeans.core.projects.SessionManager;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListener;

final class FileStateManager {
    public static final int LAYER_PROJECT = 0;
    public static final int LAYER_SESSION = 1;
    public static final int LAYER_MODULES = 2;
    public static final int FSTATE_DEFINED = 0;
    public static final int FSTATE_IGNORED = 1;
    public static final int FSTATE_INHERITED = 2;
    public static final int FSTATE_UNDEFINED = 3;
    private static FileStateManager manager = null;
    private WeakHashMap info = new WeakHashMap();
    private static final int LAYERS_COUNT = 3;
    private FileSystem[] layers = new FileSystem[3];
    private HashMap listeners = new HashMap(10);
    private PropertyChangeListener propL = null;

    public static synchronized FileStateManager getDefault() {
        if (manager == null) {
            manager = new FileStateManager();
        }
        return manager;
    }

    private FileStateManager() {
        this.getLayers();
        this.propL = new PropL();
        SessionManager.getDefault().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propL, (Object)SessionManager.getDefault()));
    }

    public void define(final FileObject fileObject, int n, boolean bl) throws IOException {
        FileSystem fileSystem;
        if (0 == this.getFileState(fileObject, n)) {
            return;
        }
        FileSystem fileSystem2 = this.getLayer(n);
        if (fileSystem2 == null) {
            throw new IllegalArgumentException("Invalid layer " + n);
        }
        FileObject fileObject2 = fileSystem2.findResource(fileObject.getPackageNameExt('/', '.'));
        if (fileObject2 != null && !bl) {
            this.deleteImpl(fileObject, fileSystem2);
            fileObject2 = null;
        }
        if (fileObject2 == null) {
            String string = fileObject.getParent().getPackageNameExt('/', '.');
            fileSystem = FileUtil.createFolder((FileObject)fileSystem2.getRoot(), (String)string);
            fileSystem.getFileSystem().runAtomicAction(new FileSystem.AtomicAction((FileObject)fileSystem){
                private final /* synthetic */ FileObject val$fparent;
                {
                    this.val$fparent = fileObject2;
                }

                public void run() throws IOException {
                    fileObject.copy(this.val$fparent, fileObject.getName(), fileObject.getExt());
                }
            });
        }
        int n2 = 0;
        while (n2 < n) {
            fileSystem = this.getLayer(n2);
            if (fileSystem != null) {
                this.deleteImpl(fileObject, fileSystem);
            }
            ++n2;
        }
    }

    public void delete(FileObject fileObject, int n) throws IOException {
        FileSystem fileSystem = this.getLayer(n);
        if (fileSystem == null) {
            throw new IllegalArgumentException("Invalid layer " + n);
        }
        this.deleteImpl(fileObject, fileSystem);
    }

    public int getFileState(FileObject fileObject, int n) {
        FileSystem fileSystem = null;
        FileInfo fileInfo = null;
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (fileSystem == null || !TopManager.getDefault().getRepository().getDefaultFileSystem().equals(fileSystem)) {
            throw new IllegalArgumentException("FileObject has to be from DefaultFileSystem - " + fileObject);
        }
        WeakHashMap weakHashMap = this.info;
        synchronized (weakHashMap) {
            fileInfo = (FileInfo)((Object)this.info.get(fileObject));
            if (null == fileInfo) {
                fileInfo = new FileInfo(fileObject);
                this.info.put(fileObject, fileInfo);
            }
        }
        return fileInfo.getState(n);
    }

    public final void addFileStatusListener(FileStatusListener fileStatusListener, FileObject fileObject) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            LinkedList linkedList = null;
            if (!this.listeners.containsKey(fileStatusListener)) {
                linkedList = new LinkedList();
                this.listeners.put(fileStatusListener, linkedList);
            } else {
                linkedList = (LinkedList)this.listeners.get(fileStatusListener);
            }
            if (!linkedList.contains(fileObject)) {
                linkedList.add(fileObject);
            }
        }
    }

    public final void removeFileStatusListener(FileStatusListener fileStatusListener, FileObject fileObject) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            if (fileObject == null) {
                this.listeners.remove(fileStatusListener);
            } else {
                LinkedList linkedList = (LinkedList)this.listeners.get(fileStatusListener);
                if (linkedList != null) {
                    linkedList.remove(fileObject);
                    if (linkedList.isEmpty()) {
                        this.listeners.remove(fileStatusListener);
                    }
                }
            }
        }
    }

    private void fireFileStatusChanged(FileObject fileObject) {
        HashMap hashMap = null;
        HashMap hashMap2 = this.listeners;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.listeners.clone();
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            FileStatusListener fileStatusListener = (FileStatusListener)iterator.next();
            LinkedList linkedList = (LinkedList)hashMap.get(fileStatusListener);
            if (!linkedList.contains(fileObject)) continue;
            fileStatusListener.fileStatusChanged(fileObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteImpl(FileObject fileObject, FileSystem fileSystem) throws IOException {
        FileObject fileObject2 = fileSystem.findResource(fileObject.getPackageNameExt('/', '.'));
        if (fileObject2 == null) return;
        FileLock fileLock = null;
        try {
            fileLock = fileObject2.lock();
            fileObject2.delete(fileLock);
            Object var6_5 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    private void discard(FileObject fileObject) {
        WeakHashMap weakHashMap = this.info;
        synchronized (weakHashMap) {
            this.info.remove(fileObject);
        }
    }

    private void getLayers() {
        this.layers[0] = SessionManager.getDefault().getLayer("project");
        this.layers[1] = SessionManager.getDefault().getLayer("session");
        this.layers[2] = SessionManager.getDefault().getLayer("install");
    }

    private FileSystem getLayer(int n) {
        return this.layers[n];
    }

    private class FileInfo
    extends FileChangeAdapter {
        private WeakReference file = null;
        private int[] state = new int[3];
        private final Object LOCK = new Object();
        private FileObject[] notifiers = new FileObject[3];
        private FileChangeListener[] weakL = new FileChangeListener[3];

        public FileInfo(FileObject fileObject) {
            this.file = new WeakReference<FileObject>(fileObject);
            int n = 0;
            while (n < 3) {
                this.state[n] = this.getStateImpl(fileObject, n);
                ++n;
            }
            int n2 = 0;
            while (n2 < 3) {
                this.attachNotifier(fileObject, n2);
                ++n2;
            }
        }

        public void invalidate() {
            this.detachAllNotifiers();
            Object object = this.LOCK;
            synchronized (object) {
                int n = 0;
                while (n < 3) {
                    this.state[n] = 3;
                    ++n;
                }
            }
        }

        public int getState(int n) {
            Object object = this.LOCK;
            synchronized (object) {
                int n2 = this.state[n];
                return n2;
            }
        }

        private void rescan(FileObject fileObject) {
            boolean bl = false;
            Object object = this.LOCK;
            synchronized (object) {
                int n = 0;
                while (n < 3) {
                    int n2 = this.getStateImpl(fileObject, n);
                    if (this.state[n] != n2) {
                        this.state[n] = n2;
                        bl = true;
                    }
                    ++n;
                }
            }
            if (bl) {
                FileStateManager.this.fireFileStatusChanged(fileObject);
            }
        }

        private int getStateImpl(FileObject fileObject, int n) {
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < n) {
                if (this.isOnLayer(fileObject, n2)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            int n3 = n + 1;
            while (n3 < 3) {
                if (this.isOnLayer(fileObject, n3)) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (this.isOnLayer(fileObject, n)) {
                return bl ? 1 : 0;
            }
            return bl2 && !bl ? 2 : 3;
        }

        private boolean isOnLayer(FileObject fileObject, int n) {
            FileSystem fileSystem = FileStateManager.this.getLayer(n);
            return fileSystem == null ? false : null != fileSystem.findResource(fileObject.getPackageNameExt('/', '.'));
        }

        /*
         * Unable to fully structure code
         */
        private synchronized boolean attachNotifier(FileObject var1_1, int var2_2) {
            var3_3 = FileStateManager.access$400(FileStateManager.this, var2_2);
            var4_4 = var1_1.getPackageNameExt('/', '.');
            var5_5 = null;
            var6_6 = true;
            if (var3_3 != null) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                var7_7 = var4_4.lastIndexOf(47);
                var6_6 = false;
                if (-1 == var7_7) break;
                var4_4 = var4_4.substring(0, var7_7);
lbl11:
                // 2 sources

                ** while (var4_4.length() > 0 && null == (var5_5 = var3_3.findResource((String)var4_4)))
            }
lbl12:
            // 2 sources

            if (var5_5 == null) {
                var5_5 = var3_3.getRoot();
            }
            if (var5_5 != this.notifiers[var2_2]) {
                if (this.notifiers[var2_2] != null) {
                    this.notifiers[var2_2].removeFileChangeListener(this.weakL[var2_2]);
                }
                this.weakL[var2_2] = WeakListener.fileChange((FileChangeListener)this, (Object)var5_5);
                var5_5.addFileChangeListener(this.weakL[var2_2]);
                this.notifiers[var2_2] = var5_5;
            }
            return var6_6;
        }

        private synchronized void detachAllNotifiers() {
            int n = 0;
            while (n < 3) {
                if (this.notifiers[n] != null) {
                    this.notifiers[n].removeFileChangeListener(this.weakL[n]);
                    this.notifiers[n] = null;
                    this.weakL[n] = null;
                }
                ++n;
            }
        }

        private int layerOfFile(FileObject fileObject) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                int n = 0;
                while (n < 3) {
                    if (fileSystem.equals(FileStateManager.this.getLayer(n))) {
                        return n;
                    }
                    ++n;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                IllegalStateException illegalStateException = new IllegalStateException("Invalid file - " + fileObject);
                TopManager.getDefault().getErrorManager().annotate((Throwable)illegalStateException, (Throwable)fileStateInvalidException);
                throw illegalStateException;
            }
            return -1;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                FileStateManager.this.discard(fileObject);
                FileStateManager.this.fireFileStatusChanged(fileObject);
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                String string;
                String string2 = fileEvent.getFile().getPackageNameExt('/', '.');
                if (string2.equals(string = fileObject.getPackageNameExt('/', '.'))) {
                    int n = this.layerOfFile(fileEvent.getFile());
                    if (-1 != n) {
                        this.attachNotifier(fileObject, n);
                    }
                    this.rescan(fileObject);
                }
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                int n;
                String string = fileEvent.getFile().getPackageNameExt('/', '.');
                String string2 = fileObject.getPackageNameExt('/', '.');
                if (string2.startsWith(string) && -1 != (n = this.layerOfFile(fileEvent.getFile())) && this.attachNotifier(fileObject, n)) {
                    this.rescan(fileObject);
                }
            } else {
                this.detachAllNotifiers();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = (FileObject)this.file.get();
            if (fileObject != null && fileObject.isValid()) {
                String string;
                String string2 = fileEvent.getFile().getPackageNameExt('/', '.');
                if (string2.equals(string = fileObject.getPackageNameExt('/', '.'))) {
                    int n = this.layerOfFile(fileEvent.getFile());
                    if (-1 != n) {
                        this.attachNotifier(fileObject, n);
                    }
                    this.rescan(fileObject);
                }
            } else {
                this.detachAllNotifiers();
            }
        }
    }

    public static interface FileStatusListener {
        public void fileStatusChanged(FileObject var1);
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("session_open".equals(propertyChangeEvent.getPropertyName())) {
                int n;
                FileObject[] fileObjectArray = null;
                WeakHashMap weakHashMap = FileStateManager.this.info;
                synchronized (weakHashMap) {
                    fileObjectArray = ((AbstractMap)FileStateManager.this.info).keySet().toArray(new FileObject[0]);
                    n = 0;
                    while (n < fileObjectArray.length) {
                        FileInfo fileInfo = (FileInfo)((Object)FileStateManager.this.info.get(fileObjectArray[n]));
                        if (fileInfo != null) {
                            fileInfo.invalidate();
                        }
                        ++n;
                    }
                    FileStateManager.this.info.clear();
                    FileStateManager.this.getLayers();
                }
                n = 0;
                while (n < fileObjectArray.length) {
                    FileStateManager.this.fireFileStatusChanged(fileObjectArray[n]);
                    ++n;
                }
            }
        }
    }
}

