/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.util.Arrays;
import java.util.Stack;

public class StartLog {
    private static final StartImpl impl;

    public static void logStart(String string) {
        if (StartLog.willLog()) {
            impl.start(string, System.currentTimeMillis());
        }
    }

    public static void logProgress(String string) {
        if (StartLog.willLog()) {
            impl.progress(string, System.currentTimeMillis());
        }
    }

    public static void logEnd(String string) {
        if (StartLog.willLog()) {
            impl.end(string, System.currentTimeMillis());
        }
    }

    public static boolean willLog() {
        return impl.willLog();
    }

    static {
        String string = System.getProperty("org.netbeans.log.startup");
        impl = string == null ? new StartImpl() : ("print".equals(string) ? new PrintImpl() : new LogImpl());
    }

    private static class LogImpl
    extends StartImpl {
        private LogImpl() {
        }
    }

    private static class PrintImpl
    extends StartImpl {
        private long zero = System.currentTimeMillis();
        private Stack starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        private PrintImpl() {
        }

        void start(String string, long l) {
            this.starts.push(new Long(l));
            this.prog = l;
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " started");
            this.indent += 2;
        }

        void progress(String string, long l) {
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " dT=" + (l - this.prog));
            this.prog = l;
        }

        void end(String string, long l) {
            this.indent -= 2;
            long l2 = (Long)this.starts.pop();
            this.prog = l;
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " finished, took " + (l - l2) + "ms");
        }

        boolean willLog() {
            return true;
        }

        private String getIndentString(int n) {
            if (this.spaces.length < n) {
                this.spaces = new char[Math.max(this.spaces.length * 2, n + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, n);
        }
    }

    private static class StartImpl {
        private StartImpl() {
        }

        void start(String string, long l) {
        }

        void progress(String string, long l) {
        }

        void end(String string, long l) {
        }

        boolean willLog() {
            return false;
        }
    }
}

