/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.actions.NextOutJumpAction;
import org.netbeans.core.actions.PreviousOutJumpAction;
import org.netbeans.core.output.OutputSettings;
import org.netbeans.core.output.OutputTab;
import org.openide.TopManager;
import org.openide.actions.CopyAction;
import org.openide.actions.PopupAction;
import org.openide.awt.JPopupMenuPlus;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class OutPane
extends JList
implements MouseListener,
ListSelectionListener,
KeyListener,
ActionPerformer,
FocusListener,
ActionListener {
    static final long serialVersionUID = -633812069000420549L;
    PaneWriter writer;
    private PaneWriter model;
    OutputTab tab;
    boolean jumpLineSet;
    private static CopyAction copyAction = (CopyAction)SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = OutPane.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction));
    private static NextOutJumpAction nextAction = (NextOutJumpAction)SystemAction.get((Class)(class$org$netbeans$core$actions$NextOutJumpAction == null ? (class$org$netbeans$core$actions$NextOutJumpAction = OutPane.class$("org.netbeans.core.actions.NextOutJumpAction")) : class$org$netbeans$core$actions$NextOutJumpAction));
    private static PreviousOutJumpAction previousAction = (PreviousOutJumpAction)SystemAction.get((Class)(class$org$netbeans$core$actions$PreviousOutJumpAction == null ? (class$org$netbeans$core$actions$PreviousOutJumpAction = OutPane.class$("org.netbeans.core.actions.PreviousOutJumpAction")) : class$org$netbeans$core$actions$PreviousOutJumpAction));
    private JumpActionPerformer jumpPerformer = new JumpActionPerformer();
    private TreeMap listeners = new TreeMap();
    private Map int2Line;
    private static MessageFormat formatOfException;
    JPopupMenu jPopup;
    private JMenuItem copyItem;
    private JMenuItem clearItem;
    Timer fireTimer;
    private static final String EMPTY = " ";
    private int previousIndex = -1;
    CallbackSystemAction csa;
    int lastidx = -1;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$NextOutJumpAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$PreviousOutJumpAction;
    static /* synthetic */ Class class$org$netbeans$core$output$OutPane;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;

    public OutPane() {
        this((OutputTab)null);
    }

    public OutPane(OutputTab outputTab) {
        this.tab = outputTab;
        this.int2Line = new HashMap(29);
        this.writer = this.model = new PaneWriter();
        this.setModel(this.model);
        this.setCellRenderer(this.jumpPerformer);
        this.setBackground(OutPane.outputSettings().getBaseBackground());
        this.setSelectionMode(0);
        this.jumpLineSet = false;
        this.addMouseListener(this);
        this.addListSelectionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.jPopup = new JPopupMenuPlus();
        this.copyItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutPane == null ? (class$org$netbeans$core$output$OutPane = OutPane.class$("org.netbeans.core.output.OutPane")) : class$org$netbeans$core$output$OutPane)).getString("CTL_ClipboardCopy"));
        this.copyItem.addActionListener(this);
        this.jPopup.add(this.copyItem);
        this.jPopup.addSeparator();
        this.clearItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutPane == null ? (class$org$netbeans$core$output$OutPane = OutPane.class$("org.netbeans.core.output.OutPane")) : class$org$netbeans$core$output$OutPane)).getString("CTL_Clear"));
        this.clearItem.addActionListener(this);
        this.jPopup.add(this.clearItem);
    }

    public OutputWriter getOut() {
        return this.writer;
    }

    private OutputListener getListenerForPosition(int n) {
        return (OutputListener)this.listeners.get(new Integer(n));
    }

    final void checkCopyAction() {
        OutPane outPane = this.getSelectedIndex() != -1 ? this : null;
        copyAction.setActionPerformer((ActionPerformer)outPane);
    }

    final void unsetCopyAction() {
        copyAction.setActionPerformer(null);
    }

    void checkNextPrevActions() {
        nextAction.setActionPerformer(this.nextJump() != -1 ? this.jumpPerformer : null);
        previousAction.setActionPerformer(this.previousJump() != -1 ? this.jumpPerformer : null);
    }

    private int nextJump() {
        Integer n = new Integer(this.getSelectedIndex() + 1);
        TreeMap treeMap = this.listeners;
        synchronized (treeMap) {
            SortedMap sortedMap = this.listeners.tailMap(n);
            if (sortedMap.isEmpty()) {
                int n2 = -1;
                return n2;
            }
            n = sortedMap.firstKey();
        }
        return n;
    }

    private int previousJump() {
        Integer n = new Integer(this.getSelectedIndex());
        TreeMap treeMap = this.listeners;
        synchronized (treeMap) {
            SortedMap sortedMap = this.listeners.headMap(n);
            if (sortedMap.isEmpty()) {
                int n2 = -1;
                return n2;
            }
            n = sortedMap.lastKey();
        }
        return n;
    }

    private void stopAtFirstJumpLine(int n) {
        if (!this.jumpLineSet) {
            this.setSelectedIndex(n);
            this.jumpLineSet = true;
        }
    }

    void clearLineTable() {
        TreeMap treeMap = this.listeners;
        synchronized (treeMap) {
            Iterator iterator = this.listeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n = (Integer)entry.getKey();
                OutputListener outputListener = (OutputListener)entry.getValue();
                if (outputListener == null) continue;
                outputListener.outputLineCleared((OutputEvent)new OutputEventImpl(this.tab, n));
            }
            this.listeners.clear();
            this.jumpLineSet = false;
            this.checkNextPrevActions();
        }
    }

    private boolean invokeJumpListener(int n) {
        OutputListener outputListener = this.getListenerForPosition(n);
        if (outputListener != null) {
            outputListener.outputLineAction((OutputEvent)new OutputEventImpl(this.tab, n));
            return true;
        }
        return false;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.getSelectedIndex();
        if (n == this.previousIndex) {
            return;
        }
        this.previousIndex = n;
        OutputListener outputListener = this.getListenerForPosition(n);
        if (outputListener != null) {
            outputListener.outputLineSelected((OutputEvent)new OutputEventImpl(this.tab, n));
        }
        this.checkNextPrevActions();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() & 0x10) != 0 && !this.invokeJumpListener(n = this.locationToIndex(mouseEvent.getPoint()))) {
            this.parseException(new Integer(n), true);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (OutPane.isPopupTrigger(mouseEvent)) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0xC) != 0;
    }

    void showPopup(int n, int n2) {
        this.jPopup.show(this, n, n2);
    }

    public void activated() {
        this.checkCopyAction();
        if (this.csa == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.actions.PopupAction");
                this.csa = (CallbackSystemAction)SystemAction.get(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError();
                TopManager.getDefault().getErrorManager().annotate((Throwable)noClassDefFoundError, (Throwable)classNotFoundException);
                throw noClassDefFoundError;
            }
        }
        if (this.lastidx >= 0) {
            this.setSelectedIndex(this.lastidx);
        }
        this.csa.setActionPerformer((ActionPerformer)this);
    }

    public void deactivated() {
        int n;
        if (this.csa != null) {
            this.csa.setActionPerformer(null);
        }
        this.lastidx = n = this.getSelectedIndex();
        this.unsetCopyAction();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    boolean parseException(Integer n, boolean bl) {
        int n2 = n;
        if (n2 < 0) {
            return false;
        }
        String string = ((String)this.model.getElementAt(n2)).trim();
        try {
            Object v = this.int2Line.get(n);
            if (v == this.int2Line) {
                return false;
            }
            if (OutPane.isExceptionHeuristic(string)) {
                Line line;
                if (v == null) {
                    String string2;
                    int n3 = string.indexOf("at ");
                    if (n3 < 0) {
                        this.int2Line.put(n, this.int2Line);
                        return false;
                    }
                    string = string.substring(n3 += 3);
                    Object[] objectArray = OutPane.getExceptionFormat().parse(string);
                    String string3 = objectArray[0].toString();
                    String string4 = objectArray[1].toString();
                    String string5 = objectArray[2].toString();
                    int n4 = Integer.parseInt(objectArray[3].toString());
                    int n5 = string3.indexOf(string4);
                    if (n5 < 0) {
                        int n6 = string3.lastIndexOf(46);
                        n6 = string3.lastIndexOf(46, n6 - 1);
                        string2 = string3.substring(0, n6 + 1).replace('.', '/') + string4 + ".java";
                    } else {
                        string2 = string3.substring(0, n5 + string4.length()).replace('.', '/') + ".java";
                    }
                    FileObject fileObject = TopManager.getDefault().getRepository().findResource(string2);
                    if (fileObject == null) {
                        this.int2Line.put(n, this.int2Line);
                        return false;
                    }
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutPane.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (editorCookie == null) {
                        this.int2Line.put(n, this.int2Line);
                        return false;
                    }
                    line = editorCookie.getLineSet().getOriginal(n4 - 1);
                    this.int2Line.put(n, line);
                } else {
                    line = (Line)v;
                }
                if (bl) {
                    line.show(2, 0);
                }
                return true;
            }
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.int2Line.put(n, this.int2Line);
        return false;
    }

    static boolean isExceptionHeuristic(String string) {
        return OutPane.startsOK(string = string.trim()) && string.charAt(string.length() - 1) == ')';
    }

    private static boolean startsOK(String string) {
        return string.startsWith("at ") || string.startsWith("[catch] at ");
    }

    static MessageFormat getExceptionFormat() {
        if (formatOfException == null) {
            formatOfException = new MessageFormat("{0}({1}.{2}:{3})");
        }
        return formatOfException;
    }

    public void performAction(SystemAction systemAction) {
        if (systemAction instanceof CopyAction) {
            this.doCopy();
        } else if (systemAction instanceof PopupAction) {
            int n = this.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Point point = this.indexToLocation(n);
            if (point == null) {
                return;
            }
            this.showPopup(point.x, point.y);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.copyItem) {
            this.doCopy();
        } else if (actionEvent.getSource() == this.clearItem) {
            this.doClear();
        } else {
            this.getFireTimer().stop();
            this.model.fireChanges();
        }
    }

    private void doCopy() {
        Object[] objectArray = this.model.lines.toArray();
        StringBuffer stringBuffer = new StringBuffer(objectArray.length * 25);
        if (objectArray.length >= 1) {
            stringBuffer.append(objectArray[0].toString());
            int n = 1;
            while (n < objectArray.length) {
                stringBuffer.append('\n').append(objectArray[n].toString());
                ++n;
            }
            if (this.model.currentLine.length() > 0) {
                stringBuffer.append('\n').append(this.model.currentLine.toString());
            }
        } else {
            stringBuffer.append(this.model.currentLine.toString());
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        TopManager.getDefault().getClipboard().setContents(stringSelection, stringSelection);
    }

    private void doClear() {
        this.model.reset();
        this.model.cleaned();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            int n = this.getSelectedIndex();
            if (n < 0) {
                return;
            }
            if (!this.invokeJumpListener(n)) {
                this.parseException(new Integer(n), true);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    static String getTab() {
        int n = OutPane.outputSettings().getTabSize();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(EMPTY);
            ++n2;
        }
        return stringBuffer.toString();
    }

    Timer getFireTimer() {
        if (this.fireTimer == null) {
            this.fireTimer = new Timer(80, this);
            this.fireTimer.setRepeats(false);
            this.fireTimer.setCoalesce(true);
        }
        return this.fireTimer;
    }

    private static OutputSettings outputSettings() {
        return (OutputSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutPane.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class JumpActionPerformer
    extends JLabel
    implements ActionPerformer,
    ListCellRenderer {
        static final long serialVersionUID = 4405590143900383138L;
        private FontMetrics fm;
        private String txt;
        private Dimension recycle;
        private Dimension recycle2;

        JumpActionPerformer() {
            this.setOpaque(true);
            this.txt = "";
        }

        public void performAction(SystemAction systemAction) {
            int n = -1;
            if (systemAction instanceof NextOutJumpAction) {
                n = OutPane.this.nextJump();
            }
            if (systemAction instanceof PreviousOutJumpAction) {
                n = OutPane.this.previousJump();
            }
            if (n != -1) {
                OutPane.this.setSelectedIndex(n);
                if (systemAction instanceof NextOutJumpAction) {
                    OutPane.this.ensureIndexIsVisible(n + 2);
                }
                OutPane.this.ensureIndexIsVisible(n);
                OutPane.this.invokeJumpListener(n);
            }
            OutPane.this.checkNextPrevActions();
        }

        public Dimension getPreferredSize() {
            this.checkFont();
            String string = this.getText();
            if (string == null) {
                string = OutPane.EMPTY;
            }
            if (this.recycle == null) {
                this.recycle = new Dimension(this.fm.stringWidth(string), this.fm.getHeight());
                this.recycle2 = new Dimension(this.fm.stringWidth(string), this.fm.getHeight());
                return this.recycle;
            }
            this.recycle.width = this.fm.stringWidth(string);
            this.recycle.height = this.fm.getHeight();
            this.recycle2.width = Math.max(this.recycle2.width, this.fm.stringWidth(string));
            this.recycle2.height = this.fm.getHeight();
            return this.recycle;
        }

        public String getText() {
            return this.txt;
        }

        public void setText(String string) {
            String string2 = this.txt;
            this.txt = string;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3;
            String string = object instanceof String ? (String)object : ((StringBuffer)object).toString();
            Color color = OutPane.outputSettings().getBaseBackground();
            if (!jList.getBackground().equals(color)) {
                jList.setBackground(color);
            }
            this.checkFont();
            this.setText(string);
            Integer n2 = new Integer(n);
            boolean bl4 = bl3 = OutPane.this.listeners.containsKey(n2) || OutPane.this.parseException(n2, false);
            if (n != jList.getSelectedIndex()) {
                this.setBackground(color);
                this.setForeground(OutPane.outputSettings().getBaseForeground());
            } else if (bl3) {
                this.setBackground(OutPane.outputSettings().getJumpCursorBackground());
                this.setForeground(OutPane.outputSettings().getJumpCursorForeground());
            } else {
                this.setBackground(OutPane.outputSettings().getCursorBackground());
                this.setForeground(OutPane.outputSettings().getCursorForeground());
            }
            return this;
        }

        void checkFont() {
            Font font = this.getFont();
            if (font != null && this.fm != null && font.isPlain() && font.getSize() == OutPane.outputSettings().getFontSize()) {
                return;
            }
            Font font2 = new Font("monospaced", 0, OutPane.outputSettings().getFontSize());
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font2);
            this.setFont(font2);
        }
    }

    final class PaneWriter
    extends OutputWriter
    implements ListModel,
    Runnable {
        ArrayList lines;
        private StringBuffer currentLine;
        private String currentLineStr;
        private StringBuffer sb;
        private boolean lastR = false;
        private ListDataListener dataListener;
        int origSize;
        long lastPaintedTime = 0L;
        int lastPaintedIdx = 0;
        int invocationCount = 0;
        int selectFirstJump = -1;

        public PaneWriter() {
            super((Writer)new OutputStreamWriter((OutputStream)new NullOutputStream()));
            ((PrintWriter)((Object)this)).out = this;
            ((Writer)((Object)this)).lock = this;
            this.lines = new ArrayList();
            this.currentLine = new StringBuffer();
            this.currentLineStr = OutPane.EMPTY;
            this.sb = new StringBuffer();
            this.origSize = 0;
        }

        void cleaned() {
            this.redraw();
        }

        private synchronized void redraw() {
            String string = this.sb.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t", true);
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("\n") || string3.equals("\r")) {
                    boolean bl = string3.equals("\r");
                    if (bl || !this.lastR) {
                        String string4 = this.currentLine.length() == 0 ? OutPane.EMPTY : this.currentLine.toString();
                        this.lines.add(string4);
                        this.currentLine.setLength(0);
                        this.currentLineStr = OutPane.EMPTY;
                    }
                    this.lastR = bl;
                    continue;
                }
                if (string3.equals("\t")) {
                    if (string2 == null) {
                        string2 = OutPane.getTab();
                    }
                    string3 = string2;
                }
                this.currentLine.append(string3);
                this.currentLineStr = null;
            }
            this.sb.setLength(0);
            this.restartFire();
        }

        void restartFire() {
            Timer timer = OutPane.this.getFireTimer();
            long l = System.currentTimeMillis();
            if (this.lastPaintedTime == 0L) {
                this.lastPaintedTime = System.currentTimeMillis();
            } else {
                long l2;
                int n = this.getUncommittedSize() - this.lastPaintedIdx;
                if (n > 1 && (l2 = (l - this.lastPaintedTime) / 1000L) > 0L) {
                    timer.stop();
                    this.fireChanges();
                    return;
                }
            }
            timer.restart();
        }

        void fireChanges() {
            if (EventQueue.isDispatchThread()) {
                boolean bl;
                long l = System.currentTimeMillis();
                if ((l - this.lastPaintedTime) / 1000L == 0L) {
                    OutPane.this.getFireTimer().restart();
                    return;
                }
                OutPane.this.getFireTimer().stop();
                this.lastPaintedTime = System.currentTimeMillis();
                int n = Math.min(this.getUncommittedSize(), this.origSize + 10000);
                int n2 = this.origSize;
                this.origSize = n;
                if (n != n2) {
                    this.fireIntervalAdded(n2, n);
                } else {
                    this.fireContentsChanged(n2, n);
                }
                if (this.selectFirstJump >= 0) {
                    OutPane.this.setSelectedIndex(this.selectFirstJump);
                    OutPane.this.valueChanged(null);
                    OutPane.this.checkNextPrevActions();
                    this.selectFirstJump = -1;
                }
                boolean bl2 = bl = this.getUncommittedSize() - n == 0;
                if (n > 0 && OutPane.this.getSelectedIndex() < 0 && bl) {
                    OutPane.this.ensureIndexIsVisible(n - 1);
                }
                this.lastPaintedTime = System.currentTimeMillis();
                this.lastPaintedIdx = this.origSize;
                this.invocationCount = 0;
                if (!bl) {
                    OutPane.this.getFireTimer().restart();
                }
            } else {
                this.invokeLater();
            }
        }

        void invokeLater() {
            if (this.invocationCount == 0) {
                this.invocationCount = 1;
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            this.fireChanges();
        }

        public void write(char[] cArray, int n, int n2) {
            OutputTab outputTab = OutPane.this.tab;
            if (outputTab != null && outputTab.isClosed()) {
                outputTab.rebindTab();
            }
            PaneWriter paneWriter = this;
            synchronized (paneWriter) {
                this.sb.append(cArray, n, n2);
                this.redraw();
            }
        }

        public void write(int n) {
            OutputTab outputTab = OutPane.this.tab;
            if (outputTab != null && outputTab.isClosed()) {
                outputTab.rebindTab();
            }
            PaneWriter paneWriter = this;
            synchronized (paneWriter) {
                this.sb.append((char)n);
                this.redraw();
            }
        }

        public void write(String string, int n, int n2) {
            OutputTab outputTab = OutPane.this.tab;
            if (outputTab != null && outputTab.isClosed()) {
                outputTab.rebindTab();
            }
            PaneWriter paneWriter = this;
            synchronized (paneWriter) {
                this.sb.append(string.substring(n, n2));
                this.redraw();
            }
        }

        public void println(String string, OutputListener outputListener) throws IOException {
            OutputTab outputTab = OutPane.this.tab;
            if (outputTab != null && outputTab.isClosed()) {
                outputTab.rebindTab();
            }
            PaneWriter paneWriter = this;
            synchronized (paneWriter) {
                if (this.sb.length() > 0) {
                    this.sb.append("\n");
                }
                int n = this.lines.size();
                if (OutPane.this.listeners.isEmpty()) {
                    this.selectFirstJump = n;
                }
                OutPane.this.listeners.put(new Integer(n), outputListener);
                this.sb.append(string);
                this.sb.append("\n");
                this.redraw();
            }
        }

        public void flush() {
            if (OutPane.this.tab != null && OutPane.this.tab.isClosed()) {
                return;
            }
            this.redraw();
        }

        public void close() {
        }

        public synchronized void reset() {
            OutPane.this.clearLineTable();
            OutPane.this.int2Line.clear();
            int n = this.getUncommittedSize();
            this.lines.clear();
            this.sb.setLength(0);
            this.currentLine.setLength(0);
            this.currentLineStr = OutPane.EMPTY;
            if (n >= 0) {
                if (EventQueue.isDispatchThread()) {
                    this.fireIntervalRemoved(0, n);
                } else {
                    Runnable runnable = new Runnable(this, n){
                        private final /* synthetic */ int val$size;
                        private final /* synthetic */ PaneWriter this$1;
                        {
                            this.this$1 = paneWriter;
                            this.val$size = n;
                        }

                        public void run() {
                            this.this$1.fireIntervalRemoved(0, this.val$size);
                        }
                    };
                    EventQueue.invokeLater(runnable);
                }
            }
            this.origSize = 0;
            this.lastPaintedTime = 0L;
            this.lastPaintedIdx = 0;
            this.invocationCount = 0;
        }

        public synchronized Object getElementAt(int n) {
            if (n < this.lines.size()) {
                Object e = this.lines.get(n);
                return e;
            }
            if (n == this.lines.size() && this.currentLine.length() > 0) {
                if (this.currentLineStr == null) {
                    this.currentLineStr = this.currentLine.toString();
                }
                return this.currentLineStr;
            }
            return OutPane.EMPTY;
        }

        public int getSize() {
            return this.origSize;
        }

        int getUncommittedSize() {
            return this.lines.size() + (this.currentLine.length() > 0 ? 1 : 0);
        }

        public void addListDataListener(ListDataListener listDataListener) {
            if (this.dataListener != null) {
                throw new InternalError();
            }
            this.dataListener = listDataListener;
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.dataListener = null;
        }

        protected void fireContentsChanged(int n, int n2) {
            if (this.dataListener != null) {
                this.dataListener.contentsChanged(new ListDataEvent(this, 0, n, n2));
            }
        }

        protected void fireIntervalAdded(int n, int n2) {
            if (this.dataListener != null) {
                this.dataListener.intervalAdded(new ListDataEvent(this, 1, n, n2));
            }
        }

        protected void fireIntervalRemoved(int n, int n2) {
            if (this.dataListener != null) {
                this.dataListener.intervalRemoved(new ListDataEvent(this, 2, n, n2));
            }
        }
    }

    private final class OutputEventImpl
    extends OutputEvent {
        private int index;
        static final long serialVersionUID = -437312909583471519L;

        public OutputEventImpl(InputOutput inputOutput, int n) {
            super(inputOutput);
            this.index = n;
        }

        public String getLine() {
            return OutPane.this.model.getElementAt(this.index).toString();
        }
    }
}

