/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.core.modules.Module;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

abstract class Util {
    static final ErrorManager err;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    private Util() {
    }

    static File makeTempJar(File file) throws IOException {
        String string = file.getName();
        if (string.endsWith(".jar") || string.endsWith(".JAR")) {
            string = string.substring(0, string.length() - 4);
        }
        if (string.length() < 3) {
            string = string + '.';
        }
        if (string.length() < 3) {
            string = string + '.';
        }
        if (string.length() < 3) {
            string = string + '.';
        }
        File file2 = File.createTempFile(string, "-test.jar", file.getParentFile());
        file2.deleteOnExit();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        err.log("Made " + file2);
        return file2;
    }

    static List findLocaleVariantsOf(File file, boolean bl) {
        String string;
        String string2;
        if (!file.isFile()) {
            return Collections.EMPTY_LIST;
        }
        File file2 = new File(file.getParentFile(), "locale");
        if (!file2.isDirectory()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(7);
        String string3 = file.getName();
        int n = string3.lastIndexOf(46);
        if (n != -1) {
            string2 = string3.substring(0, n);
            string = string3.substring(n);
        } else {
            string2 = string3;
            string = "";
        }
        Iterator iterator = NbBundle.getLocalizingSuffixes();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            File file3 = new File(file2, string2 + string4 + string);
            if (!file3.isFile()) continue;
            if (bl) {
                arrayList.add(new Object[]{file3, string4});
                continue;
            }
            arrayList.add(file3);
        }
        return arrayList;
    }

    static boolean checkJavaOrIDEDependency(Dependency dependency) throws IllegalArgumentException {
        if (dependency.getType() == 4) {
            if (!dependency.getName().equals(Dependency.IDE_NAME)) {
                return false;
            }
            if (dependency.getComparison() == 1) {
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)Dependency.IDE_SPEC) <= 0;
            }
            return dependency.getVersion().equals(Dependency.IDE_IMPL);
        }
        if (dependency.getType() == 3) {
            if (dependency.getName().equals("Java")) {
                if (dependency.getComparison() == 1) {
                    return new SpecificationVersion(dependency.getVersion()).compareTo((Object)Dependency.JAVA_SPEC) <= 0;
                }
                return dependency.getVersion().equals(Dependency.JAVA_IMPL);
            }
            if (dependency.getComparison() == 1) {
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)Dependency.VM_SPEC) <= 0;
            }
            return dependency.getVersion().equals(Dependency.VM_IMPL);
        }
        throw new IllegalArgumentException();
    }

    static boolean checkPackageDependency(Dependency dependency, ClassLoader classLoader) throws IllegalArgumentException {
        String string;
        String string2;
        if (dependency.getType() != 2) {
            throw new IllegalArgumentException("Not a package dependency");
        }
        if (!(classLoader instanceof PackageAccessibleClassLoader) && classLoader != ClassLoader.getSystemClassLoader()) {
            throw new IllegalArgumentException("Not a package-accessible classloader: " + classLoader);
        }
        String string3 = dependency.getName();
        String string4 = dependency.getVersion();
        int n = dependency.getComparison();
        int n2 = string3.indexOf(91);
        if (n2 == -1) {
            string2 = string3;
            string = null;
        } else if (n2 == 0) {
            string2 = null;
            string = string3.substring(1, string3.length() - 1);
        } else {
            string2 = string3.substring(0, n2);
            string = string3.substring(n2 + 1, string3.length() - 1);
            if (string.indexOf(46) == -1) {
                string = string2 + '.' + string;
            }
        }
        if (string != null) {
            try {
                classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string2 == null) {
                    err.notify(1, (Throwable)classNotFoundException);
                    err.log("Probed class could not be found");
                    return false;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                err.notify(1, throwable);
                err.log("Assuming package " + string2 + " is corrupt");
                return false;
            }
        }
        if (string2 != null) {
            Package package_ = classLoader instanceof PackageAccessibleClassLoader ? ((PackageAccessibleClassLoader)((Object)classLoader)).getPackageAccessibly(string2) : Package.getPackage(string2);
            if (package_ == null) {
                err.log("No package with the name " + string2 + " found");
                return false;
            }
            if (n == 3) {
                return true;
            }
            if (n == 1) {
                if (package_.getSpecificationVersion() == null) {
                    err.log("Package " + string2 + " did not give a specification version");
                    return false;
                }
                try {
                    SpecificationVersion specificationVersion = new SpecificationVersion(string4);
                    SpecificationVersion specificationVersion2 = new SpecificationVersion(package_.getSpecificationVersion().trim());
                    if (specificationVersion.compareTo((Object)specificationVersion2) <= 0) {
                        return true;
                    }
                    err.log("Loaded package " + string2 + " was only of version " + specificationVersion2 + " but " + specificationVersion + " was requested");
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    err.notify(1, (Throwable)numberFormatException);
                    err.log("Will not honor a dependency on non-numeric package spec version");
                    return false;
                }
            }
            if (package_.getImplementationVersion() == null) {
                err.log("Package " + string2 + " had no implementation version");
                return false;
            }
            if (!package_.getImplementationVersion().trim().equals(string4)) {
                err.log("Package " + string2 + " had the wrong impl version: " + package_.getImplementationVersion());
                return false;
            }
            return true;
        }
        return true;
    }

    static void debugClassLoader(ClassLoader classLoader, String string) {
        if (classLoader instanceof DebuggableClassLoader) {
            ((DebuggableClassLoader)((Object)classLoader)).dumpURLs(string);
        } else {
            URL[] uRLArray;
            if (classLoader instanceof URLClassLoader) {
                uRLArray = ((URLClassLoader)classLoader).getURLs();
                int n = 0;
                while (n < uRLArray.length) {
                    err.log(string + "[" + classLoader + "] " + uRLArray[n]);
                    ++n;
                }
            }
            if ((uRLArray = classLoader.getParent()) != null) {
                Util.debugClassLoader((ClassLoader)uRLArray, string);
            }
        }
    }

    static Comparator dependencyComparator(boolean bl) {
        return new DependencyComparator(bl);
    }

    static Comparator displayNameComparator() {
        return new DisplayNameComparator();
    }

    static String findLocalizedMessage(Throwable throwable, boolean bl) {
        String string = throwable.getLocalizedMessage();
        if (Utilities.compareObjects((Object)string, (Object)throwable.getMessage())) {
            ErrorManager.Annotation[] annotationArray = err.findAnnotations(throwable);
            if (annotationArray != null) {
                int n = 0;
                while (n < annotationArray.length) {
                    if (annotationArray[n].getLocalizedMessage() != null) {
                        return annotationArray[n].getLocalizedMessage();
                    }
                    ++n;
                }
            }
            if (!bl) {
                return null;
            }
        }
        return string;
    }

    static FilenameFilter jarFilter() {
        return new JarFilter();
    }

    static String createPackageName(String string) throws IllegalArgumentException {
        String string2 = ".class";
        if (!string.endsWith(string2)) {
            string2 = ".ser";
        }
        if (string.endsWith(string2)) {
            String string3 = string.substring(0, string.length() - string2.length());
            if (string3.length() == 0) {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            if (string3.charAt(0) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            if (string3.charAt(string3.length() - 1) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            if (string3.indexOf(46) != -1) {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            return string3.replace('/', '.');
        }
        throw new IllegalArgumentException("Bad class file name: " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = Util.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager == null) {
            errorManager = new TrivialErrorManager();
        }
        err = errorManager.getInstance("org.netbeans.core.modules");
    }

    static final class ModuleLookup
    extends Lookup {
        private final HashSet modules = new HashSet(100);
        private final Set results = new WeakSet(10);
        static /* synthetic */ Class class$org$netbeans$core$modules$Module;
        static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
        static /* synthetic */ Class class$java$lang$Object;

        ModuleLookup() {
        }

        public void add(Module module) {
            HashSet hashSet = this.modules;
            synchronized (hashSet) {
                this.modules.add(module);
            }
        }

        public void remove(Module module) {
            HashSet hashSet = this.modules;
            synchronized (hashSet) {
                this.modules.remove((Object)module);
            }
        }

        public void changed() {
            Set set = this.results;
            synchronized (set) {
                Iterator iterator = this.results.iterator();
                while (iterator.hasNext()) {
                    ((ModuleResult)((Object)iterator.next())).changed();
                }
            }
        }

        public Object lookup(Class clazz) {
            if (!(clazz != (class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = ModuleLookup.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module) && clazz != (class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = ModuleLookup.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo) && clazz != (class$java$lang$Object == null ? (class$java$lang$Object = ModuleLookup.class$("java.lang.Object")) : class$java$lang$Object) && clazz != null || this.modules.isEmpty())) {
                HashSet hashSet = this.modules;
                synchronized (hashSet) {
                    Object e = this.modules.iterator().next();
                    return e;
                }
            }
            return null;
        }

        public Lookup.Result lookup(Lookup.Template template) {
            Class clazz = template.getType();
            if (clazz == (class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = ModuleLookup.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module) || clazz == (class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = ModuleLookup.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo) || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = ModuleLookup.class$("java.lang.Object")) : class$java$lang$Object) || clazz == null) {
                return new ModuleResult(template);
            }
            return Lookup.EMPTY.lookup(template);
        }

        public String toString() {
            HashSet hashSet = this.modules;
            synchronized (hashSet) {
                String string = "ModuleLookup" + this.modules;
                return string;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private static final class ModuleItem
        extends Lookup.Item {
            public static final String PREFIX = "Module[";
            private final Module item;
            static /* synthetic */ Class class$org$netbeans$core$modules$Module;

            public ModuleItem(Module module) {
                this.item = module;
            }

            public Object getInstance() {
                return this.item;
            }

            public Class getType() {
                return class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = ModuleItem.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module;
            }

            public String getId() {
                return PREFIX + this.item.getCodeNameBase();
            }

            public String getDisplayName() {
                return this.item.getDisplayName();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }

        private final class ModuleResult
        extends Lookup.Result {
            private final Lookup.Template t;
            private final Set listeners = new HashSet(10);
            static /* synthetic */ Class class$org$netbeans$core$modules$Module;

            public ModuleResult(Lookup.Template template) {
                this.t = template;
                Set set = ModuleLookup.this.results;
                synchronized (set) {
                    ModuleLookup.this.results.add(this);
                }
            }

            public void addLookupListener(LookupListener lookupListener) {
                Set set = this.listeners;
                synchronized (set) {
                    this.listeners.add(lookupListener);
                }
            }

            public void removeLookupListener(LookupListener lookupListener) {
                Set set = this.listeners;
                synchronized (set) {
                    this.listeners.remove(lookupListener);
                }
            }

            public void changed() {
                LookupListener[] lookupListenerArray;
                Set set = this.listeners;
                synchronized (set) {
                    if (this.listeners.isEmpty()) {
                        return;
                    }
                    lookupListenerArray = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                LookupEvent lookupEvent = new LookupEvent((Lookup.Result)this);
                int n = 0;
                while (n < lookupListenerArray.length) {
                    lookupListenerArray[n].resultChanged(lookupEvent);
                    ++n;
                }
            }

            public Collection allInstances() {
                HashSet hashSet = ModuleLookup.this.modules;
                synchronized (hashSet) {
                    String string = this.t.getId();
                    Object object = this.t.getInstance();
                    if (string != null) {
                        Object object2;
                        Iterator iterator = ModuleLookup.this.modules.iterator();
                        while (iterator.hasNext()) {
                            object2 = (Module)((Object)iterator.next());
                            if (!string.equals("Module[" + ((Module)((Object)object2)).getCodeNameBase()) || object != null && object != object2) continue;
                            Set<Object> set = Collections.singleton(object2);
                            return set;
                        }
                        object2 = Collections.EMPTY_SET;
                        return object2;
                    }
                    if (object != null) {
                        Set<Object> set = ModuleLookup.this.modules.contains(object) ? Collections.singleton(object) : Collections.EMPTY_SET;
                        return set;
                    }
                    Set set = (Set)ModuleLookup.this.modules.clone();
                    return set;
                }
            }

            public Set allClasses() {
                return Collections.singleton(class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = ModuleResult.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module);
            }

            public Collection allItems() {
                Collection collection = this.allInstances();
                ArrayList<ModuleItem> arrayList = new ArrayList<ModuleItem>(Math.max(1, collection.size()));
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(new ModuleItem((Module)((Object)iterator.next())));
                }
                return arrayList;
            }

            public String toString() {
                return "ModuleResult:" + this.t;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        public boolean accept(File file, String string) {
            String string2 = string.toLowerCase();
            return string2.endsWith(".jar") && !string2.endsWith("-test.jar");
        }
    }

    private static final class DisplayNameComparator
    implements Comparator {
        private DisplayNameComparator() {
        }

        public int compare(Object object, Object object2) {
            Module module = (Module)((Object)object);
            Module module2 = (Module)((Object)object2);
            return module.getDisplayName().compareTo(module2.getDisplayName());
        }
    }

    private static final class DependencyComparator
    implements Comparator {
        private final boolean reverse;

        public DependencyComparator(boolean bl) {
            this.reverse = bl;
        }

        public int compare(Object object, Object object2) {
            Dependency dependency;
            Module module = (Module)((Object)object);
            Module module2 = (Module)((Object)object2);
            Set set = module.getDependencies();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                dependency = (Dependency)iterator.next();
                if (dependency.getType() != 1 || !dependency.getName().equals(module2.getCodeName())) continue;
                return this.reverse ? -1 : 1;
            }
            set = module2.getDependencies();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                dependency = (Dependency)iterator.next();
                if (dependency.getType() != 1 || !dependency.getName().equals(module.getCodeName())) continue;
                return this.reverse ? 1 : -1;
            }
            return 0;
        }
    }

    static interface DebuggableClassLoader {
        public void dumpURLs(String var1);
    }

    static interface ModuleProvider {
        public Module getModule();
    }

    static interface PackageAccessibleClassLoader {
        public Package getPackageAccessibly(String var1);

        public Package[] getPackagesAccessibly();
    }

    private static final class TrivialErrorManager
    extends ErrorManager {
        private static final boolean VERBOSE = "0".equals(System.getProperty("org.netbeans.core.modules"));

        private TrivialErrorManager() {
        }

        public void log(int n, String string) {
            if (VERBOSE) {
                System.err.println("[module system] " + string);
            }
        }

        public void notify(int n, Throwable throwable) {
            System.err.print("[module system] ");
            throwable.printStackTrace();
        }

        public ErrorManager getInstance(String string) {
            return this;
        }

        public ErrorManager.Annotation[] findAnnotations(Throwable throwable) {
            return new ErrorManager.Annotation[0];
        }

        public Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
            System.err.println("[module system] Annotations for " + throwable + ": msg=" + string + " locmsg=" + string2 + " stack=" + throwable2);
            if (throwable2 != null) {
                throwable2.printStackTrace();
            }
            return throwable;
        }

        public Throwable attachAnnotations(Throwable throwable, ErrorManager.Annotation[] annotationArray) {
            return throwable;
        }
    }
}

