/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.WeakSet;
import org.openide.util.enum.RemoveDuplicatesEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public class ProxyClassLoader
extends ClassLoader {
    private static final Set instances = new WeakSet();
    private final Map domainsByPackage = new HashMap();
    private HashMap packages = new HashMap();
    private ClassLoader[] parents;

    public ProxyClassLoader(ClassLoader[] classLoaderArray) {
        HashSet<ClassLoader> hashSet;
        if (classLoaderArray.length == 0) {
            classLoaderArray = new ClassLoader[]{ClassLoader.getSystemClassLoader()};
        }
        if ((hashSet = new HashSet<ClassLoader>(Arrays.asList(classLoaderArray))).size() < classLoaderArray.length) {
            throw new IllegalArgumentException("duplicate parents");
        }
        if (hashSet.contains(null)) {
            throw new IllegalArgumentException("null parent");
        }
        this.parents = this.coalesceParents(classLoaderArray);
        Set set = instances;
        synchronized (set) {
            instances.add(this);
        }
    }

    public synchronized void append(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        if (classLoaderArray == null) {
            throw new IllegalArgumentException("null parents array");
        }
        int n = 0;
        while (n < classLoaderArray.length) {
            if (classLoaderArray[n] == null) {
                throw new IllegalArgumentException("null parent");
            }
            ++n;
        }
        this.parents = this.coalesceAppend(this.parents, classLoaderArray);
    }

    public void destroy() {
        Set set = instances;
        synchronized (set) {
            Iterator iterator = instances.iterator();
            while (iterator.hasNext()) {
                ProxyClassLoader proxyClassLoader;
                ProxyClassLoader proxyClassLoader2 = proxyClassLoader = (ProxyClassLoader)iterator.next();
                synchronized (proxyClassLoader2) {
                    ClassLoader[] classLoaderArray;
                    ClassLoader[] classLoaderArray2 = proxyClassLoader.parents;
                    int n = 0;
                    while (n < classLoaderArray2.length) {
                        if (classLoaderArray2[n] == this) {
                            classLoaderArray = new ClassLoader[classLoaderArray2.length - 1];
                            if (n > 0) {
                                System.arraycopy(classLoaderArray2, 0, classLoaderArray, 0, n);
                            }
                            if (n < classLoaderArray2.length - 1) {
                                System.arraycopy(classLoaderArray2, n + 1, classLoaderArray, n, classLoaderArray2.length - n - 1);
                            }
                            proxyClassLoader.parents = classLoaderArray;
                            break;
                        }
                        ++n;
                    }
                    classLoaderArray = proxyClassLoader.domainsByPackage.values();
                    while (classLoaderArray.remove(this)) {
                    }
                }
            }
        }
    }

    protected final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new ClassNotFoundException("Will not load classes from default package");
        }
        Class clazz = this.smartLoadClass(string, n);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class simpleFindClass(String string, String string2) {
        return null;
    }

    public final URL getResource(String string) {
        ClassLoader classLoader;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        ClassLoader classLoader2 = classLoader = ProxyClassLoader.hacky(string2) ? null : (ClassLoader)this.domainsByPackage.get(string2);
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).findResource(string);
            }
            return classLoader.getResource(string);
        }
        URL uRL = null;
        int n2 = 0;
        while (n2 < this.parents.length) {
            classLoader = this.parents[n2];
            uRL = classLoader instanceof ProxyClassLoader ? ((ProxyClassLoader)classLoader).findResource(string) : classLoader.getResource(string);
            if (uRL != null) {
                this.domainsByPackage.put(string2.replace('/', '.'), classLoader);
                this.domainsByPackage.put(string2, classLoader);
                return uRL;
            }
            ++n2;
        }
        uRL = this.findResource(string);
        if (uRL != null) {
            this.domainsByPackage.put(string2.replace('/', '.'), this);
            this.domainsByPackage.put(string2, this);
        }
        return uRL;
    }

    protected URL findResource(String string) {
        return null;
    }

    protected final synchronized Enumeration findResources(String string) throws IOException {
        Enumeration enumeration = this.simpleFindResources(string);
        int n = this.parents.length - 1;
        while (n >= 0) {
            enumeration = new SequenceEnumeration(this.parents[n].getResources(string), enumeration);
            --n;
        }
        return new RemoveDuplicatesEnumeration(enumeration);
    }

    protected Enumeration simpleFindResources(String string) throws IOException {
        return super.findResources(string);
    }

    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Object object;
            Package package_ = (Package)this.packages.get(string);
            if (package_ != null) {
                Package package_2 = package_;
                return package_2;
            }
            int n = 0;
            while (n < this.parents.length) {
                object = this.parents[n];
                if (object instanceof ProxyClassLoader && (package_ = ((ProxyClassLoader)object).getPackage(string)) != null) break;
                ++n;
            }
            if (package_ == null) {
                package_ = super.getPackage(string);
            }
            if (package_ != null) {
                this.packages.put(string, package_);
            }
            object = package_;
            return object;
        }
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
            return package_;
        }
    }

    protected synchronized Package[] getPackages() {
        Object object;
        HashMap hashMap = new HashMap();
        this.addPackages(hashMap, super.getPackages());
        int n = 0;
        while (n < this.parents.length) {
            object = this.parents[n];
            if (object instanceof ProxyClassLoader) {
                this.addPackages(hashMap, ((ProxyClassLoader)object).getPackages());
            }
            ++n;
        }
        object = this.packages;
        synchronized (object) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (this.packages.containsKey(k)) continue;
                this.packages.put(k, entry.getValue());
            }
        }
        return hashMap.values().toArray(new Package[hashMap.size()]);
    }

    public Package getPackageAccessibly(String string) {
        return this.getPackage(string);
    }

    public Package[] getPackagesAccessibly() {
        return this.getPackages();
    }

    private ClassLoader[] coalesceParents(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        int n = classLoaderArray.length * 3 + 1;
        HashSet hashSet = new HashSet(n);
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < classLoaderArray.length) {
            this.addRec(hashSet, arrayList, classLoaderArray[n2]);
            ++n2;
        }
        ClassLoader[] classLoaderArray2 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray2;
    }

    private ClassLoader[] coalesceAppend(ClassLoader[] classLoaderArray, ClassLoader[] classLoaderArray2) throws IllegalArgumentException {
        int n = classLoaderArray.length + 3;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(n);
        List<ClassLoader> list = Arrays.asList(classLoaderArray);
        hashSet.addAll(list);
        if (hashSet.containsAll(Arrays.asList(classLoaderArray2))) {
            return classLoaderArray;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(n);
        arrayList.addAll(list);
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < classLoaderArray2.length) {
            this.addRec(hashSet, arrayList, classLoaderArray2[n3]);
            ++n3;
        }
        ClassLoader[] classLoaderArray3 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray3;
    }

    private void addRec(Set set, List list, ClassLoader classLoader) throws IllegalArgumentException {
        if (classLoader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (set.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof ProxyClassLoader) {
            ClassLoader[] classLoaderArray = ((ProxyClassLoader)classLoader).parents;
            int n = 0;
            while (n < classLoaderArray.length) {
                this.addRec(set, list, classLoaderArray[n]);
                ++n;
            }
        }
        set.add(classLoader);
        list.add(classLoader);
    }

    private final Class smartLoadClass(String string, int n) throws ClassNotFoundException {
        ClassLoader classLoader;
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = string.substring(0, n);
        String string3 = string.replace('.', '/').concat(".class");
        ClassLoader classLoader2 = classLoader = ProxyClassLoader.hacky(string2) ? null : (ClassLoader)this.domainsByPackage.get(string2);
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                if (classLoader == this) {
                    return this.simpleFindClass(string, string3);
                }
                return ((ProxyClassLoader)classLoader).fullFindClass(string, string3);
            }
            return classLoader.loadClass(string);
        }
        clazz = this.loadInOrder(string, string3);
        if (clazz != null) {
            ClassLoader classLoader3 = clazz.getClassLoader();
            this.domainsByPackage.put(string2, classLoader3);
            this.domainsByPackage.put(string2.replace('.', '/'), classLoader3);
        }
        return clazz;
    }

    private final Class loadInOrder(String string, String string2) throws ClassNotFoundException {
        Object object;
        ClassNotFoundException classNotFoundException = null;
        int n = 0;
        while (n < this.parents.length) {
            object = this.parents[n];
            if (object instanceof ProxyClassLoader) {
                Class clazz = ((ProxyClassLoader)object).fullFindClass(string, string2);
                if (clazz != null) {
                    return clazz;
                }
            } else {
                try {
                    return ((ClassLoader)object).loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    classNotFoundException = classNotFoundException2;
                }
            }
            ++n;
        }
        object = this.simpleFindClass(string, string2);
        if (object != null) {
            return object;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        return null;
    }

    private synchronized Class fullFindClass(String string, String string2) {
        Class clazz = this.findLoadedClass(string);
        return clazz == null ? this.simpleFindClass(string, string2) : clazz;
    }

    private void addPackages(Map map, Package[] packageArray) {
        int n = 0;
        while (n < packageArray.length) {
            map.put(packageArray[n].getName(), packageArray[n]);
            ++n;
        }
    }

    private static final boolean hacky(String string) {
        return string.equals("org.w3c.dom.events") || string.equals("org/w3c/dom/events");
    }
}

