/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.JarClassLoader;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.ProxyClassLoader;
import org.netbeans.core.modules.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

public final class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    private final ModuleManager mgr;
    private final Events ev;
    private final Object history;
    private final File jar;
    private File physicalJar = null;
    private boolean enabled;
    private boolean reloadable;
    private final boolean autoload;
    private Manifest manifest;
    private String codeNameBase;
    private int codeNameRelease;
    private Set dependencies;
    private SpecificationVersion specVers;
    private ClassLoader classloader = null;
    private Properties localizedProps;
    private static final Map extensionOwners = new HashMap();
    private final Set localeVariants = new HashSet();
    private final Set plainExtensions = new HashSet();
    private final Set localeExtensions = new HashSet();
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;

    Module(ModuleManager moduleManager, Events events, File file, Object object, boolean bl, boolean bl2) throws IOException {
        this.mgr = moduleManager;
        this.ev = events;
        this.jar = file;
        this.history = object;
        this.reloadable = bl;
        this.autoload = bl2;
        this.enabled = false;
        this.loadManifest();
        this.parseManifest();
    }

    Module(ModuleManager moduleManager, Events events, Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException {
        this.mgr = moduleManager;
        this.ev = events;
        this.manifest = manifest;
        this.history = object;
        this.classloader = classLoader;
        this.jar = null;
        this.reloadable = false;
        this.autoload = false;
        this.enabled = false;
        this.parseManifest();
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public Object getAttribute(String string) {
        return this.getManifest().getMainAttributes().getValue(string);
    }

    public Object getLocalizedAttribute(String string) {
        String string2;
        if (this.localizedProps != null && (string2 = this.localizedProps.getProperty(string)) != null) {
            return string2;
        }
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(string));
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        Attributes attributes = this.getManifest().getAttributes(string3);
        if (attributes != null) {
            return NbBundle.getLocalizedValue((Attributes)attributes, (Attributes.Name)new Attributes.Name(string4));
        }
        return null;
    }

    public String getCodeName() {
        return (String)this.getAttribute("OpenIDE-Module");
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    public boolean owns(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)classLoader)).getModule() == this;
        }
        return false;
    }

    private void parseManifest() throws InvalidException {
        Attributes attributes = this.manifest.getMainAttributes();
        String string = attributes.getValue("OpenIDE-Module");
        if (string == null) {
            throw new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + this.jar);
        }
        try {
            if (string.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + string);
            }
            Dependency.create((int)1, (String)string);
            int n = string.lastIndexOf(47);
            if (n == -1) {
                this.codeNameBase = string;
                this.codeNameRelease = -1;
            } else {
                this.codeNameBase = string.substring(0, n);
                this.codeNameRelease = Integer.parseInt(string.substring(n + 1));
            }
            String string2 = attributes.getValue("OpenIDE-Module-Specification-Version");
            if (string2 != null) {
                try {
                    this.specVers = new SpecificationVersion(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    InvalidException invalidException = new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + numberFormatException.toString());
                    Util.err.annotate((Throwable)invalidException, (Throwable)numberFormatException);
                    throw invalidException;
                }
            } else {
                this.specVers = null;
            }
            HashSet hashSet = new HashSet(20);
            hashSet.addAll(Dependency.create((int)4, (String)attributes.getValue("OpenIDE-Module-IDE-Dependencies")));
            hashSet.addAll(Dependency.create((int)3, (String)attributes.getValue("OpenIDE-Module-Java-Dependencies")));
            hashSet.addAll(Dependency.create((int)1, (String)attributes.getValue("OpenIDE-Module-Module-Dependencies")));
            hashSet.addAll(Dependency.create((int)2, (String)attributes.getValue("OpenIDE-Module-Package-Dependencies")));
            this.dependencies = Collections.unmodifiableSet(hashSet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidException invalidException = new InvalidException("While parsing a dependency attribute: " + illegalArgumentException.toString());
            Util.err.annotate((Throwable)invalidException, (Throwable)illegalArgumentException);
            throw invalidException;
        }
    }

    public File getJarFile() {
        return this.jar;
    }

    public boolean isFixed() {
        return this.jar == null;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (!this.physicalJar.delete()) {
                Util.err.log(16, "Warning: temporary JAR " + this.physicalJar + " not currently deletable.");
            } else {
                Util.err.log("deleted: " + this.physicalJar);
            }
            this.physicalJar = null;
        } else {
            Util.err.log("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    private void loadManifest() throws IOException {
        JarFile jarFile;
        Util.err.log("loading manifest of " + this.jar);
        if (this.reloadable) {
            this.ensurePhysicalJar();
            jarFile = new JarFile(this.physicalJar);
        } else {
            jarFile = new JarFile(this.jar);
        }
        try {
            Manifest manifest = jarFile.getManifest();
            this.findExtensionsAndVariants(manifest);
            this.loadLocalizedProps(jarFile, manifest);
            this.manifest = manifest;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    private void findExtensionsAndVariants(Manifest manifest) {
        this.localeVariants.clear();
        this.localeVariants.addAll(Util.findLocaleVariantsOf(this.jar, false));
        this.plainExtensions.clear();
        this.localeExtensions.clear();
        String string = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(this.jar.getParentFile(), string2.replace('/', File.separatorChar));
                if (!file.exists()) continue;
                Map map = extensionOwners;
                synchronized (map) {
                    HashSet<File> hashSet = (HashSet<File>)extensionOwners.get(file);
                    if (hashSet == null) {
                        hashSet = new HashSet<File>(2);
                        hashSet.add(this.jar);
                        extensionOwners.put(file, hashSet);
                    } else if (!hashSet.contains(this.jar)) {
                        hashSet.add(this.jar);
                        this.ev.log("extensionMultiplyLoaded", file, hashSet);
                    }
                }
                this.plainExtensions.add(file);
                this.localeExtensions.addAll(Util.findLocaleVariantsOf(file, false));
            }
        }
        Util.err.log("localeVariants of " + this.jar + ": " + this.localeVariants);
        Util.err.log("plainExtensions of " + this.jar + ": " + this.plainExtensions);
        Util.err.log("localeExtensions of " + this.jar + ": " + this.localeExtensions);
    }

    private void loadLocalizedProps(JarFile jarFile, Manifest manifest) throws IOException {
        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            String string2;
            int n;
            List list;
            Object object;
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                this.localizedProps = new Properties();
                object = jarFile.getInputStream(zipEntry);
                try {
                    this.localizedProps.load((InputStream)object);
                    list = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    ((InputStream)object).close();
                    throw throwable;
                }
                ((InputStream)object).close();
                {
                }
            }
            if ((n = string.lastIndexOf(46)) == -1) {
                object = string;
                string2 = "";
            } else {
                object = string.substring(0, n);
                string2 = string.substring(n);
            }
            list = Util.findLocaleVariantsOf(this.jar, true);
            Collections.reverse(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object var19_20;
                Object[] objectArray = (Object[])iterator.next();
                File file = (File)objectArray[0];
                String string3 = (String)objectArray[1];
                String string4 = (String)object + string3 + string2;
                JarFile jarFile2 = new JarFile(file);
                try {
                    ZipEntry zipEntry2 = jarFile2.getEntry(string4);
                    if (zipEntry2 != null) {
                        Object var17_19;
                        if (this.localizedProps == null) {
                            this.localizedProps = new Properties();
                        }
                        InputStream inputStream = jarFile2.getInputStream(zipEntry2);
                        try {
                            this.localizedProps.load(inputStream);
                            var17_19 = null;
                        }
                        catch (Throwable throwable) {
                            var17_19 = null;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                        {
                        }
                    }
                    var19_20 = null;
                }
                catch (Throwable throwable) {
                    var19_20 = null;
                    jarFile2.close();
                    throw throwable;
                }
                jarFile2.close();
                {
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + string);
            }
        }
    }

    public List getAllJars() {
        if (this.jar == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.reloadable ? this.physicalJar : this.jar);
        arrayList.addAll(this.plainExtensions);
        arrayList.addAll(this.localeVariants);
        arrayList.addAll(this.localeExtensions);
        return arrayList;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        if (this.isFixed()) {
            throw new IllegalStateException();
        }
        if (this.reloadable != bl) {
            this.reloadable = bl;
            this.mgr.fireReloadable(this);
        }
    }

    void reload() throws IOException {
        if (this.isFixed()) {
            throw new IllegalStateException();
        }
        this.destroyPhysicalJar();
        String string = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        String string2 = this.getCodeNameBase();
        if (!string.equals(string2)) {
            throw new InvalidException("Code name base changed during reload: " + string + " -> " + string2);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    void classLoaderUp(Set set) throws IOException {
        Object object;
        Object object2;
        if (this.isFixed()) {
            return;
        }
        Util.err.log("classLoaderUp on " + (Object)((Object)this) + " with parents " + set);
        ClassLoader[] classLoaderArray = new ClassLoader[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object2 = (Module)((Object)iterator.next());
            classLoaderArray[n++] = ((Module)((Object)object2)).getClassLoader();
        }
        object2 = new ArrayList(3);
        File file = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
        if (file.isDirectory()) {
            object = file.listFiles(Util.jarFilter());
            if (object != null) {
                int n2 = 0;
                while (n2 < ((File[])object).length) {
                    this.ev.log("patch", object[n2]);
                    object2.add(new JarFile(object[n2]));
                    ++n2;
                }
            } else {
                Util.err.log(16, "Could not search for patches in " + file);
            }
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            object2.add(new JarFile(this.physicalJar));
        } else {
            object2.add(new JarFile(this.jar));
        }
        iterator = this.localeVariants.iterator();
        while (iterator.hasNext()) {
            object2.add(new JarFile((File)iterator.next()));
        }
        iterator = this.localeExtensions.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            object2.add(((File)object).isDirectory() ? object : new JarFile((File)object));
        }
        iterator = this.plainExtensions.iterator();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            object2.add(((File)object).isDirectory() ? object : new JarFile((File)object));
        }
        try {
            this.classloader = new OneModuleClassLoader((List)object2, classLoaderArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException(illegalArgumentException.toString());
            Util.err.annotate((Throwable)iOException, (Throwable)illegalArgumentException);
            throw iOException;
        }
    }

    void classLoaderDown() {
        if (this.isFixed()) {
            return;
        }
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.log("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
        System.gc();
        if (!this.released) {
            Util.err.log("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.log("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Set getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + (Object)((Object)this));
        }
        if (this.isEnabled()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.mgr.missingDependencies(this));
    }

    final void firePropertyChange0(String string, Object object, Object object2) {
        if (Util.err.isLoggable(0)) {
            Util.err.log("Module.propertyChange: " + (Object)((Object)this) + " " + string + ": " + object + " -> " + object2);
        }
        this.firePropertyChange(string, object, object2);
    }

    public final Object getHistory() {
        return this.history;
    }

    public String toString() {
        String string = "Module[" + this.getCodeNameBase() + "]";
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    private class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider,
    Util.PackageAccessibleClassLoader {
        private int rc;

        public OneModuleClassLoader(List list, ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(list, classLoaderArray);
            this.rc = Module.this.releaseCount++;
        }

        public Module getModule() {
            return Module.this;
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return Module.getAllPermission();
        }

        protected String findLibrary(String string) {
            String string2 = System.mapLibraryName(string);
            File file = new File(new File(Module.this.jar.getParentFile(), "bin"), string2);
            if (file.isFile()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        public String toString() {
            return super.toString() + "[" + Module.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + Module.this.releaseCount + " released=" + Module.this.released);
            if (this.rc == Module.this.releaseCount) {
                Module.this.released = true;
            } else {
                Util.err.log("Now resources for " + Module.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

