/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Window;
import java.io.FileDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.netbeans.core.execution.AccController;
import org.netbeans.core.execution.ExecutionEngine;
import org.netbeans.core.execution.ExitSecurityException;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.TaskThreadGroup;
import org.openide.TopManager;
import org.openide.execution.NbClassLoader;

public class TopSecurityManager
extends SecurityManager {
    private ThreadGroup base = ExecutionEngine.base;
    private Permission allPermission = new AllPermission();
    private static final Class classLoaderClass;
    private static final Class nbClassLoaderClass;
    private static final Class URLClass;
    static URL URL_UNKNOWN;
    private static Field urlField;
    private static Class accessControllerClass;
    private static boolean check;
    static /* synthetic */ Class class$org$netbeans$core$execution$TopSecurityManager;

    public void checkExit(int n) throws SecurityException {
        if (!check) {
            return;
        }
        PrivilegedCheck.checkExit(n, this);
    }

    final void checkExitImpl(int n, AccessControlContext accessControlContext) throws SecurityException {
        IOPermissionCollection iOPermissionCollection = AccController.getIOPermissionCollection(accessControlContext);
        if (iOPermissionCollection != null && iOPermissionCollection.grp != null) {
            ExecutionEngine.getTaskIOs().free(iOPermissionCollection.grp, iOPermissionCollection.getIO());
            ExecutionEngine.closeGroup(iOPermissionCollection.grp);
            this.stopTaskThreadGroup(iOPermissionCollection.grp);
            throw new ExitSecurityException();
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup instanceof TaskThreadGroup) {
            throw new ExitSecurityException();
        }
        if (this.isNbClassLoader()) {
            throw new ExitSecurityException();
        }
        super.checkExit(n);
    }

    public boolean checkTopLevelWindow(Object object) {
        IOPermissionCollection iOPermissionCollection = AccController.getIOPermissionCollection();
        if (iOPermissionCollection != null && iOPermissionCollection.grp != null && object instanceof Window) {
            ExecutionEngine.putWindow((Window)object, iOPermissionCollection.grp);
        }
        return super.checkTopLevelWindow(object);
    }

    public void checkPackageAccess(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith("sun.") && (this.inClazz("sun.misc.Launcher") || this.inClazz("java.lang.Class"))) {
            return;
        }
        super.checkPackageAccess(string);
    }

    public final void checkPropertyAccess(String string) {
    }

    private boolean inClazz(String string) {
        Class<?>[] classArray = this.getClassContext();
        int n = 0;
        while (n < classArray.length && classArray[n] == (class$org$netbeans$core$execution$TopSecurityManager == null ? TopSecurityManager.class$("org.netbeans.core.execution.TopSecurityManager") : class$org$netbeans$core$execution$TopSecurityManager)) {
            ++n;
        }
        if (n == classArray.length) {
            return false;
        }
        return classArray[n].getName().startsWith(string);
    }

    private void stopTaskThreadGroup(TaskThreadGroup taskThreadGroup) {
        TaskThreadGroup taskThreadGroup2 = taskThreadGroup;
        synchronized (taskThreadGroup2) {
            int n = taskThreadGroup.activeCount();
            int n2 = -1;
            Thread thread = Thread.currentThread();
            Thread[] threadArray = new Thread[n];
            taskThreadGroup.enumerate(threadArray, true);
            int n3 = 0;
            while (n3 < threadArray.length) {
                if (threadArray[n3] == null) break;
                if (threadArray[n3] == thread) {
                    n2 = n3;
                } else {
                    threadArray[n3].stop();
                }
                ++n3;
            }
            if (n2 != -1) {
                threadArray[n2].stop();
            }
        }
    }

    public void checkRead(String string) {
    }

    public void checkRead(FileDescriptor fileDescriptor) {
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
    }

    public void checkDelete(String string) {
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException securityException) {
            super.checkDelete(string);
            return;
        }
    }

    public void checkWrite(String string) {
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException securityException) {
            super.checkWrite(string);
            return;
        }
    }

    public void checkConnect(String string, int n) {
        if (!check) {
            return;
        }
        try {
            this.checkPermission(this.allPermission);
            return;
        }
        catch (SecurityException securityException) {
            try {
                super.checkConnect(string, n);
                return;
            }
            catch (SecurityException securityException2) {
                PrivilegedCheck.checkConnect(string, n, this);
                return;
            }
        }
    }

    final void checkConnectImpl(String string, int n) {
        Class clazz = this.getInsecureClass();
        if (clazz != null) {
            URL uRL = TopSecurityManager.getClassURL(clazz);
            if (uRL == URL_UNKNOWN) {
                throw new SecurityException();
            }
            if (uRL != null) {
                try {
                    String string2 = uRL.getHost();
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    if (inetAddress.equals(inetAddress2)) {
                        return;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    TopManager.getDefault().getErrorManager().notify(4096, (Throwable)unknownHostException);
                }
            }
            throw new SecurityException();
        }
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
    }

    public void checkPermission(Permission permission) {
        TopSecurityManager.checkSetSecurityManager(permission);
        if (!check) {
            return;
        }
        super.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        TopSecurityManager.checkSetSecurityManager(permission);
        if (!check) {
            return;
        }
        super.checkPermission(permission, object);
    }

    private static void checkSetSecurityManager(Permission permission) {
        if (permission instanceof RuntimePermission && "setSecurityManager".equals(permission.getName())) {
            throw new SecurityException();
        }
    }

    protected boolean isNbClassLoader() {
        Class<?>[] classArray = this.getClassContext();
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n].getClassLoader() instanceof NbClassLoader && classArray[n].getProtectionDomain().getCodeSource() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class getInsecureClass() {
        Class<?>[] classArray = this.getClassContext();
        boolean bl = false;
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == TopSecurityManager.getAccessControllerClass()) {
                if (bl) {
                    return null;
                }
                bl = true;
            } else {
                ClassLoader classLoader = classArray[n].getClassLoader();
                if (classLoader != null) {
                    Class<?> clazz = classLoader.getClass();
                    if (!TopSecurityManager.isSecureClass(classArray[n])) return classArray[n];
                    if (classLoaderClass.isAssignableFrom(classArray[n])) {
                        return null;
                    }
                } else if (classLoaderClass.isAssignableFrom(classArray[n])) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    static boolean isSecureClass(Class clazz) {
        URL uRL = TopSecurityManager.getClassURL(clazz);
        if (uRL == URL_UNKNOWN) {
            return false;
        }
        if (uRL != null) {
            return TopSecurityManager.isSecureProtocol(uRL.getProtocol());
        }
        return true;
    }

    static URL getClassURL(Class clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL uRL = codeSource.getLocation();
            if (uRL != null) {
                return uRL;
            }
            ClassLoader classLoader = clazz.getClassLoader();
            Class<?> clazz2 = classLoader.getClass();
            if (clazz2.getName().indexOf("ice.iblite.BrowserClassLoader") >= 0) {
                try {
                    Field field = TopSecurityManager.getUrlField(clazz2);
                    if (field == null) {
                        return null;
                    }
                    return (URL)field.get(classLoader);
                }
                catch (Exception exception) {
                    TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
                }
            }
            return URL_UNKNOWN;
        }
        return null;
    }

    static Field getUrlField(Class clazz) {
        if (urlField == null) {
            try {
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = 0;
                while (n < fieldArray.length) {
                    if (fieldArray[n].getType() == URLClass) {
                        ((AccessibleObject)fieldArray[n]).setAccessible(true);
                        urlField = fieldArray[n];
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
            }
        }
        return urlField;
    }

    static boolean isSecureProtocol(String string) {
        return !string.equals("http") && !string.equals("ftp") && !string.equals("rmi");
    }

    static Class getAccessControllerClass() {
        if (accessControllerClass == null) {
            accessControllerClass = TopSecurityManager.forName("java.security.AccessController");
        }
        return accessControllerClass;
    }

    private static Class forName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)classNotFoundException);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            classLoaderClass = Class.forName("java.lang.ClassLoader");
            nbClassLoaderClass = Class.forName("org.openide.execution.NbClassLoader");
            URLClass = Class.forName("java.net.URL");
            TopSecurityManager.getAccessControllerClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError();
        }
        try {
            URL_UNKNOWN = new URL("http", "UNKNOWN", -1, "UNKNOWN");
        }
        catch (MalformedURLException malformedURLException) {
            ExceptionInInitializerError exceptionInInitializerError = new ExceptionInInitializerError();
            TopManager.getDefault().getErrorManager().annotate((Throwable)exceptionInInitializerError, (Throwable)malformedURLException);
            throw exceptionInInitializerError;
        }
        check = !Boolean.getBoolean("netbeans.security.nocheck");
    }

    private static final class PrivilegedCheck
    implements PrivilegedExceptionAction {
        int action;
        TopSecurityManager tsm;
        int status;
        AccessControlContext acc;
        String host;
        int port;

        public PrivilegedCheck(int n, TopSecurityManager topSecurityManager) {
            this.action = n;
            this.tsm = topSecurityManager;
            if (n == 0) {
                this.acc = AccessController.getContext();
            }
        }

        public Object run() throws Exception {
            switch (this.action) {
                case 0: {
                    this.tsm.checkExitImpl(this.status, this.acc);
                    break;
                }
                case 1: {
                    this.tsm.checkConnectImpl(this.host, this.port);
                    break;
                }
            }
            return null;
        }

        static void checkExit(int n, TopSecurityManager topSecurityManager) {
            PrivilegedCheck privilegedCheck = new PrivilegedCheck(0, topSecurityManager);
            privilegedCheck.status = n;
            PrivilegedCheck.check(privilegedCheck);
        }

        static void checkConnect(String string, int n, TopSecurityManager topSecurityManager) {
            PrivilegedCheck privilegedCheck = new PrivilegedCheck(1, topSecurityManager);
            privilegedCheck.host = string;
            privilegedCheck.port = n;
            PrivilegedCheck.check(privilegedCheck);
        }

        private static void check(PrivilegedCheck privilegedCheck) {
            try {
                AccessController.doPrivileged(privilegedCheck);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
            }
        }
    }
}

