/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.compiler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.compiler.CompilerTaskImpl;
import org.netbeans.core.output.OutputTabTerm;
import org.openide.TopManager;
import org.openide.compiler.CompilerListener;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ProgressEvent;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

final class CompilerDisplayer
implements CompilerListener,
ActionListener {
    private InputOutput compilerIO;
    private OutputWriter ow = null;
    private MessageFormat errorMsg;
    private MessageFormat errorDescr;
    private MessageFormat compilingMsg;
    private MessageFormat compSuccess;
    private MessageFormat compUnsuccess;
    private MessageFormat compStarted;
    private static String parsing;
    private static String generating;
    private static String writing;
    private static String cleaning;
    private Timer statusTextTimer;
    private String statusText;
    private ErrorCtl lastError;
    private boolean notSelected = true;
    int dispatcherCounts = 0;
    private long lastTime = 0L;
    static /* synthetic */ Class class$org$netbeans$core$compiler$CompilerDisplayer;

    public CompilerDisplayer() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$compiler$CompilerDisplayer == null ? (class$org$netbeans$core$compiler$CompilerDisplayer = CompilerDisplayer.class$("org.netbeans.core.compiler.CompilerDisplayer")) : class$org$netbeans$core$compiler$CompilerDisplayer));
        if (parsing == null) {
            parsing = resourceBundle.getString("MSG_StatusParsing");
            writing = resourceBundle.getString("MSG_StatusWriting");
            generating = resourceBundle.getString("MSG_StatusGenerating");
            cleaning = resourceBundle.getString("MSG_StatusCleaning");
        }
        this.errorMsg = new MessageFormat(resourceBundle.getString("MSG_CompileError"));
        this.errorDescr = new MessageFormat(resourceBundle.getString("MSG_CompileErrorDescr"));
        this.compilingMsg = new MessageFormat(resourceBundle.getString("MSG_Compiling"));
        this.compSuccess = new MessageFormat(resourceBundle.getString("MSG_CompilationSuccessful"));
        this.compUnsuccess = new MessageFormat(resourceBundle.getString("MSG_CompilationUnsuccessful"));
        this.compStarted = new MessageFormat(resourceBundle.getString("MSG_CompilationStarted"));
    }

    public void compilerProgress(ProgressEvent progressEvent) {
        String string = null;
        switch (progressEvent.getTask()) {
            case 1: {
                string = parsing;
                break;
            }
            case 3: {
                string = writing;
                break;
            }
            case 2: {
                string = generating;
                break;
            }
            case 4: {
                string = cleaning;
                break;
            }
            default: {
                string = parsing;
            }
        }
        if (string == null) {
            return;
        }
        Object[] objectArray = new Object[]{string, progressEvent.getFile().getPackageNameExt('/', '.')};
        String string2 = this.compilingMsg.format(objectArray);
        this.setStatusText(string2);
    }

    public void compilerError(ErrorEvent errorEvent) {
        SwingUtilities.invokeLater(new AWTDispatcher(errorEvent));
    }

    final synchronized void newDispatcher() {
        ++this.dispatcherCounts;
    }

    final synchronized void dispatcherEnd() {
        --this.dispatcherCounts;
        this.notify();
    }

    final synchronized void dispatcherWait() throws InterruptedException {
        while (this.dispatcherCounts > 0) {
            this.wait();
        }
    }

    private static Object[] taskToArgs(CompilerTaskImpl compilerTaskImpl) {
        return new Object[]{compilerTaskImpl.getDisplayName(), "".equals(compilerTaskImpl.getDisplayName()) ? new Integer(0) : new Integer(1)};
    }

    void compilationStarted(CompilerTaskImpl compilerTaskImpl) {
        this.initialize();
        this.setStatusText(this.compStarted.format(CompilerDisplayer.taskToArgs(compilerTaskImpl)));
        try {
            this.ow.reset();
            this.notSelected = true;
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
        }
        this.lastError = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compilationFinished(CompilerTaskImpl compilerTaskImpl, boolean bl) {
        try {
            try {
                this.initialize();
                MessageFormat messageFormat = compilerTaskImpl.isSuccessful() ? this.compSuccess : this.compUnsuccess;
                this.dispatcherWait();
                String string = messageFormat.format(CompilerDisplayer.taskToArgs(compilerTaskImpl));
                this.setStatusText(string);
                if (bl) {
                    this.println(NbBundle.getBundle((Class)(class$org$netbeans$core$compiler$CompilerDisplayer == null ? (class$org$netbeans$core$compiler$CompilerDisplayer = CompilerDisplayer.class$("org.netbeans.core.compiler.CompilerDisplayer")) : class$org$netbeans$core$compiler$CompilerDisplayer)).getString("MSG_UpToDate"));
                }
                this.println(string);
            }
            catch (InterruptedException interruptedException) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)interruptedException);
                Object var6_7 = null;
                AnnotationImpl annotationImpl2 = AnnotationImpl.getAnnotation();
                annotationImpl2.detach(null);
                if (!(this.compilerIO instanceof OutputTabTerm)) return;
                ((OutputTabTerm)this.compilerIO).setCompilationFinished();
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            AnnotationImpl annotationImpl = AnnotationImpl.getAnnotation();
            annotationImpl.detach(null);
            if (!(this.compilerIO instanceof OutputTabTerm)) throw throwable;
            ((OutputTabTerm)this.compilerIO).setCompilationFinished();
            throw throwable;
        }
        AnnotationImpl annotationImpl = AnnotationImpl.getAnnotation();
        annotationImpl.detach(null);
        if (!(this.compilerIO instanceof OutputTabTerm)) return;
        ((OutputTabTerm)this.compilerIO).setCompilationFinished();
    }

    private void initialize() {
        if (this.ow == null) {
            CompilerDisplayer compilerDisplayer = this;
            synchronized (compilerDisplayer) {
                this.setOw(NbBundle.getBundle((Class)(class$org$netbeans$core$compiler$CompilerDisplayer == null ? (class$org$netbeans$core$compiler$CompilerDisplayer = CompilerDisplayer.class$("org.netbeans.core.compiler.CompilerDisplayer")) : class$org$netbeans$core$compiler$CompilerDisplayer)).getString("CTL_CompileTab"));
            }
        }
    }

    private void setOw(String string) {
        if (this.ow != null) {
            return;
        }
        this.compilerIO = TopManager.getDefault().getIO(string);
        this.compilerIO.setFocusTaken(false);
        this.ow = this.compilerIO.getOut();
    }

    public void setStatusText(String string) {
        this.statusText = string;
        long l = System.currentTimeMillis();
        if (l - this.lastTime > 250L) {
            this.lastTime = this.lastTime;
            this.actionPerformed(null);
        } else {
            this.getStatusTextTimer().restart();
        }
    }

    private Timer getStatusTextTimer() {
        if (this.statusTextTimer == null) {
            this.statusTextTimer = new Timer(250, this);
            this.statusTextTimer.setRepeats(false);
        }
        return this.statusTextTimer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.statusText == null) {
            return;
        }
        TopManager.getDefault().setStatusText(CompilerDisplayer.oneLine(this.statusText));
        this.statusText = null;
        this.lastTime = System.currentTimeMillis();
    }

    private static String oneLine(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n' || c == '\r') {
                if (!bl) {
                    bl = true;
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(c);
                bl = false;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    final void println(String string) {
        if (this.lastError != null) {
            OutputController outputController = new OutputController(this.lastError);
            this.lastError = null;
            try {
                this.println(string, outputController);
            }
            catch (IOException iOException) {
                this.println(string);
            }
        } else {
            this.ow.println(string);
        }
    }

    final void println(String string, OutputListener outputListener) throws IOException {
        if (outputListener instanceof ErrorCtl) {
            this.lastError = (ErrorCtl)outputListener;
        }
        this.ow.println(string, outputListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class AnnotationImpl
    extends Annotation
    implements PropertyChangeListener {
        private static AnnotationImpl INSTANCE;
        private String text;
        private ErrorCtl currentCtl;

        AnnotationImpl() {
        }

        public static AnnotationImpl getAnnotation() {
            if (INSTANCE == null) {
                INSTANCE = new AnnotationImpl();
            }
            return INSTANCE;
        }

        public String getAnnotationType() {
            return "org-netbeans-core-compiler-error";
        }

        public String getShortDescription() {
            return this.text;
        }

        public void setShortDescription(String string) {
            this.text = string;
        }

        public void attach(ErrorCtl errorCtl, Line line) {
            if (this.currentCtl != null) {
                this.detach(this.currentCtl);
            }
            this.currentCtl = errorCtl;
            this.attach((Annotatable)line);
            line.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void detach(ErrorCtl errorCtl) {
            if (errorCtl == this.currentCtl || errorCtl == null) {
                this.currentCtl = null;
                Annotatable annotatable = this.getAttachedAnnotatable();
                if (annotatable != null) {
                    annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.detach();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("text".equals(propertyChangeEvent.getPropertyName())) {
                this.detach(null);
            }
        }
    }

    final class ErrorCtl
    implements OutputListener {
        FileObject file;
        Line xline;
        int column;
        private String text;
        private String shortMsg;
        static /* synthetic */ Class class$org$openide$cookies$LineCookie;

        public ErrorCtl(FileObject fileObject, int n, int n2, String string, String string2) throws IOException {
            this.file = fileObject;
            this.column = n2;
            DataObject dataObject = DataObject.find((FileObject)this.file);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = ErrorCtl.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (lineCookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = lineCookie.getLineSet().getOriginal(n);
            this.text = string;
            this.shortMsg = string2;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            AnnotationImpl annotationImpl = AnnotationImpl.getAnnotation();
            annotationImpl.setShortDescription(this.shortMsg);
            CompilerDisplayer.this.setStatusText(this.text);
            annotationImpl.attach(this, this.xline);
            this.xline.show(0, this.column);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            AnnotationImpl annotationImpl = AnnotationImpl.getAnnotation();
            annotationImpl.setShortDescription(this.shortMsg);
            CompilerDisplayer.this.setStatusText(this.text);
            annotationImpl.attach(this, this.xline);
            this.xline.show(2, this.column);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            AnnotationImpl annotationImpl = AnnotationImpl.getAnnotation();
            annotationImpl.detach(this);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    final class OutputController
    implements OutputListener {
        private ErrorCtl ctl;

        OutputController(ErrorCtl errorCtl) {
            this.ctl = errorCtl;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.ctl.outputLineSelected(outputEvent);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.ctl.outputLineAction(outputEvent);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }

    final class AWTDispatcher
    implements Runnable {
        private ErrorEvent ev;

        AWTDispatcher(ErrorEvent errorEvent) {
            this.ev = errorEvent;
            CompilerDisplayer.this.newDispatcher();
        }

        public void run() {
            CompilerDisplayer.this.initialize();
            if (CompilerDisplayer.this.notSelected) {
                CompilerDisplayer.this.notSelected = false;
                CompilerDisplayer.this.compilerIO.select();
            }
            if (this.ev.getFile() == null) {
                String string = this.ev.getMessage();
                if (!string.equals("")) {
                    if (string.startsWith("\n")) {
                        string = string.substring(1);
                    }
                    CompilerDisplayer.this.println(string);
                    CompilerDisplayer.this.ow.flush();
                }
                CompilerDisplayer.this.dispatcherEnd();
                return;
            }
            Object[] objectArray = new Object[]{this.ev.getFile().getPackageNameExt('/', '.'), new Integer(this.ev.getLine()), new Integer(this.ev.getColumn()), this.ev.getMessage()};
            String string = CompilerDisplayer.this.errorMsg.format(objectArray);
            try {
                int n = Math.max(this.ev.getLine() - 1, 0);
                Integer n2 = new Integer(n);
                ErrorCtl errorCtl = new ErrorCtl(this.ev.getFile(), n, Math.max(this.ev.getColumn() - 1, 0), string, this.ev.getMessage());
                CompilerDisplayer.this.println(string, errorCtl);
            }
            catch (IOException iOException) {
                CompilerDisplayer.this.println(string);
            }
            String string2 = this.ev.getReferenceText();
            if (string2 != null && !string2.equals("")) {
                if (string2.startsWith("\n")) {
                    string2 = string2.substring(1);
                }
                CompilerDisplayer.this.println(CompilerDisplayer.this.errorDescr.format(new Object[]{string2}));
            }
            CompilerDisplayer.this.dispatcherEnd();
        }
    }
}

