/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import org.netbeans.core.ControlPanelNode;
import org.netbeans.core.DataSystem;
import org.netbeans.core.EnvironmentNode;
import org.netbeans.core.LoaderPoolNode;
import org.netbeans.core.NbProjectOperation;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.PackageChildren;
import org.netbeans.core.modules.ManifestSection;
import org.netbeans.core.ui.LookupNode;
import org.netbeans.core.ui.MountNode;
import org.netbeans.core.windows.nodes.WorkspacePoolContext;
import org.openide.Places;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListener;

public final class NbPlaces
implements Places,
Places.Nodes,
Places.Folders {
    private static NbPlaces places;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    private NbPlaces() {
    }

    public static NbPlaces getDefault() {
        if (places == null) {
            places = new NbPlaces();
        }
        return places;
    }

    public Places.Nodes nodes() {
        return this;
    }

    public Places.Folders folders() {
        return this;
    }

    public Node repository() {
        return DataSystem.getDataSystem();
    }

    public Node repository(DataFilter dataFilter) {
        return DataSystem.getDataSystem(dataFilter);
    }

    public Node packages(DataFilter dataFilter) {
        return PackageChildren.createNode(dataFilter);
    }

    public Node loaderPool() {
        return LoaderPoolNode.getLoaderPoolNode();
    }

    public Node environment() {
        return EnvironmentNode.find("environment");
    }

    public Node session() {
        return EnvironmentNode.find("session");
    }

    public Node controlPanel() {
        return ControlPanelNode.getDefault();
    }

    public Node project() {
        return ControlPanelNode.getProjectSettings();
    }

    public Node workspaces() {
        return WorkspacePoolContext.getDefault();
    }

    public Node repositorySettings() {
        return new MountNode();
    }

    public Node projectDesktop() {
        return NbProjectOperation.getProjectDesktop();
    }

    public Node[] roots() {
        return EnvironmentNode.find("roots").getChildren().getNodes();
    }

    public DataFolder templates() {
        return NbPlaces.findSessionFolder("Templates");
    }

    public DataFolder toolbars() {
        return NbPlaces.findSessionFolder("Toolbars");
    }

    public DataFolder menus() {
        return NbPlaces.findSessionFolder("Menu");
    }

    public DataFolder actions() {
        return NbPlaces.findSessionFolder("Actions");
    }

    public DataFolder bookmarks() {
        return NbPlaces.findSessionFolder("Bookmarks");
    }

    public DataFolder projects() {
        return NbPlaces.findSessionFolder("Projects");
    }

    public DataFolder startup() {
        return NbPlaces.findSessionFolder("Startup");
    }

    public DataFolder welcome() {
        return NbPlaces.findSessionFolder("Welcome");
    }

    public DataFolder workplace() {
        return (DataFolder)TopManager.getDefault().getPlaces().nodes().projectDesktop().getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NbPlaces.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
    }

    public static synchronized DataFolder findSessionFolder(String string) {
        try {
            FileSystem fileSystem = NbTopManager.get().getRepository().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) {
                fileObject = fileSystem.getRoot().createFolder(string);
            }
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            return dataFolder;
        }
        catch (IOException iOException) {
            InternalError internalError = new InternalError("Folder not found and cannot be created: " + string);
            TopManager.getDefault().getErrorManager().annotate((Throwable)internalError, (Throwable)iOException);
            throw internalError;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Ch
    extends Children.Keys
    implements LookupListener,
    NodeListener {
        private Lookup.Result result;
        private String sectionName;
        private Node defaultNode;
        static /* synthetic */ Class class$org$openide$util$LookupListener;
        static /* synthetic */ Class class$org$netbeans$core$modules$ManifestSection$NodeSection;

        public Ch(String string) {
            this.sectionName = string;
        }

        protected void addNotify() {
            this.result = Ch.re(this.sectionName);
            this.result.addLookupListener((LookupListener)WeakListener.create((Class)(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = Ch.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener), (EventListener)((Object)this), (Object)this.result));
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.result = null;
        }

        private static Lookup.Result re(String string) {
            Lookup.Template template = new Lookup.Template(class$org$netbeans$core$modules$ManifestSection$NodeSection == null ? (class$org$netbeans$core$modules$ManifestSection$NodeSection = Ch.class$("org.netbeans.core.modules.ManifestSection$NodeSection")) : class$org$netbeans$core$modules$ManifestSection$NodeSection);
            return Lookup.getDefault().lookup(template);
        }

        public final void resultChanged(LookupEvent lookupEvent) {
            if (this.isInitialized()) {
                this.updateKeys();
            }
            if ("roots".equals(this.sectionName)) {
                NbTopManager.get().firePropertyChange("places", null, null);
            }
        }

        private void updateKeys() {
            ArrayList<String> arrayList = new ArrayList<String>(this.result.allInstances());
            arrayList.add(this.sectionName);
            this.setKeys(arrayList);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof String) {
                return this.defaultNodesForType((String)object);
            }
            ManifestSection.NodeSection nodeSection = (ManifestSection.NodeSection)object;
            try {
                String string = nodeSection.getType();
                if (string.equals(this.sectionName)) {
                    return new Node[]{(Node)nodeSection.getInstance()};
                }
                return new Node[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new Node[0];
            }
        }

        private Node[] defaultNodesForType(String string) {
            if (this.defaultNode == null) {
                this.defaultNode = "session".equals(string) ? new LookupNode(NbPlaces.findSessionFolder("UI/Services")) : Node.EMPTY;
                this.defaultNode.addNodeListener((NodeListener)this);
            }
            Node[] nodeArray = this.defaultNode.getChildren().getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                nodeArray[n] = new FilterNode(nodeArray[n]);
                ++n;
            }
            return nodeArray;
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.refreshKey(this.sectionName);
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.refreshKey(this.sectionName);
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.refreshKey(this.sectionName);
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

