/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.core.FileSelector;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class NbNodeOperation
extends TopManager.NodeOperation {
    private static final String PROP_LONGER_DISPLAY_NAME = "longerDisplayName";

    public void explore(final Node node) {
        Mutex.EVENT.readAccess(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$core$NbNodeOperation;

            public void run() {
                NbMainExplorer.ExplorerTab explorerTab = new NbMainExplorer.ExplorerTab();
                explorerTab.setRootContext(node);
                explorerTab.adjustComponentPersistence();
                WindowManagerImpl windowManagerImpl = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
                WorkspaceImpl workspaceImpl = (WorkspaceImpl)windowManagerImpl.getCurrentWorkspace();
                String string = WindowManagerImpl.findUnusedModeName(((Component)((Object)explorerTab)).getName(), workspaceImpl);
                workspaceImpl.createMode(string, NbBundle.getBundle((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = 1.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation)).getString("CTL_ExplorerTitle"), null, true).dockInto((TopComponent)explorerTab);
                explorerTab.open();
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public boolean customize(Node node) {
        final Component component = node.getCustomizer();
        if (component == null) {
            return false;
        }
        return (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){
            static /* synthetic */ Class class$org$netbeans$core$ModuleFSSection;

            public Object run() {
                if (component instanceof NbPresenter) {
                    ((NbPresenter)component).pack();
                    ((NbPresenter)component).show();
                    return Boolean.TRUE;
                }
                if (component instanceof Window) {
                    ((Window)component).pack();
                    component.setVisible(true);
                    return Boolean.TRUE;
                }
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, NbBundle.getMessage((Class)(class$org$netbeans$core$ModuleFSSection == null ? (class$org$netbeans$core$ModuleFSSection = 2.class$("org.netbeans.core.ModuleFSSection")) : class$org$netbeans$core$ModuleFSSection), (String)"CTL_Customizer_dialog_title"));
                dialogDescriptor.setOptions(new Object[]{NotifyDescriptor.CLOSED_OPTION});
                Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
                dialog.pack();
                dialog.show();
                return Boolean.TRUE;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public void showProperties(Node node) {
        Sheet sheet = new Sheet();
        sheet.setNodes(new Node[]{node});
        this.openProperties(sheet);
    }

    public void showProperties(Node[] nodeArray) {
        Sheet sheet = new Sheet();
        sheet.setNodes(nodeArray);
        this.openProperties(sheet);
    }

    public Node[] select(String string, String string2, Node node, NodeAcceptor nodeAcceptor, Component component) throws UserCancelException {
        final FileSelector fileSelector = new FileSelector(string, string2, node, nodeAcceptor, component);
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                fileSelector.show();
                return null;
            }
        });
        if (fileSelector.cancelFlag) {
            throw new UserCancelException();
        }
        return fileSelector.getNodes();
    }

    private void openProperties(final TopComponent topComponent) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (NbPresenter.currentModalDialog == null) {
                    WindowManagerImpl windowManagerImpl = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
                    WorkspaceImpl workspaceImpl = (WorkspaceImpl)windowManagerImpl.getCurrentWorkspace();
                    String string = WindowManagerImpl.findUnusedModeName(topComponent.getName(), workspaceImpl);
                    workspaceImpl.createMode(string, string, null, true).dockInto(topComponent);
                    topComponent.open();
                    topComponent.requestFocus();
                } else {
                    TopManager.getDefault().createDialog(new DialogDescriptor((Object)topComponent, topComponent.getName(), true, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.CLOSED_OPTION, 0, null, null)).show();
                }
            }
        });
    }

    public static class Sheet
    extends TopComponent {
        static final long serialVersionUID = 7807519514644165460L;
        private static Sheet sharedSheet;
        private transient Listener listener;
        private transient SheetNodesListener snListener;
        boolean global;
        private PropertySheet propertySheet;
        private Node[] nodes = new Node[0];
        private SettingsListener settingsListener;
        private static MessageFormat globalPropertiesFormat;
        private static MessageFormat localPropertiesFormat;
        static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;
        static /* synthetic */ Class class$org$netbeans$core$NbNodeOperation$Sheet;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;
        static /* synthetic */ Class class$org$netbeans$core$NbNodeOperation;

        public Sheet() {
            this(false);
        }

        public Sheet(boolean bl) {
            this.global = bl;
            this.propertySheet = new PropertySheet();
            ((JComponent)((Object)this)).putClientProperty("NamingType", "SDIOnlyCompName");
            ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
            ((Container)((Object)this)).setLayout(new BorderLayout());
            ((Container)((Object)this)).add((Component)this.propertySheet, "Center");
            this.setIcon(Utilities.loadImage((String)"org/netbeans/core/resources/frames/properties.gif"));
            this.listener = new Listener();
            this.snListener = new SheetNodesListener();
            this.settingsListener = new SettingsListener();
            PropertySheetSettings propertySheetSettings = (PropertySheetSettings)SharedClassObject.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = Sheet.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings));
            propertySheetSettings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.settingsListener, (Object)propertySheetSettings));
            this.updateGlobalListening(true);
        }

        public static Sheet getDefault() {
            if (sharedSheet == null) {
                sharedSheet = new Sheet(true);
            }
            return sharedSheet;
        }

        public HelpCtx getHelpCtx() {
            return ExplorerPanel.getHelpCtx((Node[])this.nodes, (HelpCtx)new HelpCtx(class$org$netbeans$core$NbNodeOperation$Sheet == null ? (class$org$netbeans$core$NbNodeOperation$Sheet = Sheet.class$("org.netbeans.core.NbNodeOperation$Sheet")) : class$org$netbeans$core$NbNodeOperation$Sheet));
        }

        public void requestFocus() {
            super.requestFocus();
            this.propertySheet.requestFocus();
        }

        public void open(Workspace workspace) {
            Workspace workspace2;
            Mode mode;
            if (this.global && (mode = (workspace2 = workspace == null ? TopManager.getDefault().getWindowManager().getCurrentWorkspace() : workspace).findMode((TopComponent)this)) == null) {
                Mode mode2 = workspace2.findMode("properties");
                if (mode2 == null) {
                    mode2 = workspace2.createMode("properties", NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = Sheet.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl)).getString("CTL_PropertiesWindow"), null);
                }
                mode2.dockInto((TopComponent)this);
            }
            super.open(workspace);
        }

        protected void updateTitle() {
            Object[] objectArray;
            Mode mode = TopManager.getDefault().getWindowManager().getCurrentWorkspace().findMode((TopComponent)this);
            String string = null;
            ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(this.nodes));
            FeatureDescriptor featureDescriptor = null;
            if (!arrayList.isEmpty()) {
                featureDescriptor = (Node)arrayList.get(0);
            }
            if (featureDescriptor == null) {
                string = "";
            } else {
                string = featureDescriptor.getDisplayName();
                objectArray = featureDescriptor.getValue(NbNodeOperation.PROP_LONGER_DISPLAY_NAME);
                if (objectArray instanceof String) {
                    string = (String)objectArray;
                }
            }
            objectArray = new Object[]{new Integer(arrayList.size()), string};
            if (mode != null && "properties".equals(mode.getName())) {
                if (globalPropertiesFormat == null) {
                    globalPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation), (String)"CTL_FMT_GlobalProperties"));
                }
                String string2 = globalPropertiesFormat.format(objectArray);
                this.setName(string2);
                ((JComponent)((Object)this)).setToolTipText(string2);
            } else {
                if (localPropertiesFormat == null) {
                    localPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation), (String)"CTL_FMT_LocalProperties"));
                }
                String string3 = localPropertiesFormat.format(objectArray);
                this.setName(string3);
                ((JComponent)((Object)this)).setToolTipText(string3);
            }
        }

        public void setNodes(Node[] nodeArray) {
            this.setNodesWithoutReattaching(nodeArray);
            this.snListener.detach();
            this.snListener.attach(nodeArray);
        }

        private void setNodesWithoutReattaching(Node[] nodeArray) {
            this.nodes = nodeArray;
            this.propertySheet.setNodes(nodeArray);
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Sheet this$0;
                {
                    this.this$0 = sheet;
                }

                public void run() {
                    this.this$0.updateTitle();
                }
            });
        }

        public Dimension getPreferredSize() {
            return new Dimension(250, 400);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            if (this.global) {
                objectOutput.writeObject(null);
            } else {
                Node.Handle[] handleArray = NodeOp.toHandles((Node[])this.nodes);
                objectOutput.writeObject(handleArray);
            }
            objectOutput.writeBoolean(this.global);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            try {
                super.readExternal(objectInput);
            }
            catch (SafeException safeException) {
                // empty catch block
            }
            Object object = objectInput.readObject();
            if (object instanceof NbMarshalledObject || object instanceof ExplorerManager) {
                this.global = (Boolean)objectInput.readObject();
            } else {
                Node[] nodeArray;
                if (object == null) {
                    nodeArray = TopComponent.getRegistry().getActivatedNodes();
                } else {
                    Node.Handle[] handleArray = (Node.Handle[])object;
                    try {
                        nodeArray = NodeOp.fromHandles((Node.Handle[])handleArray);
                    }
                    catch (IOException iOException) {
                        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                        errorManager.annotate((Throwable)iOException, NbBundle.getBundle((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation)).getString("EXC_CannotLoadNodes"));
                        errorManager.notify(1, (Throwable)iOException);
                        nodeArray = new Node[]{};
                    }
                }
                this.global = objectInput.readBoolean();
                this.setNodes(nodeArray);
            }
        }

        public Object readResolve() throws ObjectStreamException {
            if (this.global) {
                return Sheet.getDefault();
            }
            if (this.nodes == null || this.nodes.length <= 0) {
                return null;
            }
            return this;
        }

        protected Object writeReplace() throws ObjectStreamException {
            if (this.global) {
                return new Replacer();
            }
            return super.writeReplace();
        }

        private void updateGlobalListening(boolean bl) {
            if (this.global) {
                TopComponent.getRegistry().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.listener, (Object)TopComponent.getRegistry()));
                if (bl) {
                    this.listener.activate();
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static {
            globalPropertiesFormat = null;
            localPropertiesFormat = null;
        }

        private class SheetNodesListener
        extends NodeAdapter
        implements Runnable {
            private HashMap listenerMap;
            private HashMap pListenerMap;

            private SheetNodesListener() {
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                Node node = nodeEvent.getNode();
                NodeListener nodeListener = (NodeListener)this.listenerMap.get(node);
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.pListenerMap.get(node);
                node.removeNodeListener(nodeListener);
                node.removePropertyChangeListener(propertyChangeListener);
                this.listenerMap.remove(node);
                this.pListenerMap.remove(node);
                if (this.listenerMap.isEmpty() && !Sheet.this.global) {
                    Sheet.this.close();
                } else {
                    Sheet.this.setNodesWithoutReattaching(this.listenerMap.keySet().toArray(new Node[this.listenerMap.size()]));
                }
            }

            public void attach(Node[] nodeArray) {
                this.listenerMap = new HashMap(nodeArray.length * 2);
                this.pListenerMap = new HashMap(nodeArray.length * 2);
                NodeListener nodeListener = null;
                PropertyChangeListener propertyChangeListener = null;
                int n = 0;
                while (n < nodeArray.length) {
                    nodeListener = WeakListener.node((NodeListener)this, (Object)nodeArray[n]);
                    propertyChangeListener = WeakListener.propertyChange((PropertyChangeListener)((Object)this), (Object)nodeArray[n]);
                    this.listenerMap.put(nodeArray[n], nodeListener);
                    this.pListenerMap.put(nodeArray[n], propertyChangeListener);
                    nodeArray[n].addNodeListener(nodeListener);
                    nodeArray[n].addPropertyChangeListener(propertyChangeListener);
                    ++n;
                }
            }

            public void detach() {
                if (this.listenerMap == null) {
                    return;
                }
                Object var1_1 = null;
                Object var2_2 = null;
                Map.Entry entry = null;
                Iterator iterator = this.listenerMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    ((Node)entry.getKey()).removeNodeListener((NodeListener)entry.getValue());
                }
                Iterator iterator2 = this.pListenerMap.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    ((Node)entry.getKey()).removePropertyChangeListener((PropertyChangeListener)entry.getValue());
                }
                this.listenerMap = null;
                this.pListenerMap = null;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(this);
                }
            }

            public void run() {
                Sheet.this.updateTitle();
            }
        }

        final class SettingsListener
        implements PropertyChangeListener {
            SettingsListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == null) {
                    return;
                }
                if (string.equals("sortingMode")) {
                    try {
                        Sheet.this.propertySheet.setSortingMode(((Integer)propertyChangeEvent.getNewValue()).intValue());
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (string.equals("displayWritableOnly")) {
                    Sheet.this.propertySheet.setDisplayWritableOnly(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                } else if (string.equals("valueColor")) {
                    Sheet.this.propertySheet.setValueColor((Color)propertyChangeEvent.getNewValue());
                } else if (string.equals("disabledPropertyColor")) {
                    Sheet.this.propertySheet.setDisabledPropertyColor((Color)propertyChangeEvent.getNewValue());
                } else if (string.equals("plastic")) {
                    Sheet.this.propertySheet.setPlastic(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                } else if (string.equals("propertyPaintingStyle")) {
                    Sheet.this.propertySheet.setPropertyPaintingStyle(((Integer)propertyChangeEvent.getNewValue()).intValue());
                }
            }
        }

        private class Listener
        implements PropertyChangeListener {
            private Listener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("activatedNodes") && NbPresenter.currentModalDialog == null) {
                    this.activate();
                }
            }

            public void activate() {
                Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
                Sheet.this.setNodes(nodeArray);
            }
        }

        private static final class Replacer
        implements Serializable {
            static final long serialVersionUID = -7897067133215740572L;

            private Replacer() {
            }

            private Object readResolve() throws ObjectStreamException {
                return Sheet.getDefault();
            }
        }
    }
}

