/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.NotifyException;
import org.netbeans.core.execution.ExitSecurityException;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.util.NbBundle;

final class NbErrorManager
extends ErrorManager {
    private static Map map = new WeakHashMap(11);
    private PrintWriter logWriter = null;
    private static Map lastException = new WeakHashMap(27);
    private int minLogSeverity = 1;
    private String prefix = null;
    private static Map NESTS;
    static /* synthetic */ Class class$org$netbeans$core$NbErrorManager;
    static /* synthetic */ Class class$java$lang$Object;

    NbErrorManager() {
    }

    public synchronized Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
        LinkedList<Ann> linkedList;
        Object v = map.get(throwable);
        if (v == null) {
            linkedList = new LinkedList<Ann>();
            map.put(throwable, linkedList);
        } else {
            linkedList = (LinkedList<Ann>)v;
        }
        linkedList.add(0, new Ann(n, string, string2, throwable2, date));
        lastException.put(Thread.currentThread(), new WeakReference<Throwable>(throwable));
        return throwable;
    }

    public synchronized Throwable attachAnnotations(Throwable throwable, ErrorManager.Annotation[] annotationArray) {
        ArrayList<ErrorManager.Annotation> arrayList;
        Object v = map.get(throwable);
        if (v == null) {
            arrayList = new ArrayList<ErrorManager.Annotation>(annotationArray.length + 5);
            map.put(throwable, arrayList);
        } else {
            arrayList = (ArrayList<ErrorManager.Annotation>)v;
        }
        arrayList.addAll(0, Arrays.asList(annotationArray));
        lastException.put(Thread.currentThread(), new WeakReference<Throwable>(throwable));
        return throwable;
    }

    public synchronized void notify(int n, Throwable throwable) {
        Object object;
        Object object2;
        ErrorManager.Annotation[] annotationArray = this.findAnnotations(throwable);
        if (annotationArray == null && (object2 = (Reference)lastException.get(Thread.currentThread())) != null && (object = (Throwable)((Reference)object2).get()) != null) {
            annotationArray = this.findAnnotations((Throwable)object);
        }
        lastException.remove(Thread.currentThread());
        object2 = new Exc(throwable, n, annotationArray);
        object = this.getLogWriter();
        if (this.prefix != null) {
            ((PrintWriter)object).print("[" + this.prefix + "] ");
        }
        ((PrintWriter)object).println("*********** Exception occurred ************");
        ((PrintWriter)object).flush();
        if (System.getProperty("netbeans.debug.exceptions") != null) {
            PrintWriter printWriter = new PrintWriter(System.err);
            ((Exc)object2).printStackTrace(printWriter);
            printWriter.flush();
        } else {
            ((Exc)object2).printStackTrace((PrintWriter)object);
        }
        ((PrintWriter)object).flush();
        if (((Exc)object2).getSeverity() > 1) {
            NotifyException.notify((Exc)object2);
        }
    }

    public void log(int n, String string) {
        if (this.isLoggable(n)) {
            if (this.prefix != null) {
                this.getLogWriter().print("[" + this.prefix + "] ");
            }
            this.getLogWriter().println(string);
            this.getLogWriter().flush();
        }
    }

    public boolean isLoggable(int n) {
        return (n >>= 1) >= this.minLogSeverity;
    }

    public final ErrorManager getInstance(String string) {
        NbErrorManager nbErrorManager = new NbErrorManager();
        nbErrorManager.prefix = this.prefix == null ? string : this.prefix + '.' + string;
        nbErrorManager.minLogSeverity = this.minLogSeverity;
        String string2 = nbErrorManager.prefix;
        while (string2 != null) {
            String string3 = System.getProperty(string2);
            if (string3 != null) {
                try {
                    nbErrorManager.minLogSeverity = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.notify(16, numberFormatException);
                }
                break;
            }
            int n = string2.lastIndexOf(46);
            string2 = n == -1 ? null : string2.substring(0, n);
        }
        return nbErrorManager;
    }

    private static Throwable extractNestedThrowable(Throwable throwable) {
        Class clazz = class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager;
        synchronized (clazz) {
            if (NESTS == null) {
                NESTS = new HashMap(50);
                NESTS.put("java.lang.ClassNotFoundException", "getException");
                NESTS.put("java.lang.ExceptionInInitializerError", "getException");
                NESTS.put("java.lang.reflect.InvocationTargetException", "getTargetException");
                NESTS.put("java.lang.reflect.UndeclaredThrowableException", "getUndeclaredThrowable");
                NESTS.put("java.security.PrivilegedActionException", "getException");
                NESTS.put("javax.naming.NamingException", "getRootCause");
                NESTS.put("javax.xml.parsers.FactoryConfigurationError", "getException");
                NESTS.put("javax.xml.transform.TransformerException", "getException");
                NESTS.put("javax.xml.transform.TransformerFactoryConfigurationError", "getException");
                NESTS.put("org.openide.compiler.CompilerGroupException", ".exception");
                NESTS.put("org.openide.src.SourceException$IO", "getReason");
                NESTS.put("org.openide.src.SourceException$Veto", "getReason");
                NESTS.put("org.openide.src.SourceVetoException", "getNestedException");
                NESTS.put("org.openide.util.MutexException", "getException");
                NESTS.put("org.openide.util.io.OperationException", "getException");
                NESTS.put("org.openide.util.io.SafeException", "getException");
                NESTS.put("org.xml.sax.SAXException", "getException");
            }
        }
        Class<?> clazz2 = throwable.getClass();
        while (clazz2 != (class$java$lang$Object == null ? NbErrorManager.class$("java.lang.Object") : class$java$lang$Object)) {
            String string = (String)NESTS.get(clazz2.getName());
            if (string != null) {
                try {
                    if (string.startsWith(".")) {
                        Field field = clazz2.getField(string.substring(1));
                        return (Throwable)field.get(throwable);
                    }
                    Method method = clazz2.getMethod(string, null);
                    return (Throwable)method.invoke((Object)throwable, null);
                }
                catch (Exception exception) {
                    System.err.println("From throwable class: " + clazz2.getName());
                    exception.printStackTrace();
                }
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    public synchronized ErrorManager.Annotation[] findAnnotations(Throwable throwable) {
        Object object;
        ArrayList<Ann> arrayList = (ArrayList<Ann>)map.get(throwable);
        if (throwable instanceof MissingResourceException) {
            String string;
            arrayList = arrayList == null ? new ArrayList<Ann>(1) : new ArrayList(arrayList);
            object = (MissingResourceException)throwable;
            String string2 = object.getClassName();
            if (string2 != null) {
                arrayList.add(new Ann(4096, NbBundle.getMessage((Class)(class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager), (String)"EXC_MissingResourceException_class_name", (Object)string2), null, null, null));
            }
            if ((string = object.getKey()) != null) {
                arrayList.add(new Ann(4096, NbBundle.getMessage((Class)(class$org$netbeans$core$NbErrorManager == null ? (class$org$netbeans$core$NbErrorManager = NbErrorManager.class$("org.netbeans.core.NbErrorManager")) : class$org$netbeans$core$NbErrorManager), (String)"EXC_MissingResourceException_key", (Object)string), null, null, null));
            }
            if (arrayList.size() == 0) {
                arrayList = null;
            }
        } else {
            object = NbErrorManager.extractNestedThrowable(throwable);
            if (object != null) {
                arrayList = arrayList == null ? new ArrayList(1) : new ArrayList(arrayList);
                arrayList.add(new Ann(0, null, null, (Throwable)object, null));
            }
        }
        if (arrayList == null) {
            object = null;
        } else {
            object = new ErrorManager.Annotation[arrayList.size()];
            arrayList.toArray((T[])object);
        }
        return object;
    }

    private PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = NbTopManager.get().createErrorLogger(this.minLogSeverity);
        }
        return this.logWriter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.NbErrorManager$AWTHandler");
        NESTS = null;
    }

    public static final class AWTHandler {
        public static void handle(Throwable throwable) {
            if (throwable instanceof ExitSecurityException) {
                return;
            }
            TopManager.getDefault().getErrorManager().notify(131072, throwable);
        }
    }

    final class Exc {
        private Throwable t;
        private ErrorManager.Annotation[] arr;
        private int severity;

        public Exc(Throwable throwable, int n, ErrorManager.Annotation[] annotationArray) {
            this.t = throwable;
            this.severity = n;
            this.arr = annotationArray == null ? new ErrorManager.Annotation[]{} : annotationArray;
        }

        public String getMessage() {
            return (String)this.find(1);
        }

        public String getLocalizedMessage() {
            return (String)this.find(2);
        }

        public boolean isLocalized() {
            if (this.find(2, false) == null) {
                String string = this.getLocalizedMessage();
                return string != null && !string.equals(this.getMessage());
            }
            return true;
        }

        public String getClassName() {
            return (String)this.find(3);
        }

        public int getSeverity() {
            if (this.severity != 0) {
                return this.severity;
            }
            int n = 0;
            while (n < this.arr.length) {
                int n2 = this.arr[n].getSeverity();
                if (n2 > this.severity) {
                    this.severity = n2;
                }
                ++n;
            }
            if (this.severity == 0) {
                this.severity = this.t instanceof Error ? 65536 : 4096;
            }
            return this.severity;
        }

        public Date getDate() {
            return (Date)this.find(4);
        }

        public void printStackTrace(PrintWriter printWriter) {
            this.printStackTrace(printWriter, new HashSet(10));
        }

        private void printStackTrace(PrintWriter printWriter, Set set) {
            Object object;
            Object object2;
            if (this.t != null && !set.add(this.t)) {
                NbErrorManager.this.log(16, "WARNING - ErrorManager detected cyclic exception nesting:");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Throwable throwable = (Throwable)iterator.next();
                    NbErrorManager.this.log(16, "\t" + throwable);
                    ErrorManager.Annotation[] annotationArray = NbErrorManager.this.findAnnotations(throwable);
                    if (annotationArray == null) continue;
                    int n = 0;
                    while (n < annotationArray.length) {
                        Throwable throwable2 = annotationArray[n].getStackTrace();
                        if (throwable2 != null) {
                            NbErrorManager.this.log(16, "\t=> " + throwable2);
                        }
                        ++n;
                    }
                }
                NbErrorManager.this.log(16, "Be sure not to annotate an exception with itself, directly or indirectly.");
                return;
            }
            printWriter.print(this.getDate());
            printWriter.print(": ");
            printWriter.print(this.getClassName());
            printWriter.print(": ");
            String string = this.getMessage();
            if (string != null) {
                printWriter.print(string);
            } else {
                printWriter.print("<no message>");
            }
            printWriter.println();
            int n = 0;
            while (n < this.arr.length) {
                if (this.arr[n] != null) {
                    object2 = this.arr[n].getStackTrace();
                    object = this.arr[n].getLocalizedMessage();
                    if (object == null) {
                        object = this.arr[n].getMessage();
                    }
                    if (object == null && object2 != null) {
                        object = ((Throwable)object2).getLocalizedMessage();
                    }
                    if (object == null && object2 != null) {
                        object = ((Throwable)object2).getMessage();
                    }
                    if (object != null) {
                        if (object2 != null) {
                            printWriter.println("Nested annotation: " + (String)object);
                        } else {
                            printWriter.println("Annotation: " + (String)object);
                        }
                    }
                }
                ++n;
            }
            object2 = this.decompose(this.t);
            object = this.decompose(new Throwable());
            int n2 = -1;
            int n3 = 1;
            while (n3 <= Math.min(((String[])object2).length, ((String[])object).length)) {
                if (!((String)object2[((Object)object2).length - n3]).equals(object[((String[])object).length - n3])) {
                    n2 = ((Object)object2).length - n3;
                    break;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < ((Object)object2).length) {
                if (n4 == n2) {
                    printWriter.print("[catch]");
                    if (((String)object2[n4]).charAt(0) == '\t') {
                        printWriter.print(' ');
                        object2[n4] = ((String)object2[n4]).substring(1);
                    }
                }
                printWriter.println((String)object2[n4]);
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.arr.length) {
                Throwable throwable;
                if (this.arr[n5] != null && (throwable = this.arr[n5].getStackTrace()) != null) {
                    ErrorManager.Annotation[] annotationArray = NbErrorManager.this.findAnnotations(throwable);
                    Exc exc = new Exc(throwable, 0, annotationArray);
                    printWriter.println();
                    exc.printStackTrace(printWriter, set);
                }
                ++n5;
            }
        }

        private String[] decompose(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n\r");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            return stringArray;
        }

        private Object find(int n) {
            return this.find(n, true);
        }

        private Object find(int n, boolean bl) {
            int n2 = 0;
            while (n2 < this.arr.length) {
                ErrorManager.Annotation annotation = this.arr[n2];
                Object object = null;
                switch (n) {
                    case 1: {
                        object = annotation.getMessage();
                        break;
                    }
                    case 2: {
                        object = annotation.getLocalizedMessage();
                        break;
                    }
                    case 3: {
                        Throwable throwable = annotation.getStackTrace();
                        object = throwable == null ? null : throwable.getClass().getName();
                        break;
                    }
                    case 4: {
                        object = annotation.getDate();
                    }
                }
                if (object != null) {
                    return object;
                }
                ++n2;
            }
            if (!bl) {
                return null;
            }
            switch (n) {
                case 1: {
                    return this.t.getMessage();
                }
                case 2: {
                    return this.t.getLocalizedMessage();
                }
                case 3: {
                    return this.t.getClass().getName();
                }
                case 4: {
                    return new Date();
                }
            }
            throw new IllegalArgumentException("Unknown " + new Integer(n));
        }
    }

    private static final class Ann
    implements ErrorManager.Annotation {
        private int severity;
        private String message;
        private String localizedMessage;
        private Throwable stackTrace;
        private Date date;

        public Ann(int n, String string, String string2, Throwable throwable, Date date) {
            this.severity = n;
            this.message = string;
            this.localizedMessage = string2;
            this.stackTrace = throwable;
            this.date = date;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage;
        }

        public Throwable getStackTrace() {
            return this.stackTrace;
        }

        public Date getDate() {
            return this.date;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

