/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.netbeans.core.modules.ManifestSection;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.InstanceSupport;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;

public final class LoaderPoolNode
extends AbstractNode {
    private static final String LOADER_POOL_ICON_BASE = "/org/netbeans/core/resources/loaderPool";
    private static LoaderPoolNode loaderPoolNode;
    private static final ErrorManager err;
    private static NbLoaderPool loaderPool;
    private static LoaderChildren myChildren;
    private static List loaders;
    private static Map installBefores;
    private static Map installAfters;
    private static Object[] loadersArray;
    private static boolean installationFinished;
    static /* synthetic */ Class class$org$netbeans$core$LoaderPoolNode;
    static /* synthetic */ Class class$org$openide$actions$CustomizeBeanAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private LoaderPoolNode() {
        super((Children)new LoaderChildren());
        myChildren = (LoaderChildren)this.getChildren();
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode)).getString("CTL_LoaderPool"));
        this.setIconBase(LOADER_POOL_ICON_BASE);
        this.getCookieSet().add((Node.Cookie)new Index());
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)LoaderPoolNode.getNbLoaderPool()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$CustomizeBeanAction == null ? (class$org$openide$actions$CustomizeBeanAction = LoaderPoolNode.class$("org.openide.actions.CustomizeBeanAction")) : class$org$openide$actions$CustomizeBeanAction)), null, SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = LoaderPoolNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public static void add(ManifestSection.LoaderSection loaderSection) throws Exception {
        DataLoader dataLoader = (DataLoader)loaderSection.getInstance();
        LoaderPoolNode.doAdd(dataLoader, loaderSection);
    }

    private static synchronized void doAdd(DataLoader dataLoader, ManifestSection.LoaderSection loaderSection) throws Exception {
        Iterator iterator;
        if (err.isLoggable(0)) {
            iterator = loaderSection.getInstallBefore() == null ? null : Arrays.asList(loaderSection.getInstallBefore());
            List<String> list = loaderSection.getInstallAfter() == null ? null : Arrays.asList(loaderSection.getInstallAfter());
            err.log("add: " + dataLoader + " repclass: " + dataLoader.getRepresentationClass().getName() + " before: " + iterator + " after: " + list);
        }
        iterator = loaders.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getClass().equals(dataLoader.getClass())) continue;
            iterator.remove();
        }
        loaders.add(dataLoader);
        dataLoader.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        dataLoader.addPropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
        installBefores.put(dataLoader.getClass().getName(), loaderSection.getInstallBefore());
        installAfters.put(dataLoader.getClass().getName(), loaderSection.getInstallAfter());
        LoaderPoolNode.resort();
    }

    private static synchronized void resort() {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                String[] stringArray;
                String[] stringArray2;
                if (object == object2) {
                    return 0;
                }
                String string = object.getClass().getName();
                String string2 = object2.getClass().getName();
                String string3 = ((DataLoader)object).getRepresentationClass().getName();
                String string4 = ((DataLoader)object2).getRepresentationClass().getName();
                boolean bl = false;
                String[] stringArray3 = (String[])installBefores.get(string);
                if (stringArray3 != null) {
                    int n = 0;
                    while (n < stringArray3.length) {
                        if (stringArray3[n].equals(string4)) {
                            bl = true;
                            break;
                        }
                        if (stringArray3[n].equals(string2)) {
                            this.warn(string, string2, string4);
                        }
                        ++n;
                    }
                }
                if (!bl && (stringArray2 = (String[])installAfters.get(string2)) != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        if (stringArray2[n].equals(string3)) {
                            bl = true;
                            break;
                        }
                        if (stringArray2[n].equals(string)) {
                            this.warn(string2, string, string3);
                        }
                        ++n;
                    }
                }
                boolean bl2 = false;
                String[] stringArray4 = (String[])installBefores.get(string2);
                if (stringArray4 != null) {
                    int n = 0;
                    while (n < stringArray4.length) {
                        if (stringArray4[n].equals(string3)) {
                            bl2 = true;
                            break;
                        }
                        if (stringArray4[n].equals(string)) {
                            this.warn(string2, string, string3);
                        }
                        ++n;
                    }
                }
                if (!bl2 && (stringArray = (String[])installAfters.get(string)) != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equals(string4)) {
                            bl2 = true;
                            break;
                        }
                        if (stringArray[n].equals(string2)) {
                            this.warn(string, string2, string4);
                        }
                        ++n;
                    }
                }
                if (bl) {
                    if (bl2) {
                        err.log(256, "Warning: mutually contradictory loader ordering will be ignored; " + string + " and " + string2);
                        return 0;
                    }
                    return -1;
                }
                if (bl2) {
                    return 1;
                }
                return 0;
            }

            private void warn(String string, String string2, String string3) {
                err.log(256, "Warning: a possible error in the manifest containing " + string + " was found.");
                err.log(256, "The loader specified an Install-{After,Before} on " + string2 + ", but this is a DataLoader class.");
                err.log(256, "Probably you wanted " + string3 + " which is the loader's representation class.");
            }
        };
        if (err.isLoggable(0)) {
            err.log("Before sort: " + loaders);
        }
        try {
            loaders = Utilities.partialSort((List)loaders, (Comparator)comparator, (boolean)true);
        }
        catch (Utilities.UnorderableException unorderableException) {
            err.notify(16, (Throwable)unorderableException);
        }
        if (err.isLoggable(0)) {
            err.log("After sort: " + loaders);
        }
        LoaderPoolNode.update();
    }

    static void installationFinished() {
        installationFinished = true;
        if (myChildren != null) {
            myChildren.update();
        }
    }

    private static synchronized void writePool(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        NbMarshalledObject nbMarshalledObject;
        Object object2;
        err.log("writePool");
        objectOutputStream.writeObject(installBefores);
        objectOutputStream.writeObject(installAfters);
        Collection collection = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = LoaderPoolNode.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances();
        Iterator iterator = loaders.iterator();
        while (iterator.hasNext()) {
            object2 = (DataLoader)iterator.next();
            try {
                nbMarshalledObject = new NbMarshalledObject(object2);
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
                nbMarshalledObject = null;
            }
            if (nbMarshalledObject == null) continue;
            err.log("writing " + object2.getDisplayName());
            object = object2.getClass();
            Iterator iterator2 = collection.iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator2.next();
                if (!moduleInfo.isEnabled() || !moduleInfo.owns((Class)object)) continue;
                err.log("belongs to module: " + moduleInfo.getDisplayName());
                objectOutputStream.writeObject(moduleInfo.getCodeNameBase());
                int n = moduleInfo.getCodeNameRelease();
                objectOutputStream.writeInt(n);
                SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
                if (specificationVersion != null) {
                    objectOutputStream.writeObject(specificationVersion.toString());
                } else {
                    objectOutputStream.writeObject(null);
                }
                bl = true;
                break;
            }
            if (!bl) {
                err.log("does not belong to any module");
            }
            objectOutputStream.writeObject(nbMarshalledObject);
        }
        err.log("writing null");
        objectOutputStream.writeObject(null);
        object2 = loaderPool.allLoaders();
        while (object2.hasMoreElements()) {
            nbMarshalledObject = (DataLoader)object2.nextElement();
            if (loaders.contains(nbMarshalledObject)) continue;
            try {
                object = new NbMarshalledObject((Object)nbMarshalledObject);
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
                object = null;
            }
            if (object == null) continue;
            err.log("writing " + nbMarshalledObject.getDisplayName());
            objectOutputStream.writeObject(object);
        }
        err.log("writing null");
        objectOutputStream.writeObject(null);
        err.log("done writing");
    }

    private static synchronized void readPool(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Iterator iterator;
        Map map = installBefores;
        Map map2 = installAfters;
        installBefores = (Map)objectInputStream.readObject();
        installAfters = (Map)objectInputStream.readObject();
        installBefores.putAll(map);
        installAfters.putAll(map2);
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object3 = null;
        Iterator iterator2 = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = LoaderPoolNode.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo)).allInstances().iterator();
        HashMap hashMap = new HashMap();
        while (iterator2.hasNext()) {
            iterator = (ModuleInfo)iterator2.next();
            hashMap.put(iterator.getCodeNameBase(), iterator);
        }
        while (true) {
            Object object4;
            if ((iterator = objectInputStream.readObject()) == null) break;
            if (iterator instanceof String) {
                SpecificationVersion specificationVersion;
                object2 = (String)((Object)iterator);
                int n = objectInputStream.readInt();
                object4 = (String)objectInputStream.readObject();
                object = (NbMarshalledObject)objectInputStream.readObject();
                ModuleInfo moduleInfo = (ModuleInfo)hashMap.get(object2);
                if (moduleInfo == null) {
                    err.log("No known module " + (String)object2 + ", skipping loader");
                    continue;
                }
                if (!moduleInfo.isEnabled()) {
                    err.log("Module " + (String)object2 + " is disabled, skipping loader");
                    continue;
                }
                if (moduleInfo.getCodeNameRelease() < n) {
                    err.log("Module " + (String)object2 + " is too old (major vers.), skipping loader");
                    continue;
                }
                if (object4 != null && ((specificationVersion = moduleInfo.getSpecificationVersion()) == null || specificationVersion.compareTo((Object)new SpecificationVersion((String)object4)) < 0)) {
                    err.log("Module " + (String)object2 + " is too old (spec. vers.), skipping loader");
                    continue;
                }
                err.log("Module " + (String)object2 + " is OK, will try to restore loader");
            } else {
                object = (NbMarshalledObject)iterator;
            }
            object2 = null;
            try {
                DataLoader dataLoader = (DataLoader)object.get();
                object4 = dataLoader.getClass();
                err.log("reading " + dataLoader.getDisplayName() + " [" + ((Class)object4).getName() + "]");
                linkedList.add(dataLoader);
                hashSet.add(object4);
            }
            catch (IOException iOException) {
                object2 = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = classNotFoundException;
            }
            if (object2 == null) continue;
            TopManager.getDefault().getErrorManager().annotate((Throwable)object2, 16, null, null, null, null);
            if (object3 == null) {
                object3 = object2;
                continue;
            }
            TopManager.getDefault().getErrorManager().annotate((Throwable)object3, (Throwable)object2);
        }
        err.log("reading null");
        while (true) {
            if ((iterator = (NbMarshalledObject)objectInputStream.readObject()) == null) break;
            object = null;
            try {
                object2 = (DataLoader)iterator.get();
                err.log("reading " + object2.getDisplayName());
            }
            catch (IOException iOException) {
                object = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = classNotFoundException;
            }
            if (object == null) continue;
            TopManager.getDefault().getErrorManager().annotate((Throwable)object, 16, null, null, null, null);
            if (object3 == null) {
                object3 = object;
                continue;
            }
            TopManager.getDefault().getErrorManager().annotate((Throwable)object3, (Throwable)object);
        }
        err.log("reading null");
        err.log("done reading");
        iterator = loaders.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object2 = (DataLoader)iterator.next();
            if (hashSet.contains(object2.getClass())) continue;
            linkedList.add(object2);
            bl = true;
        }
        loaders = linkedList;
        if (bl) {
            LoaderPoolNode.resort();
        } else {
            LoaderPoolNode.update();
        }
        if (object3 != null) {
            throw new SafeException((Exception)object3);
        }
    }

    private static synchronized void update() {
        err.log("update");
        loadersArray = null;
        if (loaderPool != null && installationFinished) {
            loaderPool.superFireChangeEvent();
            if (myChildren != null) {
                myChildren.update();
            }
        }
    }

    public static synchronized boolean remove(DataLoader dataLoader) {
        if (loaders.remove(dataLoader)) {
            err.log("remove: " + dataLoader);
            installBefores.remove(dataLoader.getClass().getName());
            installAfters.remove(dataLoader.getClass().getName());
            dataLoader.removePropertyChangeListener((PropertyChangeListener)LoaderPoolNode.getNbLoaderPool());
            LoaderPoolNode.resort();
            return true;
        }
        return false;
    }

    public static synchronized LoaderPoolNode getLoaderPoolNode() {
        if (loaderPoolNode == null) {
            loaderPoolNode = new LoaderPoolNode();
        }
        return loaderPoolNode;
    }

    public static NbLoaderPool getNbLoaderPool() {
        if (loaderPool == null) {
            loaderPool = new NbLoaderPool();
        }
        return loaderPool;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Object[] access$602(Object[] objectArray) {
        loadersArray = objectArray;
        return objectArray;
    }

    static {
        err = TopManager.getDefault().getErrorManager().getInstance("org.netbeans.core.LoaderPoolNode");
        loaders = new ArrayList();
        installBefores = new HashMap();
        installAfters = new HashMap();
        installationFinished = false;
    }

    private final class Index
    extends Index.Support {
        static /* synthetic */ Class class$org$netbeans$core$LoaderPoolNode;

        private Index() {
        }

        public Node[] getNodes() {
            Enumeration enumeration = LoaderPoolNode.this.getChildren().nodes();
            ArrayList<LoaderPoolItemNode> arrayList = new ArrayList<LoaderPoolItemNode>();
            while (enumeration.hasMoreElements()) {
                LoaderPoolItemNode loaderPoolItemNode = (LoaderPoolItemNode)((Object)enumeration.nextElement());
                if (loaderPoolItemNode.isSystem) continue;
                arrayList.add(loaderPoolItemNode);
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        public int getNodesCount() {
            return this.getNodes().length;
        }

        public void reorder(int[] nArray) {
            Class clazz = class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = Index.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode;
            synchronized (clazz) {
                Object[] objectArray;
                Object[] objectArray2 = loaders.toArray();
                if (objectArray2.length == nArray.length) {
                    objectArray = new Object[objectArray2.length];
                    int n = 0;
                    while (n < objectArray2.length) {
                        if (objectArray[nArray[n]] != null) {
                            throw new IllegalArgumentException();
                        }
                        objectArray[nArray[n]] = objectArray2[n];
                        ++n;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                loaders = new ArrayList<Object>(Arrays.asList(objectArray));
                LoaderPoolNode.update();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static final class NbLoaderPool
    extends DataLoaderPool
    implements PropertyChangeListener,
    Runnable {
        private static final long serialVersionUID = -8488524097175567566L;
        private RequestProcessor.Task fireTask = RequestProcessor.createRequest((Runnable)this);
        static /* synthetic */ Class class$org$netbeans$core$LoaderPoolNode;

        protected Enumeration loaders() {
            Object[] objectArray = loadersArray;
            if (objectArray == null) {
                Class clazz = class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = NbLoaderPool.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode;
                synchronized (clazz) {
                    objectArray = LoaderPoolNode.access$602(loaders.toArray());
                }
            }
            return new ArrayEnumeration(objectArray);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("actions".equals(string) || "displayName".equals(string)) {
                return;
            }
            if (installationFinished) {
                this.superFireChangeEvent();
            }
        }

        void superFireChangeEvent() {
            this.fireTask.schedule(1000);
        }

        public void run() {
            super.fireChangeEvent(new ChangeEvent(this));
            err.log("change event fired");
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            LoaderPoolNode.writePool(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            LoaderPoolNode.readPool(objectInputStream);
        }

        private Object readResolve() {
            return LoaderPoolNode.getNbLoaderPool();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static final class LoaderChildren
    extends Children.Keys {
        public LoaderChildren() {
            this.update();
        }

        public void update() {
            LinkedList linkedList = new LinkedList();
            Enumeration enumeration = loaderPool.allLoaders();
            while (enumeration.hasMoreElements()) {
                linkedList.add(enumeration.nextElement());
            }
            this.setKeys(linkedList);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                DataLoader dataLoader = (DataLoader)iterator.next();
                dataLoader.removePropertyChangeListener((PropertyChangeListener)loaderPool);
                dataLoader.addPropertyChangeListener((PropertyChangeListener)loaderPool);
            }
        }

        protected Node[] createNodes(Object object) {
            try {
                return new Node[]{new LoaderPoolItemNode((DataLoader)object)};
            }
            catch (IntrospectionException introspectionException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    introspectionException.printStackTrace();
                }
                return new Node[0];
            }
        }
    }

    private static class LoaderPoolItemNode
    extends BeanNode {
        boolean isSystem;
        static /* synthetic */ Class class$org$netbeans$core$LoaderPoolNode;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
        static /* synthetic */ Class class$org$openide$actions$MoveDownAction;

        public LoaderPoolItemNode(DataLoader dataLoader) throws IntrospectionException {
            super((Object)dataLoader);
            boolean bl = this.isSystem = !loaders.contains(dataLoader);
            if (this.isSystem) {
                this.setSynchronizeName(false);
                this.setDisplayName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$core$LoaderPoolNode == null ? (class$org$netbeans$core$LoaderPoolNode = LoaderPoolItemNode.class$("org.netbeans.core.LoaderPoolNode")) : class$org$netbeans$core$LoaderPoolNode)).getString("LBL_system_data_loader"), ((FeatureDescriptor)((Object)this)).getDisplayName()));
            }
        }

        public SystemAction[] createActions() {
            if (this.isSystem) {
                return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolItemNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolItemNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
            }
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = LoaderPoolItemNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = LoaderPoolItemNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LoaderPoolItemNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolItemNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public SystemAction getDefaultAction() {
            return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LoaderPoolItemNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

