/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.ExtensionList;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class ExLocalFileSystem
extends LocalFileSystem
implements Runnable {
    private static final long serialVersionUID = -6117993653210115798L;
    private static final ExtensionList DEFAULT_EXTENSIONS = new ExtensionList();
    private static final String BACKUP_EXT;
    private ExtensionList backupExtensions;
    private String ignoredFiles = "";
    private transient RE ignoredRE = null;
    private String relativeName;
    private boolean relativeFlag = false;

    public OutputStream outputStream(String string) throws IOException {
        this.backupIfNecessary(string);
        return super.outputStream(string);
    }

    protected void delete(String string) throws IOException {
        this.backupIfNecessary(string);
        super.delete(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void backupIfNecessary(String string) throws IOException {
        ExtensionList extensionList = this.backupExtensions == null ? DEFAULT_EXTENSIONS : this.backupExtensions;
        if (!extensionList.isRegistered(string)) return;
        InputStream inputStream = null;
        try {
            try {
                inputStream = super.inputStream(string);
                OutputStream outputStream = super.outputStream(string + BACKUP_EXT);
                try {
                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                Object var8_9 = null;
                if (inputStream == null) return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object var8_10 = null;
                if (inputStream == null) return;
                inputStream.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public String[] children(String string) {
        String[] stringArray = super.children(string);
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (Utilities.getOperatingSystem() == 8192 && stringArray[n].endsWith(".java_")) {
                try {
                    String string2 = stringArray[n].substring(0, stringArray[n].length() - 1) + BACKUP_EXT;
                    super.rename(string + "/" + stringArray[n], string + "/" + string2);
                    stringArray[n] = new String(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (stringArray[n].endsWith(BACKUP_EXT) || this.ignoredRE != null && this.ignoredRE.match(stringArray[n])) {
                stringArray[n] = null;
            }
            ++n;
        }
        return stringArray;
    }

    public void setRefreshTime2(int n) {
        super.setRefreshTime(n);
    }

    public int getRefreshTime2() {
        return super.getRefreshTime();
    }

    public void setSystemName2(String string) throws PropertyVetoException {
        try {
            super.setSystemName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            TopManager.getDefault().getErrorManager().annotate((Throwable)propertyVetoException, propertyVetoException.getMessage());
            throw propertyVetoException;
        }
    }

    public void setBackupExtensions(ExtensionList extensionList) {
        this.backupExtensions = extensionList;
        this.firePropertyChange("backupExtensions", null, null);
    }

    public ExtensionList getBackupExtensions() {
        if (this.backupExtensions == null) {
            return (ExtensionList)DEFAULT_EXTENSIONS.clone();
        }
        return this.backupExtensions;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    public synchronized void setIgnoredFiles(String string) throws IllegalArgumentException {
        if (!string.equals(this.ignoredFiles)) {
            if (string.length() > 0) {
                try {
                    this.ignoredRE = new RE(string);
                }
                catch (RESyntaxException rESyntaxException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, (Throwable)rESyntaxException);
                    throw illegalArgumentException;
                }
            } else {
                this.ignoredRE = null;
            }
            this.ignoredFiles = string;
            this.firePropertyChange("ignoredFiles", null, null);
            RequestProcessor.postRequest((Runnable)this);
        }
    }

    public void run() {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (!fileObject.isFolder()) continue;
            fileObject.refresh(true);
        }
    }

    public void setRelativeDirectory(String string) throws PropertyVetoException, IOException {
        String string2 = this.relativeName;
        try {
            try {
                this.relativeName = string;
                this.relativeFlag = true;
                String string3 = System.getProperty("netbeans.user") + File.separatorChar + string;
                File file = new File(string3);
                try {
                    file = file.getCanonicalFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setRootDirectory(file);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.relativeName = string2;
                throw propertyVetoException;
            }
            catch (IOException iOException) {
                this.relativeName = string2;
                throw iOException;
            }
            Object var7_8 = null;
            this.relativeFlag = false;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.relativeFlag = false;
            throw throwable;
        }
    }

    public String getRelativeDirectory() {
        return this.relativeName;
    }

    protected String computeSystemName(File file) {
        if (this.relativeName != null) {
            return "{netbeans.user}/" + this.relativeName;
        }
        return super.computeSystemName(file);
    }

    public synchronized void setRootDirectory(File file) throws PropertyVetoException, IOException {
        String string = this.relativeName;
        if (!this.relativeFlag) {
            this.relativeName = null;
        }
        try {
            super.setRootDirectory(file);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.relativeName = string;
            throw propertyVetoException;
        }
        catch (IOException iOException) {
            this.relativeName = string;
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ignoredFiles == null) {
            this.ignoredFiles = "";
        } else if (this.ignoredFiles.length() > 0) {
            try {
                this.ignoredRE = new RE(this.ignoredFiles);
            }
            catch (RESyntaxException rESyntaxException) {
                TopManager.getDefault().notifyException((Throwable)rESyntaxException);
            }
        }
        if (this.relativeName != null) {
            try {
                this.setRelativeDirectory(this.relativeName);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    static {
        DEFAULT_EXTENSIONS.addExtension("java");
        BACKUP_EXT = System.getProperty("org.netbeans.core.ExLocalFileSystem.BACKUP_EXT", "~");
    }
}

