/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class ListImageEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    public static final String PROP_IMAGES = "images";
    public static final String PROP_VALUES = "values";
    public static final String PROP_DESCRIPTIONS = "descriptions";
    private boolean canWrite = true;
    private boolean canRead = true;
    private Image[] images = null;
    private Integer[] values = null;
    private String[] descriptions = null;

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        if (featureDescriptor instanceof Node.Property) {
            this.canWrite = ((Node.Property)featureDescriptor).canWrite();
            this.canRead = ((Node.Property)featureDescriptor).canRead();
        }
        Image[] imageArray = null;
        Integer[] integerArray = null;
        String[] stringArray = null;
        Object object = featureDescriptor.getValue(PROP_IMAGES);
        if (object instanceof Image[]) {
            imageArray = (Image[])object;
        }
        if ((object = featureDescriptor.getValue(PROP_VALUES)) instanceof Integer[]) {
            integerArray = (Integer[])object;
        }
        if ((object = featureDescriptor.getValue(PROP_DESCRIPTIONS)) instanceof String[]) {
            stringArray = (String[])object;
        }
        if (imageArray != null && integerArray != null) {
            int n = imageArray.length;
            if (integerArray.length < n) {
                n = integerArray.length;
            }
            if (stringArray != null && stringArray.length < n) {
                n = stringArray.length;
            }
            this.images = new Image[n];
            this.values = new Integer[n];
            this.descriptions = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.images[n2] = imageArray[n2];
                this.values[n2] = integerArray[n2];
                this.descriptions[n2] = stringArray == null ? integerArray[n2].toString() : stringArray[n2];
                ++n2;
            }
        }
    }

    public boolean isEditable() {
        return this.canWrite;
    }

    public String getAsText() {
        int n = this.findIndex(this.values, this.getValue());
        return (String)this.findObject(this.descriptions, n);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n = this.findIndex(this.descriptions, string);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.setValue(this.findObject(this.values, n));
    }

    public String[] getTags() {
        return this.descriptions;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Image image = (Image)this.findObject(this.images, this.findIndex(this.values, this.getValue()));
        if (image != null) {
            graphics.drawImage(image, rectangle.x + (rectangle.width - image.getWidth(null)) / 2, rectangle.y + (rectangle.height - image.getHeight(null)) / 2, image.getWidth(null), image.getHeight(null), null);
        }
    }

    public String getJavaInitializationString() {
        return "new Integer(" + this.getValue() + ")";
    }

    private Object findObject(Object[] objectArray, int n) {
        if (objectArray == null || n < 0 || n >= objectArray.length) {
            return null;
        }
        return objectArray[n];
    }

    private int findIndex(Object[] objectArray, Object object) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].equals(object)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }
}

