/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class DimensionCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$DimensionCustomEditor == null ? (class$org$netbeans$beaninfo$editors$DimensionCustomEditor = DimensionCustomEditor.class$("org.netbeans.beaninfo.editors.DimensionCustomEditor")) : class$org$netbeans$beaninfo$editors$DimensionCustomEditor));
    static final long serialVersionUID = 3718340148720193844L;
    private JPanel insidePanel;
    private JLabel jLabel1;
    private JLabel widthLabel;
    private JTextField widthField;
    private JLabel heightLabel;
    private JTextField heightField;
    private DimensionEditor editor;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$DimensionCustomEditor;

    public DimensionCustomEditor(DimensionEditor dimensionEditor) {
        this.initComponents();
        this.editor = dimensionEditor;
        Dimension dimension = (Dimension)dimensionEditor.getValue();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        this.jLabel1.setText(bundle.getString("CTL_Dimension"));
        this.widthLabel.setText(bundle.getString("CTL_Width"));
        this.widthLabel.setDisplayedMnemonic(bundle.getString("CTL_Width_mnemonic").charAt(0));
        this.widthLabel.setLabelFor(this.widthField);
        this.heightLabel.setText(bundle.getString("CTL_Height"));
        this.heightLabel.setDisplayedMnemonic(bundle.getString("CTL_Height_mnemonic").charAt(0));
        this.heightLabel.setLabelFor(this.heightField);
        this.widthField.setText("" + dimension.width);
        this.heightField.setText("" + dimension.height);
        this.widthField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Width"));
        this.heightField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Height"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DimensionCustomEditor"));
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            int n = Integer.parseInt(this.widthField.getText());
            int n2 = Integer.parseInt(this.heightField.getText());
            if (n < 0 || n2 < 0) {
                IllegalStateException illegalStateException = new IllegalStateException();
                TopManager.getDefault().getErrorManager().annotate((Throwable)illegalStateException, 65536, null, bundle.getString("CTL_NegativeSize"), null, null);
                throw illegalStateException;
            }
            return new Dimension(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            TopManager.getDefault().getErrorManager().annotate((Throwable)illegalStateException, 65536, null, bundle.getString("CTL_InvalidValue"), null, null);
            throw illegalStateException;
        }
    }

    private void initComponents() {
        this.insidePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.insidePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("jLabel1");
        this.jLabel1.setLabelFor(this.insidePanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.insidePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.widthLabel.setText("jLabel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 17, 0, 0);
        gridBagConstraints.anchor = 18;
        this.insidePanel.add((Component)this.widthLabel, gridBagConstraints);
        this.widthField.setColumns(5);
        this.widthField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DimensionCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        gridBagConstraints.anchor = 18;
        this.insidePanel.add((Component)this.widthField, gridBagConstraints);
        this.heightLabel.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 17, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.insidePanel.add((Component)this.heightLabel, gridBagConstraints);
        this.heightField.setColumns(5);
        this.heightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DimensionCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 12);
        gridBagConstraints.anchor = 18;
        this.insidePanel.add((Component)this.heightField, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.add((Component)this.insidePanel, gridBagConstraints2);
    }

    private void updateInsets(ActionEvent actionEvent) {
        try {
            int n = Integer.parseInt(this.widthField.getText());
            int n2 = Integer.parseInt(this.heightField.getText());
            this.editor.setValue(new Dimension(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

