/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ColorEditor
implements PropertyEditor,
XMLPropertyEditor {
    public static final int AWT_PALETTE = 1;
    public static final int SYSTEM_PALETTE = 2;
    public static final int SWING_PALETTE = 3;
    private static String[] awtColorNames;
    private static final Color[] awtColors;
    private static String[] systemColorNames;
    private static final String[] systemGenerate;
    private static final Color[] systemColors;
    private static String[] swingColorNames;
    private static Color[] swingColors;
    private SuperColor color;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String XML_COLOR = "Color";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_RED = "red";
    public static final String ATTR_GREEN = "green";
    public static final String ATTR_BLUE = "blue";
    public static final String ATTR_ID = "id";
    public static final String ATTR_PALETTE = "palette";
    public static final String VALUE_PALETTE = "palette";
    public static final String VALUE_RGB = "rgb";
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ColorEditor;

    public static JColorChooser getStaticChooser(ColorEditor colorEditor) {
        JColorChooser jColorChooser = new JColorChooser(new DefaultColorSelectionModel(Color.white){

            public void setSelectedColor(Color color) {
                if (color instanceof SuperColor) {
                    super.setSelectedColor((SuperColor)color);
                } else if (color instanceof Color) {
                    super.setSelectedColor(new SuperColor(color));
                }
            }
        }){

            public void setColor(Color color) {
                if (color == null) {
                    return;
                }
                super.setColor(color);
            }
        };
        jColorChooser.addChooserPanel(new NbColorChooserPanel(1, ColorEditor.getAWTColorNames(), awtColors, ColorEditor.getString("CTL_AWTPalette"), colorEditor));
        ColorEditor.initSwingConstants();
        jColorChooser.addChooserPanel(new NbColorChooserPanel(3, swingColorNames, swingColors, ColorEditor.getString("CTL_SwingPalette"), colorEditor));
        jColorChooser.addChooserPanel(new NbColorChooserPanel(2, ColorEditor.getSystemColorNames(), systemColors, ColorEditor.getString("CTL_SystemPalette"), colorEditor));
        return jColorChooser;
    }

    public Object getValue() {
        if (this.color instanceof Color) {
            return this.color;
        }
        return null;
    }

    public void setValue(Object object) {
        if (object != null) {
            if (object instanceof SuperColor) {
                this.color = (SuperColor)object;
            } else if (object instanceof Color) {
                this.color = new SuperColor((Color)object);
            }
        } else {
            this.color = null;
        }
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        if (this.color == null) {
            return "null";
        }
        return this.color.getAsText();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n;
        int n2;
        if (string == null) {
            throw new IllegalArgumentException(null);
        }
        string.trim();
        if ("null".equals(string)) {
            this.setValue(null);
            return;
        }
        try {
            n2 = string.length();
            if (n2 > 0) {
                n = -1;
                int n3 = -1;
                char c = string.charAt(0);
                char c2 = string.charAt(n2 - 1);
                if (c == '[' && c2 == ']') {
                    n = 1;
                    n3 = n2 - 1;
                } else if (c >= '0' && c <= '9' && c2 >= '0' && c2 <= '9') {
                    n = 0;
                    n3 = n2;
                }
                if (n >= 0) {
                    int n4;
                    int n5 = string.indexOf(44);
                    int n6 = n4 = n5 < 0 ? -1 : string.indexOf(44, n5 + 1);
                    if (n5 >= 0 && n4 >= 0) {
                        int n7 = Integer.parseInt(string.substring(n, n5));
                        int n8 = Integer.parseInt(string.substring(n5 + 1, n4));
                        int n9 = Integer.parseInt(string.substring(n4 + 1, n3));
                        this.setValue(new SuperColor(null, 0, new Color(n7, n8, n9)));
                        return;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n = 0;
        Color color = null;
        n2 = ColorEditor.getIndex(ColorEditor.getAWTColorNames(), string);
        if (n2 >= 0) {
            n = 1;
            color = awtColors[n2];
        }
        if (n2 < 0 && (n2 = ColorEditor.getIndex(ColorEditor.getSystemColorNames(), string)) >= 0) {
            n = 2;
            color = systemColors[n2];
        }
        if (n2 < 0) {
            ColorEditor.initSwingConstants();
            n2 = ColorEditor.getIndex(swingColorNames, string);
            if (n2 >= 0) {
                n = 3;
                color = swingColors[n2];
            }
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(string);
        }
        this.setValue(new SuperColor(string, n, color));
    }

    public String getJavaInitializationString() {
        if (this.color == null) {
            return "null";
        }
        if (this.color.getID() == null) {
            return "new java.awt.Color(" + this.color.getRed() + ", " + this.color.getGreen() + ", " + this.color.getBlue() + ")";
        }
        switch (this.color.getPalette()) {
            default: {
                return "java.awt.Color." + this.color.getID();
            }
            case 2: {
                return "java.awt.SystemColor." + systemGenerate[ColorEditor.getIndex(ColorEditor.getSystemColorNames(), this.color.getID())];
            }
            case 3: 
        }
        ColorEditor.initSwingConstants();
        int n = ColorEditor.getIndex(swingColorNames, this.color.getID());
        if (n < 0) {
            return "new java.awt.Color(" + this.color.getRed() + ", " + this.color.getGreen() + ", " + this.color.getBlue() + ")";
        }
        return "(java.awt.Color) javax.swing.UIManager.getDefaults().get(\"" + this.color.getID() + "\")";
    }

    public String[] getTags() {
        if (this.color == null) {
            return ColorEditor.getAWTColorNames();
        }
        switch (this.color.getPalette()) {
            case 1: {
                return ColorEditor.getAWTColorNames();
            }
            case 2: {
                return ColorEditor.getSystemColorNames();
            }
            case 3: {
                ColorEditor.initSwingConstants();
                return swingColorNames;
            }
        }
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        int n;
        Serializable serializable;
        if (this.color != null) {
            serializable = graphics.getColor();
            graphics.drawRect(rectangle.x, rectangle.y + rectangle.height / 2 - 5, 10, 10);
            graphics.setColor(this.color);
            graphics.fillRect(rectangle.x + 1, rectangle.y + rectangle.height / 2 - 4, 9, 9);
            graphics.setColor((Color)serializable);
            n = 18;
        } else {
            n = 0;
        }
        serializable = graphics.getFontMetrics();
        graphics.drawString(this.getAsText(), rectangle.x + n, rectangle.y + (rectangle.height - ((FontMetrics)serializable).getHeight()) / 2 + ((FontMetrics)serializable).getAscent());
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new NbColorChooser(this, ColorEditor.getStaticChooser(this));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private static synchronized String[] getAWTColorNames() {
        if (awtColorNames == null) {
            awtColorNames = new String[]{ColorEditor.getString("LAB_White"), ColorEditor.getString("LAB_LightGray"), ColorEditor.getString("LAB_Gray"), ColorEditor.getString("LAB_DarkGray"), ColorEditor.getString("LAB_Black"), ColorEditor.getString("LAB_Red"), ColorEditor.getString("LAB_Pink"), ColorEditor.getString("LAB_Orange"), ColorEditor.getString("LAB_Yellow"), ColorEditor.getString("LAB_Green"), ColorEditor.getString("LAB_Magenta"), ColorEditor.getString("LAB_Cyan"), ColorEditor.getString("LAB_Blue")};
        }
        return awtColorNames;
    }

    private static synchronized String[] getSystemColorNames() {
        if (systemColorNames == null) {
            systemColorNames = new String[]{ColorEditor.getString("LAB_ActiveCaption"), ColorEditor.getString("LAB_ActiveCaptionBorder"), ColorEditor.getString("LAB_ActiveCaptionText"), ColorEditor.getString("LAB_Control"), ColorEditor.getString("LAB_ControlDkShadow"), ColorEditor.getString("LAB_ControlHighlight"), ColorEditor.getString("LAB_ControlLtHighlight"), ColorEditor.getString("LAB_ControlShadow"), ColorEditor.getString("LAB_ControlText"), ColorEditor.getString("LAB_Desktop"), ColorEditor.getString("LAB_InactiveCaption"), ColorEditor.getString("LAB_InactiveCaptionBorder"), ColorEditor.getString("LAB_InactiveCaptionText"), ColorEditor.getString("LAB_Info"), ColorEditor.getString("LAB_InfoText"), ColorEditor.getString("LAB_Menu"), ColorEditor.getString("LAB_MenuText"), ColorEditor.getString("LAB_Scrollbar"), ColorEditor.getString("LAB_Text"), ColorEditor.getString("LAB_TextHighlight"), ColorEditor.getString("LAB_TextHighlightText"), ColorEditor.getString("LAB_TextInactiveText"), ColorEditor.getString("LAB_TextText"), ColorEditor.getString("LAB_Window"), ColorEditor.getString("LAB_WindowBorder"), ColorEditor.getString("LAB_WindowText")};
        }
        return systemColorNames;
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$ColorEditor == null ? (class$org$netbeans$beaninfo$editors$ColorEditor = ColorEditor.class$("org.netbeans.beaninfo.editors.ColorEditor")) : class$org$netbeans$beaninfo$editors$ColorEditor)).getString(string);
    }

    private static int getIndex(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (object.equals(objectArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static void initSwingConstants() {
        if (swingColorNames != null) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !((object = uIDefaults.get(k)) instanceof Color)) continue;
            treeSet.add((String)k);
        }
        swingColorNames = new String[treeSet.size()];
        treeSet.toArray(swingColorNames);
        swingColors = new Color[swingColorNames.length];
        int n = swingColorNames.length;
        int n2 = 0;
        while (n2 < n) {
            ColorEditor.swingColors[n2] = (Color)uIDefaults.get(swingColorNames[n2]);
            ++n2;
        }
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_COLOR.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue();
            String string2 = namedNodeMap.getNamedItem(ATTR_RED).getNodeValue();
            String string3 = namedNodeMap.getNamedItem(ATTR_GREEN).getNodeValue();
            String string4 = namedNodeMap.getNamedItem(ATTR_BLUE).getNodeValue();
            if ("palette".equals(string)) {
                String string5 = namedNodeMap.getNamedItem(ATTR_ID).getNodeValue();
                String string6 = namedNodeMap.getNamedItem("palette").getNodeValue();
                this.setValue(new SuperColor(string5, Integer.parseInt(string6), new Color(Integer.parseInt(string2, 16), Integer.parseInt(string3, 16), Integer.parseInt(string4, 16))));
            } else {
                this.setValue(new SuperColor(new Color(Integer.parseInt(string2, 16), Integer.parseInt(string3, 16), Integer.parseInt(string4, 16))));
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        if (this.color == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            errorManager.annotate((Throwable)illegalArgumentException, 4096, null, ColorEditor.getString("MSG_ColorIsNotInitialized"), null, null);
            errorManager.notify((Throwable)illegalArgumentException);
            return null;
        }
        Element element = document.createElement(XML_COLOR);
        element.setAttribute(ATTR_TYPE, this.color.getID() == null ? VALUE_RGB : "palette");
        element.setAttribute(ATTR_RED, Integer.toHexString(this.color.getRed()));
        element.setAttribute(ATTR_GREEN, Integer.toHexString(this.color.getGreen()));
        element.setAttribute(ATTR_BLUE, Integer.toHexString(this.color.getBlue()));
        if (this.color.getID() != null) {
            element.setAttribute(ATTR_ID, this.color.getID());
            element.setAttribute("palette", Integer.toString(this.color.getPalette()));
        }
        return element;
    }

    static /* synthetic */ String[] access$002(String[] stringArray) {
        swingColorNames = stringArray;
        return stringArray;
    }

    static /* synthetic */ Color[] access$102(Color[] colorArray) {
        swingColors = colorArray;
        return colorArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        awtColors = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
        systemGenerate = new String[]{"activeCaption", "activeCaptionBorder", "activeCaptionText", "control", "controlDkShadow", "controlHighlight", "controlLtHighlight", "controlShadow", "controlText", "desktop", "inactiveCaption", "inactiveCaptionBorder", "inactiveCaptionText", "info", "infoText", "menu", "menuText", "scrollbar", "text", "textHighlight", "textHighlightText", "textInactiveText", "textText", "window", "windowBorder", "windowText"};
        systemColors = new Color[]{SystemColor.activeCaption, SystemColor.activeCaptionBorder, SystemColor.activeCaptionText, SystemColor.control, SystemColor.controlDkShadow, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlText, SystemColor.desktop, SystemColor.inactiveCaption, SystemColor.inactiveCaptionBorder, SystemColor.inactiveCaptionText, SystemColor.info, SystemColor.infoText, SystemColor.menu, SystemColor.menuText, SystemColor.scrollbar, SystemColor.text, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.textText, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText};
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ColorEditor.access$002(null);
                ColorEditor.access$102(null);
            }
        });
        swingColorNames = null;
        swingColors = null;
    }

    private static final class NbColorChooserPanel
    extends AbstractColorChooserPanel
    implements ListSelectionListener {
        static final long serialVersionUID = -2792992315444428631L;
        private JList list;
        private String[] names;
        private Color[] colors;
        private int palette;
        private ColorEditor ce;
        private String displayName;

        NbColorChooserPanel(int n, String[] stringArray, Color[] colorArray, String string, ColorEditor colorEditor) {
            this.names = stringArray;
            this.colors = colorArray;
            this.palette = n;
            this.displayName = string;
            this.ce = colorEditor;
        }

        protected void buildChooser() {
            this.setLayout(new BorderLayout());
            this.list = new JList<String>(this.names);
            this.add("Center", new JScrollPane(this.list));
            this.list.setCellRenderer(new MyListCellRenderer());
            this.list.addListSelectionListener(this);
            this.list.getAccessibleContext().setAccessibleName(this.displayName);
        }

        public void updateChooser() {
            Color color = null;
            Object object = this.ce.getValue();
            if (object instanceof Color) {
                color = (Color)object;
            }
            if (color instanceof SuperColor && this.palette == ((SuperColor)color).getPalette()) {
                int n = ColorEditor.getIndex(this.names, ((SuperColor)color).getID());
                this.list.setSelectedIndex(n);
            } else {
                this.list.clearSelection();
            }
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getSmallDisplayIcon() {
            return null;
        }

        public Icon getLargeDisplayIcon() {
            return null;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!this.list.isSelectionEmpty()) {
                int n = this.list.getSelectedIndex();
                this.getColorSelectionModel().setSelectedColor(new SuperColor(this.names[n], this.palette, this.colors[n]));
            }
        }

        public void setColor(Color color) {
            this.getColorSelectionModel().setSelectedColor(color);
        }

        public Color getColor() {
            return this.getColorFromModel();
        }

        private final class MyListCellRenderer
        extends JPanel
        implements ListCellRenderer {
            private boolean selected;
            private boolean hasFocus;
            private int index;
            static final long serialVersionUID = -8877709520578055594L;

            public MyListCellRenderer() {
                this.setOpaque(true);
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }

            public Dimension getPreferredSize() {
                try {
                    FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
                    return new Dimension(fontMetrics.stringWidth(NbColorChooserPanel.this.names[this.index]) + 30, fontMetrics.getHeight() + 4);
                }
                catch (NullPointerException nullPointerException) {
                    return new Dimension(10, 10);
                }
            }

            public void paint(Graphics graphics) {
                Dimension dimension = this.getSize();
                Color color = graphics.getColor();
                if (this.selected) {
                    graphics.setColor(UIManager.getColor("List.selectionBackground"));
                } else {
                    graphics.setColor(UIManager.getColor("List.background"));
                }
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
                if (this.hasFocus) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                }
                graphics.setColor(Color.black);
                graphics.drawRect(6, dimension.height / 2 - 5, 10, 10);
                graphics.setColor(NbColorChooserPanel.this.colors[this.index]);
                graphics.fillRect(7, dimension.height / 2 - 4, 9, 9);
                if (this.selected) {
                    graphics.setColor(UIManager.getColor("List.selectionForeground"));
                } else {
                    graphics.setColor(UIManager.getColor("List.foreground"));
                }
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString(NbColorChooserPanel.this.names[this.index], 22, (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                graphics.setColor(color);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.index = n;
                this.selected = bl;
                this.hasFocus = bl2;
                this.getAccessibleContext().setAccessibleName(NbColorChooserPanel.this.names[n]);
                return this;
            }
        }
    }

    private static class SuperColor
    extends Color {
        static final long serialVersionUID = 6147637669184334151L;
        private String id = null;
        private int palette = 0;

        SuperColor(Color color) {
            super(color.getRed(), color.getGreen(), color.getBlue());
        }

        SuperColor(String string, int n, Color color) {
            super(color.getRed(), color.getGreen(), color.getBlue());
            this.id = string;
            this.palette = n;
        }

        public boolean equals(Object object) {
            boolean bl = super.equals(object);
            String string = null;
            int n = -1;
            if (object instanceof SuperColor) {
                string = ((SuperColor)object).getID();
                n = ((SuperColor)object).getPalette();
            }
            if (string != null) {
                return bl && string.equals(this.getID()) && n == this.getPalette();
            }
            return bl && string == this.getID() && n == this.getPalette();
        }

        private String getID() {
            return this.id;
        }

        private int getPalette() {
            return this.palette;
        }

        private String getAsText() {
            if (this.id != null) {
                return this.id;
            }
            return "[" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "]";
        }
    }

    private static class NbColorChooser
    extends JPanel
    implements ChangeListener {
        private final ColorEditor editor;
        private final JColorChooser chooser;
        private final ColorSelectionModel selectionModel;
        static final long serialVersionUID = -6230228701104365037L;
        static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ColorEditor$NbColorChooser;

        public NbColorChooser(ColorEditor colorEditor, JColorChooser jColorChooser) {
            this.editor = colorEditor;
            this.chooser = jColorChooser;
            this.selectionModel = jColorChooser.getSelectionModel();
            this.setLayout(new BorderLayout());
            this.add((Component)jColorChooser, "Center");
            jColorChooser.setColor((Color)colorEditor.getValue());
            this.selectionModel.addChangeListener(this);
            HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$beaninfo$editors$ColorEditor$NbColorChooser == null ? (class$org$netbeans$beaninfo$editors$ColorEditor$NbColorChooser = NbColorChooser.class$("org.netbeans.beaninfo.editors.ColorEditor$NbColorChooser")) : class$org$netbeans$beaninfo$editors$ColorEditor$NbColorChooser).getName());
            this.getAccessibleContext().setAccessibleDescription(ColorEditor.getString("ACSD_CustomColorEditor"));
        }

        public void removeNotify() {
            super.removeNotify();
            this.selectionModel.removeChangeListener(this);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width + 50, dimension.height + 10);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.editor.setValue(this.selectionModel.getSelectedColor());
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

