/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.tomcat.compile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.servlet.JasperLoader;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;
import org.netbeans.modules.java.environment.Utilities;
import org.netbeans.modules.web.core.jsploader.ErrorCompiler;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.tomcat.compile.InternalCompilerContext;
import org.netbeans.modules.web.tomcat.compile.ManglerImpl;
import org.netbeans.modules.web.tomcat.compile.TomcatOptionsImpl;
import org.netbeans.modules.web.tomcat.compile.TomcatSourceMapper;
import org.netbeans.modules.web.tomcat.compile.VerboseCommentGenerator;
import org.netbeans.modules.web.tomcat.compile.WDCompilationDescriptor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class TomcatCompileContext
implements FfjJspCompileContext {
    private static final boolean debug = false;

    public JspSourceMapper createSourceMapper(WebStandardData.WebJsp webJsp) throws IOException {
        return this.createTomcatSourceMapper(webJsp);
    }

    public InputStream getServletSource(WebStandardData.WebJsp webJsp) {
        String string = this.getDevelopmentCompilation(webJsp).getServletFileName();
        if (string != null) {
            try {
                return new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getServletClassName(WebStandardData.WebJsp webJsp) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(webJsp)).getFullClassName();
    }

    public FfjJspCompileContext.DevelopmentCompilation getDevelopmentCompilation(WebStandardData.WebJsp webJsp) {
        return new TomcatDevelopmentCompilation(webJsp);
    }

    public static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor(WebStandardData.WebModule webModule, WebStandardData.WebJsp webJsp, Throwable throwable) {
        FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor errorDescriptor = ErrorCompiler.constructJakartaErrorDescriptor((WebStandardData.WebModule)webModule, (WebStandardData.WebJsp)webJsp, (Throwable)throwable);
        if (errorDescriptor == null) {
            errorDescriptor = new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)webJsp, -1, -1, ErrorCompiler.getThrowableMessage((Throwable)throwable, (boolean)true), "");
        }
        return errorDescriptor;
    }

    public JspSourceMapper createTomcatSourceMapper(final WebStandardData.WebJsp webJsp) throws IOException {
        InputStream inputStream = this.getServletSource(webJsp);
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        TomcatSourceMapper tomcatSourceMapper = new TomcatSourceMapper(bufferedReader, new JspSourceMapper.NameConverter(){

            public String convert(String string) throws IOException {
                String string2 = string;
                FileObject fileObject = JspCompileUtil.findFileObjectForFile((FileSystem)JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)webJsp).getFileSystem(), (String)string);
                if (null != fileObject) {
                    string2 = fileObject.toString();
                }
                return string2;
            }
        });
        if (tomcatSourceMapper.isEmpty()) {
            tomcatSourceMapper.setPrimaryJspFileName(JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)webJsp).getPackageNameExt('/', '.'));
        }
        if (tomcatSourceMapper.size() == 0) {
            throw new IllegalArgumentException(" sourceMangler.size() == 0");
        }
        return tomcatSourceMapper;
    }

    private static class TomcatDevelopmentCompilation
    implements FfjJspCompileContext.DevelopmentCompilation {
        static boolean commentGeneratorInitialized = false;
        private transient String additionalClassPath;
        protected WebStandardData.WebJsp jspPage;
        private FileObject classesDirectory;
        private FileObject servletDirectory;
        private String futureServletClassName;
        private String currentServletClassName;
        private String targetClassFileName;
        private String packageName;
        private boolean outDated;
        static /* synthetic */ Class class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext;
        static /* synthetic */ Class class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext$TomcatDevelopmentCompilation;

        TomcatDevelopmentCompilation(WebStandardData.WebJsp webJsp) {
            this.jspPage = webJsp;
            this.initialize();
        }

        private void initialize() {
            try {
                ManglerImpl manglerImpl = new ManglerImpl(this.jspPage);
                this.classesDirectory = manglerImpl.getBaseOutputDir();
                this.targetClassFileName = manglerImpl.getClassFileNameSansPackageSansExt();
                this.servletDirectory = manglerImpl.getJavaOutputDir();
                this.outDated = manglerImpl.isOutDated();
                this.futureServletClassName = manglerImpl.getClassName();
                this.packageName = manglerImpl.getPackageName();
                this.computeCurrentServletFileName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void computeCurrentServletFileName() {
            this.servletDirectory.refresh();
            FileObject fileObject = this.servletDirectory.getFileObject(this.futureServletClassName, "java");
            if (fileObject != null) {
                this.currentServletClassName = this.futureServletClassName;
                return;
            }
            int n = this.futureServletClassName.lastIndexOf(95);
            if (n == -1) {
                this.currentServletClassName = null;
                return;
            }
            try {
                int n2 = Integer.parseInt(this.futureServletClassName.substring(n + 1));
                while (n2 > 0) {
                    this.currentServletClassName = this.futureServletClassName.substring(0, n + 1) + --n2;
                    FileObject fileObject2 = this.servletDirectory.getFileObject(this.currentServletClassName, "java");
                    if (fileObject2 == null) continue;
                    return;
                }
                this.currentServletClassName = null;
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.currentServletClassName = null;
                return;
            }
        }

        public boolean isOutDated() {
            return this.outDated;
        }

        public void cleanJSP() throws IOException {
            int n;
            String string;
            FileObject fileObject = this.classesDirectory.getFileObject(this.targetClassFileName, "class");
            if (fileObject != null) {
                try {
                    string = DataObject.find((FileObject)fileObject);
                    string.delete();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    throw new IOException(((Object)((Object)dataObjectNotFoundException)).getClass().getName() + " : " + dataObjectNotFoundException.getMessage());
                }
            }
            if ((string = this.getServletFileName()) == null) {
                return;
            }
            int n2 = string.lastIndexOf(File.separatorChar);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.lastIndexOf(46)) == -1) {
                return;
            }
            int n3 = (string = string.substring(0, n)).lastIndexOf(95);
            if (n3 == -1) {
                return;
            }
            int n4 = Integer.parseInt(string.substring(n3 + 1));
            string = string.substring(0, n3 + 1);
            while (n4 >= 0) {
                String string2 = string + n4;
                FileObject fileObject2 = this.servletDirectory.getFileObject(string2, "java");
                if (fileObject2 != null) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject2);
                        dataObject.delete();
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        throw new IOException(((Object)((Object)dataObjectNotFoundException)).getClass().getName() + " : " + dataObjectNotFoundException.getMessage());
                    }
                }
                --n4;
            }
        }

        public String getAdditionalClassPath() {
            if (this.additionalClassPath == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getClassPathItem("lib/ext/xerces.jar"));
                stringBuffer.append(File.pathSeparatorChar);
                stringBuffer.append(this.getClassPathItem("modules/ext/webserver.jar"));
                stringBuffer.append(File.pathSeparatorChar);
                stringBuffer.append(this.getClassPathItem("modules/ext/jasper.jar"));
                this.additionalClassPath = stringBuffer.toString();
            }
            return this.additionalClassPath;
        }

        private String getClassPathItem(String string) {
            String string2 = string.replace('/', File.separatorChar);
            return Utilities.findInstalledFile((String)string2).getAbsolutePath();
        }

        public void compilePreDeploy() throws IOException {
            String string = this.getServletFileName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                throw new IllegalArgumentException("Internal Error");
            }
            File file = new File(string.substring(0, n) + ".class");
            if (!file.exists()) {
                return;
            }
            String string2 = NbClassPath.toFile((FileObject)this.classesDirectory) + File.separator + this.targetClassFileName + ".class";
            File file2 = new File(string2);
            boolean bl = false;
            if (file2.exists()) {
                bl = true;
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                throw new IOException(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext == null ? (class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext = TomcatDevelopmentCompilation.class$("org.netbeans.modules.web.tomcat.compile.TomcatCompileContext")) : class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext)).getString("CTL_NotRenamed"), file, file2));
            }
            if (!bl) {
                this.classesDirectory.refresh();
            }
        }

        public String getServletFileName() {
            String string;
            String string2 = NbClassPath.toFile((FileObject)this.servletDirectory).getAbsolutePath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            return (string = this.currentServletClassName) == null ? null : string2 + string + ".java";
        }

        String getFullClassName() {
            String string = this.currentServletClassName;
            if (string == null) {
                return null;
            }
            return this.packageName == null || this.packageName.equals("") ? string : this.packageName + "." + string;
        }

        public String getServletEncoding() {
            return "UTF8";
        }

        public FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[] compileJspToServlet(boolean bl, String string, String string2, ClassLoader classLoader) throws IOException {
            Object object;
            if (!commentGeneratorInitialized) {
                object = class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext$TomcatDevelopmentCompilation == null ? (class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext$TomcatDevelopmentCompilation = TomcatDevelopmentCompilation.class$("org.netbeans.modules.web.tomcat.compile.TomcatCompileContext$TomcatDevelopmentCompilation")) : class$org$netbeans$modules$web$tomcat$compile$TomcatCompileContext$TomcatDevelopmentCompilation;
                synchronized (object) {
                    if (!commentGeneratorInitialized) {
                        JspParseEventListener.setCommentGenerator((CommentGenerator)new VerboseCommentGenerator());
                        commentGeneratorInitialized = true;
                    }
                }
            }
            object = new TomcatOptionsImpl(this.jspPage);
            JasperLoader jasperLoader = new JasperLoader();
            jasperLoader.setParentClassLoader(classLoader);
            jasperLoader.setOptions((Options)object);
            try {
                ManglerImpl manglerImpl = new ManglerImpl(this.jspPage);
                WDCompilationDescriptor wDCompilationDescriptor = new WDCompilationDescriptor(this.jspPage.getWebModule(), string);
                String string3 = "/" + this.jspPage.getResourceURI();
                InternalCompilerContext internalCompilerContext = new InternalCompilerContext(jasperLoader, string3, wDCompilationDescriptor, bl, (Options)object, manglerImpl);
                Compiler compiler = internalCompilerContext.createCompiler();
                compiler.compile();
                return null;
            }
            catch (Exception exception) {
                FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor errorDescriptor = TomcatCompileContext.constructJakartaErrorDescriptor(this.jspPage.getWebModule(), this.jspPage, exception);
                return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[]{errorDescriptor};
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

