/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.tomcat.compile;

import java.io.File;
import java.io.IOException;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ClassName;
import org.apache.jasper.compiler.Mangler;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.web.core.PluginUtil;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.tomcat.TomcatModuleInstall;
import org.netbeans.modules.web.tomcat.compile.ClassFileData;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class ManglerImpl
implements Mangler {
    String pkgName;
    String className;
    String javaFileName;
    String classFileName;
    String onlyClassFileName;
    File jsp;
    FileObject baseOutputDir;
    FileObject javaOutputDir;
    JspDataObject jspdo;
    ClassFileData cfd;
    boolean outDated;
    private static final boolean debug = false;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public ManglerImpl(WebStandardData.WebJsp webJsp) throws IOException, JasperException {
        FileObject fileObject = JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)webJsp);
        if (fileObject == null) {
            throw new IOException();
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        this.initialize((JspDataObject)dataObject);
    }

    private ManglerImpl(JspDataObject jspDataObject) throws IOException, JasperException {
        this.initialize(jspDataObject);
    }

    private void initialize(JspDataObject jspDataObject) throws IOException, JasperException {
        this.jsp = new File(JspCompileUtil.getContextPath((FileObject)jspDataObject.getPrimaryFile()));
        this.jspdo = jspDataObject;
        this.baseOutputDir = JspCompileUtil.suggestContextOutputRoot((FileObject)jspDataObject.getPrimaryFile(), (Server)TomcatModuleInstall.getTomcat());
        this.outDated = false;
        this.computePackageName();
        this.computeClassFileName();
        this.computeClassFileData();
        this.computeJavaOutputDir(jspDataObject);
        this.computeJavaFileName();
    }

    public final String getPackageName() {
        return this.pkgName;
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getJavaFileName() {
        return this.javaFileName;
    }

    public final String getClassFileName() {
        return this.classFileName;
    }

    public final FileObject getJavaOutputDir() {
        return this.javaOutputDir;
    }

    public final FileObject getBaseOutputDir() {
        return this.baseOutputDir;
    }

    public final String getClassFileNameSansPackageSansExt() {
        return this.onlyClassFileName;
    }

    public boolean isOutDated() {
        return this.outDated;
    }

    void computeJavaOutputDir(JspDataObject jspDataObject) throws IOException {
        FileObject fileObject = JspCompileUtil.suggestContextOutputRoot((FileObject)jspDataObject.getPrimaryFile(), (Server)TomcatModuleInstall.getTomcat());
        if (this.pkgName == null) {
            this.javaOutputDir = fileObject;
        } else {
            this.javaOutputDir = fileObject.getFileSystem().find(this.pkgName, null, null);
            if (this.javaOutputDir == null) {
                this.javaOutputDir = FileUtil.createFolder((FileObject)fileObject, (String)this.pkgName.replace('.', '/'));
            }
        }
        File file = NbClassPath.toFile((FileObject)this.javaOutputDir);
        if (!file.exists()) {
            PluginUtil.myMkdirs((File)file);
        }
    }

    void computePackageName() {
        String string = this.jsp.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1 || n == 0) {
            this.pkgName = null;
        } else {
            char c;
            int n2 = 0;
            while (n2 < keywords.length) {
                c = File.separatorChar;
                int n3 = string.indexOf(c + keywords[n2]);
                int n4 = string.indexOf(keywords[n2]);
                if (n3 != -1 || n4 != -1) {
                    int n5 = n4 == -1 ? n3 : n4;
                    while (n5 != -1) {
                        String string2 = string.substring(0, n5 + 1) + '%';
                        string = string2 + string.substring(n5 + 2);
                        n5 = string.indexOf(c + keywords[n2]);
                    }
                }
                ++n2;
            }
            string = string.replace('.', '_');
            this.pkgName = string.substring(0, string.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '.');
            c = '\u0000';
            while (c < this.pkgName.length()) {
                if (Character.isLetter(this.pkgName.charAt(c)) || this.pkgName.charAt(c) == '.') {
                    stringBuffer.append(this.pkgName.substring(c, c + '\u0001'));
                } else {
                    stringBuffer.append(ManglerImpl.mangleChar(this.pkgName.charAt(c)));
                }
                ++c;
            }
            if (stringBuffer.charAt(0) == '.') {
                String string3 = stringBuffer.toString();
                this.pkgName = string3.substring(1, stringBuffer.length());
            } else {
                this.pkgName = stringBuffer.toString();
            }
        }
    }

    public final void computeJavaFileName() throws IOException {
        this.javaFileName = JspCompileUtil.getFileObjectFileName((FileObject)this.javaOutputDir) + File.separatorChar + this.className + ".java";
    }

    void computeClassFileName() throws IOException {
        String string = this.getPrefix(this.jsp.getPath());
        this.onlyClassFileName = string + this.getBaseClassName();
        this.classFileName = JspCompileUtil.getFileObjectFileName((FileObject)this.baseOutputDir) + File.separatorChar + this.onlyClassFileName + ".class";
    }

    private final String getInitialClassName() {
        String string = this.getPrefix(this.jsp.getPath());
        return string + this.getBaseClassName() + "_jsp_" + "0";
    }

    private final String getBaseClassName() {
        String string = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (Character.isLetterOrDigit(string.charAt(n))) {
                stringBuffer.append(string.substring(n, n + 1));
            } else {
                stringBuffer.append(ManglerImpl.mangleChar(string.charAt(n)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String getPrefix(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                if (Character.isLetter(string.charAt(n))) {
                    stringBuffer.append(string.substring(n, n + 1));
                } else {
                    stringBuffer.append(ManglerImpl.mangleChar(string.charAt(n)));
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private static final String mangleChar(char c) {
        if (c == File.separatorChar) {
            c = (char)47;
        }
        String string = Integer.toHexString(c);
        int n = 5 - string.length();
        char[] cArray = new char[6];
        cArray[0] = 95;
        int n2 = 1;
        while (n2 <= n) {
            cArray[n2] = 48;
            ++n2;
        }
        int n3 = n + 1;
        int n4 = 0;
        while (n3 < 6) {
            cArray[n3] = string.charAt(n4);
            ++n3;
            ++n4;
        }
        return new String(cArray);
    }

    private final void computeClassFileData() throws JasperException {
        File file = NbClassPath.toFile((FileObject)this.jspdo.getPrimaryFile());
        File file2 = new File(this.classFileName);
        if (!file2.exists()) {
            this.className = this.getInitialClassName();
            this.cfd = new ClassFileData(true, this.classFileName, this.className);
            this.outDated = true;
        } else {
            boolean bl = this.outDated = file2.lastModified() < file.lastModified();
            if (this.outDated) {
                this.cfd = new ClassFileData(this.outDated, this.classFileName, this.className);
                this.cfd.incrementNumber();
            } else {
                this.cfd = new ClassFileData(this.outDated, this.classFileName, null);
                this.cfd.incrementNumber();
            }
            String string = ClassName.getClassName((String)this.classFileName);
            String string2 = this.cfd.getClassName();
            int n = string2.lastIndexOf(46);
            this.className = n != -1 ? string2.substring(n + 1, string2.length()) : string2;
        }
    }
}

