/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.tomcat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.j2ee.server.DebugInfo;
import org.netbeans.modules.j2ee.server.Progress;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.netbeans.modules.j2ee.server.datamodel.WebAppStandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.URLInfo;
import org.netbeans.modules.j2ee.server.web.WebServerTestExecution;
import org.netbeans.modules.web.context.WebClassesObject;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.tomcat.Context;
import org.netbeans.modules.web.tomcat.ServerOutputImpl;
import org.netbeans.modules.web.tomcat.TomcatDataObject;
import org.netbeans.modules.web.tomcat.TomcatModuleInstall;
import org.netbeans.modules.web.tomcat.TomcatServerExecution;
import org.netbeans.modules.web.tomcat.TomcatServerInstance;
import org.netbeans.modules.web.tomcat.TomcatWebServer;
import org.netbeans.modules.web.tomcat.compile.TomcatCompileContext;
import org.netbeans.modules.web.webdata.WebModuleImpl;
import org.openide.TopManager;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HttpServer;
import org.openide.util.NbBundle;
import org.openide.util.Task;

public class TomcatServerExecution
implements WebServerTestExecution,
URLInfo {
    private TomcatServerInstance webServerInstance = null;
    private Phase lastPhase = new Phase();
    private Phase futurePhase = new Phase();
    private Process tomcatProcess = null;
    private FileObject web_xml = null;
    private boolean restart = true;
    private SequenceInputStream sequenceInputStream = null;
    private ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$tomcat$TomcatServerExecution == null ? (class$org$netbeans$modules$web$tomcat$TomcatServerExecution = TomcatServerExecution.class$("org.netbeans.modules.web.tomcat.TomcatServerExecution")) : class$org$netbeans$modules$web$tomcat$TomcatServerExecution));
    private boolean makeProgress = false;
    private TomcatCompileContext compiler;
    private Task task = null;
    private WaitingRunnable runnable = null;
    private String tomcatClasspath;
    static /* synthetic */ Class class$org$netbeans$modules$web$tomcat$TomcatServerExecution;
    static /* synthetic */ Class class$org$netbeans$modules$web$tomcat$WebAppMain;
    static /* synthetic */ Class class$org$netbeans$modules$web$tomcat$WebAppStop;

    public TomcatServerExecution(TomcatServerInstance tomcatServerInstance) {
        this.webServerInstance = tomcatServerInstance;
        this.futurePhase.setExecPhase();
    }

    TomcatDataObject getTomcatDataObject() {
        return ((TomcatWebServer)this.webServerInstance.getServer()).getTomcatDataObject();
    }

    public FfjJspCompileContext getJspCompiler() {
        if (!this.getTomcatDataObject().getCompileInIDE()) {
            return null;
        }
        if (this.compiler == null) {
            this.compiler = new TomcatCompileContext();
        }
        return this.compiler;
    }

    public URLInfo getURLInfo() throws ServerException {
        return this;
    }

    public URL getURL() {
        try {
            URL uRL = new URL("http", Util.getLocalHost(), this.getPort(), "");
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)malformedURLException);
            return null;
        }
    }

    protected int getPort() {
        return this.getTomcatDataObject().getPort();
    }

    public ServerOutput[] getServerOutput() {
        try {
            return new ServerOutput[]{new ServerOutputImpl("error", this.sequenceInputStream), new ServerOutputImpl("output", this.tomcatProcess.getInputStream())};
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
            return new ServerOutput[0];
        }
    }

    public void setRestart() {
        this.restart = true;
    }

    public void setDebug(boolean bl) {
        if (bl) {
            this.futurePhase.setDebugPhase();
        } else {
            this.futurePhase.setExecPhase();
        }
    }

    public DebugInfo getDebugInfo() throws ServerException {
        String string = this.bundle.getString("SEL_debuggingType_1");
        if (this.getTomcatDataObject().getDebuggingType().equals(string)) {
            return new DebugInfo.SocketDebugInfo(Util.getLocalHost(), this.getDebuggingPort());
        }
        return new DebugInfo.SharedMemoryDebugInfo(Util.getLocalHost(), this.getTomcatDataObject().getNameForSharedMemoryAccess());
    }

    protected void startServerInExecMode(Progress progress) {
        if (this.lastPhase.isDebugPhase() || this.restart) {
            this.makeProgress(progress, 2);
            this.stopExecution();
            this.restart = false;
        }
        try {
            if (this.tomcatProcess != null) {
                int n = this.tomcatProcess.exitValue();
            }
            this.createNewTomcatProcess(false, progress);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        this.lastPhase.setExecPhase();
    }

    protected void startServerInDebugMode(Progress progress) {
        this.makeProgress(progress, 2);
        this.stopExecution();
        this.restart = false;
        this.createNewTomcatProcess(true, progress);
        this.lastPhase.setDebugPhase();
    }

    private void createNewTomcatProcess(boolean bl, Progress progress) {
        try {
            Object object;
            this.makeProgress(progress, 3);
            TomcatDataObject tomcatDataObject = this.getTomcatDataObject();
            String string = "";
            if (tomcatDataObject.getClassic()) {
                string = this.getClassicSetting();
            }
            String string2 = this.getPointbaseSetting();
            String string3 = "";
            if (bl) {
                string3 = this.getDebugSetting();
            }
            String string4 = this.getSortedFileSystemNames();
            String[] stringArray = new String[]{this.getConfigFileName(), this.getTomcatHomeDir()};
            ExecInfo execInfo = new ExecInfo((class$org$netbeans$modules$web$tomcat$WebAppMain == null ? (class$org$netbeans$modules$web$tomcat$WebAppMain = TomcatServerExecution.class$("org.netbeans.modules.web.tomcat.WebAppMain")) : class$org$netbeans$modules$web$tomcat$WebAppMain).getName(), stringArray);
            TomcatFormat tomcatFormat = new TomcatFormat(execInfo, string2, string, string3, string4);
            this.tomcatProcess = bl ? tomcatDataObject.getDebugProcessDescriptor().exec((Format)((Object)tomcatFormat)) : tomcatDataObject.getExecProcessDescriptor().exec((Format)((Object)tomcatFormat));
            this.runnable = new WaitingRunnable(this.tomcatProcess);
            this.task = new Task((Runnable)this.runnable);
            new Thread((Runnable)this.task).start();
            String string5 = null;
            if (bl) {
                object = tomcatDataObject.getDebugProcessDescriptor();
                string5 = object.getProcessName() + " " + object.getArguments();
            } else {
                object = tomcatDataObject.getExecProcessDescriptor();
                string5 = object.getProcessName() + " " + object.getArguments();
            }
            object = ((Format)((Object)tomcatFormat)).format(string5) + System.getProperty("line.separator");
            this.sequenceInputStream = new SequenceInputStream(new StringBufferInputStream((String)object), this.tomcatProcess.getErrorStream());
            this.webServerInstance.fireStatus(ServerStatus.STATUS_RESTART);
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
        }
    }

    private void executeStoppingTomcatProcess() {
        try {
            String[] stringArray = new String[]{this.getConfigFileName(), this.getTomcatHomeDir()};
            ExecInfo execInfo = new ExecInfo((class$org$netbeans$modules$web$tomcat$WebAppStop == null ? (class$org$netbeans$modules$web$tomcat$WebAppStop = TomcatServerExecution.class$("org.netbeans.modules.web.tomcat.WebAppStop")) : class$org$netbeans$modules$web$tomcat$WebAppStop).getName(), stringArray);
            TomcatFormat tomcatFormat = new TomcatFormat(execInfo, "", "", "", "");
            this.getTomcatDataObject().getExecProcessDescriptor().exec((Format)((Object)tomcatFormat));
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
        }
    }

    public synchronized void synchronize(Progress progress) {
        this.makeProgress = this.restart;
        this.makeProgress(progress, 0);
        try {
            if (this.restart) {
                this.makeProgress(progress, 1);
                this.deployConfDirectory();
                this.deployServerPortFile();
                this.createConfigFile();
                this.deployTempDirFile();
            }
            if (this.futurePhase.isExecPhase()) {
                this.startServerInExecMode(progress);
            } else {
                this.startServerInDebugMode(progress);
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)exception);
        }
        try {
            URL uRL = new URL("http", Util.getLocalHost(), this.getPort(), "/SOMENONSENSE_NONEXISTING_URL/xxxyyyzzz.nonexistingextension");
            if (Util.waitForURLConnection((URL)uRL, (int)40000, (int)1000)) {
                this.makeProgress(progress, 4);
            } else {
                this.makeProgress(progress, 5);
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)malformedURLException);
        }
    }

    public synchronized void stopExecution() {
        if (this.task != null && !this.task.isFinished()) {
            try {
                this.executeStoppingTomcatProcess();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.tomcatProcess.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 1;
            while (n < 20) {
                if (this.task.isFinished()) break;
                try {
                    Thread.sleep(n * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n == 19) {
                    TopManager.getDefault().getErrorManager().notify(1, (Throwable)new Exception("tomcat is not stopped properly"));
                    this.runnable.setFinished();
                    this.webServerInstance.fireStatus(ServerStatus.STATUS_STOPPED);
                }
                ++n;
            }
        }
        this.setRestart();
    }

    private String getSortedFileSystemNames() {
        String string = JspCompileUtil.getOutputRootFolder().getAbsolutePath();
        TreeSet treeSet = new TreeSet();
        class Env
        extends FileSystem.Environment {
            private final /* synthetic */ SortedSet val$set;
            private final /* synthetic */ TomcatServerExecution this$0;

            Env(TomcatServerExecution tomcatServerExecution, SortedSet sortedSet) {
                this.this$0 = tomcatServerExecution;
                this.val$set = sortedSet;
            }

            public void addClassPath(String string) {
                this.val$set.add(string);
            }
        }
        Env env = new Env(this, treeSet);
        String string2 = ".jar";
        String string3 = System.getProperty("path.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(this.getTomcatClasspath(string3));
        Enumeration enumeration = FileSystemCapability.EXECUTE.fileSystems();
        if (enumeration.hasMoreElements()) {
            Object object;
            FileSystem fileSystem;
            while (enumeration.hasMoreElements()) {
                fileSystem = (FileSystem)enumeration.nextElement();
                try {
                    String string4;
                    Object object2;
                    object = DataObject.find((FileObject)fileSystem.getRoot());
                    if (object instanceof WebClassesObject) continue;
                    if (object instanceof WebContextObject) {
                        object2 = ((WebContextObject)object).getClassesBase();
                        stringBuffer.append(NbClassPath.toFile((FileObject)object2.getRoot()).getAbsolutePath());
                        stringBuffer.append(string3);
                        string4 = ((WebContextObject)object).getLibraries();
                        FileObject[] fileObjectArray = string4.getPrimaryFile().getChildren();
                        int n = 0;
                        while (n < fileObjectArray.length) {
                            String string5;
                            File file = NbClassPath.toFile((FileObject)fileObjectArray[n]);
                            if (file != null && (string5 = file.getAbsolutePath()).endsWith(string2)) {
                                stringBuffer.append(string5);
                                stringBuffer.append(string3);
                            }
                            ++n;
                        }
                        stringBuffer.append(NbClassPath.toFile((FileObject)fileSystem.getRoot()).getAbsolutePath());
                        stringBuffer.append(string3);
                        continue;
                    }
                    object2 = NbClassPath.toFile((FileObject)fileSystem.getRoot());
                    if (object2 != null && (string4 = ((File)object2).getAbsolutePath()).startsWith(string)) continue;
                    try {
                        fileSystem.prepareEnvironment((FileSystem.Environment)env);
                    }
                    catch (EnvironmentNotSupportedException environmentNotSupportedException) {}
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)dataObjectNotFoundException);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
                }
            }
            fileSystem = treeSet.iterator();
            while (fileSystem.hasNext()) {
                object = (String)fileSystem.next();
                stringBuffer.append((String)object);
                stringBuffer.append(string3);
            }
            int n = stringBuffer.length();
            if (n > 0 && stringBuffer.substring(n - 1, n).equals(string3)) {
                stringBuffer.deleteCharAt(n - 1);
            }
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    private String getTomcatClasspath(String string) {
        if (this.tomcatClasspath == null) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            String string2 = NbClassPath.createLibraryPath().getClassPath();
            String string3 = NbClassPath.createClassPath().getClassPath();
            String string4 = "jsp-tomcat.jar";
            int n9 = string2.indexOf(string4);
            String string5 = "";
            if (n9 > 0 && (n8 = (string5 = string2.substring(0, n9 + 14)).lastIndexOf(string)) >= 0) {
                string5 = string5.substring(n8 + 1);
            }
            string4 = "dd2beans.jar";
            n9 = string2.indexOf(string4);
            String string6 = "";
            if (n9 > 0 && (n7 = (string6 = string2.substring(0, n9 + 12)).lastIndexOf(string)) >= 0) {
                string6 = string6.substring(n7 + 1);
            }
            string4 = "jasper.jar";
            n9 = string2.indexOf(string4);
            String string7 = "";
            if (n9 > 0 && (n6 = (string7 = string2.substring(0, n9 + 10)).lastIndexOf(string)) >= 0) {
                string7 = string7.substring(n6 + 1);
            }
            string4 = "jsp.jar";
            n9 = string2.indexOf(string4);
            String string8 = "";
            if (n9 > 0 && (n5 = (string8 = string2.substring(0, n9 + 7)).lastIndexOf(string)) >= 0) {
                string8 = string8.substring(n5 + 1);
            }
            string4 = "webserver.jar";
            n9 = string2.indexOf(string4);
            String string9 = "";
            if (n9 > 0 && (n4 = (string9 = string2.substring(0, n9 + 13)).lastIndexOf(string)) >= 0) {
                string9 = string9.substring(n4 + 1);
            }
            string4 = "parser.jar";
            n9 = string3.indexOf(string4);
            String string10 = "";
            if (n9 > 0 && (n3 = (string10 = string3.substring(0, n9 + 10)).lastIndexOf(string)) >= 0) {
                string10 = string10.substring(n3 + 1);
            }
            string4 = "xerces.jar";
            n9 = string3.indexOf(string4);
            String string11 = "";
            if (n9 > 0 && (n2 = (string11 = string3.substring(0, n9 + 10)).lastIndexOf(string)) >= 0) {
                string11 = string11.substring(n2 + 1);
            }
            string4 = "servlet-2.2.jar";
            n9 = string3.indexOf(string4);
            String string12 = "";
            if (n9 > 0 && (n = (string12 = string3.substring(0, n9 + 10)).lastIndexOf(string)) >= 0) {
                string12 = string12.substring(n + 1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string5).append(string);
            if (string6.length() > 0) {
                stringBuffer.append(string6).append(string);
            }
            stringBuffer.append(string8).append(string);
            stringBuffer.append(string7).append(string);
            stringBuffer.append(string9).append(string);
            stringBuffer.append(string10).append(string);
            stringBuffer.append(string11).append(string).append(string12).append(string);
            this.tomcatClasspath = stringBuffer.toString();
        }
        return this.tomcatClasspath;
    }

    protected void deployTempDirFile() throws IOException {
        WebAppStandardData webAppStandardData = (WebAppStandardData)this.webServerInstance.getTestComponent();
        if (webAppStandardData != null) {
            WebAppStandardData.WebMapping[] webMappingArray = webAppStandardData.getWebModules();
            FileObject[] fileObjectArray = new FileObject[webMappingArray.length];
            int n = 0;
            while (n < fileObjectArray.length) {
                FileObject fileObject;
                WebStandardData.WebModule webModule = webMappingArray[n].getWebModule();
                fileObjectArray[n] = fileObject = ((WebModuleImpl)webModule).getFileObject();
                ++n;
            }
            this.deployTempDirFile(fileObjectArray);
        }
    }

    protected void createConfigFile() {
        boolean bl = false;
        Context[] contextArray = null;
        WebAppStandardData webAppStandardData = (WebAppStandardData)this.webServerInstance.getTestComponent();
        if (webAppStandardData != null) {
            Object object;
            WebAppStandardData.WebMapping[] webMappingArray = webAppStandardData.getWebModules();
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            int n = 0;
            while (n < webMappingArray.length) {
                object = webMappingArray[n].getWebModule();
                String string = webMappingArray[n].getURLPrefix();
                Context context = new Context();
                context.setDocBase(NbClassPath.toFile((FileObject)((WebModuleImpl)object).getFileObject()));
                context.setPath(string);
                arrayList.add(context);
                if (string.equals("")) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                object = new Context();
                ((Context)object).setDocBase(NbClassPath.toFile((FileObject)this.getTomcatHomeFolder()));
                ((Context)object).setPath("");
                arrayList.add(0, object);
            }
            contextArray = arrayList.toArray(new Context[arrayList.size()]);
        } else {
            ArrayList<Context> arrayList = new ArrayList<Context>(1);
            Context context = new Context();
            context.setDocBase(NbClassPath.toFile((FileObject)this.getTomcatHomeFolder()));
            context.setPath("");
            arrayList.add(0, context);
            contextArray = arrayList.toArray(new Context[arrayList.size()]);
        }
        this.web_xml = this.getTomcatDataObject().getTomcatFileObject(contextArray);
    }

    private String getConfigFileName() {
        return NbClassPath.toFile((FileObject)this.web_xml).getAbsolutePath();
    }

    private FileObject getTomcatHomeFolder() {
        return this.getTomcatDataObject().getPrimaryFile().getParent();
    }

    private String getTomcatHomeDir() {
        File file = NbClassPath.toFile((FileObject)this.getTomcatHomeFolder());
        return file.getAbsolutePath();
    }

    protected int getDebuggingPort() {
        return this.getTomcatDataObject().getDebuggerPort();
    }

    private String getDebuggingPortString() {
        return new Integer(this.getDebuggingPort()).toString();
    }

    private String getPointbaseSetting() {
        String string = System.getProperty("pointbase.ini");
        if (string == null) {
            return "";
        }
        return "-Dpointbase.ini=" + string + " ";
    }

    private String getDebugSetting() {
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$tomcat$TomcatServerExecution == null ? (class$org$netbeans$modules$web$tomcat$TomcatServerExecution = TomcatServerExecution.class$("org.netbeans.modules.web.tomcat.TomcatServerExecution")) : class$org$netbeans$modules$web$tomcat$TomcatServerExecution)).getString("SEL_debuggingType_1");
        if (this.getTomcatDataObject().getDebuggingType().equals(string)) {
            return "-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + this.getDebuggingPortString();
        }
        return "-Xdebug -Xnoagent -Xrunjdwp:transport=dt_shmem,server=y,suspend=n,address=" + this.getTomcatDataObject().getNameForSharedMemoryAccess();
    }

    private String getClassicSetting() {
        return "-classic";
    }

    private void deployConfDirectory() throws IOException {
        FileObject fileObject = this.getTomcatHomeFolder();
        FileObject fileObject2 = null;
        try {
            fileObject2 = fileObject.createFolder("conf");
        }
        catch (IOException iOException) {
            fileObject2 = fileObject.getFileObject("conf");
        }
        try {
            fileObject2 = fileObject.createFolder("webapps/dummyapp");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deployTempDirFile(FileObject[] fileObjectArray) throws IOException {
        FileObject fileObject = this.getTomcatHomeFolder();
        FileObject fileObject2 = fileObject.getFileObject("tempDirs", "properties");
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData("tempDirs", "properties");
        }
        Properties properties = new Properties();
        FileObject[] fileObjectArray2 = this.getTomcatDataObject().getDocBasesFromContext();
        int n = 0;
        while (n < fileObjectArray2.length) {
            ((Hashtable)properties).put(NbClassPath.toFile((FileObject)fileObjectArray2[n]).getCanonicalPath(), NbClassPath.toFile((FileObject)JspCompileUtil.suggestContextOutputRoot((FileObject)fileObjectArray2[n], (Server)TomcatModuleInstall.getTomcat())).getAbsolutePath());
            ++n;
        }
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            properties.store(outputStream, null);
            outputStream.close();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    public File deployServerPortFile() throws IOException {
        File file = JspCompileUtil.suggestServerWorkDir((Server)this.webServerInstance.getServer());
        file = new File(file.getAbsolutePath() + File.separator + "port");
        URL uRL = HttpServer.getRepositoryRoot();
        String string = uRL == null ? "" : "" + uRL.getPort();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        bufferedWriter.close();
        return file;
    }

    void makeProgress(Progress progress, int n) {
        if (this.makeProgress) {
            switch (n) {
                case 0: {
                    progress.startTask(this.bundle.getString("MSG_TomcatProgress0"), 100);
                    break;
                }
                case 1: {
                    progress.addMessage(this.bundle.getString("MSG_TomcatProgress1"));
                    progress.recordWork(20);
                    break;
                }
                case 2: {
                    progress.addMessage(this.bundle.getString("MSG_TomcatProgress2"));
                    progress.recordWork(40);
                    break;
                }
                case 3: {
                    progress.addMessage(this.bundle.getString("MSG_TomcatProgress3"));
                    progress.recordWork(60);
                    break;
                }
                case 4: {
                    progress.addMessage(this.bundle.getString("MSG_TomcatProgress4"));
                    progress.recordWork(100);
                    break;
                }
                case 5: {
                    progress.addError(this.bundle.getString("MSG_TomcatProgress5"));
                    progress.recordWork(100);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Phase {
        protected static final int NULL_PHASE = 0;
        protected static final int EXEC_PHASE = 1;
        protected static final int DEBUG_PHASE = 2;
        protected int phase = 0;

        boolean isNullPhase() {
            return this.phase == 0;
        }

        boolean isExecPhase() {
            return this.phase == 1;
        }

        boolean isDebugPhase() {
            return this.phase == 2;
        }

        public void setExecPhase() {
            this.phase = 1;
        }

        public void setDebugPhase() {
            this.phase = 2;
        }
    }

    protected class WaitingRunnable
    implements Runnable {
        protected Process process = null;
        protected boolean finished = false;

        public WaitingRunnable(Process process) {
            this.process = process;
            this.finished = false;
        }

        void setFinished() {
            this.finished = true;
        }

        public void run() {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.finished) {
                TomcatServerExecution.this.webServerInstance.fireStatus(ServerStatus.STATUS_STOPPED);
                TomcatServerExecution.this.setRestart();
            }
        }
    }

    public static class TomcatFormat
    extends ProcessExecutor.Format {
        public static final String TAG_POINTBASE = "database";
        public static final String TAG_DEBUG = "debuggerOptions";
        public static final String TAG_CLASSIC = "classic";
        public static final String TAG_TOMCAT_FILE_SYSTEMS = "tomcat_filesystems";

        public TomcatFormat(ExecInfo execInfo, String string, String string2, String string3, String string4) {
            super(execInfo);
            Map map = this.getMap();
            map.put(TAG_POINTBASE, string);
            map.put(TAG_DEBUG, string3);
            map.put(TAG_CLASSIC, string2);
            map.put(TAG_TOMCAT_FILE_SYSTEMS, string4);
        }
    }
}

