/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.tomcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;

public class ForteDefaults
extends BaseInterceptor {
    private Properties props;

    public void engineInit(ContextManager contextManager) throws TomcatException {
        try {
            File file = new File(contextManager.getHome() + File.separator + "tempDirs.properties");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props = new Properties();
            this.props.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            this.props = new Properties();
        }
    }

    public void addContext(ContextManager contextManager, Context context) throws TomcatException {
    }

    public void contextInit(Context context) throws TomcatException {
        this.setWorkDir(context);
        if (!context.getWorkDir().exists()) {
            context.getWorkDir().mkdirs();
        }
        context.setAttribute("sun.servlet.workdir", (Object)context.getWorkDir());
        context.setAttribute("javax.servlet.context.tempdir", (Object)context.getWorkDir());
    }

    private void setWorkDir(Context context) {
        ContextManager contextManager = context.getContextManager();
        File file = new File(context.getDocBase());
        File file2 = new File(contextManager.getWorkDir());
        String string = null;
        try {
            String string2 = file.getCanonicalPath();
            string = (String)((Hashtable)this.props).get(string2);
        }
        catch (IOException iOException) {
            context.log("Error setting IDE-imposed temporary directory", (Throwable)iOException);
        }
        file2 = string == null ? new File(file2, URLEncoder.encode(this.computeSystemName(context.getDocBase()))) : new File(string);
        context.setWorkDir(file2);
    }

    private String computeSystemName(String string) {
        return string.replace(File.separatorChar, '/');
    }
}

