/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

class PropertiesParser {
    PropertiesFileEntry pfe;
    PropertiesEditorSupport editor;
    PropertiesReader propertiesReader;
    private boolean stop = false;

    public PropertiesParser(PropertiesFileEntry propertiesFileEntry) {
        this.pfe = propertiesFileEntry;
    }

    void initParser() throws IOException {
        this.editor = this.pfe.getPropertiesEditor();
        this.propertiesReader = this.createReader();
    }

    private PropertiesReader createReader() throws IOException {
        StyledDocument styledDocument = null;
        if (this.editor.isDocumentLoaded()) {
            styledDocument = this.editor.getDocument();
        }
        if (styledDocument == null) {
            styledDocument = this.editor.openDocument();
        }
        final StyledDocument styledDocument2 = styledDocument;
        final String[] stringArray = new String[1];
        styledDocument2.render(new Runnable(){

            public void run() {
                try {
                    stringArray[0] = styledDocument2.getText(0, styledDocument2.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        return new PropertiesReader(stringArray[0]);
    }

    public PropertiesStructure parseFile() {
        try {
            PropertiesStructure propertiesStructure = this.parseFileMain();
            return propertiesStructure;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void stop() {
        this.stop = true;
        this.clean();
    }

    public void clean() {
        block3: {
            if (this.propertiesReader != null) {
                try {
                    this.propertiesReader.close();
                    this.propertiesReader = null;
                }
                catch (IOException iOException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                    iOException.printStackTrace();
                }
            }
        }
    }

    private PropertiesStructure parseFileMain() throws IOException {
        HashMap<String, Element.ItemElem> hashMap = new HashMap<String, Element.ItemElem>(25, 1.0f);
        PropertiesReader propertiesReader = null;
        while (true) {
            if (this.stop) {
                return null;
            }
            propertiesReader = this.propertiesReader;
            if (propertiesReader == null) {
                return null;
            }
            Element.ItemElem itemElem = this.readNextElem(propertiesReader);
            if (itemElem == null) break;
            hashMap.put(itemElem.getKey(), itemElem);
        }
        return new PropertiesStructure(this.createBiasBounds(0L, propertiesReader.position), hashMap);
    }

    private Element.ItemElem readNextElem(PropertiesReader propertiesReader) throws IOException {
        Element.ValueElem valueElem;
        Element.KeyElem keyElem;
        int n;
        int n2 = n = propertiesReader.position;
        FlaggedLine flaggedLine = propertiesReader.readLineExpectComment();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (flaggedLine != null) {
            bl = false;
            if (!flaggedLine.flag) break;
            stringBuffer.append((Object)flaggedLine.line);
            stringBuffer.append(flaggedLine.lineSep);
            n2 = propertiesReader.position;
            flaggedLine = propertiesReader.readLineExpectComment();
        }
        if (bl) {
            return null;
        }
        String string = stringBuffer.toString();
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            string = stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        Element.CommentElem commentElem = new Element.CommentElem(this.createBiasBounds(n, n2), string);
        if (flaggedLine == null) {
            keyElem = null;
            valueElem = null;
        } else {
            String string2;
            int n3;
            ArrayList<FlaggedLine> arrayList = new ArrayList<FlaggedLine>(2);
            flaggedLine.startPosition = n2;
            flaggedLine.stringValue = flaggedLine.line.toString();
            arrayList.add(flaggedLine);
            while (UtilConvert.continueLine(flaggedLine.line)) {
                flaggedLine.stringValue = flaggedLine.stringValue.substring(0, flaggedLine.stringValue.length() - 1);
                int n4 = propertiesReader.position;
                flaggedLine = propertiesReader.readLineNoFrills();
                if (flaggedLine == null) break;
                int n5 = 0;
                n5 = 0;
                while (n5 < flaggedLine.line.length()) {
                    if (" \t\r\n\f".indexOf(flaggedLine.line.charAt(n5)) == -1) break;
                    ++n5;
                }
                flaggedLine.stringValue = flaggedLine.line.substring(n5, flaggedLine.line.length());
                flaggedLine.startPosition = n4 + n5;
                arrayList.add(flaggedLine);
            }
            PositionMap positionMap = new PositionMap(arrayList);
            String string3 = positionMap.getString();
            int n6 = string3.length();
            int n7 = 0;
            while (n7 < n6) {
                if (" \t\r\n\f".indexOf(string3.charAt(n7)) == -1) break;
                ++n7;
            }
            int n8 = n7;
            while (n8 < n6) {
                n3 = string3.charAt(n8);
                if (n3 == 92) {
                    ++n8;
                } else if ("=: \t\r\n\f".indexOf(n3) != -1) break;
                ++n8;
            }
            n3 = n8;
            while (n3 < n6) {
                if (" \t\r\n\f".indexOf(string3.charAt(n3)) == -1) break;
                ++n3;
            }
            if (n3 < n6 && "=:".indexOf(string3.charAt(n3)) != -1) {
                ++n3;
            }
            while (n3 < n6) {
                if (" \t\r\n\f".indexOf(string3.charAt(n3)) == -1) break;
                ++n3;
            }
            String string4 = string3.substring(n7, n8);
            String string5 = string2 = n8 < n6 ? string3.substring(n3, n6) : "";
            if (string4 == null) {
                // empty if block
            }
            int n9 = propertiesReader.position;
            int n10 = 0;
            try {
                n10 = positionMap.getFilePosition(n3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n10 = n9;
            }
            keyElem = new Element.KeyElem(this.createBiasBounds(n2, n10), string4);
            valueElem = new Element.ValueElem(this.createBiasBounds(n10, n9), string2);
        }
        return new Element.ItemElem(this.createBiasBounds(n, propertiesReader.position), keyElem, valueElem, commentElem);
    }

    private static int position(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    private PositionBounds createBiasBounds(long l, long l2) {
        PositionRef positionRef = this.editor.createPositionRef(PropertiesParser.position(l), Position.Bias.Forward);
        PositionRef positionRef2 = this.editor.createPositionRef(PropertiesParser.position(l2), Position.Bias.Backward);
        return new PositionBounds(positionRef, positionRef2);
    }

    private static class FlaggedLine {
        StringBuffer line = new StringBuffer();
        boolean flag = false;
        String lineSep = "\n";
        int startPosition = 0;
        String stringValue;

        FlaggedLine() {
        }
    }

    private static class PositionMap {
        private ArrayList list;

        PositionMap(ArrayList arrayList) {
            this.list = arrayList;
        }

        public String getString() {
            String string = ((FlaggedLine)this.list.get((int)0)).stringValue;
            int n = 1;
            while (n < this.list.size()) {
                string = string + ((FlaggedLine)this.list.get((int)n)).stringValue;
                ++n;
            }
            return string;
        }

        public int getFilePosition(int n) throws ArrayIndexOutOfBoundsException {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.list.size()) {
                n3 = n2;
                if (n4 == this.list.size() - 1 ? n2 >= n : (n2 += ((FlaggedLine)this.list.get((int)n4)).stringValue.length()) > n) break;
                ++n4;
            }
            if (n > n2) {
                throw new ArrayIndexOutOfBoundsException("not in scope");
            }
            return ((FlaggedLine)this.list.get((int)n4)).startPosition + n - n3;
        }
    }

    private static class PropertiesReader
    extends BufferedReader {
        private static final String LINE_SEPARATOR = "line.separator";
        private int peekChar = -1;
        public int position = 0;

        private PropertiesReader(String string) {
            super(new StringReader(string));
        }

        private PropertiesReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = this.peek();
            this.peekChar = -1;
            if (n != -1) {
                ++this.position;
            }
            return n;
        }

        private int peek() throws IOException {
            if (this.peekChar == -1) {
                this.peekChar = super.read();
            }
            return this.peekChar;
        }

        public FlaggedLine readLineExpectComment() throws IOException {
            int n = this.read();
            if (n == -1) {
                return null;
            }
            boolean bl = false;
            FlaggedLine flaggedLine = new FlaggedLine();
            while (n != -1 && n != 10 && n != 13) {
                if (!bl && " \t\r\n\f".indexOf((char)n) == -1) {
                    flaggedLine.flag = (char)n == '!' || (char)n == '#';
                    bl = true;
                }
                flaggedLine.line.append((char)n);
                n = this.read();
            }
            if (!bl) {
                flaggedLine.flag = true;
            }
            if (n == 13) {
                if (this.peek() == 10) {
                    n = this.read();
                    flaggedLine.lineSep = "\r\n";
                } else {
                    flaggedLine.lineSep = "\r";
                }
            } else {
                flaggedLine.lineSep = n == 10 ? "\n" : System.getProperty(LINE_SEPARATOR);
            }
            return flaggedLine;
        }

        public FlaggedLine readLineNoFrills() throws IOException {
            int n = this.read();
            if (n == -1) {
                return null;
            }
            FlaggedLine flaggedLine = new FlaggedLine();
            while (n != -1 && n != 10 && n != 13) {
                flaggedLine.line.append((char)n);
                n = this.read();
            }
            if (n == 13) {
                if (this.peek() == 10) {
                    n = this.read();
                    flaggedLine.lineSep = "\r\n";
                } else {
                    flaggedLine.lineSep = "\r";
                }
            } else {
                flaggedLine.lineSep = n == 10 ? "\n" : System.getProperty(LINE_SEPARATOR);
            }
            return flaggedLine;
        }
    }
}

