/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.PropertiesStructure;
import org.openide.nodes.Node;
import org.openide.text.PositionBounds;

public abstract class Element
implements Serializable {
    private transient PropertyChangeSupport support;
    protected PositionBounds bounds;

    protected Element(PositionBounds positionBounds) {
        this.bounds = positionBounds;
    }

    public PositionBounds getBounds() {
        return this.bounds;
    }

    void update(Element element) {
        this.bounds = element.bounds;
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.support != null) {
            this.support.firePropertyChange(string, object, object2);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            Element element = this;
            synchronized (element) {
                if (this.support == null) {
                    this.support = new PropertyChangeSupport(this);
                }
            }
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void print() {
        if (this.bounds == null) {
            return;
        }
        try {
            this.bounds.setText(this.printString());
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract String printString();

    public String toString() {
        return this.bounds == null ? "(no bounds)" : "(" + this.bounds.getBegin().getOffset() + ", " + this.bounds.getEnd().getOffset() + ")";
    }

    public static class ItemElem
    extends Element
    implements Node.Cookie {
        private KeyElem key;
        private ValueElem value;
        private CommentElem comment;
        private PropertiesStructure parent;
        public static final String PROP_ITEM_KEY = "key";
        public static final String PROP_ITEM_VALUE = "value";
        public static final String PROP_ITEM_COMMENT = "comment";
        static final long serialVersionUID = 1078147817847520586L;

        protected ItemElem(PositionBounds positionBounds, KeyElem keyElem, ValueElem valueElem, CommentElem commentElem) {
            super(positionBounds);
            this.key = keyElem;
            this.value = valueElem;
            this.comment = commentElem;
        }

        void setParent(PropertiesStructure propertiesStructure) {
            this.parent = propertiesStructure;
        }

        public PropertiesStructure getParent() {
            if (this.parent == null) {
                throw new IllegalStateException("Resource Bundle: Parent is missing");
            }
            return this.parent;
        }

        public String toString() {
            return this.comment.toString() + "\n" + (this.key == null ? "" : this.key.toString()) + "\n" + (this.value == null ? "" : this.value.toString()) + "\n";
        }

        public KeyElem getKeyElem() {
            return this.key;
        }

        public ValueElem getValueElem() {
            return this.value;
        }

        public CommentElem getCommentElem() {
            return this.comment;
        }

        void update(Element element) {
            super.update(element);
            if (this.key == null) {
                this.key = ((ItemElem)element).key;
            } else {
                this.key.update(((ItemElem)element).key);
            }
            if (this.value == null) {
                this.value = ((ItemElem)element).value;
            } else {
                this.value.update(((ItemElem)element).value);
            }
            this.comment.update(((ItemElem)element).comment);
        }

        public String printString() {
            return this.comment.printString() + (this.key == null ? "" : this.key.printString()) + (this.value == null ? "" : this.value.printString());
        }

        public String getKey() {
            return this.key == null ? null : this.key.getValue();
        }

        public void setKey(String string) {
            String string2 = this.key.getValue();
            if (!string2.equals(string)) {
                this.key.setValue(string);
                this.getParent().itemKeyChanged(string2, this);
                this.firePropertyChange(PROP_ITEM_KEY, string2, string);
            }
        }

        public String getValue() {
            return this.value == null ? null : this.value.getValue();
        }

        public void setValue(String string) {
            String string2 = this.value.getValue();
            if (!string2.equals(string)) {
                if (string2.equals("")) {
                    this.key.print();
                }
                this.value.setValue(string);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_VALUE, string2, string);
            }
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.getValue();
        }

        public void setComment(String string) {
            String string2 = this.comment.getValue();
            if (!string2.equals(string)) {
                this.comment.setValue(string);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_COMMENT, string2, string);
            }
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            ItemElem itemElem = (ItemElem)object;
            return (this.key == null && itemElem.getKeyElem() == null || this.key != null && itemElem.getKeyElem() != null && this.getKey().equals(itemElem.getKey())) && (this.value == null && itemElem.getValueElem() == null || this.value != null && itemElem.getValueElem() != null && this.getValue().equals(itemElem.getValue())) && (this.comment == null && itemElem.getCommentElem() == null || this.comment != null && itemElem.getCommentElem() != null && this.getComment().equals(itemElem.getComment()));
        }
    }

    public static class CommentElem
    extends Basic {
        static final long serialVersionUID = 2418308580934815756L;

        protected CommentElem(PositionBounds positionBounds, String string) {
            super(positionBounds, string);
        }

        public String printString() {
            if (this.value == null || this.value.length() == 0) {
                return "";
            }
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(this.value);
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                char c;
                if ((c = stringBuffer.charAt(n2++)) == '\n') {
                    n = n2;
                    continue;
                }
                if (n == -1 || " \t\r\n\f".indexOf(c) != -1) continue;
                if (c != '#' && c != '!') {
                    stringBuffer.insert(n, '#');
                    ++n2;
                }
                n = -1;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
    }

    public static class ValueElem
    extends Basic {
        static final long serialVersionUID = 4662649023463958853L;

        protected ValueElem(PositionBounds positionBounds, String string) {
            super(positionBounds, string);
        }

        public String printString() {
            return this.getValue() + "\n";
        }
    }

    public static class KeyElem
    extends Basic {
        static final long serialVersionUID = 6828294289485744331L;

        protected KeyElem(PositionBounds positionBounds, String string) {
            super(positionBounds, string);
        }

        public String printString() {
            return this.getValue() + "=";
        }
    }

    public static abstract class Basic
    extends Element {
        protected String value;

        protected Basic(PositionBounds positionBounds, String string) {
            super(positionBounds);
            this.value = string;
        }

        void update(Element element) {
            super.update(element);
            this.value = ((Basic)element).value;
        }

        public String toString() {
            return this.value + "   " + super.toString();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
            this.print();
        }
    }
}

