/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import org.netbeans.modules.debugger.jpda.util.Executor;

public class Operator {
    private boolean resume = false;
    private boolean stopRequest = false;
    private boolean disconnected = false;
    private Thread thread;

    public Operator(final VirtualMachine virtualMachine, final Runnable runnable, final Runnable runnable2) {
        this.thread = new Thread(new Runnable(){

            public void run() {
                EventQueue eventQueue = virtualMachine.eventQueue();
                try {
                    while (true) {
                        EventSet eventSet = eventQueue.remove();
                        Operator.this.resume = false;
                        Operator.this.stopRequest = false;
                        EventIterator eventIterator = eventSet.eventIterator();
                        while (eventIterator.hasNext()) {
                            Event event = eventIterator.nextEvent();
                            if (event instanceof VMDeathEvent || event instanceof VMDisconnectEvent) {
                                Operator.this.disconnected = true;
                                if (runnable2 != null) {
                                    runnable2.run();
                                }
                                return;
                            }
                            if (event instanceof VMStartEvent && runnable != null) {
                                runnable.run();
                                continue;
                            }
                            Executor executor = null;
                            if (event.request() != null) {
                                executor = (Executor)event.request().getProperty("executor");
                            }
                            if (executor == null) continue;
                            try {
                                executor.exec(event);
                            }
                            catch (VMDisconnectedException vMDisconnectedException) {
                                Operator.this.disconnected = true;
                                if (runnable2 != null) {
                                    runnable2.run();
                                }
                                return;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (!Operator.this.resume || Operator.this.stopRequest) continue;
                        virtualMachine.resume();
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (runnable2 != null) {
                    runnable2.run();
                }
            }
        }, "Debugger operator thread");
    }

    public void start() {
        this.thread.start();
    }

    public void register(EventRequest eventRequest, Executor executor) {
        eventRequest.putProperty("executor", executor);
    }

    public void unregister(EventRequest eventRequest) {
        eventRequest.putProperty("executor", null);
    }

    public void resume() {
        this.resume = true;
    }

    public void stopRequest() {
        this.stopRequest = true;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    private void printEvent(Event event, Executor executor) {
        try {
            if (event instanceof ClassPrepareEvent) {
                System.out.println("EVENT: ClassPrepareEvent " + ((ClassPrepareEvent)event).referenceType());
            } else if (event instanceof ClassUnloadEvent) {
                System.out.println("EVENT: ClassUnloadEvent " + ((ClassUnloadEvent)event).className());
            } else if (event instanceof ThreadStartEvent) {
                try {
                    System.out.println("EVENT: ThreadStartEvent " + ((ThreadStartEvent)event).thread());
                }
                catch (Exception exception) {
                    System.out.println("EVENT: ThreadStartEvent1 " + event);
                }
            } else if (event instanceof ThreadDeathEvent) {
                try {
                    System.out.println("EVENT: ThreadDeathEvent " + ((ThreadDeathEvent)event).thread());
                }
                catch (Exception exception) {
                    System.out.println("EVENT: ThreadDeathEvent1 " + event);
                }
            } else if (!(event instanceof MethodEntryEvent) && !(event instanceof BreakpointEvent)) {
                if (event instanceof StepEvent) {
                    System.out.println("EVENT: BreakpointEvent " + ((StepEvent)event).thread() + " : " + ((StepEvent)event).location());
                } else {
                    System.out.println("EVENT: " + event + " : " + executor);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

