/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.evaluator;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.jpda.evaluator.BodyParserConstants;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.Node;
import org.netbeans.modules.debugger.jpda.evaluator.RemoteValue;
import org.netbeans.modules.debugger.jpda.evaluator.Token;
import org.netbeans.modules.debugger.jpda.evaluator.VMEngine;
import org.openide.util.NbBundle;

public abstract class PValue
implements BodyParserConstants {
    static ResourceBundle bundle;
    protected Token token;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$evaluator$PValue;

    public static String getLocString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$evaluator$PValue == null ? (class$org$netbeans$modules$debugger$jpda$evaluator$PValue = PValue.class$("org.netbeans.modules.debugger.jpda.evaluator.PValue")) : class$org$netbeans$modules$debugger$jpda$evaluator$PValue));
        }
        return bundle.getString(string);
    }

    PValue(Token token) {
        this.token = token;
    }

    static PValue createInt(Token token) {
        return new Node.IntegerLiteral(token);
    }

    static PValue createFloat(Token token) {
        return new Node.FloatLiteral(token);
    }

    static PValue createChar(Token token) {
        return new Node.CharacterLiteral(token);
    }

    static PValue createString(Token token) {
        return new Node.StringLiteral(token);
    }

    static PValue createBoolean(Token token) {
        return new Node.BooleanLiteral(token);
    }

    static PValue createNull(Token token) {
        return new Node.NullLiteral(token);
    }

    static PValue createNewObject(String string, List list) {
        return new Node.NewObjectOperator(string, list);
    }

    static PValue createVariable(String string) {
        return new Node.Variable(string);
    }

    static PValue createIndexedVariable(PValue pValue, PValue pValue2) {
        return new Node.IndexedVariable(pValue, pValue2);
    }

    static PValue createField(PValue pValue, Token token) {
        return new Node.FieldOfVariable(pValue, token);
    }

    static PValue createMethod(PValue pValue, List list) {
        if (pValue instanceof Node.FieldOfVariable) {
            PValue pValue2 = ((Node.FieldOfVariable)pValue).variable;
            String string = ((Node.FieldOfVariable)pValue).fieldName.image;
            return new Node.MethodInvocation(pValue2, string, list);
        }
        if (pValue instanceof Node.Variable) {
            String string = ((Node.Variable)pValue).name;
            int n = string.lastIndexOf(".");
            if (n > -1) {
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1, string.length()).trim();
                ((Node.Variable)pValue).name = string2;
                return new Node.MethodInvocation(pValue, string3, list);
            }
            return new Node.MethodInvocation(null, ((Node.Variable)pValue).name, list);
        }
        return null;
    }

    static PValue createAssignment(PValue pValue, Token token, PValue pValue2) {
        return new Node.AssignmentOperator(pValue, token, pValue2);
    }

    static PValue createConditionalExpression(PValue pValue, PValue pValue2, PValue pValue3) {
        return new Node.ConditionalExpression(pValue, pValue2, pValue3);
    }

    static PValue createBinaryCondExpression(PValue pValue, Token token, PValue pValue2) {
        return new Node.BinaryConditionalOperator(pValue, token, pValue2);
    }

    static PValue createBExpression(PValue pValue, Token token, PValue pValue2) {
        return new Node.BinaryOperator(pValue, token, pValue2);
    }

    static PValue createInstanceOfExpression(PValue pValue, String string) {
        return new Node.InstanceofOperator(pValue, string);
    }

    static PValue createUExpression(PValue pValue, Token token) {
        return new Node.UnaryOperator(pValue, token);
    }

    static PValue createPrefixPP(PValue pValue) {
        return new Node.PPOperator(pValue, true);
    }

    static PValue createPrefixMM(PValue pValue) {
        return new Node.MMOperator(pValue, true);
    }

    static PValue createPostfixPP(PValue pValue) {
        return new Node.PPOperator(pValue, false);
    }

    static PValue createPostfixMM(PValue pValue) {
        return new Node.MMOperator(pValue, false);
    }

    static PValue createCastExpression(PValue pValue, String string) {
        return new Node.CastOperator(pValue, string);
    }

    static String operatorName(int n) {
        switch (n) {
            case 79: {
                return "=";
            }
            case 80: {
                return ">";
            }
            case 81: {
                return "<";
            }
            case 82: {
                return "!";
            }
            case 83: {
                return "~";
            }
            case 84: {
                return "?";
            }
            case 85: {
                return ":";
            }
            case 86: {
                return "==";
            }
            case 87: {
                return "<=";
            }
            case 88: {
                return ">=";
            }
            case 89: {
                return "!=";
            }
            case 90: {
                return "||";
            }
            case 91: {
                return "&&";
            }
            case 92: {
                return "++";
            }
            case 93: {
                return "--";
            }
            case 94: {
                return "+";
            }
            case 95: {
                return "-";
            }
            case 96: {
                return "*";
            }
            case 97: {
                return "/";
            }
            case 98: {
                return "&";
            }
            case 99: {
                return "|";
            }
            case 100: {
                return "^";
            }
            case 101: {
                return "%";
            }
            case 102: {
                return "<<";
            }
            case 103: {
                return ">>";
            }
            case 104: {
                return ">>>";
            }
            case 105: {
                return "+=";
            }
            case 106: {
                return "-=";
            }
            case 107: {
                return "*=";
            }
            case 108: {
                return "/=";
            }
            case 109: {
                return "&=";
            }
            case 110: {
                return "|=";
            }
            case 111: {
                return "^=";
            }
            case 112: {
                return "%=";
            }
            case 113: {
                return "<<=";
            }
            case 114: {
                return ">>=";
            }
            case 115: {
                return ">>>=";
            }
        }
        return "???";
    }

    public RemoteValue value(VMEngine vMEngine) throws EvaluateException {
        return null;
    }

    public static void error(String string) throws EvaluateException {
        PValue.error(string, new Object[0]);
    }

    public static void error(String string, Object object) throws EvaluateException {
        PValue.error(string, new Object[]{object});
    }

    public static void error(String string, Object object, Object object2) throws EvaluateException {
        PValue.error(string, new Object[]{object, object2});
    }

    public static void error(String string, Object object, Object object2, Object object3) throws EvaluateException {
        PValue.error(string, new Object[]{object, object2, object3});
    }

    public static void error(String string, Object[] objectArray) throws EvaluateException {
        String string2 = new MessageFormat(PValue.getLocString(string)).format(objectArray);
        throw new EvaluateException(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

