/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.util.Executor;

class ThreadManager
implements Executor {
    private HashMap referenceToThread;
    private List threads = Collections.synchronizedList(new ArrayList());
    private JPDADebugger debugger;
    private ThreadStartRequest req1;
    private ThreadDeathRequest req2;

    ThreadManager(JPDADebugger jPDADebugger) {
        this.referenceToThread = new HashMap();
        this.debugger = jPDADebugger;
        this.createHierarchy(jPDADebugger.virtualMachine.topLevelThreadGroups());
        this.req1 = jPDADebugger.requestManager.createThreadStartRequest();
        this.req1.setSuspendPolicy(2);
        jPDADebugger.operator.register(this.req1, this);
        this.req1.enable();
        this.req2 = jPDADebugger.requestManager.createThreadDeathRequest();
        this.req2.setSuspendPolicy(2);
        jPDADebugger.operator.register(this.req2, this);
        this.req2.enable();
    }

    public void exec(Event event) {
        if (event instanceof ThreadStartEvent) {
            try {
                this.addThread(((ThreadStartEvent)event).thread());
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.debugger.operator.resume();
            return;
        }
        try {
            this.removeThread(((ThreadDeathEvent)event).thread());
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debugger.operator.resume();
    }

    public synchronized void finish() {
        if (this.referenceToThread == null) {
            return;
        }
        Iterator iterator = this.referenceToThread.values().iterator();
        this.debugger.threadGroup.removeAllD();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof JPDAThreadGroup)) continue;
            ((JPDAThreadGroup)((Object)v)).removeAllD();
        }
        this.referenceToThread = null;
        try {
            this.debugger.requestManager.deleteEventRequest(this.req1);
            this.debugger.requestManager.deleteEventRequest(this.req2);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.debugger.operator.register(this.req1, null);
        this.debugger.operator.register(this.req2, null);
        this.threads = null;
        this.debugger = null;
    }

    synchronized void createHierarchy(List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ThreadGroupReference threadGroupReference = (ThreadGroupReference)list.get(n2);
            JPDAThreadGroup jPDAThreadGroup = this.createThreadGroup(threadGroupReference, this.debugger.threadGroup);
            this.createHierarchy(threadGroupReference, jPDAThreadGroup);
            ++n2;
        }
    }

    JPDAThread findThread(ThreadReference threadReference) {
        return (JPDAThread)((Object)this.referenceToThread.get(threadReference));
    }

    JPDAThread getThread(ThreadReference threadReference) {
        JPDAThread jPDAThread = this.findThread(threadReference);
        if (jPDAThread != null) {
            return jPDAThread;
        }
        return this.addThread(threadReference);
    }

    JPDAThreadGroup getThreadGroup(ThreadGroupReference threadGroupReference) {
        return (JPDAThreadGroup)((Object)this.referenceToThread.get(threadGroupReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshThreads() {
        List list = this.threads;
        synchronized (list) {
            Iterator iterator = this.threads.iterator();
            while (iterator.hasNext()) {
                JPDAThread jPDAThread = (JPDAThread)((Object)iterator.next());
                jPDAThread.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshStacks() {
        List list = this.threads;
        synchronized (list) {
            Iterator iterator = this.threads.iterator();
            while (iterator.hasNext()) {
                JPDAThread jPDAThread = (JPDAThread)((Object)iterator.next());
                jPDAThread.refreshStack();
            }
        }
    }

    JPDAThread getAnyThread() {
        Iterator iterator = this.referenceToThread.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next().getValue();
            if (!(v instanceof JPDAThread)) continue;
            return (JPDAThread)((Object)v);
        }
        return null;
    }

    private void createHierarchy(ThreadGroupReference threadGroupReference, JPDAThreadGroup jPDAThreadGroup) {
        List<ObjectReference> list = threadGroupReference.threadGroups();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ThreadGroupReference threadGroupReference2 = list.get(n2);
            this.createHierarchy(threadGroupReference2, this.createThreadGroup(threadGroupReference2, jPDAThreadGroup));
            ++n2;
        }
        list = threadGroupReference.threads();
        n = list.size();
        n2 = 0;
        while (n2 < n) {
            this.createThread((ThreadReference)list.get(n2), jPDAThreadGroup);
            ++n2;
        }
    }

    private JPDAThread addThread(ThreadReference threadReference) {
        JPDAThread jPDAThread = (JPDAThread)((Object)this.referenceToThread.get(threadReference));
        if (jPDAThread != null) {
            return jPDAThread;
        }
        try {
            return this.createThread(threadReference, this.createThreadGroup(threadReference.threadGroup()));
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private JPDAThread removeThread(ThreadReference threadReference) {
        JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)((Object)this.referenceToThread.get(threadReference.threadGroup()));
        if (jPDAThreadGroup == null) {
            return null;
        }
        JPDAThread jPDAThread = (JPDAThread)((Object)this.referenceToThread.remove(threadReference));
        this.threads.remove((Object)jPDAThread);
        jPDAThreadGroup.removeThread(jPDAThread);
        return jPDAThread;
    }

    private JPDAThreadGroup createThreadGroup(ThreadGroupReference threadGroupReference) {
        JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)((Object)this.referenceToThread.get(threadGroupReference));
        if (jPDAThreadGroup != null) {
            return jPDAThreadGroup;
        }
        ThreadGroupReference threadGroupReference2 = threadGroupReference.parent();
        JPDAThreadGroup jPDAThreadGroup2 = this.createThreadGroup(threadGroupReference2);
        return this.createThreadGroup(threadGroupReference, jPDAThreadGroup2);
    }

    private JPDAThreadGroup createThreadGroup(ThreadGroupReference threadGroupReference, JPDAThreadGroup jPDAThreadGroup) {
        JPDAThreadGroup jPDAThreadGroup2 = new JPDAThreadGroup(jPDAThreadGroup, threadGroupReference);
        this.referenceToThread.put(threadGroupReference, jPDAThreadGroup2);
        jPDAThreadGroup.addThreadGroup(jPDAThreadGroup2);
        return jPDAThreadGroup2;
    }

    private JPDAThread createThread(ThreadReference threadReference, JPDAThreadGroup jPDAThreadGroup) {
        JPDAThread jPDAThread = new JPDAThread(this.debugger, jPDAThreadGroup, threadReference);
        this.referenceToThread.put(threadReference, jPDAThread);
        this.threads.add(jPDAThread);
        jPDAThreadGroup.addThread(jPDAThread);
        return jPDAThread;
    }
}

