/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.LineBreakpointPanel;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Requestor;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaLineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.Debugger;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class LineBreakpoint
extends JavaLineBreakpointEvent
implements Executor,
StopEvent,
InfoProducer {
    static final long serialVersionUID = 1444281317183220550L;
    public static final String PROP_CONDITION = "condition";
    private transient ThreadReference thread;
    private transient Requestor requestor;
    private transient ReferenceType tryClass;
    private String condition = "";
    private transient String outerClassName;
    private transient boolean isSetOnNestedClass;
    private transient CoreBreakpoint.Action[] actions;
    private HashSet refTypesWithBreakpoint;
    static /* synthetic */ Class class$java$lang$String;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.condition == null) {
            this.condition = "";
        }
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof JPDADebugger)) {
            return false;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debugger;
        if (jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.getSourceName() == null || this.getSourceName().trim().length() < 1) {
            return false;
        }
        if (this.getLineNumber() < 0) {
            return false;
        }
        if (this.requestor == null) {
            this.requestor = new Requestor(jPDADebugger.requestManager, jPDADebugger.operator, this);
        }
        try {
            if (jPDADebugger.virtualMachine == null) {
                return false;
            }
            this.requestor.removeRequests();
            if (this.refTypesWithBreakpoint != null) {
                this.refTypesWithBreakpoint.clear();
            }
            ClassPrepareRequest classPrepareRequest = jPDADebugger.requestManager.createClassPrepareRequest();
            String string = this.getSourceName();
            int n = string.indexOf(36);
            this.outerClassName = n < 0 ? string : string.substring(0, n);
            boolean bl = this.isSetOnNestedClass = string != this.outerClassName;
            if (this.isSetOnNestedClass) {
                classPrepareRequest.addClassFilter(this.outerClassName + "$*");
            } else {
                classPrepareRequest.addClassFilter(this.outerClassName + '*');
            }
            classPrepareRequest.setSuspendPolicy(2);
            this.requestor.add(classPrepareRequest);
            classPrepareRequest.enable();
            List<ReferenceType> list = jPDADebugger.virtualMachine.classesByName(this.outerClassName);
            if (list.size() == 0 && (list = jPDADebugger.virtualMachine.classesByName(string)).size() == 0) {
                return false;
            }
            ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>(list);
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ReferenceType referenceType = arrayList.get(n2);
                if (this.set(referenceType)) {
                    bl2 = true;
                }
                try {
                    arrayList.addAll(referenceType.nestedTypes());
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
                ++n2;
            }
            return bl2;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public void remove() {
        if (this.requestor != null) {
            this.requestor.removeRequests();
        }
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = LineBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)"sourceName", (String)JPDADebugger.getLocString("PROP_breakpoint_source_name"), (String)JPDADebugger.getLocString("HINT_breakpoint_source_name"), (String)"getSourceName", (String)"setSourceName"), Utils.createProperty((Object)this, Integer.TYPE, (String)"lineNumber", (String)JPDADebugger.getLocString("PROP_breakpoint_line_number"), (String)JPDADebugger.getLocString("HINT_breakpoint_line_number"), (String)"getLineNumber", (String)"setLineNumber"), Utils.createProperty((Object)this, (Class)(class$java$lang$String == null ? (class$java$lang$String = LineBreakpoint.class$("java.lang.String")) : class$java$lang$String), (String)PROP_CONDITION, (String)JPDADebugger.getLocString("PROP_condition"), (String)JPDADebugger.getLocString("HINT_condition"), (String)"getCondition", (String)"setCondition")};
    }

    public CoreBreakpoint.Action[] getActions() {
        if (this.actions == null) {
            CoreBreakpoint.Action[] actionArray = super.getActions();
            this.actions = new CoreBreakpoint.Action[]{new JavaStopAction(), new PrintAction(PrintAction.BREAKPOINT_TEXT)};
            if (actionArray.length != 0) {
                CoreBreakpoint.Action[] actionArray2 = this.actions;
                this.actions = new CoreBreakpoint.Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray, 0, this.actions, 0, actionArray.length);
                System.arraycopy(actionArray2, 0, this.actions, actionArray.length, actionArray2.length);
            }
        }
        return this.actions;
    }

    public boolean supportsMIMEType(String string) {
        return string.equals("text/x-java");
    }

    public JComponent getCustomizer() {
        String string = JUtils.getCurrentClassName();
        this.setSourceName(string);
        int n = Utils.getCurrentLineNumber();
        if (n > 0) {
            this.setLine(Utils.getCurrentLine((String)string, (int)n));
        }
        return new LineBreakpointPanel(this);
    }

    protected String getAnnotationType() {
        boolean bl;
        boolean bl2 = bl = this.condition != null && !this.condition.trim().equals("");
        if (this.getBreakpoint().isEnabled()) {
            return bl ? DebuggerAnnotation.Breakpoint.TYPE_CONDITIONAL : DebuggerAnnotation.Breakpoint.TYPE_NORMAL;
        }
        return bl ? DebuggerAnnotation.Breakpoint.TYPE_DISABLED_CONDITIONAL : DebuggerAnnotation.Breakpoint.TYPE_DISABLED;
    }

    public JavaThread getThread() {
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        return jPDADebugger.threadManager.getThread(this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((JPDAThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        return null;
    }

    public void exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            boolean bl;
            boolean bl2;
            this.tryClass = ((ClassPrepareEvent)event).referenceType();
            String string = this.tryClass.name();
            String string2 = this.getSourceName();
            boolean bl3 = bl2 = this.isSetOnNestedClass || string.equals(string2) || string.startsWith(string2 + '$');
            if (bl2 && (bl = this.set(this.tryClass)) && !this.getBreakpoint().isValid()) {
                this.setValid(true);
            }
            ((JPDADebugger)this.getDebugger()).operator.resume();
            return;
        }
        this.thread = ((BreakpointEvent)event).thread();
        if (((JPDADebugger)this.getDebugger()).resolveCanBeCurrent(this.thread)) {
            return;
        }
        this.perform();
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getCondition() {
        return this.condition;
    }

    protected void perform() {
        CoreBreakpoint.Action[] actionArray;
        if (!this.condition.trim().equals("")) {
            actionArray = (CoreBreakpoint.Action[])this.getDebugger();
            JPDAWatch jPDAWatch = new JPDAWatch((JPDADebugger)actionArray, true);
            jPDAWatch.setVariableName(this.condition);
            jPDAWatch.refreshValue((JPDAThread)this.getThread());
            String string = jPDAWatch.getType();
            String string2 = jPDAWatch.getAsText();
            if (string != null && string.equals("boolean") && string2 != null && string2.equals("false")) {
                this.stop(false);
                return;
            }
            if (string == null || !string.equals("boolean")) {
                actionArray.getIOManager().println(JPDADebugger.getLocString("CTL_Incorrect_condition") + ": " + JPDADebugger.getLocString("CTL_breakpoint_at") + " " + this.getDisplayName() + ".", 1);
            }
        }
        super.perform();
        actionArray = this.getBreakpoint().getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] instanceof JavaStopAction) {
                ((JavaStopAction)actionArray[n]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++n;
        }
    }

    public void stop(boolean bl) {
        ((JPDADebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(ReferenceType referenceType) {
        JPDADebugger jPDADebugger = (JPDADebugger)this.getDebugger();
        if (jPDADebugger.virtualMachine == null) return false;
        if (jPDADebugger.isDisconnected()) {
            return false;
        }
        if (this.getLineNumber() < 0) {
            return false;
        }
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (this.refTypesWithBreakpoint == null) {
                this.refTypesWithBreakpoint = new HashSet(17);
            } else {
                try {
                    if (this.refTypesWithBreakpoint.contains(referenceType)) {
                        return true;
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    // empty catch block
                }
            }
            this.refTypesWithBreakpoint.add(referenceType);
        }
        try {
            Object object;
            Object object2;
            List<Location> list = null;
            int n = this.getLineNumber();
            Line.Set set = Utils.getLineSet((String)this.getSourceName());
            if (set != null && (object2 = set.getOriginal(this.lineNumber)) != null) {
                n = object2.getLineNumber();
            }
            try {
                list = referenceType.locationsOfLine(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) return false;
            if (list.size() < 1) {
                return false;
            }
            object2 = list.get(0);
            try {
                Line line;
                object = this.getBreakpoint();
                if (object.getLine() == null && !object.isHidden() && (line = Utils.getLineForSource((String)this.getSourceName(), (String)object2.sourceName(), (int)this.getLineNumber())) != null) {
                    ((LineBreakpoint)object.getEvent()).setLine(line);
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            object = jPDADebugger.requestManager.createBreakpointRequest((Location)object2);
            object.setSuspendPolicy(2);
            this.requestor.add((EventRequest)object);
            object.enable();
            return true;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

