/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.jpda.ArrayElement;
import org.netbeans.modules.debugger.jpda.InstanceField;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAFilter;
import org.netbeans.modules.debugger.jpda.JPDAFixedWatch;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.SuperVariable;
import org.netbeans.modules.debugger.jpda.evaluator.EvaluateException;
import org.netbeans.modules.debugger.jpda.evaluator.Evaluator;
import org.netbeans.modules.debugger.jpda.evaluator.TimeoutException;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public abstract class JPDAVariable
implements JavaVariable {
    private static ResourceBundle bundle;
    public static boolean ON_LINE;
    protected transient Value remoteValue;
    protected transient String name;
    protected transient String value;
    protected transient String innerType;
    protected transient String type;
    protected transient String modifiers;
    protected transient VariablesFilter filter;
    protected transient HashMap oldVariables = new HashMap();
    private transient JPDAVariable[] oldFields;
    protected transient boolean isCloned;
    private transient boolean isArray;
    protected transient boolean isObject;
    private transient Validator validator;
    private int startIndex = 0;
    private int length = 100;
    private transient PropertyChangeSupport pcs;
    protected JPDADebugger debugger;
    protected boolean validate;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$JPDAVariable;

    static void notify(String string) {
        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
    }

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$jpda$JPDAVariable == null ? (class$org$netbeans$modules$debugger$jpda$JPDAVariable = JPDAVariable.class$("org.netbeans.modules.debugger.jpda.JPDAVariable")) : class$org$netbeans$modules$debugger$jpda$JPDAVariable));
        }
        return bundle.getString(string);
    }

    JPDAVariable(JPDADebugger jPDADebugger, boolean bl) {
        this.validator = bl ? jPDADebugger.getValidator() : null;
        this.debugger = jPDADebugger;
        this.validate = bl;
        this.init();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    protected void init() {
        if (this.validate && !ON_LINE) {
            this.validator = this.debugger.getValidator();
            this.validator.add((Validator.Object)this);
        }
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getVariableName() {
        return this.name;
    }

    public String getAsText() {
        return this.value;
    }

    public void setAsText(String string) {
        if (this.debugger.getState() != 4) {
            return;
        }
        if (this.isCloned) {
            return;
        }
        JPDAThread jPDAThread = (JPDAThread)this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            return;
        }
        ThreadReference threadReference = jPDAThread.getThreadReference();
        Value value = null;
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add("java.lang");
            value = Evaluator.evaluate(string, this.debugger.virtualMachine, threadReference, linkedList);
        }
        catch (EvaluateException evaluateException) {
            if (evaluateException instanceof TimeoutException) {
                Line line;
                jPDAThread.setSuspended(true);
                jPDAThread.refresh();
                this.debugger.setCurrentLine(null);
                int n = jPDAThread.getLineNumber();
                if (n >= 0 && (line = jPDAThread.getLine()) != null) {
                    this.debugger.setCurrentLine(line);
                }
                this.debugger.annotateCallStack();
            }
            return;
        }
        if (!this.setValue(value)) {
            return;
        }
        if (value == null) {
            this.setRemoteValue(null);
            this.type = "";
            this.update();
        } else {
            this.setRemoteValue(value);
            this.type = value.type().name();
            this.update();
        }
        this.firePropertyChange();
    }

    public String getType() {
        return this.type;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isLeaf() {
        return this.remoteValue == null || !(this.remoteValue instanceof ObjectReference);
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
        this.pcs.firePropertyChange("variablesFilter", variablesFilter2, variablesFilter);
    }

    public AbstractVariable[] getVariables() {
        String string = this.name;
        if (this.remoteValue == null || !(this.remoteValue instanceof ObjectReference)) {
            return new JPDAVariable[0];
        }
        if (this.oldFields != null) {
            return this.oldFields;
        }
        try {
            JPDAVariable[] jPDAVariableArray;
            if (this.remoteValue instanceof ArrayReference) {
                String string2 = this.innerType.substring(0, this.innerType.length() - 2);
                ArrayReference arrayReference = (ArrayReference)this.remoteValue;
                int n = arrayReference.getValues().size();
                jPDAVariableArray = new JPDAVariable[n];
                int n2 = 0;
                while (n2 < n) {
                    jPDAVariableArray[n2] = new ArrayElement(this.debugger, arrayReference, string, n2, string2);
                    ++n2;
                }
            } else {
                List<Field> list = ((ObjectReference)this.remoteValue).referenceType().allFields();
                int n = list.size();
                jPDAVariableArray = new JPDAVariable[n];
                int n3 = 0;
                while (n3 < n) {
                    jPDAVariableArray[n3] = new InstanceField(this.debugger, (ObjectReference)this.remoteValue, list.get(n3));
                    ++n3;
                }
            }
            this.oldFields = jPDAVariableArray;
            return jPDAVariableArray;
        }
        catch (Exception exception) {
            return new JPDAVariable[0];
        }
    }

    public String getInnerType() {
        return this.innerType;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public String getInfo() {
        return null;
    }

    public AbstractVariable getVariable(String string) {
        try {
            Field field = ((ObjectReference)this.remoteValue).referenceType().fieldByName(string);
            JPDAVariable jPDAVariable = (JPDAVariable)this.oldVariables.get(field);
            if (jPDAVariable == null) {
                jPDAVariable = new InstanceField(this.debugger, (ObjectReference)this.remoteValue, field);
                this.oldVariables.put(field, jPDAVariable);
            } else if (ON_LINE) {
                jPDAVariable.validate();
            }
            return jPDAVariable;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getVariablesNumber() {
        if (this.remoteValue == null || !(this.remoteValue instanceof ArrayReference)) {
            return 0;
        }
        return ((ArrayReference)this.remoteValue).length();
    }

    public boolean canRemove() {
        return true;
    }

    protected void update() {
        if (this.remoteValue == null) {
            this.isObject = false;
            this.isArray = false;
            this.value = "null";
            this.innerType = "";
        } else {
            try {
                this.isObject = this.remoteValue instanceof ObjectReference;
                this.isArray = this.remoteValue instanceof ArrayReference;
                if (this.isArray) {
                    this.value = "#" + ((ObjectReference)this.remoteValue).uniqueID();
                    this.innerType = ((ObjectReference)this.remoteValue).referenceType().name();
                } else if (this.isObject) {
                    if (this.remoteValue instanceof StringReference) {
                        String string = this.remoteValue.toString();
                        string = string.substring(1, string.length() - 1);
                        string = JUtils.convertToStringInitializer((String)string);
                        this.value = "\"" + string + "\"";
                    } else {
                        this.value = "#" + ((ObjectReference)this.remoteValue).uniqueID();
                    }
                    this.innerType = ((ObjectReference)this.remoteValue).referenceType().name();
                } else {
                    this.innerType = this.remoteValue.type().name();
                    this.value = this.remoteValue.toString();
                }
            }
            catch (Exception exception) {
                this.type = null;
                this.value = exception.toString();
            }
        }
    }

    protected void firePropertyChange() {
        this.pcs.firePropertyChange(null, null, null);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + this.hashCode() + "[" + this.getParamString() + "]";
    }

    public String getParamString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.name != null) {
            stringBuffer.append(this.name);
            stringBuffer.append(" = ");
        }
        String string = null;
        if (this.debugger != null) {
            try {
                string = this.toStringValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append('?');
        }
        return stringBuffer.toString();
    }

    public String toStringValue() {
        if (this.remoteValue == null) {
            return "null";
        }
        if (this.remoteValue instanceof StringReference) {
            String string = this.remoteValue.toString();
            string = string.substring(1, string.length() - 1);
            string = JUtils.convertToStringInitializer((String)string);
            return "\"" + string + "\"";
        }
        if (this.remoteValue instanceof PrimitiveValue) {
            return this.remoteValue.toString();
        }
        if (this.remoteValue instanceof ArrayReference) {
            String string = this.getInnerType();
            if (string == null) {
                return "";
            }
            int n = string.indexOf("[]");
            if (n >= 0) {
                string = string.substring(0, n + 1) + this.getSize() + string.substring(n + 1, string.length());
            }
            return string;
        }
        JPDAThread jPDAThread = (JPDAThread)this.debugger.getCurrentThread();
        if (jPDAThread == null) {
            return "???";
        }
        ThreadReference threadReference = jPDAThread.getThreadReference();
        if (threadReference == null) {
            return "???";
        }
        ObjectReference objectReference = (ObjectReference)this.remoteValue;
        ReferenceType referenceType = ((ObjectReference)this.remoteValue).referenceType();
        Method method = this.debugger.getToStringMethod();
        try {
            Value value = Evaluator.toString(objectReference, method, threadReference);
            return value instanceof StringReference ? value.toString() : "null";
        }
        catch (EvaluateException evaluateException) {
            if (evaluateException instanceof TimeoutException) {
                Line line;
                jPDAThread.setSuspended(true);
                jPDAThread.refresh();
                this.debugger.setCurrentLine(null);
                int n = jPDAThread.getLineNumber();
                if (n >= 0 && (line = jPDAThread.getLine()) != null) {
                    this.debugger.setCurrentLine(line);
                }
                this.debugger.annotateCallStack();
            }
            return null;
        }
    }

    public JavaVariable createFixedVariable() {
        return new JPDAFixedWatch(this.debugger, this.name, this.remoteValue, this.type);
    }

    public boolean isFixedVariable() {
        return this.isCloned;
    }

    JPDADebugger getDebugger() {
        return this.debugger;
    }

    Value getRemoteValue() {
        return this.remoteValue;
    }

    protected abstract boolean setValue(Value var1);

    protected void setRemoteValue(Value value) {
        if (value == this.remoteValue) {
            return;
        }
        if (value != null && this.remoteValue != null && value.equals(this.remoteValue)) {
            return;
        }
        this.remoteValue = value;
        this.oldVariables = new HashMap();
        this.disposeOldFields();
    }

    private void dispose() {
        this.debugger.getValidator().remove((Validator.Object)this);
        this.disposeOldFields();
    }

    private void disposeOldFields() {
        if (this.oldFields != null) {
            int n = this.oldFields.length;
            int n2 = 0;
            while (n2 < n) {
                this.oldFields[n2].dispose();
                ++n2;
            }
            this.oldFields = null;
        }
    }

    public JavaVariable[] filterVariables(ModifiersFilter modifiersFilter, int n, int n2) {
        try {
            JavaVariable[] javaVariableArray;
            HashMap<Object, JavaVariable> hashMap = new HashMap<Object, JavaVariable>();
            if (this.remoteValue instanceof ArrayReference) {
                String string = this.innerType.substring(0, this.innerType.length() - 2);
                ArrayReference arrayReference = (ArrayReference)this.remoteValue;
                int n3 = Math.min(arrayReference.length(), n2);
                javaVariableArray = new JPDAVariable[n3];
                int n4 = 0;
                while (n4 < n3) {
                    Integer n5 = new Integer(n + n4);
                    javaVariableArray[n4] = (JPDAVariable)this.oldVariables.get(n5);
                    if (javaVariableArray[n4] == null) {
                        javaVariableArray[n4] = new ArrayElement(this.debugger, arrayReference, this.name, n + n4, string);
                    } else if (ON_LINE) {
                        javaVariableArray[n4].validate();
                    }
                    hashMap.put(n5, javaVariableArray[n4]);
                    ++n4;
                }
            } else {
                JPDAVariable jPDAVariable;
                Object object;
                Comparable<Field> comparable;
                List<Field> list = null;
                list = modifiersFilter != null && !modifiersFilter.isInherited() ? ((ObjectReference)this.remoteValue).referenceType().fields() : ((ObjectReference)this.remoteValue).referenceType().allFields();
                int n6 = list.size();
                ArrayList<JPDAVariable> arrayList = new ArrayList<JPDAVariable>(n6);
                int n7 = 0;
                while (n7 < n6) {
                    comparable = list.get(n7);
                    if (modifiersFilter == null || JPDAFilter.filter((Field)comparable, modifiersFilter)) {
                        object = comparable.name();
                        jPDAVariable = (JPDAVariable)this.oldVariables.get(comparable);
                        if (jPDAVariable == null) {
                            jPDAVariable = new InstanceField(this.debugger, (ObjectReference)this.remoteValue, (Field)comparable);
                        } else if (ON_LINE) {
                            jPDAVariable.validate();
                        }
                        hashMap.put(comparable, jPDAVariable);
                        arrayList.add(jPDAVariable);
                    }
                    ++n7;
                }
                if (modifiersFilter != null && !modifiersFilter.isInherited() && (object = (comparable = (ClassType)((ObjectReference)this.remoteValue).referenceType()).superclass()) != null) {
                    jPDAVariable = (JPDAVariable)this.oldVariables.get(object);
                    if (jPDAVariable == null) {
                        jPDAVariable = new SuperVariable(this.debugger, (ObjectReference)this.remoteValue, (ClassType)object);
                    }
                    hashMap.put(object, jPDAVariable);
                    arrayList.add(jPDAVariable);
                }
                javaVariableArray = new JPDAVariable[arrayList.size()];
                javaVariableArray = arrayList.toArray(javaVariableArray);
            }
            this.oldVariables = hashMap;
            return javaVariableArray;
        }
        catch (Exception exception) {
            this.oldVariables = new HashMap();
            return new JPDAVariable[0];
        }
    }

    public int getSize() {
        if (this.remoteValue instanceof ArrayReference) {
            return ((ArrayReference)this.remoteValue).length();
        }
        return 0;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid start index: " + n + " (must be non-negative)");
        }
        int n2 = this.startIndex;
        this.startIndex = n;
        this.firePropertyChange();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length: " + n + " (must be non-negative)");
        }
        int n2 = this.length;
        this.length = n;
        this.firePropertyChange();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ON_LINE = false;
    }
}

