/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.LinkedList;
import org.netbeans.modules.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.Monitor;

public class JPDAMonitor
extends Monitor {
    private ObjectReference ref;
    private JPDADebugger debugger;

    public JPDAMonitor(JPDADebugger jPDADebugger, ObjectReference objectReference) {
        this.debugger = jPDADebugger;
        this.ref = objectReference;
    }

    public String name() {
        return "(" + this.ref.referenceType().name() + ") #" + this.ref.uniqueID();
    }

    public JavaThread owningThread() {
        try {
            ThreadReference threadReference = this.ref.owningThread();
            if (threadReference != null) {
                return this.debugger.threadManager.findThread(threadReference);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public JavaThread[] waitingThreads() {
        int n;
        JavaThread[] javaThreadArray;
        LinkedList<JPDAThread> linkedList = new LinkedList<JPDAThread>();
        try {
            javaThreadArray = this.ref.waitingThreads();
            n = 0;
            while (n < javaThreadArray.size()) {
                JPDAThread jPDAThread = this.debugger.threadManager.findThread((ThreadReference)javaThreadArray.get(n));
                if (jPDAThread != null) {
                    linkedList.add(jPDAThread);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        javaThreadArray = new JavaThread[linkedList.size()];
        n = 0;
        while (n < linkedList.size()) {
            javaThreadArray[n] = (JavaThread)linkedList.get(n);
            ++n;
        }
        return javaThreadArray;
    }

    ObjectReference reference() {
        return this.ref;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JPDAMonitor)) {
            return false;
        }
        return this.ref.equals(((JPDAMonitor)((Object)object)).reference());
    }
}

