/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public abstract class NbBaseServlet
extends HttpServlet {
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$NbBaseServlet;
    static /* synthetic */ Class class$org$netbeans$modules$httpserver$HttpServerSettings;

    public void init() throws ServletException {
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$NbBaseServlet == null ? (class$org$netbeans$modules$httpserver$NbBaseServlet = NbBaseServlet.class$("org.netbeans.modules.httpserver.NbBaseServlet")) : class$org$netbeans$modules$httpserver$NbBaseServlet)).getString("MSG_BaseServletDescr");
    }

    protected boolean checkAccess(HttpServletRequest httpServletRequest) throws IOException {
        HttpServerSettings httpServerSettings = (HttpServerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$httpserver$HttpServerSettings == null ? (class$org$netbeans$modules$httpserver$HttpServerSettings = NbBaseServlet.class$("org.netbeans.modules.httpserver.HttpServerSettings")) : class$org$netbeans$modules$httpserver$HttpServerSettings));
        if (httpServerSettings == null) {
            return false;
        }
        if (httpServerSettings.getHostProperty().getHost().equals("any")) {
            return true;
        }
        HashSet hashSet = httpServerSettings.getGrantedAddressesSet();
        if (hashSet.contains(httpServletRequest.getRemoteAddr().trim())) {
            return true;
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = "";
        }
        try {
            String string2 = httpServletRequest.getRemoteAddr().trim();
            if (httpServerSettings.allowAccess(InetAddress.getByName(string2), string)) {
                return true;
            }
        }
        catch (Exception exception) {
            TopManager.getDefault().notifyException((Throwable)exception);
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleClasspathRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        InputStream inputStream;
        block12: {
            boolean bl;
            block11: {
                String string = httpServletRequest.getPathInfo();
                if (string == null) {
                    return false;
                }
                if (string.length() == 0) {
                    return false;
                }
                if (string.charAt(0) == '/') {
                    string = string.substring(1);
                }
                if (string.length() == 0) {
                    return false;
                }
                inputStream = TopManager.getDefault().systemClassLoader().getResourceAsStream(string);
                if (inputStream == null) {
                    return false;
                }
                try {
                    String string2;
                    String string3 = null;
                    int n = string.lastIndexOf(".");
                    if (n != -1) {
                        string2 = string.substring(n + 1);
                        string3 = FileUtil.getMIMEType((String)string2);
                    }
                    if (string3 == null) {
                        bl = false;
                        Object var11_9 = null;
                        break block11;
                    }
                    httpServletResponse.setContentType(string3);
                    string2 = httpServletResponse.getOutputStream();
                    try {
                        NbBaseServlet.copyStream(inputStream, (OutputStream)((Object)string2));
                        Object var9_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        ((OutputStream)((Object)string2)).close();
                        throw throwable;
                    }
                    ((OutputStream)((Object)string2)).close();
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    inputStream.close();
                    throw throwable;
                }
            }
            inputStream.close();
            return bl;
        }
        Object var11_10 = null;
        inputStream.close();
        return true;
    }

    protected boolean handleRepositoryRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            return false;
        }
        FileObject fileObject = TopManager.getDefault().getRepository().findResource(string);
        if (fileObject == null && string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            fileObject = TopManager.getDefault().getRepository().findResource(string + '/');
        }
        if (fileObject == null) {
            return false;
        }
        if (fileObject.isFolder()) {
            this.sendDirectory(httpServletRequest, httpServletResponse, fileObject);
        } else {
            this.sendFile(httpServletRequest, httpServletResponse, fileObject);
        }
        return true;
    }

    private void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileObject fileObject) throws IOException {
        String string = fileObject.getMIMEType();
        httpServletResponse.setContentType(string);
        int n = (int)fileObject.getSize();
        httpServletResponse.setContentLength(n);
        httpServletResponse.setDateHeader("Last-Modified", fileObject.lastModified().getTime());
        InputStream inputStream = fileObject.getInputStream();
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                NbBaseServlet.copyStream(inputStream, (OutputStream)servletOutputStream);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                servletOutputStream.close();
                throw throwable;
            }
            servletOutputStream.close();
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private void sendDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileObject fileObject) throws IOException {
        String string = fileObject.getPackageName('/');
        httpServletResponse.setContentType("text/html");
        String string2 = string;
        if (string2.length() == 0) {
            string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$NbBaseServlet == null ? (class$org$netbeans$modules$httpserver$NbBaseServlet = NbBaseServlet.class$("org.netbeans.modules.httpserver.NbBaseServlet")) : class$org$netbeans$modules$httpserver$NbBaseServlet)).getString("LAB_REPOSITORY_ROOT");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<HTML><HEAD><TITLE>");
        printWriter.print(string2);
        printWriter.print("</TITLE></HEAD><BODY>\n<H1>");
        printWriter.print(string2);
        printWriter.print("</H1>");
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 != null) {
            printWriter.print("<A HREF=\"../\">" + NbBundle.getBundle((Class)(class$org$netbeans$modules$httpserver$NbBaseServlet == null ? (class$org$netbeans$modules$httpserver$NbBaseServlet = NbBaseServlet.class$("org.netbeans.modules.httpserver.NbBaseServlet")) : class$org$netbeans$modules$httpserver$NbBaseServlet)).getString("CTL_PARENT_DIR") + "</A><BR><BR>\n");
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        Iterator iterator = NbBaseServlet.sortEnumeration(NbBaseServlet.children(fileObject.getPackageNameExt('/', '.')), new Comparator(){

            public int compare(Object object, Object object2) {
                FileObject fileObject = (FileObject)object;
                FileObject fileObject2 = (FileObject)object2;
                if (fileObject.isFolder() && !fileObject2.isFolder()) {
                    return -1;
                }
                if (!fileObject.isFolder() && fileObject2.isFolder()) {
                    return 1;
                }
                int n = String.CASE_INSENSITIVE_ORDER.compare(fileObject.getName(), fileObject2.getName());
                if (n == 0) {
                    n = String.CASE_INSENSITIVE_ORDER.compare(fileObject.getExt(), fileObject2.getExt());
                }
                return n;
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            FileObject fileObject3 = (FileObject)iterator.next();
            if (fileObject3.isFolder()) {
                string4 = "<B>";
                string3 = "</B>";
            } else {
                string4 = "";
                string3 = "";
            }
            String string5 = fileObject3.getExt().length() == 0 ? fileObject3.getName() : fileObject3.getName() + "." + fileObject3.getExt();
            if (hashMap.get(string5) != null) continue;
            hashMap.put(string5, string5);
            printWriter.print("<A HREF=\"");
            printWriter.print(string5);
            if (fileObject3.isFolder()) {
                printWriter.println("/");
            }
            printWriter.print("\">");
            printWriter.print(string4 + string5 + string3);
            printWriter.print("</A>");
            printWriter.println("<BR>");
        }
        printWriter.flush();
    }

    private static Iterator sortEnumeration(Enumeration enumeration, Comparator comparator) {
        TreeSet treeSet = new TreeSet(comparator);
        while (enumeration.hasMoreElements()) {
            treeSet.add(enumeration.nextElement());
        }
        return treeSet.iterator();
    }

    private static Enumeration children(final String string) {
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        enumeration = new AlterEnumeration(enumeration){

            public Object alter(Object object) {
                FileSystem fileSystem = (FileSystem)object;
                if (fileSystem.isHidden()) {
                    return EmptyEnumeration.EMPTY;
                }
                FileObject fileObject = fileSystem.findResource(string);
                if (fileObject == null || !fileObject.isFolder()) {
                    return EmptyEnumeration.EMPTY;
                }
                return fileObject.getChildren(false);
            }
        };
        return new SequenceEnumeration(enumeration);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 8000;
        try {
            byte[] byArray = new byte[n];
            int n2 = n;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            outputStream.flush();
            throw throwable;
        }
        outputStream.flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

