/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.Format;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.UnixWebBrowser;
import org.netbeans.modules.httpserver.WrapperServlet;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class UnixBrowserImpl
extends ExtBrowserImpl {
    private static boolean debug = false;
    private transient int currWinID = -1;
    int nOfProbes = 3;
    int probeDelayLength = 3000;
    private ExtWebBrowser extBrowserFactory;
    static /* synthetic */ Class class$org$netbeans$modules$extbrowser$UnixBrowserImpl;

    public UnixBrowserImpl() {
        this(null);
    }

    public UnixBrowserImpl(ExtWebBrowser extWebBrowser) {
        this.extBrowserFactory = extWebBrowser;
    }

    public void backward() {
    }

    public void forward() {
    }

    public boolean isBackward() {
        return false;
    }

    public boolean isForward() {
        return false;
    }

    public boolean isHistory() {
        return false;
    }

    public void reloadDocument() {
        if (this.url != null) {
            this.setURL(this.url);
        }
    }

    public void setURL(URL uRL) {
        if (SwingUtilities.isEventDispatchThread()) {
            final URL uRL2 = uRL;
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    UnixBrowserImpl.this.setURL(uRL2);
                }
            });
            return;
        }
        NbProcessDescriptor nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
        TopManager topManager = TopManager.getDefault();
        try {
            if (ExtBrowserImpl.isInternalProtocol(uRL.getProtocol())) {
                uRL = WrapperServlet.createHttpURL((URL)uRL);
            }
            if (this.currWinID != -1 && this.getXProperty(this.currWinID, "WM_NAME") == null) {
                this.currWinID = -1;
            }
            if (this.currWinID == -1) {
                nbProcessDescriptor = new NbProcessDescriptor("xwininfo", "-name " + this.getCommand(false));
                Process process = nbProcessDescriptor.exec();
                if (process.waitFor() == 0) {
                    nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
                    topManager.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)nbProcessDescriptor.getProcessName()));
                    process = nbProcessDescriptor.exec((Format)((Object)new UnixWebBrowser.UnixBrowserFormat(new ExecInfo(""), "-raise -remote openURL(" + uRL.toString() + ",new-window)")));
                    if (process.waitFor() != 0) {
                        topManager.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{nbProcessDescriptor.getProcessName()}), 2));
                        return;
                    }
                } else {
                    nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
                    topManager.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)nbProcessDescriptor.getProcessName()));
                    process = nbProcessDescriptor.exec((Format)((Object)new UnixWebBrowser.UnixBrowserFormat(new ExecInfo(""), uRL.toString())));
                }
                new Thread(new WindowFinder(uRL.toString())).start();
            } else {
                nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable();
                topManager.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)nbProcessDescriptor.getProcessName()));
                Process process = nbProcessDescriptor.exec((Format)((Object)new UnixWebBrowser.UnixBrowserFormat(new ExecInfo(""), "-id 0x" + Integer.toHexString(this.currWinID) + " -raise -remote openURL(" + uRL.toString() + ")")));
                if (process.waitFor() != 0) {
                    topManager.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{nbProcessDescriptor.getProcessName()}), 2));
                    return;
                }
            }
            URL uRL3 = this.url;
            this.url = uRL;
            this.pcs.firePropertyChange("url", uRL3, uRL);
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    TopManager.getDefault().setStatusText("");
                }
            }, (int)2000, (int)1);
        }
        catch (IOException iOException) {
            topManager.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{nbProcessDescriptor.getProcessName()}), 2));
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
            interruptedException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException.getMessage());
            numberFormatException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void showHistory() {
    }

    public void stopLoading() {
    }

    private void setWindowID(int n) {
        if (debug) {
            System.out.println("setWindowID to " + Integer.toHexString(n));
        }
        this.currWinID = n;
    }

    private String getXProperty(int n, String string) {
        try {
            BufferedReader bufferedReader;
            String string2;
            Process process = Runtime.getRuntime().exec("xprop -id 0x" + Integer.toHexString(n) + " " + string);
            if (process.waitFor() == 0 && (string2 = (bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()))).readLine()) != null && string2.startsWith(string + "(STRING)")) {
                int n2 = string2.indexOf(34);
                int n3 = string2.indexOf(34, n2 + 1);
                if (n2 == -1 || n3 == -1) {
                    return null;
                }
                return string2.substring(n2 + 1, n3);
            }
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return null;
    }

    private String getCommand(boolean bl) {
        NbProcessDescriptor nbProcessDescriptor;
        String string = "netscape";
        if (this.extBrowserFactory != null && (nbProcessDescriptor = this.extBrowserFactory.getBrowserExecutable()) != null) {
            string = nbProcessDescriptor.getProcessName();
        }
        if (!bl) {
            int n = string.lastIndexOf(47);
            if (n == -1 && Utilities.isWindows()) {
                n = string.lastIndexOf(92);
            }
            if (n != -1 && string.length() > n) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0) {
                string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WindowFinder
    implements Runnable {
        String url;

        public WindowFinder(String string) {
            this.url = string;
        }

        public void run() {
            try {
                String string;
                int n;
                String string2;
                String string3;
                BufferedReader bufferedReader;
                int n2;
                InputStream inputStream;
                Process process;
                int n3 = UnixBrowserImpl.this.nOfProbes;
                while (n3 > 0) {
                    UnixBrowserImpl.this.setStatusMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl") : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_look_for_win"));
                    process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "xwininfo -root -tree|grep " + UnixBrowserImpl.this.getCommand(false)});
                    inputStream = process.getInputStream();
                    n2 = process.waitFor();
                    if (n2 == 0) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((string3 = bufferedReader.readLine()) != null) {
                            string2 = string3.substring(string3.indexOf(120) + 1);
                            n = Integer.parseInt(string2 = string2.substring(0, string2.indexOf(32)), 16);
                            string = UnixBrowserImpl.this.getXProperty(n, "_MOZILLA_URL");
                            if (string == null || !string.equals(this.url)) continue;
                            UnixBrowserImpl.this.setWindowID(n);
                            UnixBrowserImpl.this.setTitle(UnixBrowserImpl.this.getXProperty(n, "WM_NAME"));
                            return;
                        }
                    }
                    Thread.sleep(UnixBrowserImpl.this.probeDelayLength);
                    --n3;
                }
                UnixBrowserImpl.this.setStatusMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_look_for_win"));
                process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "xwininfo -root -tree|grep " + UnixBrowserImpl.this.getCommand(false)});
                inputStream = process.getInputStream();
                n2 = process.waitFor();
                if (n2 == 0) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        string2 = string3.substring(string3.indexOf(120) + 1);
                        n = Integer.parseInt(string2 = string2.substring(0, string2.indexOf(32)), 16);
                        string = UnixBrowserImpl.this.getXProperty(n, "WM_NAME");
                        if (string == null) continue;
                        UnixBrowserImpl.this.setWindowID(n);
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException.getMessage());
                interruptedException.printStackTrace();
            }
        }
    }
}

