/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class NbToolTip
extends FileChangeAdapter {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.tooltip");
    private static final HashMap mime2tip = new HashMap();
    private String mimeType;
    private Annotation[] tipAnnotations;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbToolTip;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    static synchronized void buildToolTip(JTextComponent jTextComponent) {
        String string = NbEditorUtilities.getMimeType(jTextComponent.getDocument());
        NbToolTip nbToolTip = NbToolTip.getTip(string);
        nbToolTip.buildTip(jTextComponent);
    }

    private NbToolTip(String string) {
        this.mimeType = string;
    }

    private static NbToolTip getTip(String string) {
        NbToolTip nbToolTip = (NbToolTip)((Object)mime2tip.get(string));
        if (nbToolTip == null) {
            nbToolTip = new NbToolTip(string);
            mime2tip.put(string, nbToolTip);
        }
        return nbToolTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Annotation[] getTipAnnotations() {
        Annotation[] annotationArray;
        Class clazz = class$org$netbeans$modules$editor$NbToolTip == null ? (class$org$netbeans$modules$editor$NbToolTip = NbToolTip.class$("org.netbeans.modules.editor.NbToolTip")) : class$org$netbeans$modules$editor$NbToolTip;
        synchronized (clazz) {
            annotationArray = this.tipAnnotations;
        }
        if (annotationArray == null) {
            if (debug) {
                System.err.println("Searching for tooltip annotations for mimeType=" + this.mimeType);
            }
            FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Editors/" + this.mimeType + "/ToolTips");
            if (debug) {
                System.err.println("tooltip annotation folder=" + fileObject);
            }
            if (fileObject != null) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Enumeration enumeration = fileObject.getChildren(false);
                while (enumeration.hasMoreElements()) {
                    object = (FileObject)enumeration.nextElement();
                    if (debug) {
                        System.err.println("tooltip annotation fileobject=" + object);
                    }
                    try {
                        DataObject dataObject = DataObject.find((FileObject)object);
                        InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbToolTip.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                        if (debug) {
                            System.err.println("tooltip annotation instanceCookie=" + instanceCookie);
                        }
                        if (instanceCookie == null) continue;
                        Object object2 = instanceCookie.instanceCreate();
                        if (debug) {
                            System.err.println("tooltip annotation instance=" + object2);
                        }
                        if (!(object2 instanceof Annotation)) continue;
                        if (debug) {
                            System.err.println("Found tooltip annotation=" + object2 + ", class " + object2.getClass() + " for mimeType=" + this.mimeType);
                        }
                        arrayList.add(object2);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                annotationArray = arrayList.toArray(new Annotation[arrayList.size()]);
                object = class$org$netbeans$modules$editor$NbToolTip == null ? (class$org$netbeans$modules$editor$NbToolTip = NbToolTip.class$("org.netbeans.modules.editor.NbToolTip")) : class$org$netbeans$modules$editor$NbToolTip;
                synchronized (object) {
                    this.tipAnnotations = annotationArray;
                }
                fileObject.addFileChangeListener((FileChangeListener)this);
            }
        }
        return annotationArray;
    }

    private void buildTip(JTextComponent jTextComponent) {
        int n;
        BaseDocument baseDocument;
        ToolTipSupport toolTipSupport;
        ExtEditorUI extEditorUI;
        Annotation[] annotationArray = this.getTipAnnotations();
        if (annotationArray != null && (extEditorUI = ExtUtilities.getExtEditorUI(jTextComponent)) != null && (toolTipSupport = extEditorUI.getToolTipSupport()) != null && (baseDocument = Utilities.getDocument(jTextComponent)) != null && (n = jTextComponent.viewToModel(toolTipSupport.getLastMouseEvent().getPoint())) >= 0) {
            try {
                Line.Part part;
                Line line;
                Line.Set set;
                EditorCookie editorCookie;
                int n2 = Utilities.getLineOffset(baseDocument, n);
                int n3 = n - Utilities.getRowStart(jTextComponent, n);
                DataObject dataObject = NbEditorUtilities.getDataObject(baseDocument);
                if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = NbToolTip.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)) != null && (set = editorCookie.getLineSet()) != null && (line = set.getCurrent(n2)) != null && (part = line.createPart(n3, 0)) != null) {
                    new Request(annotationArray, part, toolTipSupport).run();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Request
    implements Runnable,
    PropertyChangeListener {
        private ToolTipSupport tts;
        private Annotation[] annos;

        Request(Annotation[] annotationArray, Line.Part part, ToolTipSupport toolTipSupport) {
            this.annos = annotationArray;
            this.tts = toolTipSupport;
            toolTipSupport.addPropertyChangeListener(this);
            int n = 0;
            while (n < annotationArray.length) {
                annotationArray[n].attach((Annotatable)part);
                ++n;
            }
        }

        public void run() {
            int n = 0;
            while (n < this.annos.length) {
                String string = this.annos[n].getShortDescription();
                if (string != null) {
                    this.tts.setToolTipText(string);
                }
                this.annos[n].addPropertyChangeListener((PropertyChangeListener)this);
                ++n;
            }
        }

        private void dismiss() {
            this.tts.removePropertyChangeListener(this);
            this.tts = null;
            int n = 0;
            while (n < this.annos.length) {
                this.annos[n].removePropertyChangeListener((PropertyChangeListener)this);
                this.annos[n].detach();
                ++n;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("shortDescription".equals(string)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    Utilities.runInEventDispatchThread(new Runnable(this, string2){
                        private final /* synthetic */ String val$tipText;
                        private final /* synthetic */ Request this$0;
                        {
                            this.this$0 = request;
                            this.val$tipText = string;
                        }

                        public void run() {
                            if (Request.access$000(this.this$0) != null) {
                                Request.access$000(this.this$0).setToolTipText(this.val$tipText);
                            }
                        }
                    });
                }
            } else if ("status".equals(string) && (Integer)propertyChangeEvent.getNewValue() == 0) {
                this.dismiss();
            }
        }

        static /* synthetic */ ToolTipSupport access$000(Request request) {
            return request.tts;
        }
    }
}

