/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.openide.nodes.*;
import org.openide.util.NbBundle;

public class NoteProperty extends PropertySupport.ReadWrite {
    private final ScoreCookie cookie;
    private final Score.Note note;
    private final int type;
    public NoteProperty(ScoreCookie cookie, Score.Note note, int type) {
        super("noteProperty" + type, Integer.TYPE,
              NbBundle.getMessage(NoteProperty.class, "PROP_note_" + type),
              NbBundle.getMessage(NoteProperty.class, "HINT_note_" + type));
        this.cookie = cookie;
        this.note = note;
        this.type = type;
    }
    public Object getValue() {
        switch (type) {
        case 0:
            return new Integer(note.getTone());
        case 1:
            return new Integer(note.getOctave());
        case 2:
            return new Integer(note.getDuration());
        default:
            throw new IllegalStateException();
        }
    }
    public void setValue(Object val) throws IllegalArgumentException, InvocationTargetException {
        int v = ((Integer)val).intValue();
        try {
            Score s = cookie.getScore();
            int size = s.getSize();
            List notes = new ArrayList(Math.max(size, 1));
            for (int i = 0; i < size; i++) {
                Score.Note n = s.getNote(i);
                if (n == note) {
                    switch (type) {
                    case 0:
                        n = new Score.Note(v, n.getOctave(), n.getDuration());
                        break;
                    case 1:
                        n = new Score.Note(n.getTone(), v, n.getDuration());
                        break;
                    case 2:
                        n = new Score.Note(n.getTone(), n.getOctave(), v);
                        break;
                    default:
                        throw new IllegalStateException();
                    }
                }
                notes.add(n);
            }
            if (notes.size() != size) throw new IOException("did not find note");
            cookie.setScore(new Score(notes));
        } catch (IOException ioe) {
            throw new InvocationTargetException(ioe);
        }
    }
    public PropertyEditor getPropertyEditor() {
        return new NotePropertyEditor(type);
    }
    private static final class NotePropertyEditor extends PropertyEditorSupport {
        private final int type;
        public NotePropertyEditor(int type) {
            this.type = type;
        }
        public String[] getTags() {
            switch (type) {
            case 0:
                return Score.TONES_LONG;
            case 1:
                return Score.OCTAVES_LONG;
            case 2:
                return Score.DURATIONS_LONG;
            default:
                throw new IllegalStateException();
            }
        }
        public String getAsText() {
            int v = ((Integer)NotePropertyEditor.this.getValue()).intValue();
            return getTags()[v];
        }
        public void setAsText(String text) throws IllegalArgumentException {
            String[] tags = getTags();
            for (int i = 0; i < tags.length; i++) {
                if (tags[i].equals(text)) {
                    NotePropertyEditor.this.setValue(new Integer(i));
                    return;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}
