/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import org.openide.*;
import org.openide.execution.Executor;
import org.openide.options.SystemOption;
import org.openide.util.*;

public class ComposerSettings extends SystemOption {
    public static final String PROP_PLAYER = "player";
    public static final String PROP_SAMPLE_RATE = "sampleRate";
    private static final long serialVersionUID = -1247005365478408406L;
    public String displayName() {
        return NbBundle.getMessage(ComposerSettings.class, "LBL_ComposerSettings");
    }
    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.examples.modules.minicomposer.settings");
    }
    public static final ComposerSettings getDefault() {
        return (ComposerSettings)findObject(ComposerSettings.class, true);
    }
    public Executor getPlayer() {
        ServiceType.Handle val = (ServiceType.Handle)getProperty(PROP_PLAYER);
        Executor exec = null;
        if (val != null) {
            exec = (Executor)val.getServiceType();
        }
        if (exec == null) {
            // [PENDING] yet internal version works on Linux too...is there a
            // definite criterion? Ideally would try to get a line out and
            // switch to external only if that fails.
            if (Utilities.isWindows() || Utilities.getOperatingSystem() == Utilities.OS_SOLARIS) {
                exec = Executor.find(InternalPlayer.class);
            } else {
                exec = Executor.find(ExternalPlayer.class);
            }
        }
        if (exec == null) {
            // Should not normally happen unless user deleted services.
            TopManager.getDefault().getErrorManager().log(ErrorManager.INFORMATIONAL, "Minicomposer players not registered in services; defaulting to internal");
            exec = new InternalPlayer();
        }
        return exec;
    }
    public void setPlayer(Executor player) {
        putProperty(PROP_PLAYER, new ServiceType.Handle(player), true);
    }
    public float getSampleRate() {
        Float val = (Float)getProperty(PROP_SAMPLE_RATE);
        if (val != null) {
            return val.floatValue();
        } else {
            return 24000.0f;
        }
    }
    public void setSampleRate(float sampleRate) {
        putProperty(PROP_SAMPLE_RATE, new Float(sampleRate), true);
    }
}
