/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

import org.openide.filesystems.*;
import org.openide.loaders.DataObject;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

/** Node property representing length of audio file, if any.
 */
public class ClipLengthProperty extends PropertySupport.ReadOnly implements PropertyChangeListener, FileChangeListener {
    private final ScoreDataObject obj;
    private final ScoreDataNode node;
    private Float value = null;
    public ClipLengthProperty(ScoreDataObject o, ScoreDataNode n) {
        super("clipLength", Float.TYPE,
              NbBundle.getMessage(ClipLengthProperty.class, "PROP_clipLength"),
              NbBundle.getMessage(ClipLengthProperty.class, "HINT_clipLength"));
        obj = o;
        node = n;
        obj.addPropertyChangeListener(WeakListener.propertyChange(this, obj));
        updateFileListeners();
    }
    public synchronized Object getValue() throws IllegalAccessException, InvocationTargetException {
        if (value == null) {
            FileObject fo = ScoreDataLoader.findAudioFile(obj);
            if (fo != null) {
                File f = FileUtil.toFile(fo);
                if (f != null) {
                    try {
                        AudioInputStream ais = AudioSystem.getAudioInputStream(f);
                        try {
                            value = new Float(ais.getFrameLength() / ais.getFormat().getFrameRate());
                        } finally {
                            ais.close();
                        }
                    } catch (Exception e) {
                        // UnsupportedAudioFileException, IOException
                        throw new InvocationTargetException(e);
                    }
                } else {
                    value = new Float(0.0f);
                }
            } else {
                value = new Float(0.0f);
            }
        }
        return value;
    }
    private void updateFileListeners() {
        FileObject fo = ScoreDataLoader.findAudioFile(obj);
        if (fo != null) {
            fo.addFileChangeListener(WeakListener.fileChange(this, fo));
        }
    }
    private void change() {
        value = null;
        node.fireClipLengthChange();
    }
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop == null || prop.equals(DataObject.PROP_FILES)) {
            change();
            updateFileListeners();
        }
    }
    public void fileChanged(FileEvent fe) {
        change();
    }
    public void fileDeleted(FileEvent fe) {
        // ignore
    }
    public void fileFolderCreated(FileEvent fe) {
        // ignore
    }
    public void fileDataCreated(FileEvent fe) {
        // ignore
    }
    public void fileAttributeChanged(FileAttributeEvent fe) {
        // ignore
    }
    public void fileRenamed(FileRenameEvent fe) {
        // ignore
    }
}
