
/*
 * @(#)DomEcho01.java	1.9 98/11/10
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
 * DAMAGES OR LIABILITIES SUFFERED BY LICENSEE AS A RESULT OF OR
 * RELATING TO USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE OR
 * ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT,
 * SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF
 * THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 * 
 */

import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.FactoryConfigurationError;  
import javax.xml.parsers.ParserConfigurationException;
 
import org.xml.sax.SAXException;  
import org.xml.sax.SAXParseException;  

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.DOMException;
import org.w3c.dom.*;

public class DomEcho01{
    // Global value so it can be ref'd by the tree-adapter
    static Document document;

    public static void main(String argv[])
    {
        String[] args2 = {"/root/java/xmlsun/slideSample01.xml"};
        argv = args2;
        
        if (argv.length != 1) {
          System.err.println("Usage: java DomEcho filename");
          System.exit(1);
        }

        DocumentBuilderFactory factory =
            DocumentBuilderFactory.newInstance();
        //factory.setValidating(true);   
        //factory.setNamespaceAware(true);
        try {
           DocumentBuilder builder = factory.newDocumentBuilder();
           document = builder.parse( new File(argv[0]) );
           
           DomEcho01 echo1 = new DomEcho01();
           echo1.followNode(document);

        } catch (SAXParseException spe) {
           // Error generated by the parser
           System.out.println("\n** Parsing error"
              + ", line " + spe.getLineNumber()
              + ", uri " + spe.getSystemId());
           System.out.println("   " + spe.getMessage() );

           // Use the contained exception, if any
           Exception  x = spe;
           if (spe.getException() != null)
               x = spe.getException();
           x.printStackTrace();
 
        } catch (SAXException sxe) {
           // Error generated during parsing)
           Exception  x = sxe;
           if (sxe.getException() != null)
               x = sxe.getException();
           x.printStackTrace();

        } catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();

        } catch (IOException ioe) {
           // I/O error
           ioe.printStackTrace();
        }
    } // main

    public void followNode(Node node)
    {   
        processNode(node);
        if (node.hasChildNodes())
        {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); i++)
            {
                followNode(children.item(i));
            } // for (int i = 0; i < children.getLength(); i++)
        } // if (node.hasChildNodes())
    } // public void followNode(Node node)

    public void processNode(Node node)
    {    
        String name = node.getNodeName();
        String type = getTypeName(node.getNodeType());
        System.out.println("Type " + type + ": " + name);    
    } // public void processNode(Node node)
  
    public static String getTypeName(int type)
    {    
        switch (type)
        {
            case Node.ELEMENT_NODE: return "Element";
            case Node.ATTRIBUTE_NODE: return "Attribute";
            case Node.TEXT_NODE: return "Text";
            case Node.CDATA_SECTION_NODE: return "CDATA Section";
            case Node.ENTITY_REFERENCE_NODE: return "Entity Reference";
            case Node.ENTITY_NODE: return "Entity";
            case Node.PROCESSING_INSTRUCTION_NODE: return "Processing Instruction";
            case Node.COMMENT_NODE : return "Comment";
            case Node.DOCUMENT_NODE: return "Document";
            case Node.DOCUMENT_TYPE_NODE: return "Document Type Declaration";
            case Node.DOCUMENT_FRAGMENT_NODE: return "Document Fragment";
            case Node.NOTATION_NODE: return "Notation";
            default: return "Unknown Type";
        } // switch (type)
    } // public static String getTypeName(int type)

}
